/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.OrFilter;
import org.springframework.ldap.filter.WhitespaceWildcardsFilter;
import org.springframework.ldap.support.LdapNameBuilder;
import org.springframework.stereotype.Component;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.ldap.LdapSettings;
import pro.taskana.common.rest.models.AccessIdRepresentationModel;
import pro.taskana.user.api.models.User;
import pro.taskana.user.internal.models.UserImpl;

@Component
public class LdapClient {
    private static final Logger LOGGER;
    private static final String CN = "cn";
    private final TaskanaEngineConfiguration taskanaEngineConfiguration;
    private final Environment env;
    private final LdapTemplate ldapTemplate;
    private final boolean useLowerCaseForAccessIds;
    private boolean active = false;
    private int minSearchForLength;
    private int maxNumberOfReturnedAccessIds;
    private String message;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;

    static {
        LdapClient.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(LdapClient.class);
    }

    @Autowired
    public LdapClient(Environment env, LdapTemplate ldapTemplate, TaskanaEngineConfiguration taskanaEngineConfiguration) {
        this.env = env;
        this.ldapTemplate = ldapTemplate;
        this.taskanaEngineConfiguration = taskanaEngineConfiguration;
        this.useLowerCaseForAccessIds = TaskanaEngineConfiguration.shouldUseLowerCaseForAccessIds();
    }

    public List<AccessIdRepresentationModel> searchUsersAndGroups(String name) throws InvalidArgumentException {
        List<AccessIdRepresentationModel> list;
        List<AccessIdRepresentationModel> list2;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.isInitOrFail();
        this.testMinSearchForLength(name);
        ArrayList<AccessIdRepresentationModel> accessIds = new ArrayList<AccessIdRepresentationModel>();
        if (this.nameIsDn(name)) {
            AccessIdRepresentationModel groupByDn = this.searchAccessIdByDn(name);
            if (groupByDn != null) {
                accessIds.add(groupByDn);
            }
        } else {
            accessIds.addAll(this.searchUsersByNameOrAccessId(name));
            accessIds.addAll(this.searchGroupsByName(name));
        }
        this.sortListOfAccessIdResources(accessIds);
        List<AccessIdRepresentationModel> list3 = list2 = (list = this.getFirstPageOfaResultList(accessIds));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public List<AccessIdRepresentationModel> searchUsersByNameOrAccessIdInUserRole(String nameOrAccessId) throws InvalidArgumentException {
        List list;
        List list2;
        String string = nameOrAccessId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LOGGER.debug("entry to searchUsersByNameOrAccessIdInUserRoleGroups(nameOrAccessId = {}).", (Object)nameOrAccessId);
        this.isInitOrFail();
        this.testMinSearchForLength(nameOrAccessId);
        OrFilter userDetailsOrFilter = new OrFilter();
        userDetailsOrFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserFirstnameAttribute(), nameOrAccessId));
        userDetailsOrFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserLastnameAttribute(), nameOrAccessId));
        userDetailsOrFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserFullnameAttribute(), nameOrAccessId));
        userDetailsOrFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserIdAttribute(), nameOrAccessId));
        Set userGroups = (Set)this.taskanaEngineConfiguration.getRoleMap().get(TaskanaRole.USER);
        OrFilter groupMembershipOrFilter = new OrFilter();
        userGroups.forEach(group -> {
            OrFilter orFilter2 = groupMembershipOrFilter.or((Filter)new EqualsFilter(this.getUserMemberOfGroupAttribute(), group));
        });
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)userDetailsOrFilter);
        andFilter.and((Filter)groupMembershipOrFilter);
        andFilter.and((Filter)new EqualsFilter(this.getUserSearchFilterName(), this.getUserSearchFilterValue()));
        List accessIds = this.ldapTemplate.search(this.getUserSearchBase(), andFilter.encode(), 2, this.getLookUpUserAttributesToReturn(), (ContextMapper)new UserContextMapper());
        LOGGER.debug("exit from searchUsersByNameOrAccessIdInUserRoleGroups. Retrieved the following users: {}.", (Object)accessIds);
        List list3 = list2 = (list = accessIds);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public List<User> searchUsersInUserRole() {
        List list;
        List list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set userGroupsOrUser = (Set)this.taskanaEngineConfiguration.getRoleMap().get(TaskanaRole.USER);
        OrFilter userOrGroupFilter = new OrFilter();
        userGroupsOrUser.forEach(userOrGroup -> {
            userOrGroupFilter.or((Filter)new EqualsFilter(this.getUserMemberOfGroupAttribute(), userOrGroup));
            userOrGroupFilter.or((Filter)new EqualsFilter(this.getUserIdAttribute(), userOrGroup));
        });
        List users = this.ldapTemplate.search(this.getUserSearchBase(), userOrGroupFilter.encode(), 2, this.getLookUpUserInfoAttributesToReturn(), (ContextMapper)new UserInfoContextMapper());
        LOGGER.debug("exit from searchUsersInUserRole. Retrieved the following users: {}.", (Object)users);
        List list3 = list2 = (list = users);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public List<AccessIdRepresentationModel> searchUsersByNameOrAccessId(String name) throws InvalidArgumentException {
        List list;
        List list2;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.isInitOrFail();
        this.testMinSearchForLength(name);
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getUserSearchFilterName(), this.getUserSearchFilterValue()));
        OrFilter orFilter = new OrFilter();
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserFirstnameAttribute(), name));
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserLastnameAttribute(), name));
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserFullnameAttribute(), name));
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getUserIdAttribute(), name));
        andFilter.and((Filter)orFilter);
        LOGGER.debug("Using filter '{}' for LDAP query.", (Object)andFilter);
        List list3 = list2 = (list = this.ldapTemplate.search(this.getUserSearchBase(), andFilter.encode(), 2, this.getLookUpUserAttributesToReturn(), (ContextMapper)new UserContextMapper()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public List<AccessIdRepresentationModel> getUsersByAccessId(String accessId) {
        List list;
        List list2;
        String string = accessId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.isInitOrFail();
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getUserSearchFilterName(), this.getUserSearchFilterValue()));
        andFilter.and((Filter)new EqualsFilter(this.getUserIdAttribute(), accessId));
        String[] userAttributesToReturn = new String[]{this.getUserFirstnameAttribute(), this.getUserLastnameAttribute(), this.getUserIdAttribute()};
        LOGGER.debug("Using filter '{}' for LDAP query.", (Object)andFilter);
        List list3 = list2 = (list = this.ldapTemplate.search(this.getUserSearchBase(), andFilter.encode(), 2, userAttributesToReturn, (ContextMapper)new UserContextMapper()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public List<AccessIdRepresentationModel> searchGroupsByName(String name) throws InvalidArgumentException {
        List list;
        List list2;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.isInitOrFail();
        this.testMinSearchForLength(name);
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getGroupSearchFilterName(), this.getGroupSearchFilterValue()));
        OrFilter orFilter = new OrFilter();
        orFilter.or((Filter)new WhitespaceWildcardsFilter(this.getGroupNameAttribute(), name));
        if (!CN.equals(this.getGroupNameAttribute())) {
            orFilter.or((Filter)new WhitespaceWildcardsFilter(CN, name));
        }
        andFilter.and((Filter)orFilter);
        LOGGER.debug("Using filter '{}' for LDAP query.", (Object)andFilter);
        List list3 = list2 = (list = this.ldapTemplate.search(this.getGroupSearchBase(), andFilter.encode(), 2, this.getLookUpGroupAttributesToReturn(), (ContextMapper)new GroupContextMapper()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public AccessIdRepresentationModel searchAccessIdByDn(String dn) {
        AccessIdRepresentationModel accessIdRepresentationModel;
        AccessIdRepresentationModel accessIdRepresentationModel2;
        String string = dn;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.isInitOrFail();
        String nameWithoutBaseDn = this.getNameWithoutBaseDn(dn).toLowerCase();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Removed baseDN {} from given DN. New DN to be used: {}", (Object)this.getBaseDn(), (Object)nameWithoutBaseDn);
        }
        AccessIdRepresentationModel accessIdRepresentationModel3 = accessIdRepresentationModel2 = (accessIdRepresentationModel = (AccessIdRepresentationModel)((Object)this.ldapTemplate.lookup(nameWithoutBaseDn, this.getLookUpUserAndGroupAttributesToReturn(), (ContextMapper)new DnContextMapper())));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)accessIdRepresentationModel2);
        return accessIdRepresentationModel;
    }

    public List<AccessIdRepresentationModel> searchGroupsAccessIdIsMemberOf(String accessId) throws InvalidArgumentException {
        List list;
        List list2;
        String string = accessId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.isInitOrFail();
        this.testMinSearchForLength(accessId);
        String dn = this.searchDnForAccessId(accessId);
        if (dn == null || dn.isEmpty()) {
            throw new InvalidArgumentException("The AccessId is invalid");
        }
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter(this.getGroupSearchFilterName(), this.getGroupSearchFilterValue()));
        OrFilter orFilter = new OrFilter();
        if (!"DN".equalsIgnoreCase(this.getGroupsOfUserType())) {
            orFilter.or((Filter)new EqualsFilter(this.getGroupsOfUserName(), accessId));
        }
        orFilter.or((Filter)new EqualsFilter(this.getGroupsOfUserName(), dn));
        andFilter.and((Filter)orFilter);
        String[] userAttributesToReturn = new String[]{this.getUserIdAttribute(), this.getGroupNameAttribute()};
        LOGGER.debug("Using filter '{}' for LDAP query with group search base {}.", (Object)andFilter, (Object)this.getGroupSearchBase());
        List list3 = list2 = (list = this.ldapTemplate.search(this.getGroupSearchBase(), andFilter.encode(), 2, userAttributesToReturn, (ContextMapper)new GroupContextMapper()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    public String searchDnForAccessId(String accessId) throws InvalidArgumentException {
        String string;
        String string2;
        String string3;
        String string4 = accessId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.isInitOrFail();
        if (this.nameIsDn(accessId)) {
            AccessIdRepresentationModel groupByDn = this.searchAccessIdByDn(accessId);
            string2 = string3 = groupByDn.getAccessId();
        } else {
            AndFilter andFilter = new AndFilter();
            andFilter.and((Filter)new EqualsFilter(this.getUserSearchFilterName(), this.getUserSearchFilterValue()));
            OrFilter orFilter = new OrFilter();
            orFilter.or((Filter)new EqualsFilter(this.getUserIdAttribute(), accessId));
            andFilter.and((Filter)orFilter);
            LOGGER.debug("Using filter '{}' for LDAP query with user search base {}.", (Object)andFilter, (Object)this.getUserSearchBase());
            List distinguishedNames = this.ldapTemplate.search(this.getUserSearchBase(), andFilter.encode(), 2, null, (ContextMapper)new DnStringContextMapper());
            if (distinguishedNames == null || distinguishedNames.isEmpty()) {
                string2 = string3 = null;
            } else {
                if (distinguishedNames.size() > 1) {
                    throw new InvalidArgumentException("Ambiguous access id found: " + accessId);
                }
                string2 = string3 = (String)distinguishedNames.get(0);
            }
        }
        String string5 = string = string2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string3;
    }

    public boolean validateAccessId(String name) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.isInitOrFail();
        if (this.nameIsDn(name)) {
            AccessIdRepresentationModel groupByDn = this.searchAccessIdByDn(name);
            bl2 = groupByDn != null ? (bl3 = true) : (bl3 = false);
        } else {
            AndFilter andFilter = new AndFilter();
            andFilter.and((Filter)new EqualsFilter(this.getUserSearchFilterName(), this.getUserSearchFilterValue()));
            OrFilter orFilter = new OrFilter();
            orFilter.or((Filter)new EqualsFilter(this.getUserIdAttribute(), name));
            andFilter.and((Filter)orFilter);
            List accessIds = this.ldapTemplate.search(this.getUserSearchBase(), andFilter.encode(), 2, this.getLookUpUserAttributesToReturn(), (ContextMapper)new UserContextMapper());
            bl2 = bl3 = !accessIds.isEmpty();
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    public String getUserSearchBase() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_SEARCH_BASE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getUserSearchFilterName() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_SEARCH_FILTER_NAME.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getUserSearchFilterValue() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_SEARCH_FILTER_VALUE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getUserFirstnameAttribute() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_FIRSTNAME_ATTRIBUTE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getUserLastnameAttribute() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_LASTNAME_ATTRIBUTE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getUserPhoneAttribute() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_PHONE_ATTRIBUTE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getUserMobilePhoneAttribute() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_MOBILE_PHONE_ATTRIBUTE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getUserEmailAttribute() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_EMAIL_ATTRIBUTE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getUserOrgLevel1Attribute() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_ORG_LEVEL_1_ATTRIBUTE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getUserOrgLevel2Attribute() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_ORG_LEVEL_2_ATTRIBUTE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getUserOrgLevel3Attribute() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_ORG_LEVEL_3_ATTRIBUTE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getUserOrgLevel4Attribute() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_ORG_LEVEL_4_ATTRIBUTE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getUserIdAttribute() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_ID_ATTRIBUTE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getUserMemberOfGroupAttribute() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_MEMBER_OF_GROUP_ATTRIBUTE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getGroupSearchBase() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_GROUP_SEARCH_BASE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getBaseDn() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_BASE_DN.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getGroupSearchFilterName() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_GROUP_SEARCH_FILTER_NAME.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getGroupSearchFilterValue() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_GROUP_SEARCH_FILTER_VALUE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getGroupNameAttribute() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_GROUP_NAME_ATTRIBUTE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public int calcMinSearchForLength(int defaultValue) {
        int n;
        int n2;
        int n3 = defaultValue;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)Conversions.intObject((int)n3));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String envValue = LdapSettings.TASKANA_LDAP_MIN_SEARCH_FOR_LENGTH.getValueFromEnv(this.env);
        int n4 = n2 = envValue == null || envValue.isEmpty() ? (n = defaultValue) : (n = Integer.parseInt(envValue));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public int getMinSearchForLength() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.minSearchForLength);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public int calcMaxNumberOfReturnedAccessIds(int defaultValue) {
        int n;
        int n2;
        int n3 = defaultValue;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)Conversions.intObject((int)n3));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String envValue = LdapSettings.TASKANA_LDAP_MAX_NUMBER_OF_RETURNED_ACCESS_IDS.getValueFromEnv(this.env);
        int n4 = n2 = envValue == null || envValue.isEmpty() ? (n = defaultValue) : (n = Integer.parseInt(envValue));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public int getMaxNumberOfReturnedAccessIds() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = (n = this.maxNumberOfReturnedAccessIds);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public String getGroupsOfUserName() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String groupsOfUser = LdapSettings.TASKANA_LDAP_GROUPS_OF_USER_NAME.getValueFromEnv(this.env);
        if (groupsOfUser == null || groupsOfUser.isEmpty()) {
            groupsOfUser = LdapSettings.TASKANA_LDAP_GROUPS_OF_USER.getValueFromEnv(this.env);
        }
        String string3 = string2 = (string = groupsOfUser);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String getGroupsOfUserType() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_GROUPS_OF_USER_TYPE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public boolean isUser(String accessId) {
        boolean bl;
        String string = accessId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl2 = !this.getUsersByAccessId(accessId).isEmpty();
        boolean bl3 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl2;
    }

    boolean nameIsDn(String name) {
        boolean bl;
        boolean bl2;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = name.toLowerCase().endsWith(this.getBaseDn().toLowerCase()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    List<AccessIdRepresentationModel> getFirstPageOfaResultList(List<AccessIdRepresentationModel> accessIds) {
        List<AccessIdRepresentationModel> list;
        List<AccessIdRepresentationModel> list2;
        List<AccessIdRepresentationModel> list3 = accessIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, list3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<AccessIdRepresentationModel> list4 = list2 = (list = accessIds.subList(0, Math.min(accessIds.size(), this.maxNumberOfReturnedAccessIds)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    void isInitOrFail() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!this.active) {
            throw new SystemException(String.format("LdapClient was called but is not active due to missing configuration: %s", this.message));
        }
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    void sortListOfAccessIdResources(List<AccessIdRepresentationModel> accessIds) {
        List<AccessIdRepresentationModel> list = accessIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        accessIds.sort(Comparator.comparing(AccessIdRepresentationModel::getAccessId, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER)));
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    String getNameWithoutBaseDn(String name) {
        String string;
        String string2;
        String string3 = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)string3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string4 = string2 = (string = name.replaceAll("(?i)" + Pattern.quote("," + this.getBaseDn()), ""));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    String[] getLookUpGroupAttributesToReturn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = CN.equals(this.getGroupNameAttribute()) ? (stringArray = new String[]{CN, this.getGroupSearchFilterName()}) : (stringArray = new String[]{this.getGroupNameAttribute(), CN, this.getGroupSearchFilterName()});
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    String[] getLookUpUserAndGroupAttributesToReturn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = (String[])Stream.concat(Arrays.stream(this.getLookUpUserAttributesToReturn()), Arrays.stream(this.getLookUpGroupAttributesToReturn())).toArray(String[]::new));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    String[] getLookUpUserAttributesToReturn() {
        String[] stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray2 = new String[]{this.getUserFirstnameAttribute(), this.getUserLastnameAttribute(), this.getUserIdAttribute(), this.getUserSearchFilterName()};
        String[] stringArray3 = stringArray = stringArray2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray);
        return stringArray2;
    }

    String[] getLookUpUserInfoAttributesToReturn() {
        String[] stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray2 = new String[]{this.getUserIdAttribute(), this.getUserMemberOfGroupAttribute(), this.getUserFirstnameAttribute(), this.getUserLastnameAttribute(), this.getUserFullnameAttribute(), this.getUserPhoneAttribute(), this.getUserMobilePhoneAttribute(), this.getUserEmailAttribute(), this.getUserOrgLevel1Attribute(), this.getUserOrgLevel2Attribute(), this.getUserOrgLevel3Attribute(), this.getUserOrgLevel4Attribute()};
        String[] stringArray3 = stringArray = stringArray2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray);
        return stringArray2;
    }

    @PostConstruct
    void init() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.minSearchForLength = this.calcMinSearchForLength(3);
        this.maxNumberOfReturnedAccessIds = this.calcMaxNumberOfReturnedAccessIds(50);
        this.ldapTemplate.setDefaultCountLimit(this.maxNumberOfReturnedAccessIds);
        List<LdapSettings> missingConfigurations = this.checkForMissingConfigurations();
        if (!missingConfigurations.isEmpty()) {
            this.message = String.format("LDAP configurations are missing: %s", missingConfigurations);
            throw new SystemException(this.message);
        }
        this.active = true;
        Object var3_3 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var3_3);
    }

    List<LdapSettings> checkForMissingConfigurations() {
        List<LdapSettings> list;
        List<LdapSettings> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<LdapSettings> list3 = list2 = (list = Arrays.stream(LdapSettings.values()).filter(Predicate.not(LdapSettings.TASKANA_LDAP_MAX_NUMBER_OF_RETURNED_ACCESS_IDS::equals)).filter(Predicate.not(LdapSettings.TASKANA_LDAP_MIN_SEARCH_FOR_LENGTH::equals)).filter(Predicate.not(LdapSettings.TASKANA_LDAP_USER_EMAIL_ATTRIBUTE::equals)).filter(Predicate.not(LdapSettings.TASKANA_LDAP_USER_PHONE_ATTRIBUTE::equals)).filter(Predicate.not(LdapSettings.TASKANA_LDAP_USER_MOBILE_PHONE_ATTRIBUTE::equals)).filter(Predicate.not(LdapSettings.TASKANA_LDAP_USER_ORG_LEVEL_1_ATTRIBUTE::equals)).filter(Predicate.not(LdapSettings.TASKANA_LDAP_USER_ORG_LEVEL_2_ATTRIBUTE::equals)).filter(Predicate.not(LdapSettings.TASKANA_LDAP_USER_ORG_LEVEL_3_ATTRIBUTE::equals)).filter(Predicate.not(LdapSettings.TASKANA_LDAP_USER_ORG_LEVEL_4_ATTRIBUTE::equals)).filter(Predicate.not(LdapSettings.TASKANA_LDAP_GROUPS_OF_USER::equals)).filter(Predicate.not(LdapSettings.TASKANA_LDAP_GROUPS_OF_USER_NAME::equals)).filter(Predicate.not(LdapSettings.TASKANA_LDAP_GROUPS_OF_USER_TYPE::equals)).filter(p -> p.getValueFromEnv(this.env) == null).collect(Collectors.toList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    void testMinSearchForLength(String name) throws InvalidArgumentException {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (name == null || name.length() < this.minSearchForLength) {
            throw new InvalidArgumentException(String.format("search for string %s is too short. Minimum Length is %s", name, this.getMinSearchForLength()));
        }
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private String getUserFullnameAttribute() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = LdapSettings.TASKANA_LDAP_USER_FULLNAME_ATTRIBUTE.getValueFromEnv(this.env));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private String getDnFromContext(DirContextOperations context) {
        String string;
        String string2;
        DirContextOperations dirContextOperations = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)dirContextOperations);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String dn = LdapNameBuilder.newInstance((String)this.getBaseDn()).add(context.getDn()).build().toString();
        String string3 = string2 = this.useLowerCaseForAccessIds ? (string = dn.toLowerCase()) : (string = dn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private String getUserIdFromContext(DirContextOperations context) {
        String string;
        String string2;
        DirContextOperations dirContextOperations = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object)dirContextOperations);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String userId = context.getStringAttribute(this.getUserIdAttribute());
        String string3 = string2 = userId != null && this.useLowerCaseForAccessIds ? (string = userId.toLowerCase()) : (string = userId);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private Set<String> getGroupIdsFromContext(DirContextOperations context) {
        Set<Object> set;
        Set<Object> set2;
        Set<Object> groups;
        DirContextOperations dirContextOperations = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object)dirContextOperations);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] groupAttributes = context.getStringAttributes(this.getUserMemberOfGroupAttribute());
        Set<Object> set3 = groups = groupAttributes != null ? Set.of(groupAttributes) : Collections.emptySet();
        if (this.useLowerCaseForAccessIds) {
            groups = groups.stream().filter(Objects::nonNull).map(String::toLowerCase).collect(Collectors.toSet());
        }
        Set<Object> set4 = set2 = (set = groups);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, set2);
        return set;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LdapClient.java", LdapClient.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchUsersAndGroups", "pro.taskana.common.rest.ldap.LdapClient", "java.lang.String", "name", "pro.taskana.common.api.exceptions.InvalidArgumentException", "java.util.List"), 74);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchUsersByNameOrAccessIdInUserRole", "pro.taskana.common.rest.ldap.LdapClient", "java.lang.String", "nameOrAccessId", "pro.taskana.common.api.exceptions.InvalidArgumentException", "java.util.List"), 93);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserSearchBase", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 361);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserSearchFilterName", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 365);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserSearchFilterValue", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 369);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserFirstnameAttribute", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 373);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserLastnameAttribute", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 377);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserPhoneAttribute", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 381);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserMobilePhoneAttribute", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 385);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserEmailAttribute", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 389);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserOrgLevel1Attribute", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 393);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserOrgLevel2Attribute", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 397);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchUsersInUserRole", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.util.List"), 137);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserOrgLevel3Attribute", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 401);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserOrgLevel4Attribute", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 405);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserIdAttribute", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 409);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserMemberOfGroupAttribute", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 413);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGroupSearchBase", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 417);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBaseDn", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 421);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGroupSearchFilterName", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 425);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGroupSearchFilterValue", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 429);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGroupNameAttribute", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 433);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "calcMinSearchForLength", "pro.taskana.common.rest.ldap.LdapClient", "int", "defaultValue", "", "int"), 437);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchUsersByNameOrAccessId", "pro.taskana.common.rest.ldap.LdapClient", "java.lang.String", "name", "pro.taskana.common.api.exceptions.InvalidArgumentException", "java.util.List"), 161);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMinSearchForLength", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "int"), 445);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "calcMaxNumberOfReturnedAccessIds", "pro.taskana.common.rest.ldap.LdapClient", "int", "defaultValue", "", "int"), 449);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxNumberOfReturnedAccessIds", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "int"), 458);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGroupsOfUserName", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 462);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGroupsOfUserType", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 470);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isUser", "pro.taskana.common.rest.ldap.LdapClient", "java.lang.String", "accessId", "", "boolean"), 474);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "nameIsDn", "pro.taskana.common.rest.ldap.LdapClient", "java.lang.String", "name", "", "boolean"), 478);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getFirstPageOfaResultList", "pro.taskana.common.rest.ldap.LdapClient", "java.util.List", "accessIds", "", "java.util.List"), 482);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "isInitOrFail", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "void"), 487);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "sortListOfAccessIdResources", "pro.taskana.common.rest.ldap.LdapClient", "java.util.List", "accessIds", "", "void"), 503);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUsersByAccessId", "pro.taskana.common.rest.ldap.LdapClient", "java.lang.String", "accessId", "", "java.util.List"), 186);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getNameWithoutBaseDn", "pro.taskana.common.rest.ldap.LdapClient", "java.lang.String", "name", "", "java.lang.String"), 510);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getLookUpGroupAttributesToReturn", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "[Ljava.lang.String;"), 515);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getLookUpUserAndGroupAttributesToReturn", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "[Ljava.lang.String;"), 522);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getLookUpUserAttributesToReturn", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "[Ljava.lang.String;"), 529);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getLookUpUserInfoAttributesToReturn", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "[Ljava.lang.String;"), 538);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "init", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "void"), 556);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "checkForMissingConfigurations", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.util.List"), 571);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "testMinSearchForLength", "pro.taskana.common.rest.ldap.LdapClient", "java.lang.String", "name", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 590);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getUserFullnameAttribute", "pro.taskana.common.rest.ldap.LdapClient", "", "", "", "java.lang.String"), 599);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getDnFromContext", "pro.taskana.common.rest.ldap.LdapClient", "org.springframework.ldap.core.DirContextOperations", "context", "", "java.lang.String"), 603);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchGroupsByName", "pro.taskana.common.rest.ldap.LdapClient", "java.lang.String", "name", "pro.taskana.common.api.exceptions.InvalidArgumentException", "java.util.List"), 207);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getUserIdFromContext", "pro.taskana.common.rest.ldap.LdapClient", "org.springframework.ldap.core.DirContextOperations", "context", "", "java.lang.String"), 612);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getGroupIdsFromContext", "pro.taskana.common.rest.ldap.LdapClient", "org.springframework.ldap.core.DirContextOperations", "context", "", "java.util.Set"), 621);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchAccessIdByDn", "pro.taskana.common.rest.ldap.LdapClient", "java.lang.String", "dn", "", "pro.taskana.common.rest.models.AccessIdRepresentationModel"), 231);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchGroupsAccessIdIsMemberOf", "pro.taskana.common.rest.ldap.LdapClient", "java.lang.String", "accessId", "pro.taskana.common.api.exceptions.InvalidArgumentException", "java.util.List"), 247);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchDnForAccessId", "pro.taskana.common.rest.ldap.LdapClient", "java.lang.String", "accessId", "pro.taskana.common.api.exceptions.InvalidArgumentException", "java.lang.String"), 288);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "validateAccessId", "pro.taskana.common.rest.ldap.LdapClient", "java.lang.String", "name", "", "boolean"), 330);
    }

    class DnContextMapper
    extends AbstractContextMapper<AccessIdRepresentationModel> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        DnContextMapper() {
        }

        public AccessIdRepresentationModel doMapFromContext(DirContextOperations context) {
            AccessIdRepresentationModel accessIdRepresentationModel;
            AccessIdRepresentationModel accessIdRepresentationModel2;
            DirContextOperations dirContextOperations = context;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)dirContextOperations);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            AccessIdRepresentationModel accessId = new AccessIdRepresentationModel();
            String[] objectClasses = context.getStringAttributes(LdapClient.this.getUserSearchFilterName());
            if (objectClasses != null && Arrays.asList(objectClasses).contains(LdapClient.this.getUserSearchFilterValue())) {
                accessId.setAccessId(LdapClient.this.getUserIdFromContext(context));
                String firstName = context.getStringAttribute(LdapClient.this.getUserFirstnameAttribute());
                String lastName = context.getStringAttribute(LdapClient.this.getUserLastnameAttribute());
                accessId.setName(String.format("%s, %s", lastName, firstName));
            } else {
                accessId.setAccessId(LdapClient.this.getDnFromContext(context));
                accessId.setName(context.getStringAttribute(LdapClient.this.getGroupNameAttribute()));
            }
            AccessIdRepresentationModel accessIdRepresentationModel3 = accessIdRepresentationModel2 = (accessIdRepresentationModel = accessId);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)accessIdRepresentationModel2);
            return accessIdRepresentationModel;
        }

        static {
            DnContextMapper.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("LdapClient.java", DnContextMapper.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doMapFromContext", "pro.taskana.common.rest.ldap.LdapClient$DnContextMapper", "org.springframework.ldap.core.DirContextOperations", "context", "", "pro.taskana.common.rest.models.AccessIdRepresentationModel"), 687);
        }
    }

    class DnStringContextMapper
    extends AbstractContextMapper<String> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        DnStringContextMapper() {
        }

        public String doMapFromContext(DirContextOperations ctx) {
            String string;
            String string2;
            DirContextOperations dirContextOperations = ctx;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)dirContextOperations);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String string3 = string2 = (string = LdapClient.this.getDnFromContext(ctx));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
            return string;
        }

        static {
            DnStringContextMapper.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("LdapClient.java", DnStringContextMapper.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doMapFromContext", "pro.taskana.common.rest.ldap.LdapClient$DnStringContextMapper", "org.springframework.ldap.core.DirContextOperations", "ctx", "", "java.lang.String"), 706);
        }
    }

    class GroupContextMapper
    extends AbstractContextMapper<AccessIdRepresentationModel> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        GroupContextMapper() {
        }

        public AccessIdRepresentationModel doMapFromContext(DirContextOperations context) {
            AccessIdRepresentationModel accessIdRepresentationModel;
            AccessIdRepresentationModel accessIdRepresentationModel2;
            DirContextOperations dirContextOperations = context;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)dirContextOperations);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            AccessIdRepresentationModel accessId = new AccessIdRepresentationModel();
            accessId.setAccessId(LdapClient.this.getDnFromContext(context));
            accessId.setName(context.getStringAttribute(LdapClient.this.getGroupNameAttribute()));
            AccessIdRepresentationModel accessIdRepresentationModel3 = accessIdRepresentationModel2 = (accessIdRepresentationModel = accessId);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)accessIdRepresentationModel2);
            return accessIdRepresentationModel;
        }

        static {
            GroupContextMapper.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("LdapClient.java", GroupContextMapper.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doMapFromContext", "pro.taskana.common.rest.ldap.LdapClient$GroupContextMapper", "org.springframework.ldap.core.DirContextOperations", "context", "", "pro.taskana.common.rest.models.AccessIdRepresentationModel"), 638);
        }
    }

    class UserContextMapper
    extends AbstractContextMapper<AccessIdRepresentationModel> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        UserContextMapper() {
        }

        public AccessIdRepresentationModel doMapFromContext(DirContextOperations context) {
            AccessIdRepresentationModel accessIdRepresentationModel;
            AccessIdRepresentationModel accessIdRepresentationModel2;
            DirContextOperations dirContextOperations = context;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)dirContextOperations);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            AccessIdRepresentationModel accessId = new AccessIdRepresentationModel();
            accessId.setAccessId(LdapClient.this.getUserIdFromContext(context));
            String firstName = context.getStringAttribute(LdapClient.this.getUserFirstnameAttribute());
            String lastName = context.getStringAttribute(LdapClient.this.getUserLastnameAttribute());
            accessId.setName(String.format("%s, %s", lastName, firstName));
            AccessIdRepresentationModel accessIdRepresentationModel3 = accessIdRepresentationModel2 = (accessIdRepresentationModel = accessId);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)accessIdRepresentationModel2);
            return accessIdRepresentationModel;
        }

        static {
            UserContextMapper.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("LdapClient.java", UserContextMapper.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doMapFromContext", "pro.taskana.common.rest.ldap.LdapClient$UserContextMapper", "org.springframework.ldap.core.DirContextOperations", "context", "", "pro.taskana.common.rest.models.AccessIdRepresentationModel"), 673);
        }
    }

    class UserInfoContextMapper
    extends AbstractContextMapper<User> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        UserInfoContextMapper() {
        }

        public User doMapFromContext(DirContextOperations context) {
            UserImpl userImpl;
            UserImpl userImpl2;
            DirContextOperations dirContextOperations = context;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)dirContextOperations);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            UserImpl user = new UserImpl();
            user.setId(LdapClient.this.getUserIdFromContext(context));
            user.setGroups(LdapClient.this.getGroupIdsFromContext(context));
            user.setFirstName(context.getStringAttribute(LdapClient.this.getUserFirstnameAttribute()));
            user.setLastName(context.getStringAttribute(LdapClient.this.getUserLastnameAttribute()));
            user.setFullName(context.getStringAttribute(LdapClient.this.getUserFullnameAttribute()));
            user.setPhone(context.getStringAttribute(LdapClient.this.getUserPhoneAttribute()));
            user.setMobilePhone(context.getStringAttribute(LdapClient.this.getUserMobilePhoneAttribute()));
            user.setEmail(context.getStringAttribute(LdapClient.this.getUserEmailAttribute()));
            user.setOrgLevel1(context.getStringAttribute(LdapClient.this.getUserOrgLevel1Attribute()));
            user.setOrgLevel2(context.getStringAttribute(LdapClient.this.getUserOrgLevel2Attribute()));
            user.setOrgLevel3(context.getStringAttribute(LdapClient.this.getUserOrgLevel3Attribute()));
            user.setOrgLevel4(context.getStringAttribute(LdapClient.this.getUserOrgLevel4Attribute()));
            UserImpl userImpl3 = userImpl2 = (userImpl = user);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)userImpl2);
            return userImpl;
        }

        static {
            UserInfoContextMapper.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("LdapClient.java", UserInfoContextMapper.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doMapFromContext", "pro.taskana.common.rest.ldap.LdapClient$UserInfoContextMapper", "org.springframework.ldap.core.DirContextOperations", "context", "", "pro.taskana.user.api.models.User"), 650);
        }
    }
}

