/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.CheckedFunction;
import pro.taskana.workbasket.api.WorkbasketQuery;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.api.models.WorkbasketAccessItem;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.internal.models.WorkbasketImpl;
import pro.taskana.workbasket.rest.assembler.WorkbasketAccessItemRepresentationModelAssembler;
import pro.taskana.workbasket.rest.assembler.WorkbasketDefinitionRepresentationModelAssembler;
import pro.taskana.workbasket.rest.assembler.WorkbasketRepresentationModelAssembler;
import pro.taskana.workbasket.rest.models.WorkbasketAccessItemRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketDefinitionCollectionRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketDefinitionRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class WorkbasketDefinitionController {
    private final WorkbasketService workbasketService;
    private final WorkbasketDefinitionRepresentationModelAssembler workbasketDefinitionAssembler;
    private final WorkbasketRepresentationModelAssembler workbasketAssembler;
    private final WorkbasketAccessItemRepresentationModelAssembler accessItemAssembler;
    private final ObjectMapper mapper;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    @Autowired
    WorkbasketDefinitionController(WorkbasketService workbasketService, WorkbasketDefinitionRepresentationModelAssembler workbasketDefinitionAssembler, WorkbasketRepresentationModelAssembler workbasketAssembler, WorkbasketAccessItemRepresentationModelAssembler accessItemAssembler, ObjectMapper mapper) {
        this.workbasketService = workbasketService;
        this.workbasketDefinitionAssembler = workbasketDefinitionAssembler;
        this.workbasketAssembler = workbasketAssembler;
        this.accessItemAssembler = accessItemAssembler;
        this.mapper = mapper;
    }

    @GetMapping(path={"/api/v1/workbasket-definitions"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketDefinitionCollectionRepresentationModel> exportWorkbaskets(@RequestParam(required=false) String[] domain) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String[] stringArray2 = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)stringArray2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketQuery query = this.workbasketService.createWorkbasketQuery();
        Optional.ofNullable(domain).ifPresent(stringArray -> {
            WorkbasketQuery workbasketQuery2 = query.domainIn(stringArray);
        });
        List workbasketSummaryList = query.list();
        WorkbasketDefinitionCollectionRepresentationModel pageModel = workbasketSummaryList.stream().map(WorkbasketSummary::getId).map(CheckedFunction.wrap(arg_0 -> ((WorkbasketService)this.workbasketService).getWorkbasket(arg_0))).collect(Collectors.collectingAndThen(Collectors.toList(), this.workbasketDefinitionAssembler::toTaskanaCollectionModel));
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)pageModel)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PostMapping(path={"/api/v1/workbasket-definitions"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Void> importWorkbaskets(@RequestParam(value="file") MultipartFile file) throws IOException, NotAuthorizedException, DomainNotFoundException, InvalidArgumentException, WorkbasketAlreadyExistException, WorkbasketNotFoundException, WorkbasketAccessItemAlreadyExistException, ConcurrencyException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        MultipartFile multipartFile = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)multipartFile);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketDefinitionCollectionRepresentationModel definitions = (WorkbasketDefinitionCollectionRepresentationModel)((Object)this.mapper.readValue(file.getInputStream(), (TypeReference)new TypeReference<WorkbasketDefinitionCollectionRepresentationModel>(){}));
        Map<String, String> systemIds = this.workbasketService.createWorkbasketQuery().list().stream().collect(Collectors.toMap(this::logicalId, WorkbasketSummary::getId));
        this.checkForDuplicates(definitions.getContent());
        HashMap<String, String> idConversion = new HashMap<String, String>();
        for (WorkbasketDefinitionRepresentationModel definition : definitions.getContent()) {
            String newId;
            Workbasket importedWb = this.workbasketAssembler.toEntityModel(definition.getWorkbasket());
            WorkbasketImpl wbWithoutId = (WorkbasketImpl)this.removeId(importedWb);
            if (systemIds.containsKey(this.logicalId((WorkbasketSummary)importedWb))) {
                Workbasket modifiedWb = this.workbasketService.getWorkbasket(importedWb.getKey(), importedWb.getDomain());
                wbWithoutId.setModified(modifiedWb.getModified());
                this.workbasketService.updateWorkbasket((Workbasket)wbWithoutId);
                newId = systemIds.get(this.logicalId((WorkbasketSummary)importedWb));
            } else {
                newId = this.workbasketService.createWorkbasket((Workbasket)wbWithoutId).getId();
            }
            boolean authenticated = definition.getAuthorizations().stream().anyMatch(access -> access.getWorkbasketId().equals(importedWb.getId()) && access.getWorkbasketKey().equals(importedWb.getKey()));
            if (!authenticated && !definition.getAuthorizations().isEmpty()) {
                throw new InvalidArgumentException("The given Authentications for Workbasket " + importedWb.getId() + " don't match in WorkbasketId and WorkbasketKey. " + "Please provide consistent WorkbasketDefinitions");
            }
            for (WorkbasketAccessItem accessItem : this.workbasketService.getWorkbasketAccessItems(newId)) {
                this.workbasketService.deleteWorkbasketAccessItem(accessItem.getId());
            }
            for (WorkbasketAccessItemRepresentationModel authorization : definition.getAuthorizations()) {
                authorization.setWorkbasketId(newId);
                this.workbasketService.createWorkbasketAccessItem(this.accessItemAssembler.toEntityModel(authorization));
            }
            idConversion.put(importedWb.getId(), newId);
        }
        for (WorkbasketDefinitionRepresentationModel definition : definitions.getContent()) {
            ArrayList<String> distributionTargets = new ArrayList<String>();
            for (String oldId : definition.getDistributionTargets()) {
                if (idConversion.containsKey(oldId)) {
                    distributionTargets.add((String)idConversion.get(oldId));
                    continue;
                }
                if (systemIds.containsValue(oldId)) {
                    distributionTargets.add(oldId);
                    continue;
                }
                throw new InvalidArgumentException(String.format("invalid import state: Workbasket '%s' does not exist in the given import list", oldId));
            }
            this.workbasketService.setDistributionTargets((String)idConversion.get(definition.getWorkbasket().getWorkbasketId()), distributionTargets);
        }
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.noContent().build());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    private Workbasket removeId(Workbasket importedWb) {
        Workbasket workbasket;
        Workbasket workbasket2;
        Workbasket workbasket3 = importedWb;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)workbasket3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketRepresentationModel wbRes = this.workbasketAssembler.toModel(importedWb);
        wbRes.setWorkbasketId(null);
        Workbasket workbasket4 = workbasket2 = (workbasket = this.workbasketAssembler.toEntityModel(wbRes));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasket2);
        return workbasket;
    }

    private void checkForDuplicates(Collection<WorkbasketDefinitionRepresentationModel> definitions) throws WorkbasketAlreadyExistException {
        Collection<WorkbasketDefinitionRepresentationModel> collection = definitions;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, collection);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HashSet<String> identifiers = new HashSet<String>();
        for (WorkbasketDefinitionRepresentationModel definition : definitions) {
            String identifier = this.logicalId((WorkbasketSummary)this.workbasketAssembler.toEntityModel(definition.getWorkbasket()));
            if (identifiers.contains(identifier)) {
                throw new WorkbasketAlreadyExistException(definition.getWorkbasket().getKey(), definition.getWorkbasket().getDomain());
            }
            identifiers.add(identifier);
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private String logicalId(WorkbasketSummary workbasket) {
        String string;
        String string2;
        WorkbasketSummary workbasketSummary = workbasket;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)workbasketSummary);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.logicalId(workbasket.getKey(), workbasket.getDomain()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    private String logicalId(String key, String domain) {
        String string;
        String string2;
        String string3 = key;
        String string4 = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string3, (Object)string4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string5 = string2 = (string = String.valueOf(key) + "|" + domain);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    static {
        WorkbasketDefinitionController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkbasketDefinitionController.java", WorkbasketDefinitionController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "exportWorkbaskets", "pro.taskana.workbasket.rest.WorkbasketDefinitionController", "[Ljava.lang.String;", "domain", "", "org.springframework.http.ResponseEntity"), 84);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importWorkbaskets", "pro.taskana.workbasket.rest.WorkbasketDefinitionController", "org.springframework.web.multipart.MultipartFile", "file", "java.io.IOException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.DomainNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException:pro.taskana.common.api.exceptions.ConcurrencyException", "org.springframework.http.ResponseEntity"), 127);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeId", "pro.taskana.workbasket.rest.WorkbasketDefinitionController", "pro.taskana.workbasket.api.models.Workbasket", "importedWb", "", "pro.taskana.workbasket.api.models.Workbasket"), 214);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkForDuplicates", "pro.taskana.workbasket.rest.WorkbasketDefinitionController", "java.util.Collection", "definitions", "pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException", "void"), 220);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "logicalId", "pro.taskana.workbasket.rest.WorkbasketDefinitionController", "pro.taskana.workbasket.api.models.WorkbasketSummary", "workbasket", "", "java.lang.String"), 233);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "logicalId", "pro.taskana.workbasket.rest.WorkbasketDefinitionController", "java.lang.String:java.lang.String", "key:domain", "", "java.lang.String"), 237);
    }
}

