/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest.ldap;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import pro.taskana.common.internal.logging.LoggingAspect;

@Configuration
public class LdapConfiguration {
    private final String ldapServerUrl;
    private final String ldapBaseDn;
    private final String ldapBindDn;
    private final String ldapBindPassword;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public LdapConfiguration(@Value(value="${taskana.ldap.serverUrl:ldap://localhost:10389}") String ldapServerUrl, @Value(value="${taskana.ldap.baseDn:OU=Test,O=TASKANA}") String ldapBaseDn, @Value(value="${taskana.ldap.bindDn:uid=admin}") String ldapBindDn, @Value(value="${taskana.ldap.bindPassword:secret}") String ldapBindPassword) {
        this.ldapServerUrl = ldapServerUrl;
        this.ldapBaseDn = ldapBaseDn;
        this.ldapBindDn = ldapBindDn;
        this.ldapBindPassword = ldapBindPassword;
    }

    @Bean
    @ConditionalOnMissingBean(value={LdapContextSource.class})
    public LdapContextSource ldapContextSource() {
        LdapContextSource ldapContextSource;
        LdapContextSource ldapContextSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(this.ldapServerUrl);
        contextSource.setBase(this.ldapBaseDn);
        contextSource.setUserDn(this.ldapBindDn);
        contextSource.setPassword(this.ldapBindPassword);
        LdapContextSource ldapContextSource3 = ldapContextSource2 = (ldapContextSource = contextSource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)ldapContextSource2);
        return ldapContextSource;
    }

    @Bean
    @ConditionalOnMissingBean(value={LdapTemplate.class})
    public LdapTemplate ldapTemplate(LdapContextSource ldapContextSource) {
        LdapTemplate ldapTemplate;
        LdapTemplate ldapTemplate2;
        LdapContextSource ldapContextSource2 = ldapContextSource;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)ldapContextSource2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LdapTemplate ldapTemplate3 = ldapTemplate2 = (ldapTemplate = new LdapTemplate((ContextSource)ldapContextSource));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)ldapTemplate2);
        return ldapTemplate;
    }

    static {
        LdapConfiguration.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LdapConfiguration.java", LdapConfiguration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "ldapContextSource", "pro.taskana.common.rest.ldap.LdapConfiguration", "", "", "", "org.springframework.ldap.core.support.LdapContextSource"), 32);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "ldapTemplate", "pro.taskana.common.rest.ldap.LdapConfiguration", "org.springframework.ldap.core.support.LdapContextSource", "ldapContextSource", "", "org.springframework.ldap.core.LdapTemplate"), 43);
    }
}

