/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.classification.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import pro.taskana.classification.api.ClassificationCustomField;
import pro.taskana.classification.api.ClassificationQuery;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.exceptions.MalformedServiceLevelException;
import pro.taskana.classification.api.models.Classification;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.classification.rest.assembler.ClassificationDefinitionCollectionRepresentationModel;
import pro.taskana.classification.rest.assembler.ClassificationDefinitionRepresentationModelAssembler;
import pro.taskana.classification.rest.models.ClassificationDefinitionRepresentationModel;
import pro.taskana.classification.rest.models.ClassificationRepresentationModel;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.CheckedFunction;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class ClassificationDefinitionController {
    private final ObjectMapper mapper;
    private final ClassificationService classificationService;
    private final ClassificationDefinitionRepresentationModelAssembler assembler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    @Autowired
    ClassificationDefinitionController(ObjectMapper mapper, ClassificationService classificationService, ClassificationDefinitionRepresentationModelAssembler assembler) {
        this.mapper = mapper;
        this.classificationService = classificationService;
        this.assembler = assembler;
    }

    @GetMapping(path={"/api/v1/classification-definitions"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ClassificationDefinitionCollectionRepresentationModel> exportClassifications(@RequestParam(required=false) String[] domain) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String[] stringArray = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)stringArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationQuery query = this.classificationService.createClassificationQuery();
        List summaries = domain != null ? query.domainIn(domain).list() : query.list();
        ClassificationDefinitionCollectionRepresentationModel collectionModel = summaries.stream().map(ClassificationSummary::getId).map(CheckedFunction.wrap(arg_0 -> ((ClassificationService)this.classificationService).getClassification(arg_0))).collect(Collectors.collectingAndThen(Collectors.toList(), this.assembler::toTaskanaCollectionModel));
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)collectionModel)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PostMapping(path={"/api/v1/classification-definitions"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Void> importClassifications(@RequestParam(value="file") MultipartFile file) throws InvalidArgumentException, NotAuthorizedException, ConcurrencyException, ClassificationNotFoundException, ClassificationAlreadyExistException, DomainNotFoundException, IOException, MalformedServiceLevelException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        MultipartFile multipartFile = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)multipartFile);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, String> systemIds = this.getSystemIds();
        ClassificationDefinitionCollectionRepresentationModel collection = this.extractClassificationResourcesFromFile(file);
        this.checkForDuplicates(collection.getContent());
        Map<Classification, String> childrenInFile = this.mapChildrenToParentKeys(collection.getContent(), systemIds);
        this.insertOrUpdateClassificationsWithoutParent(collection.getContent(), systemIds);
        this.updateParentChildrenRelations(childrenInFile);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.noContent().build());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    private Map<String, String> getSystemIds() {
        Map<String, String> map;
        Map<String, String> map2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map<String, String> map3 = map2 = (map = this.classificationService.createClassificationQuery().list().stream().collect(Collectors.toMap(i -> String.valueOf(i.getKey()) + "|" + i.getDomain(), ClassificationSummary::getId)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    private ClassificationDefinitionCollectionRepresentationModel extractClassificationResourcesFromFile(MultipartFile file) throws IOException {
        ClassificationDefinitionCollectionRepresentationModel classificationDefinitionCollectionRepresentationModel;
        ClassificationDefinitionCollectionRepresentationModel classificationDefinitionCollectionRepresentationModel2;
        MultipartFile multipartFile = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)multipartFile);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ClassificationDefinitionCollectionRepresentationModel classificationDefinitionCollectionRepresentationModel3 = classificationDefinitionCollectionRepresentationModel2 = (classificationDefinitionCollectionRepresentationModel = (ClassificationDefinitionCollectionRepresentationModel)((Object)this.mapper.readValue(file.getInputStream(), ClassificationDefinitionCollectionRepresentationModel.class)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)classificationDefinitionCollectionRepresentationModel2);
        return classificationDefinitionCollectionRepresentationModel;
    }

    private void checkForDuplicates(Collection<ClassificationDefinitionRepresentationModel> definitionList) throws ClassificationAlreadyExistException {
        Collection<ClassificationDefinitionRepresentationModel> collection = definitionList;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, collection);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<String> identifiers = new ArrayList<String>();
        for (ClassificationDefinitionRepresentationModel definition : definitionList) {
            ClassificationRepresentationModel classification = definition.getClassification();
            String identifier = String.valueOf(classification.getKey()) + "|" + classification.getDomain();
            if (identifiers.contains(identifier)) {
                throw new ClassificationAlreadyExistException(definition.getClassification().getKey(), definition.getClassification().getDomain());
            }
            identifiers.add(identifier);
        }
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private Map<Classification, String> mapChildrenToParentKeys(Collection<ClassificationDefinitionRepresentationModel> definitionList, Map<String, String> systemIds) {
        HashMap<Classification, String> hashMap;
        HashMap<Classification, String> hashMap2;
        Collection<ClassificationDefinitionRepresentationModel> collection = definitionList;
        Map<String, String> map = systemIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, collection, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HashMap<Classification, String> childrenInFile = new HashMap<Classification, String>();
        HashSet newKeysWithDomain = new HashSet();
        definitionList.stream().map(ClassificationDefinitionRepresentationModel::getClassification).forEach(cl -> {
            boolean bl = newKeysWithDomain.add(String.valueOf(cl.getKey()) + "|" + cl.getDomain());
        });
        for (ClassificationDefinitionRepresentationModel def : definitionList) {
            ClassificationRepresentationModel cl2;
            cl2.setParentId((cl2 = def.getClassification()).getParentId() == null ? "" : cl2.getParentId());
            cl2.setParentKey(cl2.getParentKey() == null ? "" : cl2.getParentKey());
            if (!cl2.getParentId().equals("") && cl2.getParentKey().equals("")) {
                for (ClassificationDefinitionRepresentationModel parentDef : definitionList) {
                    ClassificationRepresentationModel parent = parentDef.getClassification();
                    if (!cl2.getParentId().equals(parent.getClassificationId())) continue;
                    cl2.setParentKey(parent.getKey());
                }
            }
            String parentKeyAndDomain = String.valueOf(cl2.getParentKey()) + "|" + cl2.getDomain();
            if (cl2.getParentKey().isEmpty() || cl2.getParentKey().equals("") || !newKeysWithDomain.contains(parentKeyAndDomain) && !systemIds.containsKey(parentKeyAndDomain)) continue;
            childrenInFile.put(this.assembler.toEntityModel(def), cl2.getParentKey());
        }
        HashMap<Classification, String> hashMap3 = hashMap2 = (hashMap = childrenInFile);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, hashMap2);
        return hashMap;
    }

    private void insertOrUpdateClassificationsWithoutParent(Collection<ClassificationDefinitionRepresentationModel> definitionList, Map<String, String> systemIds) throws ClassificationNotFoundException, NotAuthorizedException, InvalidArgumentException, ClassificationAlreadyExistException, DomainNotFoundException, ConcurrencyException, MalformedServiceLevelException {
        Collection<ClassificationDefinitionRepresentationModel> collection = definitionList;
        Map<String, String> map = systemIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, collection, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        for (ClassificationDefinitionRepresentationModel definition : definitionList) {
            ClassificationRepresentationModel classificationRepModel = definition.getClassification();
            classificationRepModel.setParentKey(null);
            classificationRepModel.setParentId(null);
            classificationRepModel.setClassificationId(null);
            Classification newClassification = this.assembler.toEntityModel(definition);
            String systemId = systemIds.get(String.valueOf(classificationRepModel.getKey()) + "|" + classificationRepModel.getDomain());
            if (systemId != null) {
                this.updateExistingClassification(newClassification, systemId);
                continue;
            }
            this.classificationService.createClassification(newClassification);
        }
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    private void updateParentChildrenRelations(Map<Classification, String> childrenInFile) throws ClassificationNotFoundException, NotAuthorizedException, ConcurrencyException, InvalidArgumentException, MalformedServiceLevelException {
        Map<Classification, String> map = childrenInFile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, map);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        for (Map.Entry<Classification, String> entry : childrenInFile.entrySet()) {
            Classification childRes = entry.getKey();
            String parentKey = entry.getValue();
            String classificationKey = childRes.getKey();
            String classificationDomain = childRes.getDomain();
            Classification child = this.classificationService.getClassification(classificationKey, classificationDomain);
            String parentId = parentKey == null ? "" : this.classificationService.getClassification(parentKey, classificationDomain).getId();
            child.setParentKey(parentKey);
            child.setParentId(parentId);
            this.classificationService.updateClassification(child);
        }
        Object var12_12 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var12_12);
    }

    private void updateExistingClassification(Classification newClassification, String systemId) throws ClassificationNotFoundException, NotAuthorizedException, ConcurrencyException, InvalidArgumentException, MalformedServiceLevelException {
        Classification classification = newClassification;
        String string = systemId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)classification, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Classification currentClassification = this.classificationService.getClassification(systemId);
        if (newClassification.getType() != null && !newClassification.getType().equals(currentClassification.getType())) {
            throw new InvalidArgumentException("Can not change the type of a classification.");
        }
        currentClassification.setCategory(newClassification.getCategory());
        currentClassification.setIsValidInDomain(newClassification.getIsValidInDomain());
        currentClassification.setName(newClassification.getName());
        currentClassification.setParentId(newClassification.getParentId());
        currentClassification.setParentKey(newClassification.getParentKey());
        currentClassification.setDescription(newClassification.getDescription());
        currentClassification.setPriority(newClassification.getPriority());
        currentClassification.setServiceLevel(newClassification.getServiceLevel());
        currentClassification.setApplicationEntryPoint(newClassification.getApplicationEntryPoint());
        currentClassification.setCustomField(ClassificationCustomField.CUSTOM_1, newClassification.getCustomField(ClassificationCustomField.CUSTOM_1));
        currentClassification.setCustomField(ClassificationCustomField.CUSTOM_2, newClassification.getCustomField(ClassificationCustomField.CUSTOM_2));
        currentClassification.setCustomField(ClassificationCustomField.CUSTOM_3, newClassification.getCustomField(ClassificationCustomField.CUSTOM_3));
        currentClassification.setCustomField(ClassificationCustomField.CUSTOM_4, newClassification.getCustomField(ClassificationCustomField.CUSTOM_4));
        currentClassification.setCustomField(ClassificationCustomField.CUSTOM_5, newClassification.getCustomField(ClassificationCustomField.CUSTOM_5));
        currentClassification.setCustomField(ClassificationCustomField.CUSTOM_6, newClassification.getCustomField(ClassificationCustomField.CUSTOM_6));
        currentClassification.setCustomField(ClassificationCustomField.CUSTOM_7, newClassification.getCustomField(ClassificationCustomField.CUSTOM_7));
        currentClassification.setCustomField(ClassificationCustomField.CUSTOM_8, newClassification.getCustomField(ClassificationCustomField.CUSTOM_8));
        this.classificationService.updateClassification(currentClassification);
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    static {
        ClassificationDefinitionController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ClassificationDefinitionController.java", ClassificationDefinitionController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "exportClassifications", "pro.taskana.classification.rest.ClassificationDefinitionController", "[Ljava.lang.String;", "domain", "", "org.springframework.http.ResponseEntity"), 72);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importClassifications", "pro.taskana.classification.rest.ClassificationDefinitionController", "org.springframework.web.multipart.MultipartFile", "file", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException:pro.taskana.common.api.exceptions.DomainNotFoundException:java.io.IOException:pro.taskana.classification.api.exceptions.MalformedServiceLevelException", "org.springframework.http.ResponseEntity"), 108);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSystemIds", "pro.taskana.classification.rest.ClassificationDefinitionController", "", "", "", "java.util.Map"), 124);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractClassificationResourcesFromFile", "pro.taskana.classification.rest.ClassificationDefinitionController", "org.springframework.web.multipart.MultipartFile", "file", "java.io.IOException", "pro.taskana.classification.rest.assembler.ClassificationDefinitionCollectionRepresentationModel"), 131);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkForDuplicates", "pro.taskana.classification.rest.ClassificationDefinitionController", "java.util.Collection", "definitionList", "pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException", "void"), 136);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "mapChildrenToParentKeys", "pro.taskana.classification.rest.ClassificationDefinitionController", "java.util.Collection:java.util.Map", "definitionList:systemIds", "", "java.util.Map"), 151);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "insertOrUpdateClassificationsWithoutParent", "pro.taskana.classification.rest.ClassificationDefinitionController", "java.util.Collection:java.util.Map", "definitionList:systemIds", "pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException:pro.taskana.common.api.exceptions.DomainNotFoundException:pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.classification.api.exceptions.MalformedServiceLevelException", "void"), 185);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateParentChildrenRelations", "pro.taskana.classification.rest.ClassificationDefinitionController", "java.util.Map", "childrenInFile", "pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.classification.api.exceptions.MalformedServiceLevelException", "void"), 209);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateExistingClassification", "pro.taskana.classification.rest.ClassificationDefinitionController", "pro.taskana.classification.api.models.Classification:java.lang.String", "newClassification:systemId", "pro.taskana.classification.api.exceptions.ClassificationNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.classification.api.exceptions.MalformedServiceLevelException", "void"), 232);
    }
}

