/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.ldap.LdapClient;
import pro.taskana.common.rest.models.AccessIdRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class AccessIdController {
    private final LdapClient ldapClient;
    private final TaskanaEngine taskanaEngine;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    @Autowired
    public AccessIdController(LdapClient ldapClient, TaskanaEngine taskanaEngine) {
        this.ldapClient = ldapClient;
        this.taskanaEngine = taskanaEngine;
    }

    @GetMapping(path={"/api/v1/access-ids"})
    public ResponseEntity<List<AccessIdRepresentationModel>> searchUsersAndGroups(@RequestParam(value="search-for") String searchFor) throws InvalidArgumentException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = searchFor;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.checkRoleMembership(new TaskanaRole[]{TaskanaRole.ADMIN, TaskanaRole.BUSINESS_ADMIN});
        List<AccessIdRepresentationModel> accessIdUsers = this.ldapClient.searchUsersAndGroups(searchFor);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok(accessIdUsers));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/users"})
    public ResponseEntity<List<AccessIdRepresentationModel>> searchUsersByNameOrAccessIdForRole(@RequestParam(value="search-for") String nameOrAccessId, @RequestParam(value="role") String role) throws InvalidArgumentException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = nameOrAccessId;
        String string2 = role;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.checkRoleMembership(new TaskanaRole[]{TaskanaRole.USER, TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN});
        if (!role.equals("user")) {
            throw new InvalidArgumentException(String.format("Requested users for not supported role %s.  Only role 'user' is supported'", role));
        }
        List<AccessIdRepresentationModel> accessIdUsers = this.ldapClient.searchUsersByNameOrAccessIdInUserRole(nameOrAccessId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok(accessIdUsers));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/access-ids/groups"})
    public ResponseEntity<List<AccessIdRepresentationModel>> getGroupsByAccessId(@RequestParam(value="access-id") String accessId) throws InvalidArgumentException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = accessId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.checkRoleMembership(new TaskanaRole[]{TaskanaRole.ADMIN, TaskanaRole.BUSINESS_ADMIN});
        List<AccessIdRepresentationModel> accessIds = this.ldapClient.searchGroupsAccessIdIsMemberOf(accessId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok(accessIds));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    static {
        AccessIdController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AccessIdController.java", AccessIdController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchUsersAndGroups", "pro.taskana.common.rest.AccessIdController", "java.lang.String", "searchFor", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 44);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchUsersByNameOrAccessIdForRole", "pro.taskana.common.rest.AccessIdController", "java.lang.String:java.lang.String", "nameOrAccessId:role", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 69);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGroupsByAccessId", "pro.taskana.common.rest.AccessIdController", "java.lang.String", "accessId", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 95);
    }
}

