/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import pro.taskana.common.api.exceptions.ErrorCode;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.api.exceptions.TaskanaRuntimeException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.models.ExceptionRepresentationModel;

@Order(value=-2147483648)
@ControllerAdvice
public class TaskanaRestExceptionHandler
extends ResponseEntityExceptionHandler {
    public static final String ERROR_KEY_QUERY_MALFORMED = "QUERY_PARAMETER_MALFORMED";
    public static final String ERROR_KEY_PAYLOAD = "PAYLOAD_TOO_LARGE";
    public static final String ERROR_KEY_UNKNOWN_ERROR = "UNKNOWN_ERROR";
    private static final Map<String, HttpStatus> HTTP_STATUS_BY_ERROR_CODE_KEY;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        TaskanaRestExceptionHandler.ajc$preClinit();
        HTTP_STATUS_BY_ERROR_CODE_KEY = Map.ofEntries(Map.entry("CLASSIFICATION_SERVICE_LEVEL_MALFORMED", HttpStatus.BAD_REQUEST), Map.entry("CUSTOM_HOLIDAY_WRONG_FORMAT", HttpStatus.BAD_REQUEST), Map.entry("DOMAIN_NOT_FOUND", HttpStatus.BAD_REQUEST), Map.entry("INVALID_ARGUMENT", HttpStatus.BAD_REQUEST), Map.entry(ERROR_KEY_QUERY_MALFORMED, HttpStatus.BAD_REQUEST), Map.entry("TASK_INVALID_CALLBACK_STATE", HttpStatus.BAD_REQUEST), Map.entry("TASK_INVALID_OWNER", HttpStatus.BAD_REQUEST), Map.entry("TASK_INVALID_STATE", HttpStatus.BAD_REQUEST), Map.entry("NOT_AUTHORIZED", HttpStatus.FORBIDDEN), Map.entry("NOT_AUTHORIZED_ON_TASK_COMMENT", HttpStatus.FORBIDDEN), Map.entry("NOT_AUTHORIZED_ON_WORKBASKET_WITH_ID", HttpStatus.FORBIDDEN), Map.entry("NOT_AUTHORIZED_ON_WORKBASKET_WITH_KEY_AND_DOMAIN", HttpStatus.FORBIDDEN), Map.entry("CLASSIFICATION_WITH_ID_NOT_FOUND", HttpStatus.NOT_FOUND), Map.entry("CLASSIFICATION_WITH_KEY_NOT_FOUND", HttpStatus.NOT_FOUND), Map.entry("TASK_COMMENT_NOT_FOUND", HttpStatus.NOT_FOUND), Map.entry("TASK_NOT_FOUND", HttpStatus.NOT_FOUND), Map.entry("USER_NOT_FOUND", HttpStatus.NOT_FOUND), Map.entry("WORKBASKET_WITH_ID_NOT_FOUND", HttpStatus.NOT_FOUND), Map.entry("WORKBASKET_WITH_KEY_NOT_FOUND", HttpStatus.NOT_FOUND), Map.entry("HISTORY_EVENT_NOT_FOUND", HttpStatus.NOT_FOUND), Map.entry("ATTACHMENT_ALREADY_EXISTS", HttpStatus.CONFLICT), Map.entry("CLASSIFICATION_ALREADY_EXISTS", HttpStatus.CONFLICT), Map.entry("ENTITY_NOT_UP_TO_DATE", HttpStatus.CONFLICT), Map.entry("TASK_ALREADY_EXISTS", HttpStatus.CONFLICT), Map.entry("USER_ALREADY_EXISTS", HttpStatus.CONFLICT), Map.entry("WORKBASKET_ACCESS_ITEM_ALREADY_EXISTS", HttpStatus.CONFLICT), Map.entry("WORKBASKET_ALREADY_EXISTS", HttpStatus.CONFLICT), Map.entry("WORKBASKET_MARKED_FOR_DELETION", HttpStatus.CONFLICT), Map.entry(ERROR_KEY_PAYLOAD, HttpStatus.PAYLOAD_TOO_LARGE), Map.entry("CLASSIFICATION_IN_USE", HttpStatus.LOCKED), Map.entry("WORKBASKET_IN_USE", HttpStatus.LOCKED), Map.entry("CONNECTION_AUTOCOMMIT_FAILED", HttpStatus.INTERNAL_SERVER_ERROR), Map.entry("CONNECTION_NOT_SET", HttpStatus.INTERNAL_SERVER_ERROR), Map.entry("CRITICAL_SYSTEM_ERROR", HttpStatus.INTERNAL_SERVER_ERROR), Map.entry("DATABASE_UNSUPPORTED", HttpStatus.INTERNAL_SERVER_ERROR), Map.entry(ERROR_KEY_UNKNOWN_ERROR, HttpStatus.INTERNAL_SERVER_ERROR));
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    protected ResponseEntity<Object> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        MaxUploadSizeExceededException maxUploadSizeExceededException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)maxUploadSizeExceededException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HttpStatus status = HTTP_STATUS_BY_ERROR_CODE_KEY.getOrDefault(ERROR_KEY_PAYLOAD, HttpStatus.INTERNAL_SERVER_ERROR);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ErrorCode.of((String)ERROR_KEY_PAYLOAD), (Throwable)ex, req, status));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={BeanInstantiationException.class})
    protected ResponseEntity<Object> handleBeanInstantiationException(BeanInstantiationException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        ResponseEntity<Object> responseEntity3;
        BeanInstantiationException beanInstantiationException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)beanInstantiationException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (ex.getCause() instanceof InvalidArgumentException) {
            InvalidArgumentException cause = (InvalidArgumentException)ex.getCause();
            responseEntity2 = responseEntity3 = this.handleTaskanaRuntimeException((TaskanaRuntimeException)cause, req);
        } else {
            responseEntity2 = responseEntity3 = this.buildResponse(null, (Throwable)ex, req, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        ResponseEntity<Object> responseEntity4 = responseEntity = responseEntity2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity);
        return responseEntity3;
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    protected ResponseEntity<Object> handleIllegalArgumentException(IllegalArgumentException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        IllegalArgumentException illegalArgumentException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)illegalArgumentException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HttpStatus status = HTTP_STATUS_BY_ERROR_CODE_KEY.getOrDefault("INVALID_ARGUMENT", HttpStatus.INTERNAL_SERVER_ERROR);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ErrorCode.of((String)"INVALID_ARGUMENT"), ex, req, status));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={TaskanaRuntimeException.class})
    protected ResponseEntity<Object> handleTaskanaRuntimeException(TaskanaRuntimeException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        TaskanaRuntimeException taskanaRuntimeException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)taskanaRuntimeException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HttpStatus status = HTTP_STATUS_BY_ERROR_CODE_KEY.getOrDefault(ex.getErrorCode().getKey(), HttpStatus.INTERNAL_SERVER_ERROR);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ex.getErrorCode(), (Throwable)ex, req, status));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={TaskanaException.class})
    protected ResponseEntity<Object> handleTaskanaException(TaskanaException ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        TaskanaException taskanaException = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)taskanaException, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HttpStatus status = HTTP_STATUS_BY_ERROR_CODE_KEY.getOrDefault(ex.getErrorCode().getKey(), HttpStatus.INTERNAL_SERVER_ERROR);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ex.getErrorCode(), (Throwable)ex, req, status));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleGeneralException(Exception ex, WebRequest req) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        Exception exception = ex;
        WebRequest webRequest = req;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object)exception, (Object)webRequest);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(ErrorCode.of((String)ERROR_KEY_UNKNOWN_ERROR), ex, req, HttpStatus.INTERNAL_SERVER_ERROR));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    @NonNull
    protected ResponseEntity<Object> handleBindException(BindException ex, @NonNull HttpHeaders headers, @NonNull HttpStatus status, @NonNull WebRequest request) {
        ResponseEntity<Object> responseEntity;
        ResponseEntity<Object> responseEntity2;
        BindException bindException = ex;
        HttpHeaders httpHeaders = headers;
        HttpStatus httpStatus = status;
        WebRequest webRequest = request;
        Object[] objectArray = new Object[]{bindException, httpHeaders, httpStatus, webRequest};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        MalformedQueryParameter[] wrongQueryParameters = (MalformedQueryParameter[])ex.getBindingResult().getFieldErrors().stream().map(this::extractMalformedQueryParameters).flatMap(Collection::stream).toArray(MalformedQueryParameter[]::new);
        ErrorCode errorCode = wrongQueryParameters.length != 0 ? ErrorCode.of((String)ERROR_KEY_QUERY_MALFORMED, Map.of("malformedQueryParameters", wrongQueryParameters)) : null;
        ResponseEntity<Object> responseEntity3 = responseEntity2 = (responseEntity = this.buildResponse(errorCode, (Throwable)ex, request, HttpStatus.BAD_REQUEST));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, responseEntity2);
        return responseEntity;
    }

    private ResponseEntity<Object> buildResponse(ErrorCode errorCode, Throwable ex, WebRequest req, HttpStatus status) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        ErrorCode errorCode2 = errorCode;
        Throwable throwable = ex;
        WebRequest webRequest = req;
        HttpStatus httpStatus = status;
        Object[] objectArray = new Object[]{errorCode2, throwable, webRequest, httpStatus};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ExceptionRepresentationModel errorData = new ExceptionRepresentationModel(errorCode, status, ex, req);
        this.logger.error((Object)String.format("Error occurred during processing of rest request: %s", errorData), ex);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatus)status).body((Object)errorData));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    private List<MalformedQueryParameter> extractMalformedQueryParameters(FieldError fieldError) {
        List<MalformedQueryParameter> list;
        List<MalformedQueryParameter> list2;
        List<MalformedQueryParameter> list3;
        ConversionFailedException conversionFailedException;
        Class targetType;
        TypeMismatchException typeMismatchException;
        FieldError fieldError2 = fieldError;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object)fieldError2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (fieldError.contains(TypeMismatchException.class) && (typeMismatchException = (TypeMismatchException)fieldError.unwrap(TypeMismatchException.class)).getCause() instanceof ConversionFailedException && (targetType = (conversionFailedException = (ConversionFailedException)typeMismatchException.getCause()).getTargetType().getType()).isEnum()) {
            String queryParameter = fieldError.getField();
            List enumConstants = Arrays.stream(targetType.getEnumConstants()).map(Enum.class::cast).map(Enum::name).collect(Collectors.toList());
            HashSet enumConstantSet = new HashSet(enumConstants);
            list2 = list3 = this.getRejectedValues(typeMismatchException).filter(Predicate.not(enumConstantSet::contains)).map(value -> new MalformedQueryParameter(queryParameter, (String)value, enumConstants)).collect(Collectors.toList());
        } else {
            list2 = list3 = Collections.emptyList();
        }
        List<MalformedQueryParameter> list4 = list = list2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list);
        return list3;
    }

    private Stream<String> getRejectedValues(TypeMismatchException ex) {
        Stream<String> stream;
        Stream<String> stream2;
        TypeMismatchException typeMismatchException = ex;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this), (Object)typeMismatchException);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Object value = ex.getValue();
        Stream<String> stream3 = stream2 = value != null && value.getClass().isArray() ? (stream = Arrays.stream((Object[])value).map(Objects::toString)) : (value != null && value.getClass().isAssignableFrom(Collection.class) ? (stream = ((Collection)value).stream().map(Objects::toString)) : (stream = Stream.of(value).map(Objects::toString)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, stream2);
        return stream;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskanaRestExceptionHandler.java", TaskanaRestExceptionHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleMaxUploadSizeExceededException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.web.multipart.MaxUploadSizeExceededException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 121);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleBeanInstantiationException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.beans.BeanInstantiationException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 130);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleIllegalArgumentException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "java.lang.IllegalArgumentException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 142);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleTaskanaRuntimeException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.TaskanaRuntimeException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 151);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleTaskanaException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.TaskanaException:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 160);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleGeneralException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "java.lang.Exception:org.springframework.web.context.request.WebRequest", "ex:req", "", "org.springframework.http.ResponseEntity"), 168);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleBindException", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.validation.BindException:org.springframework.http.HttpHeaders:org.springframework.http.HttpStatus:org.springframework.web.context.request.WebRequest", "ex:headers:status:request", "", "org.springframework.http.ResponseEntity"), 175);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "buildResponse", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "pro.taskana.common.api.exceptions.ErrorCode:java.lang.Throwable:org.springframework.web.context.request.WebRequest:org.springframework.http.HttpStatus", "errorCode:ex:req:status", "", "org.springframework.http.ResponseEntity"), 198);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractMalformedQueryParameters", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.validation.FieldError", "fieldError", "", "java.util.List"), 207);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getRejectedValues", "pro.taskana.common.rest.TaskanaRestExceptionHandler", "org.springframework.beans.TypeMismatchException", "ex", "", "java.util.stream.Stream"), 236);
    }

    public static class MalformedQueryParameter
    implements Serializable {
        private final String queryParameter;
        private final String actualValue;
        private final Collection<String> expectedValues;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        MalformedQueryParameter(String queryParameter, String actualValue, Collection<String> expectedValues) {
            this.queryParameter = queryParameter;
            this.actualValue = actualValue;
            this.expectedValues = expectedValues;
        }

        public String getActualValue() {
            String string;
            String string2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String string3 = string2 = (string = this.actualValue);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
            return string;
        }

        public Collection<String> getExpectedValues() {
            Collection<String> collection;
            Collection<String> collection2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Collection<String> collection3 = collection2 = (collection = this.expectedValues);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, collection2);
            return collection;
        }

        public String getQueryParameter() {
            String string;
            String string2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            String string3 = string2 = (string = this.queryParameter);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
            return string;
        }

        static {
            MalformedQueryParameter.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskanaRestExceptionHandler.java", MalformedQueryParameter.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getActualValue", "pro.taskana.common.rest.TaskanaRestExceptionHandler$MalformedQueryParameter", "", "", "", "java.lang.String"), 260);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getExpectedValues", "pro.taskana.common.rest.TaskanaRestExceptionHandler$MalformedQueryParameter", "", "", "", "java.util.Collection"), 265);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getQueryParameter", "pro.taskana.common.rest.TaskanaRestExceptionHandler$MalformedQueryParameter", "", "", "", "java.lang.String"), 270);
        }
    }
}

