/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QueryParameter;
import pro.taskana.common.rest.QuerySortBy;

public class QuerySortParameter<Q extends BaseQuery<?, ?>, S extends QuerySortBy<Q>>
implements QueryParameter<Q, Void> {
    @JsonProperty(value="sort-by")
    private final List<S> sortBy;
    @JsonProperty(value="order")
    private final List<BaseQuery.SortDirection> order;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public QuerySortParameter(List<S> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
        this.sortBy = sortBy;
        this.order = order;
        QuerySortParameter.verifyNotOnlyOrderByExists(sortBy, order);
        QuerySortParameter.verifyAmountOfSortByAndOrderByMatches(sortBy, order);
    }

    @Override
    public Void apply(Q query) {
        Void void_;
        Q q = query;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, q);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.sortBy != null) {
            int i = 0;
            while (i < this.sortBy.size()) {
                BaseQuery.SortDirection sortDirection = this.order == null || this.order.isEmpty() ? BaseQuery.SortDirection.ASCENDING : this.order.get(i);
                ((QuerySortBy)this.sortBy.get(i)).applySortByForQuery(query, sortDirection);
                ++i;
            }
        }
        Void void_2 = null;
        Void void_3 = void_ = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, void_);
        return void_2;
    }

    public static <T> void verifyAmountOfSortByAndOrderByMatches(List<T> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
        List<T> list = sortBy;
        List<BaseQuery.SortDirection> list2 = order;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, list, list2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (sortBy != null && order != null && sortBy.size() != order.size() && !order.isEmpty()) {
            throw new InvalidArgumentException("The amount of 'sort-by' and 'order' does not match. Please specify an 'order' for each 'sort-by' or no 'order' parameters at all.");
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public static <T> void verifyNotOnlyOrderByExists(List<T> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
        List<T> list = sortBy;
        List<BaseQuery.SortDirection> list2 = order;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, list, list2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (sortBy == null && order != null) {
            throw new InvalidArgumentException("Only 'order' parameters were provided. Please also provide 'sort-by' parameter(s)");
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    @JsonProperty(value="sort-by")
    public List<S> getSortBy() {
        List<S> list;
        List<S> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<S> list3 = list2 = (list = this.sortBy);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public List<BaseQuery.SortDirection> getOrder() {
        List<BaseQuery.SortDirection> list;
        List<BaseQuery.SortDirection> list2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<BaseQuery.SortDirection> list3 = list2 = (list = this.order);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    static {
        QuerySortParameter.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("QuerySortParameter.java", QuerySortParameter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "apply", "pro.taskana.common.rest.QuerySortParameter", "pro.taskana.common.api.BaseQuery", "query", "", "java.lang.Void"), 37);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "verifyAmountOfSortByAndOrderByMatches", "pro.taskana.common.rest.QuerySortParameter", "java.util.List:java.util.List", "sortBy:order", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 49);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "verifyNotOnlyOrderByExists", "pro.taskana.common.rest.QuerySortParameter", "java.util.List:java.util.List", "sortBy:order", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 59);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSortBy", "pro.taskana.common.rest.QuerySortParameter", "", "", "", "java.util.List"), 74);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOrder", "pro.taskana.common.rest.QuerySortParameter", "", "", "", "java.util.List"), 78);
    }
}

