/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest.assembler;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.assembler.CollectionRepresentationModelAssembler;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.rest.assembler.WorkbasketAccessItemRepresentationModelAssembler;
import pro.taskana.workbasket.rest.assembler.WorkbasketRepresentationModelAssembler;
import pro.taskana.workbasket.rest.models.WorkbasketDefinitionCollectionRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketDefinitionRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketRepresentationModel;

@Component
public class WorkbasketDefinitionRepresentationModelAssembler
implements CollectionRepresentationModelAssembler<Workbasket, WorkbasketDefinitionRepresentationModel, WorkbasketDefinitionCollectionRepresentationModel> {
    private final WorkbasketService workbasketService;
    private final WorkbasketAccessItemRepresentationModelAssembler accessItemAssembler;
    private final WorkbasketRepresentationModelAssembler workbasketAssembler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Autowired
    public WorkbasketDefinitionRepresentationModelAssembler(WorkbasketService workbasketService, WorkbasketAccessItemRepresentationModelAssembler accessItemAssembler, WorkbasketRepresentationModelAssembler workbasketAssembler) {
        this.workbasketService = workbasketService;
        this.accessItemAssembler = accessItemAssembler;
        this.workbasketAssembler = workbasketAssembler;
    }

    @NonNull
    public WorkbasketDefinitionRepresentationModel toModel(@NonNull Workbasket workbasket) {
        WorkbasketDefinitionRepresentationModel workbasketDefinitionRepresentationModel;
        WorkbasketDefinitionRepresentationModel workbasketDefinitionRepresentationModel2;
        Set<String> distroTargets;
        Collection authorizations;
        Workbasket workbasket2 = workbasket;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)workbasket2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketRepresentationModel basket = this.workbasketAssembler.toModel(workbasket);
        try {
            List workbasketAccessItems = this.workbasketService.getWorkbasketAccessItems(basket.getWorkbasketId());
            authorizations = this.accessItemAssembler.toCollectionModel(workbasketAccessItems).getContent();
            distroTargets = this.workbasketService.getDistributionTargets(workbasket.getId()).stream().map(WorkbasketSummary::getId).collect(Collectors.toSet());
        }
        catch (NotAuthorizedException | NotAuthorizedOnWorkbasketException | WorkbasketNotFoundException e) {
            throw new SystemException("Caught Exception", e);
        }
        WorkbasketDefinitionRepresentationModel repModel = new WorkbasketDefinitionRepresentationModel();
        repModel.setWorkbasket(basket);
        repModel.setAuthorizations(authorizations);
        repModel.setDistributionTargets(distroTargets);
        WorkbasketDefinitionRepresentationModel workbasketDefinitionRepresentationModel3 = workbasketDefinitionRepresentationModel2 = (workbasketDefinitionRepresentationModel = repModel);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketDefinitionRepresentationModel2);
        return workbasketDefinitionRepresentationModel;
    }

    @Override
    public WorkbasketDefinitionCollectionRepresentationModel buildCollectionEntity(List<WorkbasketDefinitionRepresentationModel> content) {
        WorkbasketDefinitionCollectionRepresentationModel workbasketDefinitionCollectionRepresentationModel;
        WorkbasketDefinitionCollectionRepresentationModel workbasketDefinitionCollectionRepresentationModel2;
        List<WorkbasketDefinitionRepresentationModel> list = content;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketDefinitionCollectionRepresentationModel workbasketDefinitionCollectionRepresentationModel3 = workbasketDefinitionCollectionRepresentationModel2 = (workbasketDefinitionCollectionRepresentationModel = new WorkbasketDefinitionCollectionRepresentationModel((Collection<WorkbasketDefinitionRepresentationModel>)content));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketDefinitionCollectionRepresentationModel2);
        return workbasketDefinitionCollectionRepresentationModel;
    }

    static {
        WorkbasketDefinitionRepresentationModelAssembler.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkbasketDefinitionRepresentationModelAssembler.java", WorkbasketDefinitionRepresentationModelAssembler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toModel", "pro.taskana.workbasket.rest.assembler.WorkbasketDefinitionRepresentationModelAssembler", "pro.taskana.workbasket.api.models.Workbasket", "workbasket", "", "pro.taskana.workbasket.rest.models.WorkbasketDefinitionRepresentationModel"), 50);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildCollectionEntity", "pro.taskana.workbasket.rest.assembler.WorkbasketDefinitionRepresentationModelAssembler", "java.util.List", "content", "", "pro.taskana.workbasket.rest.models.WorkbasketDefinitionCollectionRepresentationModel"), 78);
    }
}

