/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.logging.LoggingAspect;

public class QueryParamsValidator {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    private QueryParamsValidator() {
        throw new IllegalStateException("Utility class");
    }

    public static void validateParams(HttpServletRequest request, Class<?> ... filterOrSortingClazz) {
        HttpServletRequest httpServletRequest = request;
        Class<?>[] classArray = filterOrSortingClazz;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)httpServletRequest, classArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set allowedParams = Stream.of(filterOrSortingClazz).flatMap(clazz -> Stream.of(clazz.getDeclaredFields())).map(field -> Optional.ofNullable(field.getDeclaredAnnotation(JsonProperty.class)).map(JsonProperty::value).orElseGet(field::getName)).collect(Collectors.toSet());
        HashSet providedParams = new HashSet(request.getParameterMap().keySet());
        providedParams.removeIf(allowedParams::contains);
        if (!providedParams.isEmpty()) {
            throw new IllegalArgumentException("Unknown request parameters found: " + providedParams);
        }
        QueryParamsValidator.checkExactParam(request, "owner-is-null");
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    public static void checkExactParam(HttpServletRequest request, String queryParameter) {
        Pattern pattern;
        Matcher matcher;
        boolean hasExactParam;
        boolean containParam;
        HttpServletRequest httpServletRequest = request;
        String string = queryParameter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)httpServletRequest, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String queryString = request.getQueryString();
        boolean bl = containParam = queryString != null && queryString.contains(queryParameter);
        if (containParam && !(hasExactParam = (matcher = (pattern = Pattern.compile("\\b" + queryParameter + "(&|$)")).matcher(queryString)).find())) {
            throw new InvalidArgumentException("It is prohibited to use the param " + queryParameter + " with values.");
        }
        Object var10_10 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_10);
    }

    static {
        QueryParamsValidator.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("QueryParamsValidator.java", QueryParamsValidator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("89", "validateParams", "pro.taskana.common.rest.util.QueryParamsValidator", "jakarta.servlet.http.HttpServletRequest:[Ljava.lang.Class;", "request:filterOrSortingClazz", "", "void"), 20);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "checkExactParam", "pro.taskana.common.rest.util.QueryParamsValidator", "jakarta.servlet.http.HttpServletRequest:java.lang.String", "request:queryParameter", "", "void"), 41);
    }
}

