/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.rest;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.MonitorService;
import pro.taskana.monitor.api.TaskTimestamp;
import pro.taskana.monitor.api.reports.ClassificationCategoryReport;
import pro.taskana.monitor.api.reports.ClassificationReport;
import pro.taskana.monitor.api.reports.TaskCustomFieldValueReport;
import pro.taskana.monitor.api.reports.TaskStatusReport;
import pro.taskana.monitor.api.reports.TimeIntervalReportBuilder;
import pro.taskana.monitor.api.reports.TimestampReport;
import pro.taskana.monitor.api.reports.WorkbasketPriorityReport;
import pro.taskana.monitor.api.reports.WorkbasketReport;
import pro.taskana.monitor.api.reports.header.TimeIntervalColumnHeader;
import pro.taskana.monitor.rest.PriorityReportFilterParameter;
import pro.taskana.monitor.rest.TimeIntervalReportFilterParameter;
import pro.taskana.monitor.rest.assembler.PriorityColumnHeaderRepresentationModelAssembler;
import pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler;
import pro.taskana.monitor.rest.models.PriorityColumnHeaderRepresentationModel;
import pro.taskana.monitor.rest.models.ReportRepresentationModel;
import pro.taskana.task.api.TaskCustomField;
import pro.taskana.task.api.TaskState;
import pro.taskana.workbasket.api.WorkbasketType;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class MonitorController {
    private final MonitorService monitorService;
    private final ReportRepresentationModelAssembler reportRepresentationModelAssembler;
    private final PriorityColumnHeaderRepresentationModelAssembler priorityColumnHeaderRepresentationModelAssembler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    @Autowired
    MonitorController(MonitorService monitorService, ReportRepresentationModelAssembler reportRepresentationModelAssembler, PriorityColumnHeaderRepresentationModelAssembler priorityColumnHeaderRepresentationModelAssembler) {
        this.monitorService = monitorService;
        this.reportRepresentationModelAssembler = reportRepresentationModelAssembler;
        this.priorityColumnHeaderRepresentationModelAssembler = priorityColumnHeaderRepresentationModelAssembler;
    }

    @GetMapping(path={"/api/v1/monitor/workbasket-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> computeWorkbasketReport(TimeIntervalReportFilterParameter filterParameter, @RequestParam(name="task-timestamp", required=false) TaskTimestamp taskTimestamp) throws NotAuthorizedException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        TimeIntervalReportFilterParameter timeIntervalReportFilterParameter = filterParameter;
        TaskTimestamp taskTimestamp2 = taskTimestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)timeIntervalReportFilterParameter, (Object)taskTimestamp2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskTimestamp == null) {
            taskTimestamp = TaskTimestamp.DUE;
        }
        WorkbasketReport.Builder builder = this.monitorService.createWorkbasketReportBuilder();
        filterParameter.apply((TimeIntervalReportBuilder<?, ?, TimeIntervalColumnHeader>)builder);
        ReportRepresentationModel report = this.reportRepresentationModelAssembler.toModel(builder.buildReport(taskTimestamp), filterParameter, taskTimestamp);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)report));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/monitor/workbasket-priority-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> computePriorityWorkbasketReport(PriorityReportFilterParameter filterParameter, @RequestParam(name="workbasket-type", required=false) WorkbasketType[] workbasketTypes, @RequestParam(name="columnHeader", required=false) PriorityColumnHeaderRepresentationModel[] columnHeaders) throws NotAuthorizedException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        PriorityReportFilterParameter priorityReportFilterParameter = filterParameter;
        WorkbasketType[] workbasketTypeArray = workbasketTypes;
        PriorityColumnHeaderRepresentationModel[] priorityColumnHeaderRepresentationModelArray = columnHeaders;
        Object[] objectArray = new Object[]{priorityReportFilterParameter, workbasketTypeArray, priorityColumnHeaderRepresentationModelArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketPriorityReport.Builder builder = this.monitorService.createWorkbasketPriorityReportBuilder().workbasketTypeIn(workbasketTypes);
        filterParameter.apply(builder);
        if (columnHeaders != null) {
            List priorityColumnHeaders = Arrays.stream(columnHeaders).map(this.priorityColumnHeaderRepresentationModelAssembler::toEntityModel).collect(Collectors.toList());
            builder.withColumnHeaders(priorityColumnHeaders);
        }
        ReportRepresentationModel report = this.reportRepresentationModelAssembler.toModel(builder.buildReport(), filterParameter, workbasketTypes, columnHeaders);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)report));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/monitor/classification-category-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> computeClassificationCategoryReport(TimeIntervalReportFilterParameter filterParameter, @RequestParam(name="task-timestamp", required=false) TaskTimestamp taskTimestamp) throws InvalidArgumentException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        TimeIntervalReportFilterParameter timeIntervalReportFilterParameter = filterParameter;
        TaskTimestamp taskTimestamp2 = taskTimestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)timeIntervalReportFilterParameter, (Object)taskTimestamp2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskTimestamp == null) {
            taskTimestamp = TaskTimestamp.DUE;
        }
        ClassificationCategoryReport.Builder builder = this.monitorService.createClassificationCategoryReportBuilder();
        filterParameter.apply((TimeIntervalReportBuilder<?, ?, TimeIntervalColumnHeader>)builder);
        ReportRepresentationModel report = this.reportRepresentationModelAssembler.toModel(builder.buildReport(taskTimestamp), filterParameter, taskTimestamp);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)report));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/monitor/classification-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> computeClassificationReport(TimeIntervalReportFilterParameter filterParameter, @RequestParam(name="task-timestamp", required=false) TaskTimestamp taskTimestamp) throws NotAuthorizedException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        TimeIntervalReportFilterParameter timeIntervalReportFilterParameter = filterParameter;
        TaskTimestamp taskTimestamp2 = taskTimestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)timeIntervalReportFilterParameter, (Object)taskTimestamp2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskTimestamp == null) {
            taskTimestamp = TaskTimestamp.DUE;
        }
        ClassificationReport.Builder builder = this.monitorService.createClassificationReportBuilder();
        filterParameter.apply((TimeIntervalReportBuilder<?, ?, TimeIntervalColumnHeader>)builder);
        ReportRepresentationModel report = this.reportRepresentationModelAssembler.toModel(builder.buildReport(taskTimestamp), filterParameter, taskTimestamp);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)report));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/monitor/detailed-classification-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> computeDetailedClassificationReport(TimeIntervalReportFilterParameter filterParameter, @RequestParam(name="task-timestamp", required=false) TaskTimestamp taskTimestamp) throws NotAuthorizedException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        TimeIntervalReportFilterParameter timeIntervalReportFilterParameter = filterParameter;
        TaskTimestamp taskTimestamp2 = taskTimestamp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)timeIntervalReportFilterParameter, (Object)taskTimestamp2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskTimestamp == null) {
            taskTimestamp = TaskTimestamp.DUE;
        }
        ClassificationReport.Builder builder = this.monitorService.createClassificationReportBuilder();
        filterParameter.apply((TimeIntervalReportBuilder<?, ?, TimeIntervalColumnHeader>)builder);
        ReportRepresentationModel report = this.reportRepresentationModelAssembler.toModel(builder.buildDetailedReport(taskTimestamp), filterParameter, taskTimestamp);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)report));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/monitor/task-custom-field-value-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> computeTaskCustomFieldValueReport(@RequestParam(name="custom-field") TaskCustomField customField, TimeIntervalReportFilterParameter filterParameter, @RequestParam(name="task-timestamp", required=false) TaskTimestamp taskTimestamp) throws NotAuthorizedException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        TaskCustomField taskCustomField = customField;
        TimeIntervalReportFilterParameter timeIntervalReportFilterParameter = filterParameter;
        TaskTimestamp taskTimestamp2 = taskTimestamp;
        Object[] objectArray = new Object[]{taskCustomField, timeIntervalReportFilterParameter, taskTimestamp2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (taskTimestamp == null) {
            taskTimestamp = TaskTimestamp.DUE;
        }
        TaskCustomFieldValueReport.Builder builder = this.monitorService.createTaskCustomFieldValueReportBuilder(customField);
        filterParameter.apply((TimeIntervalReportBuilder<?, ?, TimeIntervalColumnHeader>)builder);
        ReportRepresentationModel report = this.reportRepresentationModelAssembler.toModel(builder.buildReport(taskTimestamp), customField, filterParameter, taskTimestamp);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)report));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/monitor/task-status-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> computeTaskStatusReport(@RequestParam(name="domain", required=false) List<String> domains, @RequestParam(name="state", required=false) List<TaskState> states, @RequestParam(name="workbasket-id", required=false) List<String> workbasketIds, @RequestParam(name="priority-minimum", required=false) Integer priorityMinimum) throws NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        List<String> list = domains;
        List<TaskState> list2 = states;
        List<String> list3 = workbasketIds;
        Integer n = priorityMinimum;
        Object[] objectArray = new Object[]{list, list2, list3, n};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskStatusReport.Builder builder = this.monitorService.createTaskStatusReportBuilder();
        if (states != null && !states.isEmpty()) {
            builder = builder.stateIn(states);
        }
        if (domains != null && !domains.isEmpty()) {
            builder.domainIn(domains);
        }
        if (workbasketIds != null && !workbasketIds.isEmpty()) {
            builder.workbasketIdsIn(workbasketIds);
        }
        if (priorityMinimum != null) {
            builder.priorityMinimum(priorityMinimum);
        }
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.reportRepresentationModelAssembler.toModel(builder.buildReport(), domains, states, workbasketIds, priorityMinimum))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/monitor/timestamp-report"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<ReportRepresentationModel> computeTimestampReport(TimeIntervalReportFilterParameter filterParameter, @RequestParam(name="task-timestamp", required=false) TaskTimestamp[] timestamps) throws NotAuthorizedException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        TimeIntervalReportFilterParameter timeIntervalReportFilterParameter = filterParameter;
        TaskTimestamp[] taskTimestampArray2 = timestamps;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)timeIntervalReportFilterParameter, (Object)taskTimestampArray2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TimestampReport.Builder builder = this.monitorService.createTimestampReportBuilder();
        filterParameter.apply((TimeIntervalReportBuilder<?, ?, TimeIntervalColumnHeader>)builder);
        Optional.ofNullable(timestamps).map(taskTimestampArray -> Arrays.asList(taskTimestampArray)).ifPresent(arg_0 -> ((TimestampReport.Builder)builder).withTimestamps(arg_0));
        ReportRepresentationModel report = this.reportRepresentationModelAssembler.toModel(builder.buildReport(), filterParameter, timestamps);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)report));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    static {
        MonitorController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MonitorController.java", MonitorController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "computeWorkbasketReport", "pro.taskana.monitor.rest.MonitorController", "pro.taskana.monitor.rest.TimeIntervalReportFilterParameter:pro.taskana.monitor.api.TaskTimestamp", "filterParameter:taskTimestamp", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 75);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "computePriorityWorkbasketReport", "pro.taskana.monitor.rest.MonitorController", "pro.taskana.monitor.rest.PriorityReportFilterParameter:[Lpro.taskana.workbasket.api.WorkbasketType;:[Lpro.taskana.monitor.rest.models.PriorityColumnHeaderRepresentationModel;", "filterParameter:workbasketTypes:columnHeaders", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 110);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "computeClassificationCategoryReport", "pro.taskana.monitor.rest.MonitorController", "pro.taskana.monitor.rest.TimeIntervalReportFilterParameter:pro.taskana.monitor.api.TaskTimestamp", "filterParameter:taskTimestamp", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 152);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "computeClassificationReport", "pro.taskana.monitor.rest.MonitorController", "pro.taskana.monitor.rest.TimeIntervalReportFilterParameter:pro.taskana.monitor.api.TaskTimestamp", "filterParameter:taskTimestamp", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 187);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "computeDetailedClassificationReport", "pro.taskana.monitor.rest.MonitorController", "pro.taskana.monitor.rest.TimeIntervalReportFilterParameter:pro.taskana.monitor.api.TaskTimestamp", "filterParameter:taskTimestamp", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 222);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "computeTaskCustomFieldValueReport", "pro.taskana.monitor.rest.MonitorController", "pro.taskana.task.api.TaskCustomField:pro.taskana.monitor.rest.TimeIntervalReportFilterParameter:pro.taskana.monitor.api.TaskTimestamp", "customField:filterParameter:taskTimestamp", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 257);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "computeTaskStatusReport", "pro.taskana.monitor.rest.MonitorController", "java.util.List:java.util.List:java.util.List:java.lang.Integer", "domains:states:workbasketIds:priorityMinimum", "pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 294);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "computeTimestampReport", "pro.taskana.monitor.rest.MonitorController", "pro.taskana.monitor.rest.TimeIntervalReportFilterParameter:[Lpro.taskana.monitor.api.TaskTimestamp;", "filterParameter:timestamps", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 337);
    }
}

