/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.monitor.rest.assembler;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.monitor.api.TaskTimestamp;
import pro.taskana.monitor.api.reports.ClassificationCategoryReport;
import pro.taskana.monitor.api.reports.ClassificationReport;
import pro.taskana.monitor.api.reports.Report;
import pro.taskana.monitor.api.reports.TaskCustomFieldValueReport;
import pro.taskana.monitor.api.reports.TaskStatusReport;
import pro.taskana.monitor.api.reports.TimestampReport;
import pro.taskana.monitor.api.reports.WorkbasketPriorityReport;
import pro.taskana.monitor.api.reports.WorkbasketReport;
import pro.taskana.monitor.api.reports.header.ColumnHeader;
import pro.taskana.monitor.api.reports.item.QueryItem;
import pro.taskana.monitor.api.reports.row.FoldableRow;
import pro.taskana.monitor.api.reports.row.Row;
import pro.taskana.monitor.api.reports.row.SingleRow;
import pro.taskana.monitor.rest.MonitorController;
import pro.taskana.monitor.rest.PriorityReportFilterParameter;
import pro.taskana.monitor.rest.TimeIntervalReportFilterParameter;
import pro.taskana.monitor.rest.models.PriorityColumnHeaderRepresentationModel;
import pro.taskana.monitor.rest.models.ReportRepresentationModel;
import pro.taskana.task.api.TaskCustomField;
import pro.taskana.task.api.TaskState;
import pro.taskana.workbasket.api.WorkbasketType;

@Component
public class ReportRepresentationModelAssembler {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    @NonNull
    public ReportRepresentationModel toModel(@NonNull WorkbasketReport report, @NonNull TimeIntervalReportFilterParameter filterParameter, @NonNull TaskTimestamp taskTimestamp) throws InvalidArgumentException, NotAuthorizedException {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        WorkbasketReport workbasketReport = report;
        TimeIntervalReportFilterParameter timeIntervalReportFilterParameter = filterParameter;
        TaskTimestamp taskTimestamp2 = taskTimestamp;
        Object[] objectArray = new Object[]{workbasketReport, timeIntervalReportFilterParameter, taskTimestamp2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).computeWorkbasketReport(filterParameter, taskTimestamp)).withSelfRel());
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = resource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    @NonNull
    public ReportRepresentationModel toModel(@NonNull WorkbasketPriorityReport report, @NonNull PriorityReportFilterParameter filterParameter, WorkbasketType[] workbasketTypes, PriorityColumnHeaderRepresentationModel[] columnHeaders) throws InvalidArgumentException, NotAuthorizedException {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        WorkbasketPriorityReport workbasketPriorityReport = report;
        PriorityReportFilterParameter priorityReportFilterParameter = filterParameter;
        WorkbasketType[] workbasketTypeArray = workbasketTypes;
        PriorityColumnHeaderRepresentationModel[] priorityColumnHeaderRepresentationModelArray = columnHeaders;
        Object[] objectArray = new Object[]{workbasketPriorityReport, priorityReportFilterParameter, workbasketTypeArray, priorityColumnHeaderRepresentationModelArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).computePriorityWorkbasketReport(filterParameter, workbasketTypes, columnHeaders)).withSelfRel());
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = resource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    @NonNull
    public ReportRepresentationModel toModel(@NonNull ClassificationCategoryReport report, @NonNull TimeIntervalReportFilterParameter filterParameter, @NonNull TaskTimestamp taskTimestamp) throws NotAuthorizedException, InvalidArgumentException {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        ClassificationCategoryReport classificationCategoryReport = report;
        TimeIntervalReportFilterParameter timeIntervalReportFilterParameter = filterParameter;
        TaskTimestamp taskTimestamp2 = taskTimestamp;
        Object[] objectArray = new Object[]{classificationCategoryReport, timeIntervalReportFilterParameter, taskTimestamp2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).computeClassificationCategoryReport(filterParameter, taskTimestamp)).withSelfRel());
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = resource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    @NonNull
    public ReportRepresentationModel toModel(@NonNull ClassificationReport report, @NonNull TimeIntervalReportFilterParameter filterParameter, @NonNull TaskTimestamp taskTimestamp) throws NotAuthorizedException, InvalidArgumentException {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        ClassificationReport classificationReport = report;
        TimeIntervalReportFilterParameter timeIntervalReportFilterParameter = filterParameter;
        TaskTimestamp taskTimestamp2 = taskTimestamp;
        Object[] objectArray = new Object[]{classificationReport, timeIntervalReportFilterParameter, taskTimestamp2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).computeClassificationReport(filterParameter, taskTimestamp)).withSelfRel());
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = resource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    @NonNull
    public ReportRepresentationModel toModel(@NonNull ClassificationReport.DetailedClassificationReport report, @NonNull TimeIntervalReportFilterParameter filterParameter, @NonNull TaskTimestamp taskTimestamp) throws NotAuthorizedException, InvalidArgumentException {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        ClassificationReport.DetailedClassificationReport detailedClassificationReport = report;
        TimeIntervalReportFilterParameter timeIntervalReportFilterParameter = filterParameter;
        TaskTimestamp taskTimestamp2 = taskTimestamp;
        Object[] objectArray = new Object[]{detailedClassificationReport, timeIntervalReportFilterParameter, taskTimestamp2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).computeDetailedClassificationReport(filterParameter, taskTimestamp)).withSelfRel());
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = resource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    @NonNull
    public ReportRepresentationModel toModel(@NonNull TaskCustomFieldValueReport report, @NonNull TaskCustomField customField, @NonNull TimeIntervalReportFilterParameter filterParameter, @NonNull TaskTimestamp taskTimestamp) throws InvalidArgumentException, NotAuthorizedException {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        TaskCustomFieldValueReport taskCustomFieldValueReport = report;
        TaskCustomField taskCustomField = customField;
        TimeIntervalReportFilterParameter timeIntervalReportFilterParameter = filterParameter;
        TaskTimestamp taskTimestamp2 = taskTimestamp;
        Object[] objectArray = new Object[]{taskCustomFieldValueReport, taskCustomField, timeIntervalReportFilterParameter, taskTimestamp2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).computeTaskCustomFieldValueReport(customField, filterParameter, taskTimestamp)).withSelfRel());
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = resource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    @NonNull
    public ReportRepresentationModel toModel(TaskStatusReport report, List<String> domain, List<TaskState> state, List<String> workbasketIds, Integer priorityMinimum) throws NotAuthorizedException {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        TaskStatusReport taskStatusReport = report;
        List<String> list = domain;
        List<TaskState> list2 = state;
        List<String> list3 = workbasketIds;
        Integer n = priorityMinimum;
        Object[] objectArray = new Object[]{taskStatusReport, list, list2, list3, n};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).computeTaskStatusReport(domain, state, workbasketIds, priorityMinimum)).withSelfRel());
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = resource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    @NonNull
    public ReportRepresentationModel toModel(@NonNull TimestampReport report, @NonNull TimeIntervalReportFilterParameter filterParameter, TaskTimestamp[] timestamps) throws NotAuthorizedException, InvalidArgumentException {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        TimestampReport timestampReport = report;
        TimeIntervalReportFilterParameter timeIntervalReportFilterParameter = filterParameter;
        TaskTimestamp[] taskTimestampArray = timestamps;
        Object[] objectArray = new Object[]{timestampReport, timeIntervalReportFilterParameter, taskTimestampArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel resource = this.toReportResource((Report)report);
        resource.add(WebMvcLinkBuilder.linkTo(((MonitorController)WebMvcLinkBuilder.methodOn(MonitorController.class, (Object[])new Object[0])).computeTimestampReport(filterParameter, timestamps)).withSelfRel());
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = resource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    <I extends QueryItem, H extends ColumnHeader<? super I>> ReportRepresentationModel toReportResource(Report<I, H> report, Instant time) {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        Report report2 = report;
        Instant instant = time;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, report2, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] header = (String[])report.getColumnHeaders().stream().map(ColumnHeader::getDisplayName).toArray(String[]::new);
        ReportRepresentationModel.MetaInformation meta = new ReportRepresentationModel.MetaInformation(report.getClass().getSimpleName(), time, header, report.getRowDesc(), report.getSumRow().getKey());
        List<ReportRepresentationModel.RowRepresentationModel> rows = report.getRows().values().stream().sorted(Comparator.comparing(e -> e.getKey().toLowerCase())).map(i -> this.transformRow((Row)i, new String[report.getRowDesc().length], 0)).flatMap(Collection::stream).collect(Collectors.toList());
        List<ReportRepresentationModel.RowRepresentationModel> sumRow = this.transformRow(report.getSumRow(), new String[report.getRowDesc().length], 0);
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = new ReportRepresentationModel(meta, rows, sumRow));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    <I extends QueryItem, H extends ColumnHeader<? super I>> ReportRepresentationModel toReportResource(Report<I, H> report) {
        ReportRepresentationModel reportRepresentationModel;
        ReportRepresentationModel reportRepresentationModel2;
        Report<I, H> report2 = report;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, report2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel reportRepresentationModel3 = reportRepresentationModel2 = (reportRepresentationModel = this.toReportResource(report, Instant.now()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)reportRepresentationModel2);
        return reportRepresentationModel;
    }

    private <I extends QueryItem> List<ReportRepresentationModel.RowRepresentationModel> transformRow(Row<I> row, String[] desc, int depth) {
        List<ReportRepresentationModel.RowRepresentationModel> list;
        List<ReportRepresentationModel.RowRepresentationModel> list2;
        Row<I> row2 = row;
        String[] stringArray = desc;
        int n = depth;
        Object[] objectArray = new Object[]{row2, stringArray, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<ReportRepresentationModel.RowRepresentationModel> list3 = list2 = row.getClass() == SingleRow.class ? (list = Collections.singletonList(this.transformSingleRow((SingleRow)row, desc, depth))) : (list = this.transformFoldableRow((FoldableRow)row, desc, depth));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    private <I extends QueryItem> ReportRepresentationModel.RowRepresentationModel transformSingleRow(SingleRow<I> row, String[] previousRowDesc, int depth) {
        ReportRepresentationModel.RowRepresentationModel rowRepresentationModel;
        ReportRepresentationModel.RowRepresentationModel rowRepresentationModel2;
        SingleRow<I> singleRow = row;
        String[] stringArray = previousRowDesc;
        int n = depth;
        Object[] objectArray = new Object[]{singleRow, stringArray, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] rowDesc = new String[previousRowDesc.length];
        System.arraycopy(previousRowDesc, 0, rowDesc, 0, depth);
        rowDesc[depth] = row.getDisplayName();
        ReportRepresentationModel.RowRepresentationModel rowRepresentationModel3 = rowRepresentationModel2 = (rowRepresentationModel = new ReportRepresentationModel.RowRepresentationModel(row.getCells(), row.getTotalValue(), depth, rowDesc, depth == 0));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)rowRepresentationModel2);
        return rowRepresentationModel;
    }

    private <I extends QueryItem> List<ReportRepresentationModel.RowRepresentationModel> transformFoldableRow(FoldableRow<I> row, String[] previousRowDesc, int depth) {
        LinkedList<ReportRepresentationModel.RowRepresentationModel> linkedList;
        LinkedList<ReportRepresentationModel.RowRepresentationModel> linkedList2;
        FoldableRow foldableRow = row;
        String[] stringArray = previousRowDesc;
        int n = depth;
        Object[] objectArray = new Object[]{foldableRow, stringArray, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ReportRepresentationModel.RowRepresentationModel baseRow = this.transformSingleRow((SingleRow<I>)row, previousRowDesc, depth);
        LinkedList<ReportRepresentationModel.RowRepresentationModel> rowList = new LinkedList<ReportRepresentationModel.RowRepresentationModel>();
        rowList.add(baseRow);
        row.getFoldableRowKeySet().stream().sorted(String.CASE_INSENSITIVE_ORDER).map(s -> this.transformRow(row.getFoldableRow(s), baseRow.getDesc(), depth + 1)).flatMap(Collection::stream).forEachOrdered(rowList::add);
        LinkedList<ReportRepresentationModel.RowRepresentationModel> linkedList3 = linkedList2 = (linkedList = rowList);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, linkedList2);
        return linkedList;
    }

    static {
        ReportRepresentationModelAssembler.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ReportRepresentationModelAssembler.java", ReportRepresentationModelAssembler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toModel", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.WorkbasketReport:pro.taskana.monitor.rest.TimeIntervalReportFilterParameter:pro.taskana.monitor.api.TaskTimestamp", "report:filterParameter:taskTimestamp", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 47);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toModel", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.WorkbasketPriorityReport:pro.taskana.monitor.rest.PriorityReportFilterParameter:[Lpro.taskana.workbasket.api.WorkbasketType;:[Lpro.taskana.monitor.rest.models.PriorityColumnHeaderRepresentationModel;", "report:filterParameter:workbasketTypes:columnHeaders", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 62);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "transformRow", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.row.Row:[Ljava.lang.String;:int", "row:desc:depth", "", "java.util.List"), 202);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "transformSingleRow", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.row.SingleRow:[Ljava.lang.String;:int", "row:previousRowDesc:depth", "", "pro.taskana.monitor.rest.models.ReportRepresentationModel$RowRepresentationModel"), 214);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "transformFoldableRow", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.row.FoldableRow:[Ljava.lang.String;:int", "row:previousRowDesc:depth", "", "java.util.List"), 223);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toModel", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.ClassificationCategoryReport:pro.taskana.monitor.rest.TimeIntervalReportFilterParameter:pro.taskana.monitor.api.TaskTimestamp", "report:filterParameter:taskTimestamp", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 79);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toModel", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.ClassificationReport:pro.taskana.monitor.rest.TimeIntervalReportFilterParameter:pro.taskana.monitor.api.TaskTimestamp", "report:filterParameter:taskTimestamp", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 94);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toModel", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.ClassificationReport$DetailedClassificationReport:pro.taskana.monitor.rest.TimeIntervalReportFilterParameter:pro.taskana.monitor.api.TaskTimestamp", "report:filterParameter:taskTimestamp", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 109);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toModel", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.TaskCustomFieldValueReport:pro.taskana.task.api.TaskCustomField:pro.taskana.monitor.rest.TimeIntervalReportFilterParameter:pro.taskana.monitor.api.TaskTimestamp", "report:customField:filterParameter:taskTimestamp", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 124);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toModel", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.TaskStatusReport:java.util.List:java.util.List:java.util.List:java.lang.Integer", "report:domain:state:workbasketIds:priorityMinimum", "pro.taskana.common.api.exceptions.NotAuthorizedException", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 140);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toModel", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.TimestampReport:pro.taskana.monitor.rest.TimeIntervalReportFilterParameter:[Lpro.taskana.monitor.api.TaskTimestamp;", "report:filterParameter:timestamps", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 157);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "toReportResource", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.Report:java.time.Instant", "report:time", "", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 172);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "toReportResource", "pro.taskana.monitor.rest.assembler.ReportRepresentationModelAssembler", "pro.taskana.monitor.api.reports.Report", "report", "", "pro.taskana.monitor.rest.models.ReportRepresentationModel"), 198);
    }
}

