/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.BiConsumer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QueryPagingParameter;
import pro.taskana.common.rest.QuerySortBy;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.common.rest.ldap.LdapClient;
import pro.taskana.common.rest.util.QueryParamsValidator;
import pro.taskana.workbasket.api.WorkbasketAccessItemQuery;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.models.WorkbasketAccessItem;
import pro.taskana.workbasket.rest.WorkbasketAccessItemQueryFilterParameter;
import pro.taskana.workbasket.rest.assembler.WorkbasketAccessItemRepresentationModelAssembler;
import pro.taskana.workbasket.rest.models.WorkbasketAccessItemPagedRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class WorkbasketAccessItemController {
    private final LdapClient ldapClient;
    private final WorkbasketService workbasketService;
    private final WorkbasketAccessItemRepresentationModelAssembler modelAssembler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Autowired
    public WorkbasketAccessItemController(LdapClient ldapClient, WorkbasketService workbasketService, WorkbasketAccessItemRepresentationModelAssembler modelAssembler) {
        this.ldapClient = ldapClient;
        this.workbasketService = workbasketService;
        this.modelAssembler = modelAssembler;
    }

    @GetMapping(path={"/api/v1/workbasket-access-items"})
    public ResponseEntity<WorkbasketAccessItemPagedRepresentationModel> getWorkbasketAccessItems(HttpServletRequest request, WorkbasketAccessItemQueryFilterParameter filterParameter, WorkbasketAccessItemQuerySortParameter sortParameter, QueryPagingParameter<WorkbasketAccessItem, WorkbasketAccessItemQuery> pagingParameter) throws NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        HttpServletRequest httpServletRequest = request;
        WorkbasketAccessItemQueryFilterParameter workbasketAccessItemQueryFilterParameter = filterParameter;
        WorkbasketAccessItemQuerySortParameter workbasketAccessItemQuerySortParameter = sortParameter;
        QueryPagingParameter<WorkbasketAccessItem, WorkbasketAccessItemQuery> queryPagingParameter = pagingParameter;
        Object[] objectArray = new Object[]{httpServletRequest, workbasketAccessItemQueryFilterParameter, workbasketAccessItemQuerySortParameter, queryPagingParameter};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        QueryParamsValidator.validateParams(request, WorkbasketAccessItemQueryFilterParameter.class, QuerySortParameter.class, QueryPagingParameter.class);
        WorkbasketAccessItemQuery query = this.workbasketService.createWorkbasketAccessItemQuery();
        filterParameter.apply(query);
        sortParameter.apply(query);
        List<WorkbasketAccessItem> workbasketAccessItems = pagingParameter.apply(query);
        WorkbasketAccessItemPagedRepresentationModel pagedResources = (WorkbasketAccessItemPagedRepresentationModel)this.modelAssembler.toPagedModel(workbasketAccessItems, pagingParameter.getPageMetadata());
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)pagedResources)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @DeleteMapping(path={"/api/v1/workbasket-access-items"})
    public ResponseEntity<Void> removeWorkbasketAccessItems(@RequestParam(value="access-id") String accessId) throws NotAuthorizedException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = accessId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.ldapClient.isUser(accessId)) {
            List workbasketAccessItemList = this.workbasketService.createWorkbasketAccessItemQuery().accessIdIn(new String[]{accessId}).list();
            if (workbasketAccessItemList != null && !workbasketAccessItemList.isEmpty()) {
                this.workbasketService.deleteWorkbasketAccessItemsForAccessId(accessId);
            }
        } else {
            throw new InvalidArgumentException(String.format("AccessId '%s' is not a user. You can remove all access items for users only.", accessId));
        }
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.noContent().build());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    static {
        WorkbasketAccessItemController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkbasketAccessItemController.java", WorkbasketAccessItemController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketAccessItems", "pro.taskana.workbasket.rest.WorkbasketAccessItemController", "jakarta.servlet.http.HttpServletRequest:pro.taskana.workbasket.rest.WorkbasketAccessItemQueryFilterParameter:pro.taskana.workbasket.rest.WorkbasketAccessItemController$WorkbasketAccessItemQuerySortParameter:pro.taskana.common.rest.QueryPagingParameter", "request:filterParameter:sortParameter:pagingParameter", "pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeWorkbasketAccessItems", "pro.taskana.workbasket.rest.WorkbasketAccessItemController", "java.lang.String", "accessId", "pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 95);
    }

    public static class WorkbasketAccessItemQuerySortParameter
    extends QuerySortParameter<WorkbasketAccessItemQuery, WorkbasketAccessItemSortBy> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        @ConstructorProperties(value={"sort-by", "order"})
        public WorkbasketAccessItemQuerySortParameter(List<WorkbasketAccessItemSortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
            super(sortBy, order);
        }

        @Override
        public List<WorkbasketAccessItemSortBy> getSortBy() {
            List<WorkbasketAccessItemSortBy> list;
            List<WorkbasketAccessItemSortBy> list2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            List<WorkbasketAccessItemSortBy> list3 = list2 = (list = super.getSortBy());
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
            return list;
        }

        static {
            WorkbasketAccessItemQuerySortParameter.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("WorkbasketAccessItemController.java", WorkbasketAccessItemQuerySortParameter.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSortBy", "pro.taskana.workbasket.rest.WorkbasketAccessItemController$WorkbasketAccessItemQuerySortParameter", "", "", "", "java.util.List"), 145);
        }
    }

    public static final class WorkbasketAccessItemSortBy
    extends Enum<WorkbasketAccessItemSortBy>
    implements QuerySortBy<WorkbasketAccessItemQuery> {
        public static final /* enum */ WorkbasketAccessItemSortBy WORKBASKET_KEY;
        public static final /* enum */ WorkbasketAccessItemSortBy ACCESS_ID;
        private final BiConsumer<WorkbasketAccessItemQuery, BaseQuery.SortDirection> consumer;
        private static final /* synthetic */ WorkbasketAccessItemSortBy[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        static {
            WorkbasketAccessItemSortBy.ajc$preClinit();
            WORKBASKET_KEY = new WorkbasketAccessItemSortBy(WorkbasketAccessItemQuery::orderByWorkbasketKey);
            ACCESS_ID = new WorkbasketAccessItemSortBy(WorkbasketAccessItemQuery::orderByAccessId);
            ENUM$VALUES = new WorkbasketAccessItemSortBy[]{WORKBASKET_KEY, ACCESS_ID};
        }

        private WorkbasketAccessItemSortBy(BiConsumer<WorkbasketAccessItemQuery, BaseQuery.SortDirection> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void applySortByForQuery(WorkbasketAccessItemQuery query, BaseQuery.SortDirection sortDirection) {
            WorkbasketAccessItemQuery workbasketAccessItemQuery = query;
            BaseQuery.SortDirection sortDirection2 = sortDirection;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)workbasketAccessItemQuery, (Object)sortDirection2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.consumer.accept(query, sortDirection);
            Object var6_6 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
        }

        public static WorkbasketAccessItemSortBy[] values() {
            WorkbasketAccessItemSortBy[] workbasketAccessItemSortByArray;
            WorkbasketAccessItemSortBy[] workbasketAccessItemSortByArray2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            WorkbasketAccessItemSortBy[] workbasketAccessItemSortByArray3 = ENUM$VALUES;
            int n = workbasketAccessItemSortByArray3.length;
            WorkbasketAccessItemSortBy[] workbasketAccessItemSortByArray4 = new WorkbasketAccessItemSortBy[n];
            System.arraycopy(ENUM$VALUES, 0, workbasketAccessItemSortByArray4, 0, n);
            WorkbasketAccessItemSortBy[] workbasketAccessItemSortByArray5 = workbasketAccessItemSortByArray2 = (workbasketAccessItemSortByArray = workbasketAccessItemSortByArray4);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketAccessItemSortByArray2);
            return workbasketAccessItemSortByArray;
        }

        public static WorkbasketAccessItemSortBy valueOf(String arg0) {
            WorkbasketAccessItemSortBy workbasketAccessItemSortBy;
            WorkbasketAccessItemSortBy workbasketAccessItemSortBy2;
            String string = arg0;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            WorkbasketAccessItemSortBy workbasketAccessItemSortBy3 = workbasketAccessItemSortBy2 = (workbasketAccessItemSortBy = Enum.valueOf(WorkbasketAccessItemSortBy.class, arg0));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketAccessItemSortBy2);
            return workbasketAccessItemSortBy;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("WorkbasketAccessItemController.java", WorkbasketAccessItemSortBy.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "applySortByForQuery", "pro.taskana.workbasket.rest.WorkbasketAccessItemController$WorkbasketAccessItemSortBy", "pro.taskana.workbasket.api.WorkbasketAccessItemQuery:pro.taskana.common.api.BaseQuery$SortDirection", "query:sortDirection", "", "void"), 126);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "pro.taskana.workbasket.rest.WorkbasketAccessItemController$WorkbasketAccessItemSortBy", "", "", "", "[Lpro.taskana.workbasket.rest.WorkbasketAccessItemController$WorkbasketAccessItemSortBy;"), 1);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "pro.taskana.workbasket.rest.WorkbasketAccessItemController$WorkbasketAccessItemSortBy", "java.lang.String", "arg0", "", "pro.taskana.workbasket.rest.WorkbasketAccessItemController$WorkbasketAccessItemSortBy"), 1);
        }
    }
}

