/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QueryPagingParameter;
import pro.taskana.common.rest.QuerySortBy;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.common.rest.util.QueryParamsValidator;
import pro.taskana.workbasket.api.WorkbasketCustomField;
import pro.taskana.workbasket.api.WorkbasketQuery;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketInUseException;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter;
import pro.taskana.workbasket.rest.assembler.WorkbasketAccessItemRepresentationModelAssembler;
import pro.taskana.workbasket.rest.assembler.WorkbasketRepresentationModelAssembler;
import pro.taskana.workbasket.rest.assembler.WorkbasketSummaryRepresentationModelAssembler;
import pro.taskana.workbasket.rest.models.DistributionTargetsCollectionRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketAccessItemCollectionRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketSummaryPagedRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class WorkbasketController {
    private static final Logger LOGGER;
    private final WorkbasketService workbasketService;
    private final WorkbasketRepresentationModelAssembler workbasketRepresentationModelAssembler;
    private final WorkbasketSummaryRepresentationModelAssembler workbasketSummaryRepresentationModelAssembler;
    private final WorkbasketAccessItemRepresentationModelAssembler workbasketAccessItemRepresentationModelAssembler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        WorkbasketController.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(WorkbasketController.class);
    }

    @Autowired
    WorkbasketController(WorkbasketService workbasketService, WorkbasketRepresentationModelAssembler workbasketRepresentationModelAssembler, WorkbasketSummaryRepresentationModelAssembler workbasketSummaryRepresentationModelAssembler, WorkbasketAccessItemRepresentationModelAssembler workbasketAccessItemRepresentationModelAssembler) {
        this.workbasketService = workbasketService;
        this.workbasketRepresentationModelAssembler = workbasketRepresentationModelAssembler;
        this.workbasketSummaryRepresentationModelAssembler = workbasketSummaryRepresentationModelAssembler;
        this.workbasketAccessItemRepresentationModelAssembler = workbasketAccessItemRepresentationModelAssembler;
    }

    @GetMapping(path={"/api/v1/workbaskets"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketSummaryPagedRepresentationModel> getWorkbaskets(HttpServletRequest request, WorkbasketQueryFilterParameter filterParameter, WorkbasketQuerySortParameter sortParameter, QueryPagingParameter<WorkbasketSummary, WorkbasketQuery> pagingParameter) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        HttpServletRequest httpServletRequest = request;
        WorkbasketQueryFilterParameter workbasketQueryFilterParameter = filterParameter;
        WorkbasketQuerySortParameter workbasketQuerySortParameter = sortParameter;
        QueryPagingParameter<WorkbasketSummary, WorkbasketQuery> queryPagingParameter = pagingParameter;
        Object[] objectArray = new Object[]{httpServletRequest, workbasketQueryFilterParameter, workbasketQuerySortParameter, queryPagingParameter};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        QueryParamsValidator.validateParams(request, WorkbasketQueryFilterParameter.class, QuerySortParameter.class, QueryPagingParameter.class);
        WorkbasketQuery query = this.workbasketService.createWorkbasketQuery();
        filterParameter.apply(query);
        sortParameter.apply(query);
        List<WorkbasketSummary> workbasketSummaries = pagingParameter.apply(query);
        WorkbasketSummaryPagedRepresentationModel pagedModels = (WorkbasketSummaryPagedRepresentationModel)((Object)this.workbasketSummaryRepresentationModelAssembler.toPagedModel(workbasketSummaries, pagingParameter.getPageMetadata()));
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)pagedModels)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/workbaskets/{workbasketId}"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketRepresentationModel> getWorkbasket(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Workbasket workbasket = this.workbasketService.getWorkbasket(workbasketId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.workbasketRepresentationModelAssembler.toModel(workbasket))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @DeleteMapping(path={"/api/v1/workbaskets/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={WorkbasketNotFoundException.class})
    public ResponseEntity<WorkbasketRepresentationModel> deleteWorkbasket(@PathVariable(value="workbasketId") String workbasketId) throws InvalidArgumentException, WorkbasketNotFoundException, WorkbasketInUseException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        ResponseEntity responseEntity3;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean workbasketDeleted = this.workbasketService.deleteWorkbasket(workbasketId);
        if (workbasketDeleted) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Workbasket successfully deleted.");
            }
            responseEntity2 = responseEntity3 = ResponseEntity.noContent().build();
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Workbasket was only marked for deletion and will be physically deleted later on.");
            }
            responseEntity2 = responseEntity3 = ResponseEntity.accepted().build();
        }
        ResponseEntity responseEntity4 = responseEntity = responseEntity2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity);
        return responseEntity3;
    }

    @PostMapping(path={"/api/v1/workbaskets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketRepresentationModel> createWorkbasket(@RequestBody WorkbasketRepresentationModel workbasketRepresentationModel) throws InvalidArgumentException, NotAuthorizedException, WorkbasketAlreadyExistException, DomainNotFoundException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        WorkbasketRepresentationModel workbasketRepresentationModel2 = workbasketRepresentationModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)((Object)workbasketRepresentationModel2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Workbasket workbasket = this.workbasketRepresentationModelAssembler.toEntityModel(workbasketRepresentationModel);
        workbasket = this.workbasketService.createWorkbasket(workbasket);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.workbasketRepresentationModelAssembler.toModel(workbasket)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PutMapping(path={"/api/v1/workbaskets/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketRepresentationModel> updateWorkbasket(@PathVariable(value="workbasketId") String workbasketId, @RequestBody WorkbasketRepresentationModel workbasketRepresentationModel) throws WorkbasketNotFoundException, NotAuthorizedException, ConcurrencyException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = workbasketId;
        WorkbasketRepresentationModel workbasketRepresentationModel2 = workbasketRepresentationModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)((Object)workbasketRepresentationModel2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!workbasketId.equals(workbasketRepresentationModel.getWorkbasketId())) {
            throw new InvalidArgumentException("Target-WB-ID('" + workbasketId + "') is not identical with the WB-ID of to object which should be updated. ID=('" + workbasketRepresentationModel.getWorkbasketId() + "')");
        }
        Workbasket workbasket = this.workbasketRepresentationModelAssembler.toEntityModel(workbasketRepresentationModel);
        workbasket = this.workbasketService.updateWorkbasket(workbasket);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.workbasketRepresentationModelAssembler.toModel(workbasket))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/workbaskets/{workbasketId}/workbasketAccessItems"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketAccessItemCollectionRepresentationModel> getWorkbasketAccessItems(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List accessItems = this.workbasketService.getWorkbasketAccessItems(workbasketId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.workbasketAccessItemRepresentationModelAssembler.toTaskanaCollectionModelForSingleWorkbasket(workbasketId, accessItems))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PutMapping(path={"/api/v1/workbaskets/{workbasketId}/workbasketAccessItems"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketAccessItemCollectionRepresentationModel> setWorkbasketAccessItems(@PathVariable(value="workbasketId") String workbasketId, @RequestBody WorkbasketAccessItemCollectionRepresentationModel workbasketAccessItemRepModels) throws InvalidArgumentException, WorkbasketNotFoundException, WorkbasketAccessItemAlreadyExistException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = workbasketId;
        WorkbasketAccessItemCollectionRepresentationModel workbasketAccessItemCollectionRepresentationModel = workbasketAccessItemRepModels;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string, (Object)((Object)workbasketAccessItemCollectionRepresentationModel));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (workbasketAccessItemRepModels == null) {
            throw new InvalidArgumentException("Can't create something with NULL body-value.");
        }
        List wbAccessItems = workbasketAccessItemRepModels.getContent().stream().map(this.workbasketAccessItemRepresentationModelAssembler::toEntityModel).collect(Collectors.toList());
        this.workbasketService.setWorkbasketAccessItems(workbasketId, wbAccessItems);
        List updatedWbAccessItems = this.workbasketService.getWorkbasketAccessItems(workbasketId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.workbasketAccessItemRepresentationModelAssembler.toTaskanaCollectionModelForSingleWorkbasket(workbasketId, updatedWbAccessItems))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/workbaskets/{workbasketId}/distribution-targets"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<DistributionTargetsCollectionRepresentationModel> getDistributionTargets(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List distributionTargets = this.workbasketService.getDistributionTargets(workbasketId);
        DistributionTargetsCollectionRepresentationModel distributionTargetRepModels = (DistributionTargetsCollectionRepresentationModel)this.workbasketSummaryRepresentationModelAssembler.toTaskanaCollectionModel(distributionTargets);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)distributionTargetRepModels)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @PutMapping(path={"/api/v1/workbaskets/{workbasketId}/distribution-targets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<DistributionTargetsCollectionRepresentationModel> setDistributionTargetsForWorkbasketId(@PathVariable(value="workbasketId") String sourceWorkbasketId, @RequestBody List<String> targetWorkbasketIds) throws WorkbasketNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = sourceWorkbasketId;
        List<String> list = targetWorkbasketIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.workbasketService.setDistributionTargets(sourceWorkbasketId, targetWorkbasketIds);
        List distributionTargets = this.workbasketService.getDistributionTargets(sourceWorkbasketId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)((DistributionTargetsCollectionRepresentationModel)this.workbasketSummaryRepresentationModelAssembler.toTaskanaCollectionModel(distributionTargets)))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @DeleteMapping(path={"/api/v1/workbaskets/{workbasketId}/distribution-targets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Void> removeDistributionTargetForWorkbasketId(@PathVariable(value="workbasketId") String targetWorkbasketId) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = targetWorkbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List sourceWorkbaskets = this.workbasketService.getDistributionSources(targetWorkbasketId);
        for (WorkbasketSummary source : sourceWorkbaskets) {
            this.workbasketService.removeDistributionTarget(source.getId(), targetWorkbasketId);
        }
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.noContent().build());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkbasketController.java", WorkbasketController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbaskets", "pro.taskana.workbasket.rest.WorkbasketController", "jakarta.servlet.http.HttpServletRequest:pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter:pro.taskana.workbasket.rest.WorkbasketController$WorkbasketQuerySortParameter:pro.taskana.common.rest.QueryPagingParameter", "request:filterParameter:sortParameter:pagingParameter", "", "org.springframework.http.ResponseEntity"), 95);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasket", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String", "workbasketId", "pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 131);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteWorkbasket", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String", "workbasketId", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketInUseException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 163);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createWorkbasket", "pro.taskana.workbasket.rest.WorkbasketController", "pro.taskana.workbasket.rest.models.WorkbasketRepresentationModel", "workbasketRepresentationModel", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException:pro.taskana.common.api.exceptions.DomainNotFoundException", "org.springframework.http.ResponseEntity"), 201);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateWorkbasket", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String:pro.taskana.workbasket.rest.models.WorkbasketRepresentationModel", "workbasketId:workbasketRepresentationModel", "pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 232);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketAccessItems", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String", "workbasketId", "pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 270);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setWorkbasketAccessItems", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String:pro.taskana.workbasket.rest.models.WorkbasketAccessItemCollectionRepresentationModel", "workbasketId:workbasketAccessItemRepModels", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 301);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDistributionTargets", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String", "workbasketId", "pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 340);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDistributionTargetsForWorkbasketId", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String:java.util.List", "sourceWorkbasketId:targetWorkbasketIds", "pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 366);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeDistributionTargetForWorkbasketId", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String", "targetWorkbasketId", "pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 394);
    }

    public static final class WorkbasketQuerySortBy
    extends Enum<WorkbasketQuerySortBy>
    implements QuerySortBy<WorkbasketQuery> {
        public static final /* enum */ WorkbasketQuerySortBy NAME;
        public static final /* enum */ WorkbasketQuerySortBy KEY;
        public static final /* enum */ WorkbasketQuerySortBy OWNER;
        public static final /* enum */ WorkbasketQuerySortBy TYPE;
        public static final /* enum */ WorkbasketQuerySortBy DESCRIPTION;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_1;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_2;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_3;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_4;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_5;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_6;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_7;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_8;
        public static final /* enum */ WorkbasketQuerySortBy DOMAIN;
        public static final /* enum */ WorkbasketQuerySortBy ORG_LEVEL_1;
        public static final /* enum */ WorkbasketQuerySortBy ORG_LEVEL_2;
        public static final /* enum */ WorkbasketQuerySortBy ORG_LEVEL_3;
        public static final /* enum */ WorkbasketQuerySortBy ORG_LEVEL_4;
        private final BiConsumer<WorkbasketQuery, BaseQuery.SortDirection> consumer;
        private static final /* synthetic */ WorkbasketQuerySortBy[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        static {
            WorkbasketQuerySortBy.ajc$preClinit();
            NAME = new WorkbasketQuerySortBy(WorkbasketQuery::orderByName);
            KEY = new WorkbasketQuerySortBy(WorkbasketQuery::orderByKey);
            OWNER = new WorkbasketQuerySortBy(WorkbasketQuery::orderByOwner);
            TYPE = new WorkbasketQuerySortBy(WorkbasketQuery::orderByType);
            DESCRIPTION = new WorkbasketQuerySortBy(WorkbasketQuery::orderByDescription);
            CUSTOM_1 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_1, sort);
            });
            CUSTOM_2 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_2, sort);
            });
            CUSTOM_3 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_3, sort);
            });
            CUSTOM_4 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_4, sort);
            });
            CUSTOM_5 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_5, sort);
            });
            CUSTOM_6 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_6, sort);
            });
            CUSTOM_7 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_7, sort);
            });
            CUSTOM_8 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_8, sort);
            });
            DOMAIN = new WorkbasketQuerySortBy(WorkbasketQuery::orderByDomain);
            ORG_LEVEL_1 = new WorkbasketQuerySortBy(WorkbasketQuery::orderByOrgLevel1);
            ORG_LEVEL_2 = new WorkbasketQuerySortBy(WorkbasketQuery::orderByOrgLevel2);
            ORG_LEVEL_3 = new WorkbasketQuerySortBy(WorkbasketQuery::orderByOrgLevel3);
            ORG_LEVEL_4 = new WorkbasketQuerySortBy(WorkbasketQuery::orderByOrgLevel4);
            ENUM$VALUES = new WorkbasketQuerySortBy[]{NAME, KEY, OWNER, TYPE, DESCRIPTION, CUSTOM_1, CUSTOM_2, CUSTOM_3, CUSTOM_4, CUSTOM_5, CUSTOM_6, CUSTOM_7, CUSTOM_8, DOMAIN, ORG_LEVEL_1, ORG_LEVEL_2, ORG_LEVEL_3, ORG_LEVEL_4};
        }

        private WorkbasketQuerySortBy(BiConsumer<WorkbasketQuery, BaseQuery.SortDirection> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void applySortByForQuery(WorkbasketQuery query, BaseQuery.SortDirection sortDirection) {
            WorkbasketQuery workbasketQuery = query;
            BaseQuery.SortDirection sortDirection2 = sortDirection;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)workbasketQuery, (Object)sortDirection2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.consumer.accept(query, sortDirection);
            Object var6_6 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
        }

        public static WorkbasketQuerySortBy[] values() {
            WorkbasketQuerySortBy[] workbasketQuerySortByArray;
            WorkbasketQuerySortBy[] workbasketQuerySortByArray2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            WorkbasketQuerySortBy[] workbasketQuerySortByArray3 = ENUM$VALUES;
            int n = workbasketQuerySortByArray3.length;
            WorkbasketQuerySortBy[] workbasketQuerySortByArray4 = new WorkbasketQuerySortBy[n];
            System.arraycopy(ENUM$VALUES, 0, workbasketQuerySortByArray4, 0, n);
            WorkbasketQuerySortBy[] workbasketQuerySortByArray5 = workbasketQuerySortByArray2 = (workbasketQuerySortByArray = workbasketQuerySortByArray4);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketQuerySortByArray2);
            return workbasketQuerySortByArray;
        }

        public static WorkbasketQuerySortBy valueOf(String arg0) {
            WorkbasketQuerySortBy workbasketQuerySortBy;
            WorkbasketQuerySortBy workbasketQuerySortBy2;
            String string = arg0;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            WorkbasketQuerySortBy workbasketQuerySortBy3 = workbasketQuerySortBy2 = (workbasketQuerySortBy = Enum.valueOf(WorkbasketQuerySortBy.class, arg0));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketQuerySortBy2);
            return workbasketQuerySortBy;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("WorkbasketController.java", WorkbasketQuerySortBy.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "applySortByForQuery", "pro.taskana.workbasket.rest.WorkbasketController$WorkbasketQuerySortBy", "pro.taskana.workbasket.api.WorkbasketQuery:pro.taskana.common.api.BaseQuery$SortDirection", "query:sortDirection", "", "void"), 435);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "pro.taskana.workbasket.rest.WorkbasketController$WorkbasketQuerySortBy", "", "", "", "[Lpro.taskana.workbasket.rest.WorkbasketController$WorkbasketQuerySortBy;"), 1);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "pro.taskana.workbasket.rest.WorkbasketController$WorkbasketQuerySortBy", "java.lang.String", "arg0", "", "pro.taskana.workbasket.rest.WorkbasketController$WorkbasketQuerySortBy"), 1);
        }
    }

    public static class WorkbasketQuerySortParameter
    extends QuerySortParameter<WorkbasketQuery, WorkbasketQuerySortBy> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        @ConstructorProperties(value={"sort-by", "order"})
        public WorkbasketQuerySortParameter(List<WorkbasketQuerySortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
            super(sortBy, order);
        }

        @Override
        public List<WorkbasketQuerySortBy> getSortBy() {
            List<WorkbasketQuerySortBy> list;
            List<WorkbasketQuerySortBy> list2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            List<WorkbasketQuerySortBy> list3 = list2 = (list = super.getSortBy());
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
            return list;
        }

        static {
            WorkbasketQuerySortParameter.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("WorkbasketController.java", WorkbasketQuerySortParameter.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSortBy", "pro.taskana.workbasket.rest.WorkbasketController$WorkbasketQuerySortParameter", "", "", "", "java.util.List"), 454);
        }
    }
}

