/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.classification.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.classification.api.ClassificationCustomField;
import pro.taskana.classification.api.ClassificationQuery;
import pro.taskana.common.api.SharedConstants;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.CheckedConsumer;
import pro.taskana.common.internal.util.Pair;
import pro.taskana.common.rest.QueryParameter;

public class ClassificationQueryFilterParameter
implements QueryParameter<ClassificationQuery, Void> {
    @Schema(name="name", description="Filter by the name of the Classification. This is an exact match.")
    @JsonProperty(value="name")
    private final String[] name;
    @Schema(name="name-like", description="Filter by the name of the Classification. This results in a substring search. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="name-like")
    private final String[] nameLike;
    @Schema(name="key", description="Filter by the key of the Classification. This is an exact match.")
    @JsonProperty(value="key")
    private final String[] key;
    @Schema(name="category", description="Filter by the category of the Classification. This is an exact match.")
    @JsonProperty(value="category")
    private final String[] category;
    @Schema(name="domain", description="Filter by the domain of the Classification. This is an exact match.")
    @JsonProperty(value="domain")
    private final String[] domain;
    @Schema(name="type", description="Filter by the type of the Classification. This is an exact match.")
    @JsonProperty(value="type")
    private final String[] type;
    @Schema(name="custom-1-like", description="Filter by the value of the field custom1. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="custom-1-like")
    private final String[] custom1Like;
    @Schema(name="custom-2-like", description="Filter by the value of the field custom2. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="custom-2-like")
    private final String[] custom2Like;
    @Schema(name="custom-3-like", description="Filter by the value of the field custom3. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="custom-3-like")
    private final String[] custom3Like;
    @Schema(name="custom-4-like", description="Filter by the value of the field custom4. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="custom-4-like")
    private final String[] custom4Like;
    @Schema(name="custom-5-like", description="Filter by the value of the field custom5. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="custom-5-like")
    private final String[] custom5Like;
    @Schema(name="custom-6-like", description="Filter by the value of the field custom6. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="custom-6-like")
    private final String[] custom6Like;
    @Schema(name="custom-7-like", description="Filter by the value of the field custom7. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="custom-7-like")
    private final String[] custom7Like;
    @Schema(name="custom-8-like", description="Filter by the value of the field custom8. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="custom-8-like")
    private final String[] custom8Like;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;

    public String[] getName() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.name);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getNameLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.nameLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getKey() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.key);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCategory() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.category);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getDomain() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.domain);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getType() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.type);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom1Like() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom1Like);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom2Like() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom2Like);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom3Like() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom3Like);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom4Like() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom4Like);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom5Like() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom5Like);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom6Like() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom6Like);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom7Like() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom7Like);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCustom8Like() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.custom8Like);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    @ConstructorProperties(value={"name", "name-like", "key", "category", "domain", "type", "custom-1-like", "custom-2-like", "custom-3-like", "custom-4-like", "custom-5-like", "custom-6-like", "custom-7-like", "custom-8-like"})
    public ClassificationQueryFilterParameter(String[] name, String[] nameLike, String[] key, String[] category, String[] domain, String[] type, String[] custom1Like, String[] custom2Like, String[] custom3Like, String[] custom4Like, String[] custom5Like, String[] custom6Like, String[] custom7Like, String[] custom8Like) {
        this.name = name;
        this.nameLike = nameLike;
        this.key = key;
        this.category = category;
        this.domain = domain != null && domain.length == 0 ? new String[]{SharedConstants.MASTER_DOMAIN} : domain;
        this.type = type;
        this.custom1Like = custom1Like;
        this.custom2Like = custom2Like;
        this.custom3Like = custom3Like;
        this.custom4Like = custom4Like;
        this.custom5Like = custom5Like;
        this.custom6Like = custom6Like;
        this.custom7Like = custom7Like;
        this.custom8Like = custom8Like;
    }

    @Override
    public Void apply(ClassificationQuery query) {
        Void void_;
        ClassificationQuery classificationQuery = query;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)classificationQuery);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Optional.ofNullable(this.name).ifPresent(stringArray -> {
            ClassificationQuery classificationQuery2 = query.nameIn(stringArray);
        });
        Optional.ofNullable(this.nameLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            ClassificationQuery classificationQuery2 = query.nameLike(stringArray);
        });
        Optional.ofNullable(this.key).ifPresent(stringArray -> {
            ClassificationQuery classificationQuery2 = query.keyIn(stringArray);
        });
        Optional.ofNullable(this.category).ifPresent(stringArray -> {
            ClassificationQuery classificationQuery2 = query.categoryIn(stringArray);
        });
        Optional.ofNullable(this.domain).ifPresent(stringArray -> {
            ClassificationQuery classificationQuery2 = query.domainIn(stringArray);
        });
        Optional.ofNullable(this.type).ifPresent(stringArray -> {
            ClassificationQuery classificationQuery2 = query.typeIn(stringArray);
        });
        Stream.of(Pair.of((Object)ClassificationCustomField.CUSTOM_1, (Object)this.custom1Like), Pair.of((Object)ClassificationCustomField.CUSTOM_2, (Object)this.custom2Like), Pair.of((Object)ClassificationCustomField.CUSTOM_3, (Object)this.custom3Like), Pair.of((Object)ClassificationCustomField.CUSTOM_4, (Object)this.custom4Like), Pair.of((Object)ClassificationCustomField.CUSTOM_5, (Object)this.custom5Like), Pair.of((Object)ClassificationCustomField.CUSTOM_6, (Object)this.custom6Like), Pair.of((Object)ClassificationCustomField.CUSTOM_7, (Object)this.custom7Like), Pair.of((Object)ClassificationCustomField.CUSTOM_8, (Object)this.custom8Like)).forEach(pair -> Optional.ofNullable((String[])pair.getRight()).map(this::wrapElementsInLikeStatement).ifPresent(CheckedConsumer.wrap(l -> {
            ClassificationQuery classificationQuery2 = query.customAttributeLike((ClassificationCustomField)pair.getLeft(), l);
        })));
        Void void_2 = null;
        Void void_3 = void_ = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, void_);
        return void_2;
    }

    static {
        ClassificationQueryFilterParameter.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ClassificationQueryFilterParameter.java", ClassificationQueryFilterParameter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getName", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 19);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNameLike", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 23);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom5Like", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 59);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom6Like", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 63);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom7Like", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 67);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom8Like", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 71);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "apply", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "pro.taskana.classification.api.ClassificationQuery", "query", "", "java.lang.Void"), 238);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getKey", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 27);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCategory", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 31);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomain", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 35);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 39);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom1Like", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 43);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom2Like", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 47);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom3Like", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 51);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCustom4Like", "pro.taskana.classification.rest.ClassificationQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 55);
    }
}

