/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import javax.naming.InvalidNameException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.ldap.LdapClient;
import pro.taskana.common.rest.models.AccessIdRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class AccessIdController {
    private final LdapClient ldapClient;
    private final TaskanaEngine taskanaEngine;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    @Autowired
    public AccessIdController(LdapClient ldapClient, TaskanaEngine taskanaEngine) {
        this.ldapClient = ldapClient;
        this.taskanaEngine = taskanaEngine;
    }

    @Operation(summary="Search for Access Id (users and groups)", description="This endpoint searches a provided access Id in the configured ldap.", parameters={@Parameter(name="search-for", description="the Access Id which should be searched for.", example="max", required=true)}, responses={@ApiResponse(responseCode="200", description="a list of all found Access Ids", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=AccessIdRepresentationModel[].class))})})
    @GetMapping(path={"/api/v1/access-ids"})
    public ResponseEntity<List<AccessIdRepresentationModel>> searchUsersAndGroupsAndPermissions(@RequestParam(value="search-for") String searchFor) throws InvalidArgumentException, NotAuthorizedException, InvalidNameException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = searchFor;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.checkRoleMembership(new TaskanaRole[]{TaskanaRole.ADMIN, TaskanaRole.BUSINESS_ADMIN});
        List<AccessIdRepresentationModel> accessIdUsers = this.ldapClient.searchUsersAndGroupsAndPermissions(searchFor);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok(accessIdUsers));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Search for Access Id (users) in TASKANA user role", description="This endpoint searches AccessIds for a provided name or Access Id. It will only search and return users and members of groups which are configured with the requested TASKANA role. This search will only work if the users in the configured LDAP have an attribute that shows their group memberships, e.g. \"memberOf\"", parameters={@Parameter(name="search-for", description="the name or Access Id which should be searched for.", example="user-1", required=true), @Parameter(name="role", description="the role for which all users should be searched for", example="user", required=true)}, responses={@ApiResponse(responseCode="200", description="a list of all found Access Ids (users)", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=AccessIdRepresentationModel[].class))})})
    @GetMapping(path={"/api/v1/access-ids/with-name"})
    public ResponseEntity<List<AccessIdRepresentationModel>> searchUsersByNameOrAccessIdForRole(@RequestParam(value="search-for") String nameOrAccessId, @RequestParam(value="role") String role) throws InvalidArgumentException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = nameOrAccessId;
        String string2 = role;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.checkRoleMembership(new TaskanaRole[]{TaskanaRole.USER, TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN});
        if (!role.equals("user")) {
            throw new InvalidArgumentException(String.format("Requested users for not supported role %s.  Only role 'user' is supported'", role));
        }
        List<AccessIdRepresentationModel> accessIdUsers = this.ldapClient.searchUsersByNameOrAccessIdInUserRole(nameOrAccessId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok(accessIdUsers));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Get groups for Access Id", description="This endpoint retrieves all groups a given Access Id belongs to.", parameters={@Parameter(name="access-id", description="the Access Id whose groups should be determined.", example="teamlead-1", required=true)}, responses={@ApiResponse(responseCode="200", description="a list of the group Access Ids the requested Access Id belongs to", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=AccessIdRepresentationModel[].class))})})
    @GetMapping(path={"/api/v1/access-ids/groups"})
    public ResponseEntity<List<AccessIdRepresentationModel>> getGroupsByAccessId(@RequestParam(value="access-id") String accessId) throws InvalidArgumentException, NotAuthorizedException, InvalidNameException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = accessId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.checkRoleMembership(new TaskanaRole[]{TaskanaRole.ADMIN, TaskanaRole.BUSINESS_ADMIN});
        List<AccessIdRepresentationModel> accessIds = this.ldapClient.searchGroupsAccessIdIsMemberOf(accessId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok(accessIds));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/access-ids/permissions"})
    public ResponseEntity<List<AccessIdRepresentationModel>> getPermissionsByAccessId(@RequestParam(value="access-id") String accessId) throws InvalidArgumentException, NotAuthorizedException, InvalidNameException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = accessId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskanaEngine.checkRoleMembership(new TaskanaRole[]{TaskanaRole.ADMIN, TaskanaRole.BUSINESS_ADMIN});
        List<AccessIdRepresentationModel> accessIds = this.ldapClient.searchPermissionsAccessIdHas(accessId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok(accessIds));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    static {
        AccessIdController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AccessIdController.java", AccessIdController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchUsersAndGroupsAndPermissions", "pro.taskana.common.rest.AccessIdController", "java.lang.String", "searchFor", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException:javax.naming.InvalidNameException", "org.springframework.http.ResponseEntity"), 70);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchUsersByNameOrAccessIdForRole", "pro.taskana.common.rest.AccessIdController", "java.lang.String:java.lang.String", "nameOrAccessId:role", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 124);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGroupsByAccessId", "pro.taskana.common.rest.AccessIdController", "java.lang.String", "accessId", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException:javax.naming.InvalidNameException", "org.springframework.http.ResponseEntity"), 170);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPermissionsByAccessId", "pro.taskana.common.rest.AccessIdController", "java.lang.String", "accessId", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException:javax.naming.InvalidNameException", "org.springframework.http.ResponseEntity"), 192);
    }
}

