/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import java.beans.ConstructorProperties;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QueryParameter;
import pro.taskana.common.rest.models.PageMetadata;

public class QueryPagingParameter<T, Q extends BaseQuery<T, ?>>
implements QueryParameter<Q, List<T>> {
    @Schema(name="page", description="Request a specific page. Requires the definition of the 'page-size'.")
    @JsonProperty(value="page")
    @Min(value=1L)
    private final @Min(value=1L) Integer page;
    @Schema(name="page-size", description="Defines the size for each page. This requires a specific requested 'page'.")
    @JsonProperty(value="page-size")
    @Min(value=1L)
    private final @Min(value=1L) Integer pageSize;
    @JsonIgnore
    private PageMetadata pageMetadata;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public Integer getPage() {
        Integer n;
        Integer n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Integer n3 = n2 = (n = this.page);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)n2);
        return n;
    }

    public Integer getPageSize() {
        Integer n;
        Integer n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Integer n3 = n2 = (n = this.pageSize);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)n2);
        return n;
    }

    @ConstructorProperties(value={"page", "page-size"})
    public QueryPagingParameter(Integer page, Integer pageSize) {
        if (pageSize == null) {
            pageSize = Integer.MAX_VALUE;
        }
        this.page = page;
        this.pageSize = pageSize;
    }

    public PageMetadata getPageMetadata() {
        PageMetadata pageMetadata;
        PageMetadata pageMetadata2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        PageMetadata pageMetadata3 = pageMetadata2 = (pageMetadata = this.pageMetadata);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pageMetadata2);
        return pageMetadata;
    }

    @Override
    public List<T> apply(Q query) {
        List list;
        List list2;
        Q q = query;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, q);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.initPageMetaData(query);
        List resultList = this.pageMetadata != null ? query.listPage(Math.toIntExact(this.pageMetadata.getNumber()), Math.toIntExact(this.pageMetadata.getSize())) : query.list();
        List list3 = list2 = (list = resultList);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)list2);
        return list;
    }

    private void initPageMetaData(Q query) {
        Q q = query;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, q);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.page != null) {
            long totalElements = query.count();
            long maxPages = (long)Math.ceil((double)totalElements / this.pageSize.doubleValue());
            this.pageMetadata = new PageMetadata(this.pageSize.intValue(), totalElements, maxPages, this.page.intValue());
        }
        Object var8_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_6);
    }

    static {
        QueryPagingParameter.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("QueryPagingParameter.java", QueryPagingParameter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPage", "pro.taskana.common.rest.QueryPagingParameter", "", "", "", "java.lang.Integer"), 15);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPageSize", "pro.taskana.common.rest.QueryPagingParameter", "", "", "", "java.lang.Integer"), 19);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPageMetadata", "pro.taskana.common.rest.QueryPagingParameter", "", "", "", "pro.taskana.common.rest.models.PageMetadata"), 49);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "apply", "pro.taskana.common.rest.QueryPagingParameter", "pro.taskana.common.api.BaseQuery", "query", "", "java.util.List"), 54);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initPageMetaData", "pro.taskana.common.rest.QueryPagingParameter", "pro.taskana.common.api.BaseQuery", "query", "", "void"), 67);
    }
}

