/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.rest.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.internal.logging.LoggingAspect;

public class QueryParamsValidator {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    private QueryParamsValidator() {
        throw new IllegalStateException("Utility class");
    }

    public static void validateParams(HttpServletRequest request, Class<?> ... filterOrSortingClazz) {
        HttpServletRequest httpServletRequest = request;
        Class<?>[] classArray = filterOrSortingClazz;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)httpServletRequest, classArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set allowedParams = Stream.of(filterOrSortingClazz).flatMap(clazz -> Stream.of(clazz.getDeclaredFields())).map(field -> Optional.ofNullable(field.getDeclaredAnnotation(JsonProperty.class)).map(JsonProperty::value).orElseGet(field::getName)).collect(Collectors.toSet());
        HashSet providedParams = new HashSet(request.getParameterMap().keySet());
        providedParams.removeIf(allowedParams::contains);
        if (!providedParams.isEmpty()) {
            throw new IllegalArgumentException("Unknown request parameters found: " + providedParams);
        }
        Object var7_7 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var7_7);
    }

    public static boolean hasQueryParameterValues(HttpServletRequest request, String queryParameter) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        HttpServletRequest httpServletRequest = request;
        String string = queryParameter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)httpServletRequest, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map queryParametersMap = request.getParameterMap();
        if (queryParametersMap.isEmpty()) {
            bl2 = bl3 = false;
        } else {
            String[] queryParameterValues = (String[])queryParametersMap.get(queryParameter);
            if (queryParameterValues == null) {
                bl2 = bl3 = false;
            } else {
                boolean hasQueryParameterNotEmptyValues = Arrays.stream(queryParameterValues).anyMatch(value -> !value.isBlank());
                boolean hasQueryParameterEmptyValues = request.getQueryString().contains(String.valueOf(queryParameter) + "=");
                bl2 = !hasQueryParameterNotEmptyValues && !hasQueryParameterEmptyValues ? (bl3 = false) : (bl3 = true);
            }
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    public static boolean hasQueryParameterValuesOrIsNotTrue(HttpServletRequest request, String queryParameter) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        HttpServletRequest httpServletRequest = request;
        String string = queryParameter;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)httpServletRequest, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Map queryParametersMap = request.getParameterMap();
        if (queryParametersMap.isEmpty()) {
            bl2 = bl3 = false;
        } else {
            String[] queryParameterValues = (String[])queryParametersMap.get(queryParameter);
            if (queryParameterValues == null) {
                bl2 = bl3 = false;
            } else {
                boolean hasQueryParameterProhibitedValues = Arrays.stream(queryParameterValues).anyMatch(value -> !value.isBlank() && !Boolean.parseBoolean(value));
                boolean hasQueryParameterEmptyValues = Arrays.stream(queryParameterValues).allMatch(String::isBlank) && request.getQueryString().contains(String.valueOf(queryParameter) + "=");
                bl2 = !hasQueryParameterProhibitedValues && !hasQueryParameterEmptyValues ? (bl3 = false) : (bl3 = true);
            }
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    static {
        QueryParamsValidator.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("QueryParamsValidator.java", QueryParamsValidator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("89", "validateParams", "pro.taskana.common.rest.util.QueryParamsValidator", "jakarta.servlet.http.HttpServletRequest:[Ljava.lang.Class;", "request:filterOrSortingClazz", "", "void"), 19);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "hasQueryParameterValues", "pro.taskana.common.rest.util.QueryParamsValidator", "jakarta.servlet.http.HttpServletRequest:java.lang.String", "request:queryParameter", "", "boolean"), 39);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "hasQueryParameterValuesOrIsNotTrue", "pro.taskana.common.rest.util.QueryParamsValidator", "jakarta.servlet.http.HttpServletRequest:java.lang.String", "request:queryParameter", "", "boolean"), 63);
    }
}

