/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.BiConsumer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QueryPagingParameter;
import pro.taskana.common.rest.QuerySortBy;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.common.rest.util.QueryParamsValidator;
import pro.taskana.task.api.TaskCommentQuery;
import pro.taskana.task.api.TaskService;
import pro.taskana.task.api.exceptions.NotAuthorizedOnTaskCommentException;
import pro.taskana.task.api.exceptions.TaskCommentNotFoundException;
import pro.taskana.task.api.exceptions.TaskNotFoundException;
import pro.taskana.task.api.models.TaskComment;
import pro.taskana.task.rest.TaskCommentQueryFilterParameter;
import pro.taskana.task.rest.assembler.TaskCommentRepresentationModelAssembler;
import pro.taskana.task.rest.models.TaskCommentCollectionRepresentationModel;
import pro.taskana.task.rest.models.TaskCommentRepresentationModel;
import pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class TaskCommentController {
    private final TaskService taskService;
    private final TaskCommentRepresentationModelAssembler taskCommentRepresentationModelAssembler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    @Autowired
    TaskCommentController(TaskService taskService, TaskCommentRepresentationModelAssembler taskCommentRepresentationModelAssembler) {
        this.taskService = taskService;
        this.taskCommentRepresentationModelAssembler = taskCommentRepresentationModelAssembler;
    }

    @Operation(summary="Get a single Task Comment", description="This endpoint retrieves a Task Comment.", parameters={@Parameter(name="taskCommentId", description="The Id of the Task Comment", example="TCI:000000000000000000000000000000000000", required=true)}, responses={@ApiResponse(responseCode="200", description="the Task Comment", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=TaskCommentRepresentationModel.class))})})
    @GetMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> getTaskComment(@PathVariable(value="taskCommentId") String taskCommentId) throws TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskComment taskComment = this.taskService.getTaskComment(taskCommentId);
        TaskCommentRepresentationModel taskCommentRepresentationModel = this.taskCommentRepresentationModelAssembler.toModel(taskComment);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)taskCommentRepresentationModel)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Get a list of all Task Comments for a specific Task", description="This endpoint retrieves all Task Comments for a specific Task. Further filters can be applied.", parameters={@Parameter(name="taskId", description="The Id of the Task whose comments are requested", example="TKI:000000000000000000000000000000000000", required=true)}, responses={@ApiResponse(responseCode="200", description="a list of Task Comments", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=TaskCommentCollectionRepresentationModel.class))})})
    @GetMapping(path={"/api/v1/tasks/{taskId}/comments"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentCollectionRepresentationModel> getTaskComments(@PathVariable(value="taskId") String taskId, HttpServletRequest request, @ParameterObject TaskCommentQueryFilterParameter filterParameter, @ParameterObject TaskCommentQuerySortParameter sortParameter, @ParameterObject QueryPagingParameter<TaskComment, TaskCommentQuery> pagingParameter) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        HttpServletRequest httpServletRequest = request;
        TaskCommentQueryFilterParameter taskCommentQueryFilterParameter = filterParameter;
        TaskCommentQuerySortParameter taskCommentQuerySortParameter = sortParameter;
        QueryPagingParameter<TaskComment, TaskCommentQuery> queryPagingParameter = pagingParameter;
        Object[] objectArray = new Object[]{string, httpServletRequest, taskCommentQueryFilterParameter, taskCommentQuerySortParameter, queryPagingParameter};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        QueryParamsValidator.validateParams(request, TaskCommentQueryFilterParameter.class, QuerySortParameter.class, QueryPagingParameter.class);
        TaskCommentQuery query = this.taskService.createTaskCommentQuery();
        query.taskIdIn(new String[]{taskId});
        filterParameter.apply(query);
        sortParameter.apply(query);
        List<TaskComment> taskComments = pagingParameter.apply(query);
        TaskCommentCollectionRepresentationModel taskCommentListResource = (TaskCommentCollectionRepresentationModel)((Object)this.taskCommentRepresentationModelAssembler.toTaskanaCollectionModel(taskComments));
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)taskCommentListResource)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Delete a Task Comment", description="This endpoint deletes a given Task Comment.", parameters={@Parameter(name="taskCommentId", description="The Id of the Task Comment which should be deleted", example="TCI:000000000000000000000000000000000001", required=true)}, responses={@ApiResponse(responseCode="204", content={@Content(schema=@Schema)})})
    @DeleteMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> deleteTaskComment(@PathVariable(value="taskCommentId") String taskCommentId) throws TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException, NotAuthorizedOnTaskCommentException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskCommentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.taskService.deleteTaskComment(taskCommentId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.noContent().build());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Update a Task Comment", description="This endpoint updates a given Task Comment.", parameters={@Parameter(name="taskCommentId", description="The Id of the Task Comment which should be updated", example="TCI:000000000000000000000000000000000000", required=true)}, requestBody=@RequestBody(description="The new comment for the requested id", content={@Content(schema=@Schema(implementation=TaskCommentRepresentationModel.class), examples={@ExampleObject(value="{\n  \"taskCommentId\": \"TCI:000000000000000000000000000000000000\",\n  \"taskId\": \"TKI:000000000000000000000000000000000000\",\n  \"textField\": \"updated text in textfield\",\n  \"creator\": \"user-1-1\",\n  \"creatorFullName\": \"Mustermann, Max\",\n  \"created\": \"2017-01-29T15:55:00Z\",\n  \"modified\": \"2018-01-30T15:55:00Z\"\n}")})}), responses={@ApiResponse(responseCode="200", description="the updated Task Comment", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=TaskCommentRepresentationModel.class))})})
    @PutMapping(path={"/api/v1/tasks/comments/{taskCommentId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> updateTaskComment(@PathVariable(value="taskCommentId") String taskCommentId, @org.springframework.web.bind.annotation.RequestBody TaskCommentRepresentationModel taskCommentRepresentationModel) throws TaskNotFoundException, TaskCommentNotFoundException, InvalidArgumentException, ConcurrencyException, NotAuthorizedOnTaskCommentException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskCommentId;
        TaskCommentRepresentationModel taskCommentRepresentationModel2 = taskCommentRepresentationModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)((Object)taskCommentRepresentationModel2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!taskCommentId.equals(taskCommentRepresentationModel.getTaskCommentId())) {
            throw new InvalidArgumentException(String.format("TaskCommentId ('%s') is not identical with the id of the object in the payload which should be updated", taskCommentId));
        }
        TaskComment taskComment = this.taskCommentRepresentationModelAssembler.toEntityModel(taskCommentRepresentationModel);
        taskComment = this.taskService.updateTaskComment(taskComment);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.taskCommentRepresentationModelAssembler.toModel(taskComment))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Create a new Task Comment", description="This endpoint creates a Task Comment.", parameters={@Parameter(name="taskId", description="The Id of the Task where a Task Comment should be created", example="TKI:000000000000000000000000000000000000", required=true)}, requestBody=@RequestBody(description="The Task Comment to create", content={@Content(schema=@Schema(implementation=TaskCommentRepresentationModel.class), examples={@ExampleObject(value="{\n  \"taskId\": \"TKI:000000000000000000000000000000000000\",\n  \"textField\": \"some text in textfield\"\n}")})}), responses={@ApiResponse(responseCode="201", description="the created Task Comment", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=TaskCommentRepresentationModel.class))})})
    @PostMapping(path={"/api/v1/tasks/{taskId}/comments"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<TaskCommentRepresentationModel> createTaskComment(@PathVariable(value="taskId") String taskId, @org.springframework.web.bind.annotation.RequestBody TaskCommentRepresentationModel taskCommentRepresentationModel) throws InvalidArgumentException, TaskNotFoundException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = taskId;
        TaskCommentRepresentationModel taskCommentRepresentationModel2 = taskCommentRepresentationModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)((Object)taskCommentRepresentationModel2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        taskCommentRepresentationModel.setTaskId(taskId);
        TaskComment taskCommentFromResource = this.taskCommentRepresentationModelAssembler.toEntityModel(taskCommentRepresentationModel);
        TaskComment createdTaskComment = this.taskService.createTaskComment(taskCommentFromResource);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.taskCommentRepresentationModelAssembler.toModel(createdTaskComment)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    static {
        TaskCommentController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskCommentController.java", TaskCommentController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskComment", "pro.taskana.task.rest.TaskCommentController", "java.lang.String", "taskCommentId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 97);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskComments", "pro.taskana.task.rest.TaskCommentController", "java.lang.String:jakarta.servlet.http.HttpServletRequest:pro.taskana.task.rest.TaskCommentQueryFilterParameter:pro.taskana.task.rest.TaskCommentController$TaskCommentQuerySortParameter:pro.taskana.common.rest.QueryPagingParameter", "taskId:request:filterParameter:sortParameter:pagingParameter", "", "org.springframework.http.ResponseEntity"), 146);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTaskComment", "pro.taskana.task.rest.TaskCommentController", "java.lang.String", "taskCommentId", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.NotAuthorizedOnTaskCommentException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 200);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTaskComment", "pro.taskana.task.rest.TaskCommentController", "java.lang.String:pro.taskana.task.rest.models.TaskCommentRepresentationModel", "taskCommentId:taskCommentRepresentationModel", "pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.task.api.exceptions.TaskCommentNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.task.api.exceptions.NotAuthorizedOnTaskCommentException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 270);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTaskComment", "pro.taskana.task.rest.TaskCommentController", "java.lang.String:pro.taskana.task.rest.models.TaskCommentRepresentationModel", "taskId:taskCommentRepresentationModel", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.task.api.exceptions.TaskNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 343);
    }

    public static final class TaskCommentQuerySortBy
    extends Enum<TaskCommentQuerySortBy>
    implements QuerySortBy<TaskCommentQuery> {
        public static final /* enum */ TaskCommentQuerySortBy CREATED;
        public static final /* enum */ TaskCommentQuerySortBy MODIFIED;
        private final BiConsumer<TaskCommentQuery, BaseQuery.SortDirection> consumer;
        private static final /* synthetic */ TaskCommentQuerySortBy[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        static {
            TaskCommentQuerySortBy.ajc$preClinit();
            CREATED = new TaskCommentQuerySortBy(TaskCommentQuery::orderByCreated);
            MODIFIED = new TaskCommentQuerySortBy(TaskCommentQuery::orderByModified);
            ENUM$VALUES = new TaskCommentQuerySortBy[]{CREATED, MODIFIED};
        }

        private TaskCommentQuerySortBy(BiConsumer<TaskCommentQuery, BaseQuery.SortDirection> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void applySortByForQuery(TaskCommentQuery query, BaseQuery.SortDirection sortDirection) {
            TaskCommentQuery taskCommentQuery = query;
            BaseQuery.SortDirection sortDirection2 = sortDirection;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)taskCommentQuery, (Object)sortDirection2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.consumer.accept(query, sortDirection);
            Object var6_6 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
        }

        public static TaskCommentQuerySortBy[] values() {
            TaskCommentQuerySortBy[] taskCommentQuerySortByArray;
            TaskCommentQuerySortBy[] taskCommentQuerySortByArray2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskCommentQuerySortBy[] taskCommentQuerySortByArray3 = ENUM$VALUES;
            int n = taskCommentQuerySortByArray3.length;
            TaskCommentQuerySortBy[] taskCommentQuerySortByArray4 = new TaskCommentQuerySortBy[n];
            System.arraycopy(ENUM$VALUES, 0, taskCommentQuerySortByArray4, 0, n);
            TaskCommentQuerySortBy[] taskCommentQuerySortByArray5 = taskCommentQuerySortByArray2 = (taskCommentQuerySortByArray = taskCommentQuerySortByArray4);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQuerySortByArray2);
            return taskCommentQuerySortByArray;
        }

        public static TaskCommentQuerySortBy valueOf(String arg0) {
            TaskCommentQuerySortBy taskCommentQuerySortBy;
            TaskCommentQuerySortBy taskCommentQuerySortBy2;
            String string = arg0;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            TaskCommentQuerySortBy taskCommentQuerySortBy3 = taskCommentQuerySortBy2 = (taskCommentQuerySortBy = Enum.valueOf(TaskCommentQuerySortBy.class, arg0));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskCommentQuerySortBy2);
            return taskCommentQuerySortBy;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskCommentController.java", TaskCommentQuerySortBy.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "applySortByForQuery", "pro.taskana.task.rest.TaskCommentController$TaskCommentQuerySortBy", "pro.taskana.task.api.TaskCommentQuery:pro.taskana.common.api.BaseQuery$SortDirection", "query:sortDirection", "", "void"), 368);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "pro.taskana.task.rest.TaskCommentController$TaskCommentQuerySortBy", "", "", "", "[Lpro.taskana.task.rest.TaskCommentController$TaskCommentQuerySortBy;"), 1);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "pro.taskana.task.rest.TaskCommentController$TaskCommentQuerySortBy", "java.lang.String", "arg0", "", "pro.taskana.task.rest.TaskCommentController$TaskCommentQuerySortBy"), 1);
        }
    }

    public static class TaskCommentQuerySortParameter
    extends QuerySortParameter<TaskCommentQuery, TaskCommentQuerySortBy> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        @ConstructorProperties(value={"sort-by", "order"})
        public TaskCommentQuerySortParameter(List<TaskCommentQuerySortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
            super(sortBy, order);
        }

        @Override
        public List<TaskCommentQuerySortBy> getSortBy() {
            List<TaskCommentQuerySortBy> list;
            List<TaskCommentQuerySortBy> list2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            List<TaskCommentQuerySortBy> list3 = list2 = (list = super.getSortBy());
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
            return list;
        }

        static {
            TaskCommentQuerySortParameter.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskCommentController.java", TaskCommentQuerySortParameter.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSortBy", "pro.taskana.task.rest.TaskCommentController$TaskCommentQuerySortParameter", "", "", "", "java.util.List"), 385);
        }
    }
}

