/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.task.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.IntInterval;
import pro.taskana.common.api.KeyDomain;
import pro.taskana.common.api.TimeInterval;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QueryParameter;
import pro.taskana.task.api.CallbackState;
import pro.taskana.task.api.TaskQuery;
import pro.taskana.task.api.TaskState;
import pro.taskana.task.api.WildcardSearchField;
import pro.taskana.task.api.models.ObjectReference;

public class TaskQueryFilterParameter
implements QueryParameter<TaskQuery, Void> {
    @Schema(name="task-id", description="Filter by task id. This is an exact match.")
    @JsonProperty(value="task-id")
    private final String[] taskIdIn;
    @Schema(name="task-id-not", description="Filter by what the task id shouldn't be. This is an exact match.")
    @JsonProperty(value="task-id-not")
    private final String[] taskIdNotIn;
    @Schema(name="external-id", description="Filter by the external id of the Task. This is an exact match.")
    @JsonProperty(value="external-id")
    private final String[] externalIdIn;
    @Schema(name="external-id-not", description="Filter by what the external id of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="external-id-not")
    private final String[] externalIdNotIn;
    @Schema(name="received", description="Filter by a time interval within which the Task was received. To create an open interval you can just leave it blank.<p>The format is ISO-8601.<p>This parameter can't be used together with 'received-from' or 'received-until'.")
    @JsonProperty(value="received")
    private final Instant[] receivedWithin;
    @Schema(name="receivedFrom", description="Filter since a given received timestamp.<p>The format is ISO-8601.<p>This parameter can't be used together with 'received'.")
    @JsonProperty(value="received-from")
    private final Instant receivedFrom;
    @Schema(name="received-until", description="Filter until a given received timestamp.<p>The format is ISO-8601.<p>This parameter can't be used together with 'received'.")
    @JsonProperty(value="received-until")
    private final Instant receivedUntil;
    @Schema(name="received-not", description="Filter by a time interval within which the Task wasn't received. To create an open interval you can just leave it blank.<p>The format is ISO-8601.<p>This parameter can't be used together with 'received-not-in-from' or 'received-not-in-until'.")
    @JsonProperty(value="received-not")
    private final Instant[] receivedNotIn;
    @Schema(name="received-from-not", description="Filter since a given timestamp where it wasn't received.<p>The format is ISO-8601.<p>This parameter can't be used together with 'received-not-in'.")
    @JsonProperty(value="received-from-not")
    private final Instant receivedFromNot;
    @Schema(name="received-until-not", description="Filter until a given timestamp where it wasn't received.<p>The format is ISO-8601.<p>This parameter can't be used together with 'received-not-in'.")
    @JsonProperty(value="received-until-not")
    private final Instant receivedUntilNot;
    @Schema(name="created", description="Filter by a time interval within which the Task was created. To create an open interval you can just leave it blank.<p>The format is ISO-8601.<p>This parameter can't be used together with 'created-from' or 'created-until'.")
    @JsonProperty(value="created")
    private final Instant[] createdWithin;
    @Schema(name="created-from", description="Filter since a given created timestamp.<p>The format is ISO-8601.<p>This parameter can't be used together with 'created'.")
    @JsonProperty(value="created-from")
    private final Instant createdFrom;
    @Schema(name="created-until", description="Filter until a given created timestamp.<p>The format is ISO-8601.<p>This parameter can't be used together with 'created'.")
    @JsonProperty(value="created-until")
    private final Instant createdUntil;
    @Schema(name="created-not", description="Filter by a time interval within which the Task wasn't created. To create an open interval you can just leave it blank.<p>The format is ISO-8601.<p>This parameter can't be used together with 'created-not-in-from' or 'created-not-in-until'.")
    @JsonProperty(value="created-not")
    private final Instant[] createdNotWithin;
    @Schema(name="created-from-not", description="Filter not since a given timestamp where it wasn't created.<p>The format is ISO-8601.<p>This parameter can't be used together with 'created-not-in'.")
    @JsonProperty(value="created-from-not")
    private final Instant createdFromNot;
    @Schema(name="created-until-not", description="Filter not until a given timestamp where it wasn't created.<p>The format is ISO-8601.<p>This parameter can't be used together with 'created-not-in'.")
    @JsonProperty(value="created-until-not")
    private final Instant createdUntilNot;
    @Schema(name="claimed", description="Filter by a time interval within which the Task was claimed. To create an open interval you can just leave it blank.<p>The format is ISO-8601.")
    @JsonProperty(value="claimed")
    private final Instant[] claimedWithin;
    @Schema(name="claimed-not", description="Filter by a time interval within which the Task wasn't claimed. To create an open interval you can just leave it blank.<p>The format is ISO-8601.")
    @JsonProperty(value="claimed-not")
    private final Instant[] claimedNotWithin;
    @Schema(name="modified", description="Filter by a time interval within which the Task was modified. To create an open interval you can just leave it blank.<p>The format is ISO-8601.")
    @JsonProperty(value="modified")
    private final Instant[] modifiedWithin;
    @Schema(name="modified-not", description="Filter by a time interval within which the Task wasn't modified. To create an open interval you can just leave it blank.<p>The format is ISO-8601.")
    @JsonProperty(value="modified-not")
    private final Instant[] modifiedNotWithin;
    @Schema(name="planned", description="Filter by a time interval within which the Task was planned. To create an open interval you can just leave it blank.<p>The format is ISO-8601.<p>This parameter can't be used together with 'planned-from' or 'planned-until'.")
    @JsonProperty(value="planned")
    private final Instant[] plannedWithin;
    @Schema(name="planned-from", description="Filter since a given planned timestamp.<p>The format is ISO-8601.<p>This parameter can't be used together with 'planned'.")
    @JsonProperty(value="planned-from")
    private final Instant plannedFrom;
    @Schema(name="planned-until", description="Filter until a given planned timestamp.<p>The format is ISO-8601.<p>This parameter can't be used together with 'planned'.")
    @JsonProperty(value="planned-until")
    private final Instant plannedUntil;
    @Schema(name="planned-not", description="Filter by a time interval within which the Task was planned. To create an open interval you can just leave it blank.<p>The format is ISO-8601.<p>This parameter can't be used together with 'planned-not-in-from' or 'planned-not-in-until'.")
    @JsonProperty(value="planned-not")
    private final Instant[] plannedNotWithin;
    @Schema(name="planned-from-not", description="Filter since a given timestamp where it wasn't planned.<p>The format is ISO-8601.<p>This parameter can't be used together with 'planned-not-in'.")
    @JsonProperty(value="planned-from-not")
    private final Instant plannedFromNot;
    @Schema(name="planned-until-not", description="Filter until a given timestamp where it wasn't planned.<p>The format is ISO-8601.<p>This parameter can't be used together with 'planned-not-in'.")
    @JsonProperty(value="planned-until-not")
    private final Instant plannedUntilNot;
    @Schema(name="due", description="Filter by a time interval within which the Task was due. To create an open interval you can just leave it blank.<p>The format is ISO-8601.<p>This parameter can't be used together with 'due-from' or 'due-until'.")
    @JsonProperty(value="due")
    private final Instant[] dueWithin;
    @Schema(name="due-from", description="Filter since a given due timestamp.<p>The format is ISO-8601.<p>This parameter can't be used together with 'due'.")
    @JsonProperty(value="due-from")
    private final Instant dueFrom;
    @Schema(name="due-until", description="Filter until a given due timestamp.<p>The format is ISO-8601.<p>This parameter can't be used together with 'due'.")
    @JsonProperty(value="due-until")
    private final Instant dueUntil;
    @Schema(name="due-not", description="Filter by a time interval within which the Task wasn't due. To create an open interval you can just leave it blank.<p>The format is ISO-8601.<p>This parameter can't be used together with 'due-not-in-from' or 'due-not-in-until'.")
    @JsonProperty(value="due-not")
    private final Instant[] dueNotWithin;
    @Schema(name="due-from-not", description="Filter since a given timestamp where it isn't due.<p>The format is ISO-8601.<p>This parameter can't be used together with 'due-not-in'.")
    @JsonProperty(value="due-from-not")
    private final Instant dueFromNot;
    @Schema(name="due-until-not", description="Filter until a given timestamp where it isn't due.<p>The format is ISO-8601.<p>This parameter can't be used together with 'due-not-in'.")
    @JsonProperty(value="due-until-not")
    private final Instant dueUntilNot;
    @Schema(name="completed", description="Filter by a time interval within which the Task was completed. To create an open interval you can just leave it blank.<p>The format is ISO-8601.<p>This parameter can't be used together with 'completed-from' or 'completed-until'.")
    @JsonProperty(value="completed")
    private final Instant[] completedWithin;
    @Schema(name="completed-from", description="Filter since a given completed timestamp.<p>The format is ISO-8601.<p>This parameter can't be used together with 'completed'.")
    @JsonProperty(value="completed-from")
    private final Instant completedFrom;
    @Schema(name="completed-until", description="Filter until a given completed timestamp.<p>The format is ISO-8601.<p>This parameter can't be used together with 'completed'.")
    @JsonProperty(value="completed-until")
    private final Instant completedUntil;
    @Schema(name="completed-not", description="Filter by a time interval within which the Task wasn't completed. To create an open interval you can just leave it blank.<p>The format is ISO-8601.<p>This parameter can't be used together with 'completed-not-in-from' or 'completed-not-in-until'.")
    @JsonProperty(value="completed-not")
    private final Instant[] completedNotWithin;
    @Schema(name="completed-from-not", description="Filter since a given timestamp where it wasn't completed. <p>The format is ISO-8601. <p>This parameter can't be used together with 'completed-not-in'.")
    @JsonProperty(value="completed-from-not")
    private final Instant completedFromNot;
    @Schema(name="completed-until-not", description="Filter until a given timestamp where it wasn't completed. <p>The format is ISO-8601. <p>This parameter can't be used together with 'completed-not-in'.")
    @JsonProperty(value="completed-until-not")
    private final Instant completedUntilNot;
    @Schema(name="name", description="Filter by the name of the Task. This is an exact match.")
    @JsonProperty(value="name")
    private final String[] nameIn;
    @Schema(name="name-not", description="Filter by what the name of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="name-not")
    private final String[] nameNotIn;
    @Schema(name="name-like", description="Filter by the name of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="name-like")
    private final String[] nameLike;
    @Schema(name="name-not-like", description="Filter by what the name of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="name-not-like")
    private final String[] nameNotLike;
    @Schema(name="creator", description="Filter by creator of the Task. This is an exact match.")
    @JsonProperty(value="creator")
    private final String[] creatorIn;
    @Schema(name="creator-not", description="Filter by what the creator of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="creator-not")
    private final String[] creatorNotIn;
    @Schema(name="creator-like", description="Filter by the creator of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="creator-like")
    private final String[] creatorLike;
    @Schema(name="creator-not-like", description="Filter by what the creator of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="creator-not-like")
    private final String[] creatorNotLike;
    @Schema(name="note-like", description="Filter by the note of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="note-like")
    private final String[] noteLike;
    @Schema(name="note-not-like", description="Filter by what the note of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="note-not-like")
    private final String[] noteNotLike;
    @Schema(name="description-like", description="Filter by the description of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="description-like")
    private final String[] descriptionLike;
    @Schema(name="description-not-like", description="Filter by what the description of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="description-not-like")
    private final String[] descriptionNotLike;
    @Schema(name="priority", description="Filter by the priority of the Task. This is an exact match.")
    @JsonProperty(value="priority")
    private final int[] priorityIn;
    @Schema(name="priority-not", description="Filter by what the priority of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="priority-not")
    private final int[] priorityNotIn;
    @Schema(name="priority-within", description="Filter by the range of values of the priority field of the Task.")
    @JsonProperty(value="priority-within")
    private final Integer[] priorityWithin;
    @Schema(name="priority-from", description="Filter by priority starting from the given value (inclusive).")
    @JsonProperty(value="priority-from")
    private final Integer priorityFrom;
    @Schema(name="priority-until", description="Filter by priority up to the given value (inclusive).")
    @JsonProperty(value="priority-until")
    private final Integer priorityUntil;
    @Schema(name="priority-not-within", description="Filter by exclusing the range of values of the priority field of the Task.")
    @JsonProperty(value="priority-not-within")
    private final Integer[] priorityNotWithin;
    @Schema(name="priority-not-from", description="Filter by excluding priority starting from the given value (inclusive).")
    @JsonProperty(value="priority-not-from")
    private final Integer priorityNotFrom;
    @Schema(name="priority-not-until", description="Filter by excluding priority up to the given value (inclusive).")
    @JsonProperty(value="priority-not-until")
    private final Integer priorityNotUntil;
    @Schema(name="state", description="Filter by the Task state. This is an exact match.")
    @JsonProperty(value="state")
    private final TaskState[] stateIn;
    @Schema(name="state-not", description="Filter by what the Task state shouldn't be. This is an exact match.")
    @JsonProperty(value="state-not")
    private final TaskState[] stateNotIn;
    @JsonProperty(value="has-comments")
    private final Boolean hasComments;
    @Schema(name="classification-id", description="Filter by the classification id of the Task. This is an exact match.")
    @JsonProperty(value="classification-id")
    private final String[] classificationIdIn;
    @Schema(name="classification-id-not", description="Filter by what the classification id of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="classification-id-not")
    private final String[] classificationIdNotIn;
    @Schema(name="classification-key", description="Filter by the classification key of the Task. This is an exact match.")
    @JsonProperty(value="classification-key")
    private final String[] classificationKeyIn;
    @Schema(name="classification-key-not", description="Filter by the classification key of the Task. This is an exact match.")
    @JsonProperty(value="classification-key-not")
    private final String[] classificationKeyNotIn;
    @Schema(name="classification-key-like", description="Filter by the classification key of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="classification-key-like")
    private final String[] classificationKeyLike;
    @Schema(name="classification-key-not-like", description="Filter by what the classification key of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="classification-key-not-like")
    private final String[] classificationKeyNotLike;
    @Schema(name="classification-parent-key", description="Filter by the key of the parent Classification of the Classification of the Task. This is an exact match.")
    @JsonProperty(value="classification-parent-key")
    private final String[] classificationParentKeyIn;
    @Schema(name="classification-parent-key-not", description="Filter by what the key of the parent Classification of the Classification of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="classification-parent-key-not")
    private final String[] classificationParentKeyNotIn;
    @Schema(name="classification-parent-key-like", description="Filter by the key of the parent Classification of the Classification of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="classification-parent-key-like")
    private final String[] classificationParentKeyLike;
    @Schema(name="classification-parent-key-not-like", description="Filter by what the key of the parent Classification of the Classification of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="classification-parent-key-not-like")
    private final String[] classificationParentKeyNotLike;
    @Schema(name="classification-category", description="Filter by the classification category of the Task. This is an exact match.")
    @JsonProperty(value="classification-category")
    private final String[] classificationCategoryIn;
    @Schema(name="classification-category-not", description="Filter by what the classification category of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="classification-category-not")
    private final String[] classificationCategoryNotIn;
    @Schema(name="classification-category-like", description="Filter by the classification category of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="classification-category-like")
    private final String[] classificationCategoryLike;
    @Schema(name="classification-category-not-like", description="Filter by what the classification category of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="classification-category-not-like")
    private final String[] classificationCategoryNotLike;
    @Schema(name="classification-name", description="Filter by the classification name of the Task. This is an exact match.")
    @JsonProperty(value="classification-name")
    private final String[] classificationNameIn;
    @Schema(name="classification-name-not", description="Filter by what the classification name of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="classification-name-not")
    private final String[] classificationNameNotIn;
    @Schema(name="classification-name-like", description="Filter by the classification name of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="classification-name-like")
    private final String[] classificationNameLike;
    @Schema(name="classification-name-not-like", description="Filter by what the classification name of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="classification-name-not-like")
    private final String[] classificationNameNotLike;
    @Schema(name="workbasket-id", description="Filter by workbasket id of the Task. This is an exact match.")
    @JsonProperty(value="workbasket-id")
    private final String[] workbasketIdIn;
    @Schema(name="workbasket-id-not", description="Filter by what the workbasket id of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="workbasket-id-not")
    private final String[] workbasketIdNotIn;
    @Schema(name="workbasket-key", description="Filter by workbasket keys of the Task. This parameter can only be used in combination with 'domain'")
    @JsonProperty(value="workbasket-key")
    private final String[] workbasketKeyIn;
    @Schema(name="workbasket-key-not", description="Filter by what the workbasket keys of the Task aren't. This parameter can only be used in combination with 'domain'")
    @JsonProperty(value="workbasket-key-not")
    private final String[] workbasketKeyNotIn;
    @Schema(name="domain", description="Filter by domain of the Task. This is an exact match.")
    @JsonProperty(value="domain")
    private final String domain;
    @Schema(name="business-process-id", description="Filter by the business process id of the Task. This is an exact match.")
    @JsonProperty(value="business-process-id")
    private final String[] businessProcessIdIn;
    @Schema(name="business-process-id-not", description="Filter by what the business process id of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="business-process-id-not")
    private final String[] businessProcessIdNot;
    @Schema(name="business-process-id-like", description="Filter by the business process id of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="business-process-id-like")
    private final String[] businessProcessIdLike;
    @Schema(name="business-process-id-not-like", description="Filter by the business process id of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="business-process-id-not-like")
    private final String[] businessProcessIdNotLike;
    @Schema(name="parent-business-process-id", description="Filter by the parent business process id of the Task. This is an exact match.")
    @JsonProperty(value="parent-business-process-id")
    private final String[] parentBusinessProcessIdIn;
    @Schema(name="parent-business-process-id-not", description="Filter by what the parent business process id of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="parent-business-process-id-not")
    private final String[] parentBusinessProcessIdNotIn;
    @Schema(name="parent-business-process-id-like", description="Filter by the parent business process id of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="parent-business-process-id-like")
    private final String[] parentBusinessProcessIdLike;
    @Schema(name="parent-business-process-id-not-like", description="Filter by the parent business process id of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="parent-business-process-id-not-like")
    private final String[] parentBusinessProcessIdNotLike;
    @JsonProperty(value="owner")
    private final String[] ownerIn;
    @Schema(name="owner-not", description="Filter by what the owner of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="owner-not")
    private final String[] ownerNotIn;
    @Schema(name="owner-like", description="Filter by the owner of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="owner-like")
    private final String[] ownerLike;
    @Schema(name="owner-not-like", description="Filter by what the owner of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="owner-not-like")
    private final String[] ownerNotLike;
    @Schema(name="owner-is-null", description="Filter by tasks that have no owner. The parameter should exactly be \"owner-is-null\" without being followed by \"=...\"")
    @JsonProperty(value="owner-is-null")
    private final String ownerNull;
    @Schema(name="por", description="Filter by the primary object reference of the Task. This is an exact match. \"por\" is a parameter of complex type. Its following attributes from por[].id to por[].value can be specified according to the description of complex parameters in the overview, e.g. por={\"value\":\"exampleValue\"}")
    @JsonProperty(value="por")
    private final ObjectReference[] primaryObjectReferenceIn;
    @Schema(name="por-company", description="Filter by the company of the primary object reference of the Task. This is an exact match.")
    @JsonProperty(value="por-company")
    private final String[] porCompanyIn;
    @Schema(name="por-company-not", description="Filter by what the company of the primary object reference of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="por-company-not")
    private final String[] porCompanyNotIn;
    @Schema(name="por-company-like", description="Filter by the company of the primary object reference of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="por-company-like")
    private final String[] porCompanyLike;
    @Schema(name="por-company-not-like", description="Filter by what the company of the primary object reference of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="por-company-not-like")
    private final String[] porCompanyNotLike;
    @Schema(name="por-system", description="Filter by the system of the primary object reference of the Task. This is an exact match.")
    @JsonProperty(value="por-system")
    private final String[] porSystemIn;
    @Schema(name="por-system-not", description="Filter by what the system of the primary object reference of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="por-system-not")
    private final String[] porSystemNotIn;
    @Schema(name="por-system-like", description="Filter by the system of the primary object reference of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="por-system-like")
    private final String[] porSystemLike;
    @Schema(name="por-system-not-like", description="Filter by what the system of the primary object reference of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="por-system-not-like")
    private final String[] porSystemNotLike;
    @Schema(name="por-instance", description="Filter by the system instance of the primary object reference of the Task. This is an exact match.")
    @JsonProperty(value="por-instance")
    private final String[] porInstanceIn;
    @Schema(name="por-instance-not", description="Filter by what the system instance of the primary object reference of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="por-instance-not")
    private final String[] porInstanceNotIn;
    @Schema(name="por-instance-like", description="Filter by the system instance of the primary object reference of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="por-instance-like")
    private final String[] porInstanceLike;
    @Schema(name="por-instance-not-like", description="Filter by what the system instance of the primary object reference of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="por-instance-not-like")
    private final String[] porInstanceNotLike;
    @Schema(name="por-type", description="Filter by the type of the primary object reference of the Task. This is an exact match.")
    @JsonProperty(value="por-type")
    private final String[] porTypeIn;
    @Schema(name="por-type-not", description="Filter by what the type of the primary object reference of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="por-type-not")
    private final String[] porTypeNotIn;
    @Schema(name="por-type-like", description="Filter by the type of the primary object reference of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="por-type-like")
    private final String[] porTypeLike;
    @Schema(name="por-type-not-like", description="Filter by what the type of the primary object reference of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="por-type-not-like")
    private final String[] porTypeNotLike;
    @Schema(name="por-value", description="Filter by the value of the primary object reference of the Task. This is an exact match.")
    @JsonProperty(value="por-value")
    private final String[] porValueIn;
    @Schema(name="por-value-not", description="Filter by what the value of the primary object reference of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="por-value-not")
    private final String[] porValueNotIn;
    @Schema(name="por-value-like", description="Filter by the value of the primary object reference of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="por-value-like")
    private final String[] porValueLike;
    @Schema(name="por-value-not-like", description="Filter by what the value of the primary object reference of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="por-value-not-like")
    private final String[] porValueNotLike;
    @Schema(name="sor", description="Filter by the primary object reference of the Task. This is an exact match. \"sor\" is a parameter of complex type. Its following attributes from sor[].id to sor[].value can be specified according to the description of complex parameters in the overview, e.g. sor={\"value\":\"exampleValue\"}")
    @JsonProperty(value="sor")
    private final ObjectReference[] secondaryObjectReferenceIn;
    @Schema(name="sor-company", description="Filter by the company of the secondary object reference of the Task. This is an exact match.")
    @JsonProperty(value="sor-company")
    private final String[] sorCompanyIn;
    @Schema(name="sor-company-like", description="Filter by the company of the secondary object references of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="sor-company-like")
    private final String[] sorCompanyLike;
    @Schema(name="sor-system", description="Filter by the system of the secondary object reference of the Task. This is an exact match.")
    @JsonProperty(value="sor-system")
    private final String[] sorSystemIn;
    @Schema(name="sor-system-like", description="Filter by the system of the secondary object reference of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="sor-system-like")
    private final String[] sorSystemLike;
    @Schema(name="sor-instance", description="Filter by the system instance of the secondary object reference of the Task. This is an exact match.")
    @JsonProperty(value="sor-instance")
    private final String[] sorInstanceIn;
    @Schema(name="sor-instance-like", description="Filter by the system instance of the secondary object reference of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="sor-instance-like")
    private final String[] sorInstanceLike;
    @Schema(name="sor-type", description="Filter by the type of the secondary object reference of the Task. This is an exact match.")
    @JsonProperty(value="sor-type")
    private final String[] sorTypeIn;
    @Schema(name="sor-type-like", description="Filter by the type of the secondary object reference of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="sor-type-like")
    private final String[] sorTypeLike;
    @Schema(name="sor-value", description="Filter by the value of the secondary object reference of the Task. This is an exact match.")
    @JsonProperty(value="sor-value")
    private final String[] sorValueIn;
    @Schema(name="sor-value-like", description="Filter by the value of the secondary object reference of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="sor-value-like")
    private final String[] sorValueLike;
    @Schema(name="is-read", description="Filter by the is read flag of the Task. This is an exact match.")
    @JsonProperty(value="is-read")
    private final Boolean isRead;
    @Schema(name="is-transferred", description="Filter by the is transferred flag of the Task. This is an exact match.")
    @JsonProperty(value="is-transferred")
    private final Boolean isTransferred;
    @Schema(name="attachment-classification-id", description="Filter by the attachment classification id of the Task. This is an exact match.")
    @JsonProperty(value="attachment-classification-id")
    private final String[] attachmentClassificationIdIn;
    @Schema(name="attachment-classification-id-not", description="Filter by what the attachment classification id of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="attachment-classification-id-not")
    private final String[] attachmentClassificationIdNotIn;
    @Schema(name="attachment-classification-key", description="Filter by the attachment classification key of the Task. This is an exact match.")
    @JsonProperty(value="attachment-classification-key")
    private final String[] attachmentClassificationKeyIn;
    @Schema(name="attachment-classification-key-not", description="Filter by what the attachment classification key of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="attachment-classification-key-not")
    private final String[] attachmentClassificationKeyNotIn;
    @Schema(name="attachment-classification-key-like", description="Filter by the attachment classification key of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="attachment-classification-key-like")
    private final String[] attachmentClassificationKeyLike;
    @Schema(name="attachment-classification-key-not-like", description="Filter by what the attachment classification key of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="attachment-classification-key-not-like")
    private final String[] attachmentClassificationKeyNotLike;
    @Schema(name="attachment-classification-name", description="Filter by the attachment classification name of the Task. This is an exact match.")
    @JsonProperty(value="attachment-classification-name")
    private final String[] attachmentClassificationNameIn;
    @Schema(name="attachment-classification-name-not", description="Filter by what the attachment classification name of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="attachment-classification-name-not")
    private final String[] attachmentClassificationNameNotIn;
    @Schema(name="attachment-classification-name-like", description="Filter by the attachment classification name of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="attachment-classification-name-like")
    private final String[] attachmentClassificationNameLike;
    @Schema(name="attachment-classification-name-not-like", description="Filter by what the attachment classification name of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="attachment-classification-name-not-like")
    private final String[] attachmentClassificationNameNotLike;
    @Schema(name="attachment-channel", description="Filter by the attachment channel of the Task. This is an exact match.")
    @JsonProperty(value="attachment-channel")
    private final String[] attachmentChannelIn;
    @Schema(name="attachment-channel-not", description="Filter by what the attachment channel of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="attachment-channel-not")
    private final String[] attachmentChannelNotIn;
    @Schema(name="attachment-channel-like", description="Filter by the attachment channel of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="attachment-channel-like")
    private final String[] attachmentChannelLike;
    @Schema(name="attachment-channel-not-like", description="Filter by what the attachment channel of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="attachment-channel-not-like")
    private final String[] attachmentChannelNotLike;
    @Schema(name="attachment-reference", description="Filter by the attachment reference of the Task. This is an exact match.")
    @JsonProperty(value="attachment-reference")
    private final String[] attachmentReferenceIn;
    @Schema(name="attachment-reference-not", description="Filter by what the attachment reference of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="attachment-reference-not")
    private final String[] attachmentReferenceNotIn;
    @Schema(name="attachment-reference-like", description="Filter by the attachment reference of the Task. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="attachment-reference-like")
    private final String[] attachmentReferenceLike;
    @Schema(name="attachment-reference-not-like", description="Filter by what the attachment reference of the Task shouldn't be. This results in a substring search (% is appended to the front and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="attachment-reference-not-like")
    private final String[] attachmentReferenceNotLike;
    @Schema(name="attachment-received", description="Filter by a time interval within which the attachment of the Task was received. To create an open interval you can just leave it blank. <p>The format is ISO-8601.")
    @JsonProperty(value="attachment-received")
    private final Instant[] attachmentReceivedWithin;
    @Schema(name="attachment-received-not", description="Filter by a time interval within which the attachment of the Task wasn't received. To create an open interval you can just leave it blank. <p>The format is ISO-8601.")
    @JsonProperty(value="attachment-received-not")
    private final Instant[] attachmentReceivedNotWithin;
    @Schema(name="without-attachment", description="In order to filter Tasks that don't have any Attachments, set 'without-attachment' to 'true'. Any other value for 'without-attachment' is invalid.")
    @JsonProperty(value="without-attachment")
    private final Boolean withoutAttachment;
    @Schema(name="callback-state", description="Filter by the callback state of the Task. This is an exact match.")
    @JsonProperty(value="callback-state")
    private final CallbackState[] callbackStateIn;
    @Schema(name="callback-state-not", description="Filter by what the callback state of the Task shouldn't be. This is an exact match.")
    @JsonProperty(value="callback-state-not")
    private final CallbackState[] callbackStateNotIn;
    @Schema(name="wildcard-search-fields", description="Filter by wildcard search field of the Task. <p>This must be used in combination with 'wildcard-search-value'")
    @JsonProperty(value="wildcard-search-fields")
    private final WildcardSearchField[] wildcardSearchFieldIn;
    @Schema(name="wildcard-search-value", description="Filter by wildcard search field of the Task. This is an exact match. <p>This must be used in combination with 'wildcard-search-fields'")
    @JsonProperty(value="wildcard-search-value")
    private final String wildcardSearchValue;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_60;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_61;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_62;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_63;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_64;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_65;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_66;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_67;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_68;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_69;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_70;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_71;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_72;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_73;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_74;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_75;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_76;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_77;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_78;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_79;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_80;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_81;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_82;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_83;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_84;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_85;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_86;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_87;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_88;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_89;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_90;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_91;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_92;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_93;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_94;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_95;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_96;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_97;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_98;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_99;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_100;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_101;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_102;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_103;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_104;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_105;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_106;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_107;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_108;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_109;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_110;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_111;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_112;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_113;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_114;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_115;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_116;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_117;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_118;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_119;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_120;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_121;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_122;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_123;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_124;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_125;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_126;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_127;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_128;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_129;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_130;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_131;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_132;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_133;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_134;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_135;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_136;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_137;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_138;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_139;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_140;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_141;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_142;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_143;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_144;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_145;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_146;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_147;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_148;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_149;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_150;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_151;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_152;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_153;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_154;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_155;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_156;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_157;

    public String[] getTaskIdIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.taskIdIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getExternalIdIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.externalIdIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getExternalIdNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.externalIdNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public Instant[] getReceivedWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.receivedWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant getReceivedFrom() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.receivedFrom);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant getReceivedUntil() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.receivedUntil);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant[] getReceivedNotIn() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.receivedNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant getReceivedFromNot() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.receivedFromNot);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant getReceivedUntilNot() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.receivedUntilNot);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant[] getCreatedWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.createdWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant getCreatedFrom() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.createdFrom);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant getCreatedUntil() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.createdUntil);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant[] getCreatedNotWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.createdNotWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant getCreatedFromNot() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.createdFromNot);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant getCreatedUntilNot() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.createdUntilNot);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant[] getClaimedWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.claimedWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant[] getClaimedNotWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.claimedNotWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant[] getModifiedWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.modifiedWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant[] getModifiedNotWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.modifiedNotWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant[] getPlannedWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.plannedWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant getPlannedFrom() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.plannedFrom);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant getPlannedUntil() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.plannedUntil);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant[] getPlannedNotWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.plannedNotWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant getPlannedFromNot() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.plannedFromNot);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant getPlannedUntilNot() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.plannedUntilNot);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant[] getDueWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.dueWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant getDueFrom() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.dueFrom);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant getDueUntil() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.dueUntil);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant[] getDueNotWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.dueNotWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant getDueFromNot() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.dueFromNot);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant getDueUntilNot() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.dueUntilNot);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant[] getCompletedWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.completedWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant getCompletedFrom() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.completedFrom);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant getCompletedUntil() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.completedUntil);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant[] getCompletedNotWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.completedNotWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant getCompletedFromNot() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.completedFromNot);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public Instant getCompletedUntilNot() {
        Instant instant;
        Instant instant2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant instant3 = instant2 = (instant = this.completedUntilNot);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant2);
        return instant;
    }

    public String[] getNameIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.nameIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getNameNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.nameNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getNameLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.nameLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getNameNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.nameNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCreatorIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.creatorIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCreatorNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.creatorNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCreatorLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.creatorLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getCreatorNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.creatorNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getNoteLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.noteLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getNoteNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.noteNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getDescriptionLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.descriptionLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getDescriptionNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.descriptionNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public int[] getPriorityIn() {
        int[] nArray;
        int[] nArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int[] nArray3 = nArray2 = (nArray = this.priorityIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)nArray2);
        return nArray;
    }

    public int[] getPriorityNotIn() {
        int[] nArray;
        int[] nArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int[] nArray3 = nArray2 = (nArray = this.priorityNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)nArray2);
        return nArray;
    }

    public Integer[] getPriorityWithin() {
        Integer[] integerArray;
        Integer[] integerArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Integer[] integerArray3 = integerArray2 = (integerArray = this.priorityWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)integerArray2);
        return integerArray;
    }

    public Integer getPriorityFrom() {
        Integer n;
        Integer n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Integer n3 = n2 = (n = this.priorityFrom);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)n2);
        return n;
    }

    public Integer getPriorityUntil() {
        Integer n;
        Integer n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Integer n3 = n2 = (n = this.priorityUntil);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)n2);
        return n;
    }

    public Integer[] getPriorityNotWithin() {
        Integer[] integerArray;
        Integer[] integerArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Integer[] integerArray3 = integerArray2 = (integerArray = this.priorityNotWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)integerArray2);
        return integerArray;
    }

    public Integer getPriorityNotFrom() {
        Integer n;
        Integer n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Integer n3 = n2 = (n = this.priorityNotFrom);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)n2);
        return n;
    }

    public Integer getPriorityNotUntil() {
        Integer n;
        Integer n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Integer n3 = n2 = (n = this.priorityNotUntil);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)n2);
        return n;
    }

    public TaskState[] getStateIn() {
        TaskState[] taskStateArray;
        TaskState[] taskStateArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskState[] taskStateArray3 = taskStateArray2 = (taskStateArray = this.stateIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskStateArray2);
        return taskStateArray;
    }

    public TaskState[] getStateNotIn() {
        TaskState[] taskStateArray;
        TaskState[] taskStateArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        TaskState[] taskStateArray3 = taskStateArray2 = (taskStateArray = this.stateNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)taskStateArray2);
        return taskStateArray;
    }

    public String[] getClassificationIdIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationIdIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationIdNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_60, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationIdNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationKeyIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_61, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationKeyIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationKeyNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_62, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationKeyNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationKeyLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_63, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationKeyLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationKeyNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_64, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationKeyNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationParentKeyIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_65, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationParentKeyIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationParentKeyNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_66, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationParentKeyNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationParentKeyLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_67, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationParentKeyLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationParentKeyNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_68, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationParentKeyNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationCategoryIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_69, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationCategoryIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationCategoryNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_70, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationCategoryNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationCategoryLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_71, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationCategoryLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationCategoryNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_72, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationCategoryNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationNameIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_73, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationNameIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationNameNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_74, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationNameNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationNameLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_75, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationNameLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getClassificationNameNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_76, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.classificationNameNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getWorkbasketIdIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_77, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.workbasketIdIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getWorkbasketIdNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_78, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.workbasketIdNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getWorkbasketKeyIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_79, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.workbasketKeyIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getWorkbasketKeyNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_80, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.workbasketKeyNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String getDomain() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_81, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.domain);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String[] getBusinessProcessIdIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_82, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.businessProcessIdIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getBusinessProcessIdNot() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_83, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.businessProcessIdNot);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getBusinessProcessIdLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_84, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.businessProcessIdLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getBusinessProcessIdNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_85, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.businessProcessIdNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getParentBusinessProcessIdIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_86, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.parentBusinessProcessIdIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getParentBusinessProcessIdNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_87, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.parentBusinessProcessIdNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getParentBusinessProcessIdLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_88, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.parentBusinessProcessIdLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getParentBusinessProcessIdNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_89, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.parentBusinessProcessIdNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getOwnerIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_90, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.ownerIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getOwnerNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_91, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.ownerNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getOwnerLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_92, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.ownerLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getOwnerNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_93, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.ownerNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String getOwnerNull() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_94, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.ownerNull);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public ObjectReference[] getPrimaryObjectReferenceIn() {
        ObjectReference[] objectReferenceArray;
        ObjectReference[] objectReferenceArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_95, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ObjectReference[] objectReferenceArray3 = objectReferenceArray2 = (objectReferenceArray = this.primaryObjectReferenceIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)objectReferenceArray2);
        return objectReferenceArray;
    }

    public String[] getPorCompanyIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_96, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porCompanyIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorCompanyNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_97, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porCompanyNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorCompanyLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_98, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porCompanyLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorCompanyNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_99, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porCompanyNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorSystemIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_100, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porSystemIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorSystemNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_101, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porSystemNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorSystemLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_102, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porSystemLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorSystemNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_103, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porSystemNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorInstanceIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_104, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porInstanceIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorInstanceNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_105, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porInstanceNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorInstanceLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_106, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porInstanceLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorInstanceNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_107, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porInstanceNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorTypeIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_108, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porTypeIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorTypeNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_109, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porTypeNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorTypeLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_110, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porTypeLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorTypeNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_111, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porTypeNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorValueIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_112, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porValueIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorValueNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_113, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porValueNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorValueLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_114, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porValueLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getPorValueNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_115, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.porValueNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public ObjectReference[] getSecondaryObjectReferenceIn() {
        ObjectReference[] objectReferenceArray;
        ObjectReference[] objectReferenceArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_116, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ObjectReference[] objectReferenceArray3 = objectReferenceArray2 = (objectReferenceArray = this.secondaryObjectReferenceIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)objectReferenceArray2);
        return objectReferenceArray;
    }

    public String[] getSorCompanyIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_117, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.sorCompanyIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getSorCompanyLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_118, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.sorCompanyLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getSorSystemIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_119, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.sorSystemIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getSorSystemLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_120, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.sorSystemLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getSorInstanceIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_121, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.sorInstanceIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getSorInstanceLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_122, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.sorInstanceLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getSorTypeIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_123, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.sorTypeIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getSorTypeLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_124, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.sorTypeLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getSorValueIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_125, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.sorValueIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getSorValueLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_126, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.sorValueLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public Boolean getRead() {
        Boolean bl;
        Boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_127, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Boolean bl3 = bl2 = (bl = this.isRead);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bl2);
        return bl;
    }

    public Boolean getTransferred() {
        Boolean bl;
        Boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_128, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Boolean bl3 = bl2 = (bl = this.isTransferred);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bl2);
        return bl;
    }

    public String[] getAttachmentClassificationIdIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_129, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentClassificationIdIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentClassificationIdNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_130, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentClassificationIdNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentClassificationKeyIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_131, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentClassificationKeyIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentClassificationKeyNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_132, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentClassificationKeyNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentClassificationKeyLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_133, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentClassificationKeyLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentClassificationKeyNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_134, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentClassificationKeyNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentClassificationNameIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_135, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentClassificationNameIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentClassificationNameNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_136, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentClassificationNameNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentClassificationNameLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_137, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentClassificationNameLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentClassificationNameNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_138, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentClassificationNameNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentChannelIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_139, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentChannelIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentChannelNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_140, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentChannelNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentChannelLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_141, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentChannelLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentChannelNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_142, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentChannelNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentReferenceIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_143, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentReferenceIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentReferenceNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_144, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentReferenceNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentReferenceLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_145, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentReferenceLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAttachmentReferenceNotLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_146, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.attachmentReferenceNotLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public Instant[] getAttachmentReceivedWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_147, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.attachmentReceivedWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Instant[] getAttachmentReceivedNotWithin() {
        Instant[] instantArray;
        Instant[] instantArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_148, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Instant[] instantArray3 = instantArray2 = (instantArray = this.attachmentReceivedNotWithin);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instantArray2);
        return instantArray;
    }

    public Boolean getWithoutAttachment() {
        Boolean bl;
        Boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_149, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Boolean bl3 = bl2 = (bl = this.withoutAttachment);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)bl2);
        return bl;
    }

    public CallbackState[] getCallbackStateIn() {
        CallbackState[] callbackStateArray;
        CallbackState[] callbackStateArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_150, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        CallbackState[] callbackStateArray3 = callbackStateArray2 = (callbackStateArray = this.callbackStateIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)callbackStateArray2);
        return callbackStateArray;
    }

    public CallbackState[] getCallbackStateNotIn() {
        CallbackState[] callbackStateArray;
        CallbackState[] callbackStateArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_151, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        CallbackState[] callbackStateArray3 = callbackStateArray2 = (callbackStateArray = this.callbackStateNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)callbackStateArray2);
        return callbackStateArray;
    }

    public WildcardSearchField[] getWildcardSearchFieldIn() {
        WildcardSearchField[] wildcardSearchFieldArray;
        WildcardSearchField[] wildcardSearchFieldArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_152, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WildcardSearchField[] wildcardSearchFieldArray3 = wildcardSearchFieldArray2 = (wildcardSearchFieldArray = this.wildcardSearchFieldIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)wildcardSearchFieldArray2);
        return wildcardSearchFieldArray;
    }

    public String getWildcardSearchValue() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_153, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.wildcardSearchValue);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public String[] getTaskIdNotIn() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_154, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.taskIdNotIn);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    @ConstructorProperties(value={"task-id", "task-id-not", "external-id", "external-id-not", "received", "received-from", "received-until", "received-not", "received-from-not", "received-until-not", "created", "created-from", "created-until", "created-not", "created-from-not", "created-until-not", "claimed", "claimed-not", "modified", "modified-not", "planned", "planned-from", "planned-until", "planned-not", "planned-from-not", "planned-until-not", "due", "due-from", "due-until", "due-not", "due-from-not", "due-until-not", "completed", "completed-from", "completed-until", "completed-not", "completed-from-not", "completed-until-not", "name", "name-not", "name-like", "name-not-like", "creator", "creator-not", "creator-like", "creator-not-like", "note-like", "note-not-like", "description-like", "description-not-like", "priority", "priority-not", "priority-within", "priority-from", "priority-until", "priority-not-within", "priority-not-from", "priority-not-until", "state", "state-not", "has-comments", "classification-id", "classification-id-not", "classification-key", "classification-key-not", "classification-key-like", "classification-key-not-like", "classification-parent-key", "classification-parent-key-not", "classification-parent-key-like", "classification-parent-key-not-like", "classification-category", "classification-category-not", "classification-category-like", "classification-category-not-like", "classification-name", "classification-name-not", "classification-name-like", "classification-name-not-like", "workbasket-id", "workbasket-id-not", "workbasket-key", "workbasket-key-not", "domain", "business-process-id", "business-process-id-not", "business-process-id-like", "business-process-id-not-like", "parent-business-process-id", "parent-business-process-id-not", "parent-business-process-id-like", "parent-business-process-id-not-like", "owner", "owner-not", "owner-like", "owner-not-like", "owner-is-null", "por", "por-company", "por-company-not", "por-company-like", "por-company-not-like", "por-system", "por-system-not", "por-system-like", "por-system-not-like", "por-instance", "por-instance-not", "por-instance-like", "por-instance-not-like", "por-type", "por-type-not", "por-type-like", "por-type-not-like", "por-value", "por-value-not", "por-value-like", "por-value-not-like", "sor", "sor-company", "sor-company-like", "sor-system", "sor-system-like", "sor-instance", "sor-instance-like", "sor-type", "sor-type-like", "sor-value", "sor-value-like", "is-read", "is-transferred", "attachment-classification-id", "attachment-classification-id-not", "attachment-classification-key", "attachment-classification-key-not", "attachment-classification-key-like", "attachment-classification-key-not-like", "attachment-classification-name", "attachment-classification-name-not", "attachment-classification-name-like", "attachment-classification-name-not-like", "attachment-channel", "attachment-channel-not", "attachment-channel-like", "attachment-channel-not-like", "attachment-reference", "attachment-reference-not", "attachment-reference-like", "attachment-reference-not-like", "attachment-received", "attachment-received-not", "without-attachment", "callback-state", "callback-state-not", "wildcard-search-fields", "wildcard-search-value"})
    public TaskQueryFilterParameter(String[] taskIdIn, String[] taskIdNotIn, String[] externalIdIn, String[] externalIdNotIn, Instant[] receivedWithin, Instant receivedFrom, Instant receivedUntil, Instant[] receivedNotIn, Instant receivedFromNot, Instant receivedUntilNot, Instant[] createdWithin, Instant createdFrom, Instant createdUntil, Instant[] createdNotWithin, Instant createdFromNot, Instant createdUntilNot, Instant[] claimedWithin, Instant[] claimedNotWithin, Instant[] modifiedWithin, Instant[] modifiedNotWithin, Instant[] plannedWithin, Instant plannedFrom, Instant plannedUntil, Instant[] plannedNotWithin, Instant plannedFromNot, Instant plannedUntilNot, Instant[] dueWithin, Instant dueFrom, Instant dueUntil, Instant[] dueNotWithin, Instant dueFromNot, Instant dueUntilNot, Instant[] completedWithin, Instant completedFrom, Instant completedUntil, Instant[] completedNotWithin, Instant completedFromNot, Instant completedUntilNot, String[] nameIn, String[] nameNotIn, String[] nameLike, String[] nameNotLike, String[] creatorIn, String[] creatorNotIn, String[] creatorLike, String[] creatorNotLike, String[] noteLike, String[] noteNotLike, String[] descriptionLike, String[] descriptionNotLike, int[] priorityIn, int[] priorityNotIn, Integer[] priorityWithin, Integer priorityFrom, Integer priorityUntil, Integer[] priorityNotWithin, Integer priorityNotFrom, Integer priorityNotUntil, TaskState[] stateIn, TaskState[] stateNotIn, Boolean hasComments, String[] classificationIdIn, String[] classificationIdNotIn, String[] classificationKeyIn, String[] classificationKeyNotIn, String[] classificationKeyLike, String[] classificationKeyNotLike, String[] classificationParentKeyIn, String[] classificationParentKeyNotIn, String[] classificationParentKeyLike, String[] classificationParentKeyNotLike, String[] classificationCategoryIn, String[] classificationCategoryNotIn, String[] classificationCategoryLike, String[] classificationCategoryNotLike, String[] classificationNameIn, String[] classificationNameNotIn, String[] classificationNameLike, String[] classificationNameNotLike, String[] workbasketIdIn, String[] workbasketIdNotIn, String[] workbasketKeyIn, String[] workbasketKeyNotIn, String domain, String[] businessProcessIdIn, String[] businessProcessIdNot, String[] businessProcessIdLike, String[] businessProcessIdNotLike, String[] parentBusinessProcessIdIn, String[] parentBusinessProcessIdNotIn, String[] parentBusinessProcessIdLike, String[] parentBusinessProcessIdNotLike, String[] ownerIn, String[] ownerNotIn, String[] ownerLike, String[] ownerNotLike, String ownerNull, ObjectReference[] primaryObjectReferenceIn, String[] porCompanyIn, String[] porCompanyNotIn, String[] porCompanyLike, String[] porCompanyNotLike, String[] porSystemIn, String[] porSystemNotIn, String[] porSystemLike, String[] porSystemNotLike, String[] porInstanceIn, String[] porInstanceNotIn, String[] porInstanceLike, String[] porInstanceNotLike, String[] porTypeIn, String[] porTypeNotIn, String[] porTypeLike, String[] porTypeNotLike, String[] porValueIn, String[] porValueNotIn, String[] porValueLike, String[] porValueNotLike, ObjectReference[] secondaryObjectReferenceIn, String[] sorCompanyIn, String[] sorCompanyLike, String[] sorSystemIn, String[] sorSystemLike, String[] sorInstanceIn, String[] sorInstanceLike, String[] sorTypeIn, String[] sorTypeLike, String[] sorValueIn, String[] sorValueLike, Boolean isRead, Boolean isTransferred, String[] attachmentClassificationIdIn, String[] attachmentClassificationIdNotIn, String[] attachmentClassificationKeyIn, String[] attachmentClassificationKeyNotIn, String[] attachmentClassificationKeyLike, String[] attachmentClassificationKeyNotLike, String[] attachmentClassificationNameIn, String[] attachmentClassificationNameNotIn, String[] attachmentClassificationNameLike, String[] attachmentClassificationNameNotLike, String[] attachmentChannelIn, String[] attachmentChannelNotIn, String[] attachmentChannelLike, String[] attachmentChannelNotLike, String[] attachmentReferenceIn, String[] attachmentReferenceNotIn, String[] attachmentReferenceLike, String[] attachmentReferenceNotLike, Instant[] attachmentReceivedWithin, Instant[] attachmentReceivedNotWithin, Boolean withoutAttachment, CallbackState[] callbackStateIn, CallbackState[] callbackStateNotIn, WildcardSearchField[] wildcardSearchFieldIn, String wildcardSearchValue) throws InvalidArgumentException {
        this.taskIdIn = taskIdIn;
        this.taskIdNotIn = taskIdNotIn;
        this.externalIdIn = externalIdIn;
        this.externalIdNotIn = externalIdNotIn;
        this.receivedWithin = receivedWithin;
        this.receivedFrom = receivedFrom;
        this.receivedUntil = receivedUntil;
        this.receivedNotIn = receivedNotIn;
        this.receivedFromNot = receivedFromNot;
        this.receivedUntilNot = receivedUntilNot;
        this.createdWithin = createdWithin;
        this.createdFrom = createdFrom;
        this.createdUntil = createdUntil;
        this.createdNotWithin = createdNotWithin;
        this.createdFromNot = createdFromNot;
        this.createdUntilNot = createdUntilNot;
        this.claimedWithin = claimedWithin;
        this.claimedNotWithin = claimedNotWithin;
        this.modifiedWithin = modifiedWithin;
        this.modifiedNotWithin = modifiedNotWithin;
        this.plannedWithin = plannedWithin;
        this.plannedFrom = plannedFrom;
        this.plannedUntil = plannedUntil;
        this.plannedNotWithin = plannedNotWithin;
        this.plannedFromNot = plannedFromNot;
        this.plannedUntilNot = plannedUntilNot;
        this.dueWithin = dueWithin;
        this.dueFrom = dueFrom;
        this.dueUntil = dueUntil;
        this.dueNotWithin = dueNotWithin;
        this.dueFromNot = dueFromNot;
        this.dueUntilNot = dueUntilNot;
        this.completedWithin = completedWithin;
        this.completedFrom = completedFrom;
        this.completedUntil = completedUntil;
        this.completedNotWithin = completedNotWithin;
        this.completedFromNot = completedFromNot;
        this.completedUntilNot = completedUntilNot;
        this.nameIn = nameIn;
        this.nameNotIn = nameNotIn;
        this.nameLike = nameLike;
        this.nameNotLike = nameNotLike;
        this.creatorIn = creatorIn;
        this.creatorNotIn = creatorNotIn;
        this.creatorLike = creatorLike;
        this.creatorNotLike = creatorNotLike;
        this.noteLike = noteLike;
        this.noteNotLike = noteNotLike;
        this.descriptionLike = descriptionLike;
        this.descriptionNotLike = descriptionNotLike;
        this.priorityIn = priorityIn;
        this.priorityNotIn = priorityNotIn;
        this.priorityWithin = priorityWithin;
        this.priorityFrom = priorityFrom;
        this.priorityUntil = priorityUntil;
        this.priorityNotWithin = priorityNotWithin;
        this.priorityNotFrom = priorityNotFrom;
        this.priorityNotUntil = priorityNotUntil;
        this.stateIn = stateIn;
        this.stateNotIn = stateNotIn;
        this.hasComments = hasComments;
        this.classificationIdIn = classificationIdIn;
        this.classificationIdNotIn = classificationIdNotIn;
        this.classificationKeyIn = classificationKeyIn;
        this.classificationKeyNotIn = classificationKeyNotIn;
        this.classificationKeyLike = classificationKeyLike;
        this.classificationKeyNotLike = classificationKeyNotLike;
        this.classificationParentKeyIn = classificationParentKeyIn;
        this.classificationParentKeyNotIn = classificationParentKeyNotIn;
        this.classificationParentKeyLike = classificationParentKeyLike;
        this.classificationParentKeyNotLike = classificationParentKeyNotLike;
        this.classificationCategoryIn = classificationCategoryIn;
        this.classificationCategoryNotIn = classificationCategoryNotIn;
        this.classificationCategoryLike = classificationCategoryLike;
        this.classificationCategoryNotLike = classificationCategoryNotLike;
        this.classificationNameIn = classificationNameIn;
        this.classificationNameNotIn = classificationNameNotIn;
        this.classificationNameLike = classificationNameLike;
        this.classificationNameNotLike = classificationNameNotLike;
        this.workbasketIdIn = workbasketIdIn;
        this.workbasketIdNotIn = workbasketIdNotIn;
        this.workbasketKeyIn = workbasketKeyIn;
        this.workbasketKeyNotIn = workbasketKeyNotIn;
        this.domain = domain;
        this.businessProcessIdIn = businessProcessIdIn;
        this.businessProcessIdNot = businessProcessIdNot;
        this.businessProcessIdLike = businessProcessIdLike;
        this.businessProcessIdNotLike = businessProcessIdNotLike;
        this.parentBusinessProcessIdIn = parentBusinessProcessIdIn;
        this.parentBusinessProcessIdNotIn = parentBusinessProcessIdNotIn;
        this.parentBusinessProcessIdLike = parentBusinessProcessIdLike;
        this.parentBusinessProcessIdNotLike = parentBusinessProcessIdNotLike;
        this.ownerIn = ownerIn;
        this.ownerNotIn = ownerNotIn;
        this.ownerLike = ownerLike;
        this.ownerNotLike = ownerNotLike;
        this.ownerNull = ownerNull;
        this.primaryObjectReferenceIn = primaryObjectReferenceIn;
        this.porCompanyIn = porCompanyIn;
        this.porCompanyNotIn = porCompanyNotIn;
        this.porCompanyLike = porCompanyLike;
        this.porCompanyNotLike = porCompanyNotLike;
        this.porSystemIn = porSystemIn;
        this.porSystemNotIn = porSystemNotIn;
        this.porSystemLike = porSystemLike;
        this.porSystemNotLike = porSystemNotLike;
        this.porInstanceIn = porInstanceIn;
        this.porInstanceNotIn = porInstanceNotIn;
        this.porInstanceLike = porInstanceLike;
        this.porInstanceNotLike = porInstanceNotLike;
        this.porTypeIn = porTypeIn;
        this.porTypeNotIn = porTypeNotIn;
        this.porTypeLike = porTypeLike;
        this.porTypeNotLike = porTypeNotLike;
        this.porValueIn = porValueIn;
        this.porValueNotIn = porValueNotIn;
        this.porValueLike = porValueLike;
        this.porValueNotLike = porValueNotLike;
        this.secondaryObjectReferenceIn = secondaryObjectReferenceIn;
        this.sorCompanyIn = sorCompanyIn;
        this.sorCompanyLike = sorCompanyLike;
        this.sorSystemIn = sorSystemIn;
        this.sorSystemLike = sorSystemLike;
        this.sorInstanceIn = sorInstanceIn;
        this.sorInstanceLike = sorInstanceLike;
        this.sorTypeIn = sorTypeIn;
        this.sorTypeLike = sorTypeLike;
        this.sorValueIn = sorValueIn;
        this.sorValueLike = sorValueLike;
        this.isRead = isRead;
        this.isTransferred = isTransferred;
        this.attachmentClassificationIdIn = attachmentClassificationIdIn;
        this.attachmentClassificationIdNotIn = attachmentClassificationIdNotIn;
        this.attachmentClassificationKeyIn = attachmentClassificationKeyIn;
        this.attachmentClassificationKeyNotIn = attachmentClassificationKeyNotIn;
        this.attachmentClassificationKeyLike = attachmentClassificationKeyLike;
        this.attachmentClassificationKeyNotLike = attachmentClassificationKeyNotLike;
        this.attachmentClassificationNameIn = attachmentClassificationNameIn;
        this.attachmentClassificationNameNotIn = attachmentClassificationNameNotIn;
        this.attachmentClassificationNameLike = attachmentClassificationNameLike;
        this.attachmentClassificationNameNotLike = attachmentClassificationNameNotLike;
        this.attachmentChannelIn = attachmentChannelIn;
        this.attachmentChannelNotIn = attachmentChannelNotIn;
        this.attachmentChannelLike = attachmentChannelLike;
        this.attachmentChannelNotLike = attachmentChannelNotLike;
        this.attachmentReferenceIn = attachmentReferenceIn;
        this.attachmentReferenceNotIn = attachmentReferenceNotIn;
        this.attachmentReferenceLike = attachmentReferenceLike;
        this.attachmentReferenceNotLike = attachmentReferenceNotLike;
        this.attachmentReceivedWithin = attachmentReceivedWithin;
        this.attachmentReceivedNotWithin = attachmentReceivedNotWithin;
        this.withoutAttachment = withoutAttachment;
        this.callbackStateIn = callbackStateIn;
        this.callbackStateNotIn = callbackStateNotIn;
        this.wildcardSearchFieldIn = wildcardSearchFieldIn;
        this.wildcardSearchValue = wildcardSearchValue;
        this.validateFilterParameters();
    }

    @Override
    public Void apply(TaskQuery query) {
        Void void_;
        TaskQuery taskQuery = query;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_155, (Object)this, (Object)this, (Object)taskQuery);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Optional.ofNullable(this.taskIdIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.idIn(stringArray);
        });
        Optional.ofNullable(this.taskIdNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.idNotIn(stringArray);
        });
        Optional.ofNullable(this.externalIdIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.externalIdIn(stringArray);
        });
        Optional.ofNullable(this.externalIdNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.externalIdNotIn(stringArray);
        });
        Optional.ofNullable(this.receivedWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.receivedWithin(timeIntervalArray);
        });
        if (this.receivedFrom != null || this.receivedUntil != null) {
            query.receivedWithin(new TimeInterval[]{new TimeInterval(this.receivedFrom, this.receivedUntil)});
        }
        Optional.ofNullable(this.receivedNotIn).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.receivedNotWithin(timeIntervalArray);
        });
        if (this.receivedFromNot != null || this.receivedUntilNot != null) {
            query.receivedNotWithin(new TimeInterval[]{new TimeInterval(this.receivedFromNot, this.receivedUntilNot)});
        }
        Optional.ofNullable(this.createdWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.createdWithin(timeIntervalArray);
        });
        if (this.createdFrom != null || this.createdUntil != null) {
            query.createdWithin(new TimeInterval[]{new TimeInterval(this.createdFrom, this.createdUntil)});
        }
        Optional.ofNullable(this.createdNotWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.createdNotWithin(timeIntervalArray);
        });
        if (this.createdFromNot != null || this.createdUntilNot != null) {
            query.createdNotWithin(new TimeInterval[]{new TimeInterval(this.createdFromNot, this.createdUntilNot)});
        }
        Optional.ofNullable(this.claimedWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.claimedWithin(timeIntervalArray);
        });
        Optional.ofNullable(this.claimedNotWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.claimedNotWithin(timeIntervalArray);
        });
        Optional.ofNullable(this.modifiedWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.modifiedWithin(timeIntervalArray);
        });
        Optional.ofNullable(this.modifiedNotWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.modifiedNotWithin(timeIntervalArray);
        });
        Optional.ofNullable(this.plannedWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.plannedWithin(timeIntervalArray);
        });
        if (this.plannedFrom != null || this.plannedUntil != null) {
            query.plannedWithin(new TimeInterval[]{new TimeInterval(this.plannedFrom, this.plannedUntil)});
        }
        Optional.ofNullable(this.plannedNotWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.plannedNotWithin(timeIntervalArray);
        });
        if (this.plannedFromNot != null || this.plannedUntilNot != null) {
            query.plannedNotWithin(new TimeInterval[]{new TimeInterval(this.plannedFromNot, this.plannedUntilNot)});
        }
        Optional.ofNullable(this.dueWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.dueWithin(timeIntervalArray);
        });
        if (this.dueFrom != null || this.dueUntil != null) {
            query.dueWithin(new TimeInterval[]{new TimeInterval(this.dueFrom, this.dueUntil)});
        }
        Optional.ofNullable(this.dueNotWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.dueNotWithin(timeIntervalArray);
        });
        if (this.dueFromNot != null || this.dueUntilNot != null) {
            query.dueNotWithin(new TimeInterval[]{new TimeInterval(this.dueFromNot, this.dueUntilNot)});
        }
        Optional.ofNullable(this.completedWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.completedWithin(timeIntervalArray);
        });
        if (this.completedFrom != null || this.completedUntil != null) {
            query.completedWithin(new TimeInterval[]{new TimeInterval(this.completedFrom, this.completedUntil)});
        }
        Optional.ofNullable(this.completedNotWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.completedNotWithin(timeIntervalArray);
        });
        if (this.completedFromNot != null || this.completedUntilNot != null) {
            query.completedNotWithin(new TimeInterval[]{new TimeInterval(this.completedFromNot, this.completedUntilNot)});
        }
        Optional.ofNullable(this.nameIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.nameIn(stringArray);
        });
        Optional.ofNullable(this.nameNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.nameNotIn(stringArray);
        });
        Optional.ofNullable(this.nameLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.nameLike(stringArray);
        });
        Optional.ofNullable(this.nameNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.nameNotLike(stringArray);
        });
        Optional.ofNullable(this.creatorIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.creatorIn(stringArray);
        });
        Optional.ofNullable(this.creatorNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.creatorNotIn(stringArray);
        });
        Optional.ofNullable(this.creatorLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.creatorLike(stringArray);
        });
        Optional.ofNullable(this.creatorNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.creatorNotLike(stringArray);
        });
        Optional.ofNullable(this.noteLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.noteLike(stringArray);
        });
        Optional.ofNullable(this.noteNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.noteNotLike(stringArray);
        });
        Optional.ofNullable(this.descriptionLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.descriptionLike(stringArray);
        });
        Optional.ofNullable(this.descriptionNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.descriptionNotLike(stringArray);
        });
        Optional.ofNullable(this.priorityIn).ifPresent(nArray -> {
            TaskQuery taskQuery2 = query.priorityIn(nArray);
        });
        Optional.ofNullable(this.priorityNotIn).ifPresent(nArray -> {
            TaskQuery taskQuery2 = query.priorityNotIn(nArray);
        });
        Optional.ofNullable(this.priorityWithin).map(this::extractIntIntervals).ifPresent(intIntervalArray -> {
            TaskQuery taskQuery2 = query.priorityWithin(intIntervalArray);
        });
        if (this.priorityFrom != null || this.priorityUntil != null) {
            query.priorityWithin(new IntInterval[]{new IntInterval(this.priorityFrom, this.priorityUntil)});
        }
        Optional.ofNullable(this.priorityNotWithin).map(this::extractIntIntervals).ifPresent(intIntervalArray -> {
            TaskQuery taskQuery2 = query.priorityNotWithin(intIntervalArray);
        });
        if (this.priorityNotFrom != null || this.priorityNotUntil != null) {
            query.priorityNotWithin(new IntInterval[]{new IntInterval(this.priorityNotFrom, this.priorityNotUntil)});
        }
        Optional.ofNullable(this.stateIn).ifPresent(taskStateArray -> {
            TaskQuery taskQuery2 = query.stateIn(taskStateArray);
        });
        Optional.ofNullable(this.stateNotIn).ifPresent(taskStateArray -> {
            TaskQuery taskQuery2 = query.stateNotIn(taskStateArray);
        });
        Optional.ofNullable(this.classificationIdIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationIdIn(stringArray);
        });
        Optional.ofNullable(this.classificationIdNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationIdNotIn(stringArray);
        });
        Optional.ofNullable(this.classificationKeyIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationKeyIn(stringArray);
        });
        Optional.ofNullable(this.classificationKeyNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationKeyNotIn(stringArray);
        });
        Optional.ofNullable(this.classificationKeyLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationKeyLike(stringArray);
        });
        Optional.ofNullable(this.classificationKeyNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationKeyNotLike(stringArray);
        });
        Optional.ofNullable(this.classificationParentKeyIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationParentKeyIn(stringArray);
        });
        Optional.ofNullable(this.classificationParentKeyNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationParentKeyNotIn(stringArray);
        });
        Optional.ofNullable(this.classificationParentKeyLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationParentKeyLike(stringArray);
        });
        Optional.ofNullable(this.classificationParentKeyNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationParentKeyNotLike(stringArray);
        });
        Optional.ofNullable(this.classificationCategoryIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationCategoryIn(stringArray);
        });
        Optional.ofNullable(this.classificationCategoryNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationCategoryNotIn(stringArray);
        });
        Optional.ofNullable(this.classificationCategoryLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationCategoryLike(stringArray);
        });
        Optional.ofNullable(this.classificationCategoryNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationCategoryNotLike(stringArray);
        });
        Optional.ofNullable(this.classificationNameIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationNameIn(stringArray);
        });
        Optional.ofNullable(this.classificationNameNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationNameNotIn(stringArray);
        });
        Optional.ofNullable(this.classificationNameLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationNameLike(stringArray);
        });
        Optional.ofNullable(this.classificationNameNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.classificationNameNotLike(stringArray);
        });
        Optional.ofNullable(this.workbasketIdIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.workbasketIdIn(stringArray);
        });
        Optional.ofNullable(this.workbasketIdNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.workbasketIdNotIn(stringArray);
        });
        Optional.ofNullable(this.workbasketKeyIn).map(keys -> (KeyDomain[])Arrays.stream(keys).map(key -> new KeyDomain(key, this.domain)).toArray(KeyDomain[]::new)).ifPresent(keyDomainArray -> {
            TaskQuery taskQuery2 = query.workbasketKeyDomainIn(keyDomainArray);
        });
        Optional.ofNullable(this.workbasketKeyNotIn).map(keys -> (KeyDomain[])Arrays.stream(keys).map(key -> new KeyDomain(key, this.domain)).toArray(KeyDomain[]::new)).ifPresent(keyDomainArray -> {
            TaskQuery taskQuery2 = query.workbasketKeyDomainNotIn(keyDomainArray);
        });
        Optional.ofNullable(this.businessProcessIdIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.businessProcessIdIn(stringArray);
        });
        Optional.ofNullable(this.businessProcessIdNot).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.businessProcessIdNotIn(stringArray);
        });
        Optional.ofNullable(this.businessProcessIdLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.businessProcessIdLike(stringArray);
        });
        Optional.ofNullable(this.businessProcessIdNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.businessProcessIdNotLike(stringArray);
        });
        Optional.ofNullable(this.parentBusinessProcessIdIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.parentBusinessProcessIdIn(stringArray);
        });
        Optional.ofNullable(this.parentBusinessProcessIdNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.parentBusinessProcessIdNotIn(stringArray);
        });
        Optional.ofNullable(this.parentBusinessProcessIdLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.parentBusinessProcessIdLike(stringArray);
        });
        Optional.ofNullable(this.parentBusinessProcessIdNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.parentBusinessProcessIdNotLike(stringArray);
        });
        String[] ownerInIncludingNull = this.addNullToOwnerIn();
        Optional.ofNullable(ownerInIncludingNull).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.ownerIn(stringArray);
        });
        Optional.ofNullable(this.ownerNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.ownerNotIn(stringArray);
        });
        Optional.ofNullable(this.ownerLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.ownerLike(stringArray);
        });
        Optional.ofNullable(this.ownerNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.ownerNotLike(stringArray);
        });
        Optional.ofNullable(this.primaryObjectReferenceIn).ifPresent(objectReferenceArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceIn(objectReferenceArray);
        });
        Optional.ofNullable(this.porCompanyIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceCompanyIn(stringArray);
        });
        Optional.ofNullable(this.porCompanyNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceCompanyNotIn(stringArray);
        });
        Optional.ofNullable(this.porCompanyLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceCompanyLike(stringArray);
        });
        Optional.ofNullable(this.porCompanyNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceCompanyNotLike(stringArray);
        });
        Optional.ofNullable(this.porSystemIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceSystemIn(stringArray);
        });
        Optional.ofNullable(this.porSystemNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceSystemNotIn(stringArray);
        });
        Optional.ofNullable(this.porSystemLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceSystemLike(stringArray);
        });
        Optional.ofNullable(this.porSystemNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceSystemNotLike(stringArray);
        });
        Optional.ofNullable(this.porInstanceIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceSystemInstanceIn(stringArray);
        });
        Optional.ofNullable(this.porInstanceNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceSystemInstanceNotIn(stringArray);
        });
        Optional.ofNullable(this.porInstanceLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceSystemInstanceLike(stringArray);
        });
        Optional.ofNullable(this.porInstanceNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceSystemInstanceNotLike(stringArray);
        });
        Optional.ofNullable(this.porTypeIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceTypeIn(stringArray);
        });
        Optional.ofNullable(this.porTypeNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceTypeNotIn(stringArray);
        });
        Optional.ofNullable(this.porTypeLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceTypeLike(stringArray);
        });
        Optional.ofNullable(this.porTypeNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceTypeNotLike(stringArray);
        });
        Optional.ofNullable(this.porValueIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceValueIn(stringArray);
        });
        Optional.ofNullable(this.porValueNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceValueNotIn(stringArray);
        });
        Optional.ofNullable(this.porValueLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceValueLike(stringArray);
        });
        Optional.ofNullable(this.porValueNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.primaryObjectReferenceValueNotLike(stringArray);
        });
        Optional.ofNullable(this.secondaryObjectReferenceIn).ifPresent(objectReferenceArray -> {
            TaskQuery taskQuery2 = query.secondaryObjectReferenceIn(objectReferenceArray);
        });
        Optional.ofNullable(this.sorCompanyIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.sorCompanyIn(stringArray);
        });
        Optional.ofNullable(this.sorCompanyLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.sorCompanyLike(stringArray);
        });
        Optional.ofNullable(this.sorSystemIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.sorSystemIn(stringArray);
        });
        Optional.ofNullable(this.sorSystemLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.sorSystemLike(stringArray);
        });
        Optional.ofNullable(this.sorInstanceIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.sorSystemInstanceIn(stringArray);
        });
        Optional.ofNullable(this.sorInstanceLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.sorSystemInstanceLike(stringArray);
        });
        Optional.ofNullable(this.sorTypeIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.sorTypeIn(stringArray);
        });
        Optional.ofNullable(this.sorTypeLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.sorTypeLike(stringArray);
        });
        Optional.ofNullable(this.sorValueIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.sorValueIn(stringArray);
        });
        Optional.ofNullable(this.sorValueLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.sorValueLike(stringArray);
        });
        Optional.ofNullable(this.isRead).ifPresent(arg_0 -> ((TaskQuery)query).readEquals(arg_0));
        Optional.ofNullable(this.isTransferred).ifPresent(arg_0 -> ((TaskQuery)query).transferredEquals(arg_0));
        Optional.ofNullable(this.hasComments).ifPresent(arg_0 -> ((TaskQuery)query).hasComments(arg_0));
        Optional.ofNullable(this.attachmentClassificationIdIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentClassificationIdIn(stringArray);
        });
        Optional.ofNullable(this.attachmentClassificationIdNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentClassificationIdNotIn(stringArray);
        });
        Optional.ofNullable(this.attachmentClassificationKeyIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentClassificationKeyIn(stringArray);
        });
        Optional.ofNullable(this.attachmentClassificationKeyNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentClassificationKeyNotIn(stringArray);
        });
        Optional.ofNullable(this.attachmentClassificationKeyLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentClassificationKeyLike(stringArray);
        });
        Optional.ofNullable(this.attachmentClassificationKeyNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentClassificationKeyNotLike(stringArray);
        });
        Optional.ofNullable(this.attachmentClassificationNameIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentClassificationNameIn(stringArray);
        });
        Optional.ofNullable(this.attachmentClassificationNameNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentClassificationNameNotIn(stringArray);
        });
        Optional.ofNullable(this.attachmentClassificationNameLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentClassificationNameLike(stringArray);
        });
        Optional.ofNullable(this.attachmentClassificationNameNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentClassificationNameNotLike(stringArray);
        });
        Optional.ofNullable(this.attachmentChannelIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentChannelIn(stringArray);
        });
        Optional.ofNullable(this.attachmentChannelNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentChannelNotIn(stringArray);
        });
        Optional.ofNullable(this.attachmentChannelLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentChannelLike(stringArray);
        });
        Optional.ofNullable(this.attachmentChannelNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentChannelNotLike(stringArray);
        });
        Optional.ofNullable(this.attachmentReferenceIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentReferenceValueIn(stringArray);
        });
        Optional.ofNullable(this.attachmentReferenceNotIn).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentReferenceValueNotIn(stringArray);
        });
        Optional.ofNullable(this.attachmentReferenceLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentReferenceValueLike(stringArray);
        });
        Optional.ofNullable(this.attachmentReferenceNotLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            TaskQuery taskQuery2 = query.attachmentReferenceValueNotLike(stringArray);
        });
        Optional.ofNullable(this.attachmentReceivedWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.attachmentReceivedWithin(timeIntervalArray);
        });
        Optional.ofNullable(this.attachmentReceivedNotWithin).map(this::extractTimeIntervals).ifPresent(timeIntervalArray -> {
            TaskQuery taskQuery2 = query.attachmentNotReceivedWithin(timeIntervalArray);
        });
        if (Boolean.TRUE.equals(this.withoutAttachment)) {
            query.withoutAttachment();
        }
        Optional.ofNullable(this.callbackStateIn).ifPresent(callbackStateArray -> {
            TaskQuery taskQuery2 = query.callbackStateIn(callbackStateArray);
        });
        Optional.ofNullable(this.callbackStateNotIn).ifPresent(callbackStateArray -> {
            TaskQuery taskQuery2 = query.callbackStateNotIn(callbackStateArray);
        });
        if (this.wildcardSearchFieldIn != null) {
            query.wildcardSearchFieldsIn(this.wildcardSearchFieldIn);
            query.wildcardSearchValueLike("%" + this.wildcardSearchValue + "%");
        }
        Void void_2 = null;
        Void void_3 = void_ = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, void_);
        return void_2;
    }

    private void validateFilterParameters() throws InvalidArgumentException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_156, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.plannedWithin != null && (this.plannedFrom != null || this.plannedUntil != null)) {
            throw new InvalidArgumentException("It is prohibited to use the param 'planned' in combination with the params 'planned-from'  and / or 'planned-until'");
        }
        if (this.plannedNotWithin != null && (this.plannedFromNot != null || this.plannedUntilNot != null)) {
            throw new InvalidArgumentException("It is prohibited to use the param 'planned-not-in' in combination with the params 'planned-not-in-from'  and / or 'planned-not-in-until'");
        }
        if (this.receivedWithin != null && (this.receivedFrom != null || this.receivedUntil != null)) {
            throw new InvalidArgumentException("It is prohibited to use the param 'received' in combination with the params 'received-from'  and / or 'received-until'");
        }
        if (this.receivedNotIn != null && (this.receivedFromNot != null || this.receivedUntilNot != null)) {
            throw new InvalidArgumentException("It is prohibited to use the param 'received-not-in' in combination with the params 'received-not-in-from'  and / or 'received-not-in-until'");
        }
        if (this.dueWithin != null && (this.dueFrom != null || this.dueUntil != null)) {
            throw new InvalidArgumentException("It is prohibited to use the param 'due' in combination with the params 'due-from'  and / or 'due-until'");
        }
        if (this.dueNotWithin != null && (this.dueFromNot != null || this.dueUntilNot != null)) {
            throw new InvalidArgumentException("It is prohibited to use the param 'due-not-in' in combination with the params 'due-not-in-from'  and / or 'due-not-in-until'");
        }
        if (this.createdWithin != null && (this.createdFrom != null || this.createdUntil != null)) {
            throw new InvalidArgumentException("It is prohibited to use the param 'created' in combination with the params 'created-from'  and / or 'created-until'");
        }
        if (this.createdNotWithin != null && (this.createdFromNot != null || this.createdUntilNot != null)) {
            throw new InvalidArgumentException("It is prohibited to use the param 'created-not-in' in combination with the params 'created-not-in-from'  and / or 'created-not-in-until'");
        }
        if (this.completedWithin != null && (this.completedFrom != null || this.completedUntil != null)) {
            throw new InvalidArgumentException("It is prohibited to use the param 'completed' in combination with the params 'completed-from'  and / or 'completed-until'");
        }
        if (this.completedNotWithin != null && (this.completedFromNot != null || this.completedUntilNot != null)) {
            throw new InvalidArgumentException("It is prohibited to use the param 'completed-not-in' in combination with the params 'completed-not-in-from'  and / or 'completed-not-in-until'");
        }
        if (this.priorityWithin != null && (this.priorityFrom != null || this.priorityUntil != null)) {
            throw new InvalidArgumentException("It is prohibited to use the param 'priority-within' in combination with the params 'priority-from'  and / or 'priority-until'");
        }
        if (this.priorityNotWithin != null && (this.priorityNotFrom != null || this.priorityNotUntil != null)) {
            throw new InvalidArgumentException("It is prohibited to use the param 'priority-not-within' in combination with the params 'priority-not-from'  and / or 'priority-not-until'");
        }
        if (this.priorityWithin != null && this.priorityWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'priority-within' is not dividable by 2");
        }
        if (this.priorityNotWithin != null && this.priorityNotWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'priority-not-within' is not dividable by 2");
        }
        if (this.wildcardSearchFieldIn == null ^ this.wildcardSearchValue == null) {
            throw new InvalidArgumentException("The params 'wildcard-search-field' and 'wildcard-search-value' must be used together");
        }
        if (this.workbasketKeyIn != null && this.domain == null) {
            throw new InvalidArgumentException("'workbasket-key' can only be used together with 'domain'.");
        }
        if (this.workbasketKeyNotIn != null && this.domain == null) {
            throw new InvalidArgumentException("'workbasket-key-not' can only be used together with 'domain'.");
        }
        if (this.workbasketKeyIn == null && this.workbasketKeyNotIn == null && this.domain != null) {
            throw new InvalidArgumentException("'domain' can only be used together with 'workbasket-key' or 'workbasket-key-not'.");
        }
        if (this.plannedWithin != null && this.plannedWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'planned' is not dividable by 2");
        }
        if (this.receivedWithin != null && this.receivedWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'received' is not dividable by 2");
        }
        if (this.dueWithin != null && this.dueWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'due' is not dividable by 2");
        }
        if (this.modifiedWithin != null && this.modifiedWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'modified' is not dividable by 2");
        }
        if (this.createdWithin != null && this.createdWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'created' is not dividable by 2");
        }
        if (this.completedWithin != null && this.completedWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'completed' is not dividable by 2");
        }
        if (this.claimedWithin != null && this.claimedWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'claimed' is not dividable by 2");
        }
        if (this.attachmentReceivedWithin != null && this.attachmentReceivedWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'attachmentReceived' is not dividable by 2");
        }
        if (this.plannedNotWithin != null && this.plannedNotWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'planned-not-in' is not dividable by 2");
        }
        if (this.receivedNotIn != null && this.receivedNotIn.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'received-not-in' is not dividable by 2");
        }
        if (this.dueNotWithin != null && this.dueNotWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'due-not-in' is not dividable by 2");
        }
        if (this.modifiedNotWithin != null && this.modifiedNotWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'modified-not-in' is not dividable by 2");
        }
        if (this.createdNotWithin != null && this.createdNotWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'created-not-in' is not dividable by 2");
        }
        if (this.completedNotWithin != null && this.completedNotWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'completed-not-in' is not dividable by 2");
        }
        if (this.claimedNotWithin != null && this.claimedNotWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'claimed-not-in' is not dividable by 2");
        }
        if (this.attachmentReceivedNotWithin != null && this.attachmentReceivedNotWithin.length % 2 != 0) {
            throw new InvalidArgumentException("provided length of the property 'attachment-not-received' is not dividable by 2");
        }
        if (this.withoutAttachment != null && !this.withoutAttachment.booleanValue()) {
            throw new InvalidArgumentException("provided value of the property 'without-attachment' must be 'true'");
        }
        Object var2_2 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var2_2);
    }

    private String[] addNullToOwnerIn() {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_157, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (this.ownerNull == null) {
            stringArray2 = stringArray3 = this.ownerIn;
        } else if (this.ownerIn == null) {
            stringArray2 = stringArray3 = new String[1];
        } else {
            ArrayList<String> ownerInAsList = new ArrayList<String>(Arrays.asList(this.ownerIn));
            ownerInAsList.add(null);
            stringArray2 = stringArray3 = ownerInAsList.toArray(new String[ownerInAsList.size()]);
        }
        String[] stringArray4 = stringArray = stringArray2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray);
        return stringArray3;
    }

    static {
        TaskQueryFilterParameter.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskQueryFilterParameter.java", TaskQueryFilterParameter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskIdIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 24);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getExternalIdIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 28);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatedFrom", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 64);
        ajc$tjp_100 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorSystemIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 424);
        ajc$tjp_101 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorSystemNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 428);
        ajc$tjp_102 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorSystemLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 432);
        ajc$tjp_103 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorSystemNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 436);
        ajc$tjp_104 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorInstanceIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 440);
        ajc$tjp_105 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorInstanceNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 444);
        ajc$tjp_106 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorInstanceLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 448);
        ajc$tjp_107 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorInstanceNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 452);
        ajc$tjp_108 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorTypeIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 456);
        ajc$tjp_109 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorTypeNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 460);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatedUntil", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 68);
        ajc$tjp_110 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorTypeLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 464);
        ajc$tjp_111 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorTypeNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 468);
        ajc$tjp_112 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorValueIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 472);
        ajc$tjp_113 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorValueNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 476);
        ajc$tjp_114 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorValueLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 480);
        ajc$tjp_115 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorValueNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 484);
        ajc$tjp_116 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSecondaryObjectReferenceIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Lpro.taskana.task.api.models.ObjectReference;"), 488);
        ajc$tjp_117 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSorCompanyIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 492);
        ajc$tjp_118 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSorCompanyLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 496);
        ajc$tjp_119 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSorSystemIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 500);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatedNotWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 72);
        ajc$tjp_120 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSorSystemLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 504);
        ajc$tjp_121 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSorInstanceIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 508);
        ajc$tjp_122 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSorInstanceLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 512);
        ajc$tjp_123 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSorTypeIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 516);
        ajc$tjp_124 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSorTypeLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 520);
        ajc$tjp_125 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSorValueIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 524);
        ajc$tjp_126 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSorValueLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 528);
        ajc$tjp_127 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRead", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.lang.Boolean"), 532);
        ajc$tjp_128 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTransferred", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.lang.Boolean"), 536);
        ajc$tjp_129 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentClassificationIdIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 540);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatedFromNot", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 76);
        ajc$tjp_130 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentClassificationIdNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 544);
        ajc$tjp_131 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentClassificationKeyIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 548);
        ajc$tjp_132 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentClassificationKeyNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 552);
        ajc$tjp_133 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentClassificationKeyLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 556);
        ajc$tjp_134 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentClassificationKeyNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 560);
        ajc$tjp_135 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentClassificationNameIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 564);
        ajc$tjp_136 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentClassificationNameNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 568);
        ajc$tjp_137 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentClassificationNameLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 572);
        ajc$tjp_138 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentClassificationNameNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 576);
        ajc$tjp_139 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentChannelIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 580);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatedUntilNot", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 80);
        ajc$tjp_140 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentChannelNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 584);
        ajc$tjp_141 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentChannelLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 588);
        ajc$tjp_142 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentChannelNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 592);
        ajc$tjp_143 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentReferenceIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 596);
        ajc$tjp_144 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentReferenceNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 600);
        ajc$tjp_145 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentReferenceLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 604);
        ajc$tjp_146 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentReferenceNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 608);
        ajc$tjp_147 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentReceivedWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 612);
        ajc$tjp_148 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttachmentReceivedNotWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 616);
        ajc$tjp_149 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWithoutAttachment", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.lang.Boolean"), 620);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClaimedWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 84);
        ajc$tjp_150 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCallbackStateIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Lpro.taskana.task.api.CallbackState;"), 624);
        ajc$tjp_151 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCallbackStateNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Lpro.taskana.task.api.CallbackState;"), 628);
        ajc$tjp_152 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWildcardSearchFieldIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Lpro.taskana.task.api.WildcardSearchField;"), 632);
        ajc$tjp_153 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWildcardSearchValue", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.lang.String"), 636);
        ajc$tjp_154 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTaskIdNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 640);
        ajc$tjp_155 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "apply", "pro.taskana.task.rest.TaskQueryFilterParameter", "pro.taskana.task.api.TaskQuery", "query", "", "java.lang.Void"), 2451);
        ajc$tjp_156 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateFilterParameters", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 2816);
        ajc$tjp_157 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addNullToOwnerIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 3003);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClaimedNotWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 88);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getModifiedWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 92);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getModifiedNotWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 96);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPlannedWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 100);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getExternalIdNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 32);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPlannedFrom", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 104);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPlannedUntil", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 108);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPlannedNotWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 112);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPlannedFromNot", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 116);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPlannedUntilNot", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 120);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDueWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 124);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDueFrom", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 128);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDueUntil", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 132);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDueNotWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 136);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDueFromNot", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 140);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReceivedWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 36);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDueUntilNot", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 144);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCompletedWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 148);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCompletedFrom", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 152);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCompletedUntil", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 156);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCompletedNotWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 160);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCompletedFromNot", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 164);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCompletedUntilNot", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 168);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNameIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 172);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNameNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 176);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNameLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 180);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReceivedFrom", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 40);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNameNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 184);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatorIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 188);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatorNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 192);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatorLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 196);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatorNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 200);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNoteLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 204);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNoteNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 208);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDescriptionLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 212);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDescriptionNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 216);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[I"), 220);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReceivedUntil", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 44);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[I"), 224);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.Integer;"), 228);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityFrom", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.lang.Integer"), 232);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityUntil", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.lang.Integer"), 236);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityNotWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.Integer;"), 240);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityNotFrom", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.lang.Integer"), 244);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPriorityNotUntil", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.lang.Integer"), 248);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getStateIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Lpro.taskana.task.api.TaskState;"), 252);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getStateNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Lpro.taskana.task.api.TaskState;"), 256);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationIdIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 260);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReceivedNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 48);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationIdNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 264);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationKeyIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 268);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationKeyNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 272);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationKeyLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 276);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationKeyNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 280);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationParentKeyIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 284);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationParentKeyNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 288);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationParentKeyLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 292);
        ajc$tjp_68 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationParentKeyNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 296);
        ajc$tjp_69 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationCategoryIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 300);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReceivedFromNot", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 52);
        ajc$tjp_70 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationCategoryNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 304);
        ajc$tjp_71 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationCategoryLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 308);
        ajc$tjp_72 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationCategoryNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 312);
        ajc$tjp_73 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationNameIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 316);
        ajc$tjp_74 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationNameNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 320);
        ajc$tjp_75 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationNameLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 324);
        ajc$tjp_76 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassificationNameNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 328);
        ajc$tjp_77 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketIdIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 332);
        ajc$tjp_78 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketIdNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 336);
        ajc$tjp_79 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketKeyIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 340);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReceivedUntilNot", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.time.Instant"), 56);
        ajc$tjp_80 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketKeyNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 344);
        ajc$tjp_81 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomain", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.lang.String"), 348);
        ajc$tjp_82 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBusinessProcessIdIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 352);
        ajc$tjp_83 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBusinessProcessIdNot", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 356);
        ajc$tjp_84 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBusinessProcessIdLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 360);
        ajc$tjp_85 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBusinessProcessIdNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 364);
        ajc$tjp_86 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getParentBusinessProcessIdIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 368);
        ajc$tjp_87 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getParentBusinessProcessIdNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 372);
        ajc$tjp_88 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getParentBusinessProcessIdLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 376);
        ajc$tjp_89 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getParentBusinessProcessIdNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 380);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCreatedWithin", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.time.Instant;"), 60);
        ajc$tjp_90 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOwnerIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 384);
        ajc$tjp_91 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOwnerNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 388);
        ajc$tjp_92 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOwnerLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 392);
        ajc$tjp_93 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOwnerNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 396);
        ajc$tjp_94 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOwnerNull", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "java.lang.String"), 400);
        ajc$tjp_95 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPrimaryObjectReferenceIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Lpro.taskana.task.api.models.ObjectReference;"), 404);
        ajc$tjp_96 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorCompanyIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 408);
        ajc$tjp_97 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorCompanyNotIn", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 412);
        ajc$tjp_98 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorCompanyLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 416);
        ajc$tjp_99 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPorCompanyNotLike", "pro.taskana.task.rest.TaskQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 420);
    }
}

