/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.user.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashSet;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.security.CurrentUserContext;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.util.QueryParamsValidator;
import pro.taskana.user.api.UserService;
import pro.taskana.user.api.exceptions.UserAlreadyExistException;
import pro.taskana.user.api.exceptions.UserNotFoundException;
import pro.taskana.user.api.models.User;
import pro.taskana.user.rest.assembler.UserRepresentationModelAssembler;
import pro.taskana.user.rest.models.UserCollectionRepresentationModel;
import pro.taskana.user.rest.models.UserRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class UserController {
    private final UserService userService;
    private final UserRepresentationModelAssembler userAssembler;
    private final CurrentUserContext currentUserContext;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    @Autowired
    UserController(UserService userService, UserRepresentationModelAssembler userAssembler, CurrentUserContext currentUserContext) {
        this.userService = userService;
        this.userAssembler = userAssembler;
        this.currentUserContext = currentUserContext;
    }

    @Operation(summary="Get a User", description="This endpoint retrieves a User.", parameters={@Parameter(name="userId", description="The ID of the requested user", example="teamlead-1")}, responses={@ApiResponse(responseCode="200", description="The requested User", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=UserRepresentationModel.class))})})
    @GetMapping(value={"/api/v1/users/{userId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<UserRepresentationModel> getUser(@PathVariable(value="userId") String userId) throws UserNotFoundException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        User user = this.userService.getUser(userId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.userAssembler.toModel(user))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Get multiple Users", description="This endpoint retrieves multiple Users. If a userId can't be found in the database it will be ignored. If none of the given userIds is valid, the returned list will be empty. If currentUser is set, the current User from the context will be retrieved as well.", parameters={@Parameter(name="user-id", description="The IDs of the users to be retrieved", example="teamlead-1"), @Parameter(name="current-user", description="Whether to fetch the current user as well", example="user-1-1")}, responses={@ApiResponse(responseCode="200", description="The requested Users", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=UserCollectionRepresentationModel.class))})})
    @GetMapping(value={"/api/v1/users"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<UserCollectionRepresentationModel> getUsers(HttpServletRequest request, @RequestParam(name="user-id", required=false) String[] userIds, @RequestParam(name="current-user", required=false) String currentUser) throws InvalidArgumentException, UserNotFoundException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        HttpServletRequest httpServletRequest = request;
        String[] stringArray = userIds;
        String string = currentUser;
        Object[] objectArray = new Object[]{httpServletRequest, stringArray, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HashSet<User> users = new HashSet<User>();
        if (userIds != null) {
            users.addAll(this.userService.getUsers(new HashSet<String>(List.of(userIds))));
        }
        if (currentUser != null) {
            if (QueryParamsValidator.hasQueryParameterValues(request, "current-user")) {
                throw new InvalidArgumentException("It is prohibited to use the param current-user with values.");
            }
            users.add(this.userService.getUser(this.currentUserContext.getUserid()));
        }
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)((UserCollectionRepresentationModel)((Object)this.userAssembler.toTaskanaCollectionModel(users))))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Create a User", description="This endpoint creates a new User.", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(description="the User which should be created", required=true, content={@Content(schema=@Schema(implementation=UserRepresentationModel.class), examples={@ExampleObject(value="{\n  \"userId\": \"user-10-2\",\n  \"groups\": [],\n  \"permissions\": [],\n  \"domains\": [],\n  \"firstName\": \"Hans\",\n  \"lastName\": \"Georg\"\n}")})}), responses={@ApiResponse(responseCode="201", description="The inserted User", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=UserRepresentationModel.class))})})
    @PostMapping(value={"/api/v1/users"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<UserRepresentationModel> createUser(@RequestBody UserRepresentationModel repModel) throws InvalidArgumentException, UserAlreadyExistException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        UserRepresentationModel userRepresentationModel = repModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)((Object)userRepresentationModel));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        User user = this.userAssembler.toEntityModel(repModel);
        user = this.userService.createUser(user);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.userAssembler.toModel(user)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Update a User", description="This endpoint updates a User.", parameters={@Parameter(name="userId", description="The ID of the User to update", example="teamlead-1")}, requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(description="the User with the updated fields", required=true, content={@Content(schema=@Schema(implementation=UserRepresentationModel.class), examples={@ExampleObject(value="{\n  \"userId\": \"teamlead-1\",\n  \"groups\": [],\n  \"permissions\": [],\n  \"domains\": [\"DOMAIN_A\"],\n  \"firstName\": \"new name\",\n  \"lastName\": \"Toll\",\n  \"fullName\": \"Toll, Titus\",\n  \"longName\": \"Toll, Titus - (teamlead-1)\",\n  \"email\": \"titus.toll@web.de\",\n  \"phone\": \"040-2951854\",\n  \"mobilePhone\": \"015637683197\",\n  \"orgLevel4\": \"Novatec\",\n  \"orgLevel3\": \"BPM\",\n  \"orgLevel2\": \"Human Workflow\",\n  \"orgLevel1\": \"TASKANA\",\n  \"data\": \"xy\"\n}")})}), responses={@ApiResponse(responseCode="200", description="The updated User", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=UserRepresentationModel.class))})})
    @PutMapping(value={"/api/v1/users/{userId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<UserRepresentationModel> updateUser(@PathVariable(value="userId") String userId, @RequestBody UserRepresentationModel repModel) throws InvalidArgumentException, UserNotFoundException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = userId;
        UserRepresentationModel userRepresentationModel = repModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)((Object)userRepresentationModel));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!userId.equals(repModel.getUserId())) {
            throw new InvalidArgumentException(String.format("UserId '%s' of the URI is not identical with the userId '%s' of the object in the payload.", userId, repModel.getUserId()));
        }
        User user = this.userAssembler.toEntityModel(repModel);
        user = this.userService.updateUser(user);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.userAssembler.toModel(user))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Delete a User", description="This endpoint deletes a User.", parameters={@Parameter(name="userId", description="The ID of the user to delete", example="user-1-1")}, responses={@ApiResponse(responseCode="204", description="User deleted", content={@Content(schema=@Schema)})})
    @DeleteMapping(value={"/api/v1/users/{userId}"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<UserRepresentationModel> deleteUser(@PathVariable(value="userId") String userId) throws UserNotFoundException, NotAuthorizedException, InvalidArgumentException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.userService.deleteUser(userId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.noContent().build());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    static {
        UserController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserController.java", UserController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUser", "pro.taskana.user.rest.UserController", "java.lang.String", "userId", "pro.taskana.user.api.exceptions.UserNotFoundException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 89);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUsers", "pro.taskana.user.rest.UserController", "jakarta.servlet.http.HttpServletRequest:[Ljava.lang.String;:java.lang.String", "request:userIds:currentUser", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.user.api.exceptions.UserNotFoundException", "org.springframework.http.ResponseEntity"), 136);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createUser", "pro.taskana.user.rest.UserController", "pro.taskana.user.rest.models.UserRepresentationModel", "repModel", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.user.api.exceptions.UserAlreadyExistException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 200);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateUser", "pro.taskana.user.rest.UserController", "java.lang.String:pro.taskana.user.rest.models.UserRepresentationModel", "userId:repModel", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.user.api.exceptions.UserNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 269);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteUser", "pro.taskana.user.rest.UserController", "java.lang.String", "userId", "pro.taskana.user.api.exceptions.UserNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.InvalidArgumentException", "org.springframework.http.ResponseEntity"), 312);
    }
}

