/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QueryParameter;
import pro.taskana.workbasket.api.WorkbasketAccessItemQuery;

public class WorkbasketAccessItemQueryFilterParameter
implements QueryParameter<WorkbasketAccessItemQuery, Void> {
    @Schema(name="workbasket-key", description="Filter by the key of the Workbasket. This is an exact match.")
    @JsonProperty(value="workbasket-key")
    private final String[] workbasketKey;
    @Schema(name="workbasket-key-like", description="Filter by the key of the Workbasket. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="workbasket-key-like")
    private final String[] workbasketKeyLike;
    @Schema(name="access-id", description="Filter by the name of the access id. This is an exact match.")
    @JsonProperty(value="access-id")
    private final String[] accessId;
    @Schema(name="access-id-like", description="Filter by the name of the access id. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="access-id-like")
    private final String[] accessIdLike;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public String[] getWorkbasketKey() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.workbasketKey);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getWorkbasketKeyLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.workbasketKeyLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAccessId() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.accessId);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getAccessIdLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.accessIdLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    @ConstructorProperties(value={"workbasket-key", "workbasket-key-like", "access-id", "access-id-like"})
    public WorkbasketAccessItemQueryFilterParameter(String[] workbasketKey, String[] workbasketKeyLike, String[] accessId, String[] accessIdLike) {
        this.workbasketKey = workbasketKey;
        this.workbasketKeyLike = workbasketKeyLike;
        this.accessId = accessId;
        this.accessIdLike = accessIdLike;
    }

    @Override
    public Void apply(WorkbasketAccessItemQuery query) {
        Void void_;
        WorkbasketAccessItemQuery workbasketAccessItemQuery = query;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)workbasketAccessItemQuery);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Optional.ofNullable(this.workbasketKey).ifPresent(stringArray -> {
            WorkbasketAccessItemQuery workbasketAccessItemQuery2 = query.workbasketKeyIn(stringArray);
        });
        Optional.ofNullable(this.workbasketKeyLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            WorkbasketAccessItemQuery workbasketAccessItemQuery2 = query.workbasketKeyLike(stringArray);
        });
        Optional.ofNullable(this.accessId).ifPresent(stringArray -> {
            WorkbasketAccessItemQuery workbasketAccessItemQuery2 = query.accessIdIn(stringArray);
        });
        Optional.ofNullable(this.accessIdLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            WorkbasketAccessItemQuery workbasketAccessItemQuery2 = query.accessIdLike(stringArray);
        });
        Void void_2 = null;
        Void void_3 = void_ = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, void_);
        return void_2;
    }

    static {
        WorkbasketAccessItemQueryFilterParameter.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkbasketAccessItemQueryFilterParameter.java", WorkbasketAccessItemQueryFilterParameter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketKey", "pro.taskana.workbasket.rest.WorkbasketAccessItemQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 12);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketKeyLike", "pro.taskana.workbasket.rest.WorkbasketAccessItemQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 16);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAccessId", "pro.taskana.workbasket.rest.WorkbasketAccessItemQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 20);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAccessIdLike", "pro.taskana.workbasket.rest.WorkbasketAccessItemQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 24);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "apply", "pro.taskana.workbasket.rest.WorkbasketAccessItemQueryFilterParameter", "pro.taskana.workbasket.api.WorkbasketAccessItemQuery", "query", "", "java.lang.Void"), 71);
    }
}

