/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.BiConsumer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QueryPagingParameter;
import pro.taskana.common.rest.QuerySortBy;
import pro.taskana.common.rest.QuerySortParameter;
import pro.taskana.common.rest.util.QueryParamsValidator;
import pro.taskana.workbasket.api.WorkbasketCustomField;
import pro.taskana.workbasket.api.WorkbasketQuery;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.workbasket.api.exceptions.WorkbasketInUseException;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;
import pro.taskana.workbasket.api.models.Workbasket;
import pro.taskana.workbasket.api.models.WorkbasketAccessItem;
import pro.taskana.workbasket.api.models.WorkbasketSummary;
import pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter;
import pro.taskana.workbasket.rest.assembler.WorkbasketAccessItemRepresentationModelAssembler;
import pro.taskana.workbasket.rest.assembler.WorkbasketRepresentationModelAssembler;
import pro.taskana.workbasket.rest.assembler.WorkbasketSummaryRepresentationModelAssembler;
import pro.taskana.workbasket.rest.models.DistributionTargetsCollectionRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketAccessItemCollectionRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketRepresentationModel;
import pro.taskana.workbasket.rest.models.WorkbasketSummaryPagedRepresentationModel;

@RestController
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL})
public class WorkbasketController {
    private static final Logger LOGGER;
    private final WorkbasketService workbasketService;
    private final WorkbasketRepresentationModelAssembler workbasketRepresentationModelAssembler;
    private final WorkbasketSummaryRepresentationModelAssembler workbasketSummaryRepresentationModelAssembler;
    private final WorkbasketAccessItemRepresentationModelAssembler workbasketAccessItemRepresentationModelAssembler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        WorkbasketController.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(WorkbasketController.class);
    }

    @Autowired
    WorkbasketController(WorkbasketService workbasketService, WorkbasketRepresentationModelAssembler workbasketRepresentationModelAssembler, WorkbasketSummaryRepresentationModelAssembler workbasketSummaryRepresentationModelAssembler, WorkbasketAccessItemRepresentationModelAssembler workbasketAccessItemRepresentationModelAssembler) {
        this.workbasketService = workbasketService;
        this.workbasketRepresentationModelAssembler = workbasketRepresentationModelAssembler;
        this.workbasketSummaryRepresentationModelAssembler = workbasketSummaryRepresentationModelAssembler;
        this.workbasketAccessItemRepresentationModelAssembler = workbasketAccessItemRepresentationModelAssembler;
    }

    @Operation(summary="Get a list of all Workbaskets", description="This endpoint retrieves a list of existing Workbaskets. Filters can be applied.", parameters={@Parameter(name="type", example="PERSONAL")}, responses={@ApiResponse(responseCode="200", description="Found all Workbaskets", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=WorkbasketSummaryPagedRepresentationModel.class))})})
    @GetMapping(path={"/api/v1/workbaskets"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketSummaryPagedRepresentationModel> getWorkbaskets(HttpServletRequest request, @ParameterObject WorkbasketQueryFilterParameter filterParameter, @ParameterObject WorkbasketQuerySortParameter sortParameter, @ParameterObject QueryPagingParameter<WorkbasketSummary, WorkbasketQuery> pagingParameter) {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        HttpServletRequest httpServletRequest = request;
        WorkbasketQueryFilterParameter workbasketQueryFilterParameter = filterParameter;
        WorkbasketQuerySortParameter workbasketQuerySortParameter = sortParameter;
        QueryPagingParameter<WorkbasketSummary, WorkbasketQuery> queryPagingParameter = pagingParameter;
        Object[] objectArray = new Object[]{httpServletRequest, workbasketQueryFilterParameter, workbasketQuerySortParameter, queryPagingParameter};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        QueryParamsValidator.validateParams(request, WorkbasketQueryFilterParameter.class, QuerySortParameter.class, QueryPagingParameter.class);
        WorkbasketQuery query = this.workbasketService.createWorkbasketQuery();
        filterParameter.apply(query);
        sortParameter.apply(query);
        List<WorkbasketSummary> workbasketSummaries = pagingParameter.apply(query);
        WorkbasketSummaryPagedRepresentationModel pagedModels = (WorkbasketSummaryPagedRepresentationModel)((Object)this.workbasketSummaryRepresentationModelAssembler.toPagedModel(workbasketSummaries, pagingParameter.getPageMetadata()));
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)pagedModels)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Get a single Workbasket", description="This endpoint retrieves a single Workbasket.", parameters={@Parameter(name="workbasketId", description="the Id of the requested Workbasket", required=true, example="WBI:100000000000000000000000000000000001")}, responses={@ApiResponse(responseCode="200", description="the requested Workbasket", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=WorkbasketRepresentationModel.class))})})
    @GetMapping(path={"/api/v1/workbaskets/{workbasketId}"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketRepresentationModel> getWorkbasket(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Workbasket workbasket = this.workbasketService.getWorkbasket(workbasketId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.workbasketRepresentationModelAssembler.toModel(workbasket))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Delete a Workbasket", description="This endpoint deletes an existing Workbasket", parameters={@Parameter(name="workbasketId", description="the Id of the requested Workbasket", required=true, example="WBI:100000000000000000000000000000000002")}, responses={@ApiResponse(responseCode="204", description="<b>204 NO_CONTENT</b> - Workbasket has been deleted successfully", content={@Content(schema=@Schema)}), @ApiResponse(responseCode="202", description="<b>202 ACCEPTED</b> - Workbasket still contains completed Tasks. It has been marked for deletion and will be deleted automatically as soon as all completed Tasks are deleted.", content={@Content(schema=@Schema)}), @ApiResponse(responseCode="423", description="<b>423 LOCKED</b> - Workbasket contains non-completed Tasks and cannot be deleted.", content={@Content(schema=@Schema)})})
    @DeleteMapping(path={"/api/v1/workbaskets/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={WorkbasketNotFoundException.class})
    public ResponseEntity<WorkbasketRepresentationModel> deleteWorkbasket(@PathVariable(value="workbasketId") String workbasketId) throws InvalidArgumentException, WorkbasketNotFoundException, WorkbasketInUseException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        ResponseEntity responseEntity3;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean workbasketDeleted = this.workbasketService.deleteWorkbasket(workbasketId);
        if (workbasketDeleted) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Workbasket successfully deleted.");
            }
            responseEntity2 = responseEntity3 = ResponseEntity.noContent().build();
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Workbasket was only marked for deletion and will be physically deleted later on.");
            }
            responseEntity2 = responseEntity3 = ResponseEntity.accepted().build();
        }
        ResponseEntity responseEntity4 = responseEntity = responseEntity2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity);
        return responseEntity3;
    }

    @Operation(summary="Create a new Workbasket", description="This endpoint creates a persistent Workbasket.", requestBody=@RequestBody(description="the Workbasket which should be created.", content={@Content(schema=@Schema(implementation=WorkbasketRepresentationModel.class), examples={@ExampleObject(value="{\n  \"key\" : \"asdasdasd\",\n  \"name\" : \"this is a wonderful workbasket name\",\n  \"domain\" : \"DOMAIN_A\",\n  \"type\" : \"GROUP\",\n  \"markedForDeletion\" : false\n}")})}), responses={@ApiResponse(responseCode="201", description="the created Workbasket", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=WorkbasketRepresentationModel.class))})})
    @PostMapping(path={"/api/v1/workbaskets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketRepresentationModel> createWorkbasket(@org.springframework.web.bind.annotation.RequestBody WorkbasketRepresentationModel workbasketRepresentationModel) throws InvalidArgumentException, NotAuthorizedException, WorkbasketAlreadyExistException, DomainNotFoundException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        WorkbasketRepresentationModel workbasketRepresentationModel2 = workbasketRepresentationModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)((Object)workbasketRepresentationModel2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Workbasket workbasket = this.workbasketRepresentationModelAssembler.toEntityModel(workbasketRepresentationModel);
        workbasket = this.workbasketService.createWorkbasket(workbasket);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.workbasketRepresentationModelAssembler.toModel(workbasket)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Update a Workbasket", description="This endpoint creates a persistent Workbasket.", parameters={@Parameter(name="workbasketId", description="the Id of the requested Workbasket", required=true, example="WBI:100000000000000000000000000000000001")}, requestBody=@RequestBody(description="the new Workbasket for the requested id", content={@Content(schema=@Schema(implementation=WorkbasketRepresentationModel.class), examples={@ExampleObject(value="{\n  \"workbasketId\" : \"WBI:100000000000000000000000000000000001\",\n  \"key\" : \"GPK_KSC\",\n  \"name\" : \"new name\",\n  \"domain\" : \"DOMAIN_A\",\n  \"type\" : \"GROUP\",\n  \"description\" : \"Gruppenpostkorb KSC\",\n  \"owner\" : \"teamlead-1\",\n  \"custom1\" : \"ABCQVW\",\n  \"custom2\" : \"\",\n  \"custom3\" : \"xyz4\",\n  \"custom4\" : \"\",\n  \"custom5\" : \"\",\n  \"custom6\" : \"\",\n  \"custom7\" : \"\",\n  \"custom8\" : \"\",\n  \"orgLevel1\" : \"\",\n  \"orgLevel2\" : \"\",\n  \"orgLevel3\" : \"\",\n  \"orgLevel4\" : \"\",\n  \"markedForDeletion\" : false,\n  \"created\" : \"2018-02-01T12:00:00.000Z\",\n  \"modified\" : \"2018-02-01T12:00:00.000Z\"\n}")})}), responses={@ApiResponse(responseCode="200", description="the requested Workbasket", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=WorkbasketRepresentationModel.class))})})
    @PutMapping(path={"/api/v1/workbaskets/{workbasketId}"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketRepresentationModel> updateWorkbasket(@PathVariable(value="workbasketId") String workbasketId, @org.springframework.web.bind.annotation.RequestBody WorkbasketRepresentationModel workbasketRepresentationModel) throws WorkbasketNotFoundException, NotAuthorizedException, ConcurrencyException, InvalidArgumentException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = workbasketId;
        WorkbasketRepresentationModel workbasketRepresentationModel2 = workbasketRepresentationModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)((Object)workbasketRepresentationModel2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (!workbasketId.equals(workbasketRepresentationModel.getWorkbasketId())) {
            throw new InvalidArgumentException("Target-WB-ID('" + workbasketId + "') is not identical with the WB-ID of to object which should be updated. ID=('" + workbasketRepresentationModel.getWorkbasketId() + "')");
        }
        Workbasket workbasket = this.workbasketRepresentationModelAssembler.toEntityModel(workbasketRepresentationModel);
        workbasket = this.workbasketService.updateWorkbasket(workbasket);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.workbasketRepresentationModelAssembler.toModel(workbasket))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Get all Workbasket Access Items", description="This endpoint retrieves all Workbasket Access Items for a given Workbasket.", parameters={@Parameter(name="workbasketId", description="the Id of the requested Workbasket", required=true, example="WBI:100000000000000000000000000000000001")}, responses={@ApiResponse(responseCode="200", description="the access items for the requested Workbasket.", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=WorkbasketAccessItemCollectionRepresentationModel.class))})})
    @GetMapping(path={"/api/v1/workbaskets/{workbasketId}/workbasketAccessItems"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketAccessItemCollectionRepresentationModel> getWorkbasketAccessItems(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List accessItems = this.workbasketService.getWorkbasketAccessItems(workbasketId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.workbasketAccessItemRepresentationModelAssembler.toTaskanaCollectionModelForSingleWorkbasket(workbasketId, accessItems))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Set all Workbasket Access Items", description="This endpoint replaces all Workbasket Access Items for a given Workbasket with the provided", parameters={@Parameter(name="workbasketId", description="the Id of the Workbasket whose Workbasket Access Items will be replaced", required=true, example="WBI:100000000000000000000000000000000001")}, requestBody=@RequestBody(description="the new Workbasket Access Items.", content={@Content(schema=@Schema(implementation=WorkbasketAccessItemCollectionRepresentationModel.class), examples={@ExampleObject(value="{\n  \"accessItems\" : [ {\n    \"workbasketId\" : \"WBI:100000000000000000000000000000000001\",\n    \"accessId\" : \"new-access-id\",\n    \"accessName\" : \"new-access-name\",\n    \"permRead\" : false,\n    \"permReadTasks\" : false,\n    \"permOpen\" : true,\n    \"permAppend\" : false,\n    \"permEditTasks\" : false,\n    \"permTransfer\" : false,\n    \"permDistribute\" : false,\n    \"permCustom1\" : false,\n    \"permCustom2\" : false,\n    \"permCustom3\" : false,\n    \"permCustom4\" : false,\n    \"permCustom5\" : false,\n    \"permCustom6\" : false,\n    \"permCustom7\" : false,\n    \"permCustom8\" : false,\n    \"permCustom9\" : false,\n    \"permCustom10\" : false,\n    \"permCustom11\" : false,\n    \"permCustom12\" : false\n  } ]\n}")})}), responses={@ApiResponse(responseCode="200", description="the new Workbasket Access Items for the requested Workbasket", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=WorkbasketAccessItemCollectionRepresentationModel.class))})})
    @PutMapping(path={"/api/v1/workbaskets/{workbasketId}/workbasketAccessItems"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<WorkbasketAccessItemCollectionRepresentationModel> setWorkbasketAccessItems(@PathVariable(value="workbasketId") String workbasketId, @org.springframework.web.bind.annotation.RequestBody WorkbasketAccessItemCollectionRepresentationModel workbasketAccessItemRepModels) throws InvalidArgumentException, WorkbasketNotFoundException, WorkbasketAccessItemAlreadyExistException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = workbasketId;
        WorkbasketAccessItemCollectionRepresentationModel workbasketAccessItemCollectionRepresentationModel = workbasketAccessItemRepModels;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string, (Object)((Object)workbasketAccessItemCollectionRepresentationModel));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (workbasketAccessItemRepModels == null) {
            throw new InvalidArgumentException("Can't create something with NULL body-value.");
        }
        List<WorkbasketAccessItem> wbAccessItems = workbasketAccessItemRepModels.getContent().stream().map(this.workbasketAccessItemRepresentationModelAssembler::toEntityModel).toList();
        this.workbasketService.setWorkbasketAccessItems(workbasketId, wbAccessItems);
        List updatedWbAccessItems = this.workbasketService.getWorkbasketAccessItems(workbasketId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)this.workbasketAccessItemRepresentationModelAssembler.toTaskanaCollectionModelForSingleWorkbasket(workbasketId, updatedWbAccessItems))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Get all Distribution Targets for a Workbasket", description="This endpoint retrieves all Distribution Targets for a requested Workbasket.", parameters={@Parameter(name="workbasketId", description="the Id of the Workbasket whose Distribution Targets will be retrieved", required=true, example="WBI:100000000000000000000000000000000002")}, responses={@ApiResponse(responseCode="200", description="the Distribution Targets for the requested Workbasket", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=DistributionTargetsCollectionRepresentationModel.class))})})
    @GetMapping(path={"/api/v1/workbaskets/{workbasketId}/distribution-targets"}, produces={"application/hal+json"})
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ResponseEntity<DistributionTargetsCollectionRepresentationModel> getDistributionTargets(@PathVariable(value="workbasketId") String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = workbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List distributionTargets = this.workbasketService.getDistributionTargets(workbasketId);
        DistributionTargetsCollectionRepresentationModel distributionTargetRepModels = (DistributionTargetsCollectionRepresentationModel)this.workbasketSummaryRepresentationModelAssembler.toTaskanaCollectionModel(distributionTargets);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)distributionTargetRepModels)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Set all Distribution Targets for a Workbasket", description="This endpoint replaces all Distribution Targets for a given Workbasket with the provided ones.", parameters={@Parameter(name="workbasketId", description="the source Workbasket", required=true, example="WBI:100000000000000000000000000000000001")}, requestBody=@RequestBody(description="the destination Workbaskets.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class)), examples={@ExampleObject(value="[ \"WBI:100000000000000000000000000000000002\", \"WBI:100000000000000000000000000000000003\" ]")})}), responses={@ApiResponse(responseCode="200", description="the new Distribution Targets for the requested Workbasket.", content={@Content(mediaType="application/hal+json", schema=@Schema(implementation=DistributionTargetsCollectionRepresentationModel.class))})})
    @PutMapping(path={"/api/v1/workbaskets/{workbasketId}/distribution-targets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<DistributionTargetsCollectionRepresentationModel> setDistributionTargetsForWorkbasketId(@PathVariable(value="workbasketId") String sourceWorkbasketId, @org.springframework.web.bind.annotation.RequestBody List<String> targetWorkbasketIds) throws WorkbasketNotFoundException, NotAuthorizedException, NotAuthorizedOnWorkbasketException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = sourceWorkbasketId;
        List<String> list = targetWorkbasketIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.workbasketService.setDistributionTargets(sourceWorkbasketId, targetWorkbasketIds);
        List distributionTargets = this.workbasketService.getDistributionTargets(sourceWorkbasketId);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)((DistributionTargetsCollectionRepresentationModel)this.workbasketSummaryRepresentationModelAssembler.toTaskanaCollectionModel(distributionTargets)))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @Operation(summary="Remove a Workbasket as Distribution Target", description="This endpoint removes all Distribution Target references for a provided Workbasket.", parameters={@Parameter(name="workbasketId", description="the Id of the requested Workbasket.", required=true, example="WBI:100000000000000000000000000000000007")})
    @DeleteMapping(path={"/api/v1/workbaskets/{workbasketId}/distribution-targets"})
    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<Void> removeDistributionTargetForWorkbasketId(@PathVariable(value="workbasketId") String targetWorkbasketId) throws WorkbasketNotFoundException, NotAuthorizedOnWorkbasketException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        String string = targetWorkbasketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List sourceWorkbaskets = this.workbasketService.getDistributionSources(targetWorkbasketId);
        for (WorkbasketSummary source : sourceWorkbaskets) {
            this.workbasketService.removeDistributionTarget(source.getId(), targetWorkbasketId);
        }
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.noContent().build());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkbasketController.java", WorkbasketController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbaskets", "pro.taskana.workbasket.rest.WorkbasketController", "jakarta.servlet.http.HttpServletRequest:pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter:pro.taskana.workbasket.rest.WorkbasketController$WorkbasketQuerySortParameter:pro.taskana.common.rest.QueryPagingParameter", "request:filterParameter:sortParameter:pagingParameter", "", "org.springframework.http.ResponseEntity"), 118);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasket", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String", "workbasketId", "pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 174);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteWorkbasket", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String", "workbasketId", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketInUseException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 235);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createWorkbasket", "pro.taskana.workbasket.rest.WorkbasketController", "pro.taskana.workbasket.rest.models.WorkbasketRepresentationModel", "workbasketRepresentationModel", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.WorkbasketAlreadyExistException:pro.taskana.common.api.exceptions.DomainNotFoundException", "org.springframework.http.ResponseEntity"), 302);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateWorkbasket", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String:pro.taskana.workbasket.rest.models.WorkbasketRepresentationModel", "workbasketId:workbasketRepresentationModel", "pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.common.api.exceptions.ConcurrencyException:pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 387);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkbasketAccessItems", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String", "workbasketId", "pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 447);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setWorkbasketAccessItems", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String:pro.taskana.workbasket.rest.models.WorkbasketAccessItemCollectionRepresentationModel", "workbasketId:workbasketAccessItemRepModels", "pro.taskana.common.api.exceptions.InvalidArgumentException:pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.WorkbasketAccessItemAlreadyExistException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 541);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDistributionTargets", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String", "workbasketId", "pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 602);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDistributionTargetsForWorkbasketId", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String:java.util.List", "sourceWorkbasketId:targetWorkbasketIds", "pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.common.api.exceptions.NotAuthorizedException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException", "org.springframework.http.ResponseEntity"), 663);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeDistributionTargetForWorkbasketId", "pro.taskana.workbasket.rest.WorkbasketController", "java.lang.String", "targetWorkbasketId", "pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException:pro.taskana.workbasket.api.exceptions.NotAuthorizedOnWorkbasketException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 702);
    }

    public static final class WorkbasketQuerySortBy
    extends Enum<WorkbasketQuerySortBy>
    implements QuerySortBy<WorkbasketQuery> {
        public static final /* enum */ WorkbasketQuerySortBy NAME;
        public static final /* enum */ WorkbasketQuerySortBy KEY;
        public static final /* enum */ WorkbasketQuerySortBy OWNER;
        public static final /* enum */ WorkbasketQuerySortBy TYPE;
        public static final /* enum */ WorkbasketQuerySortBy DESCRIPTION;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_1;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_2;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_3;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_4;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_5;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_6;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_7;
        public static final /* enum */ WorkbasketQuerySortBy CUSTOM_8;
        public static final /* enum */ WorkbasketQuerySortBy DOMAIN;
        public static final /* enum */ WorkbasketQuerySortBy ORG_LEVEL_1;
        public static final /* enum */ WorkbasketQuerySortBy ORG_LEVEL_2;
        public static final /* enum */ WorkbasketQuerySortBy ORG_LEVEL_3;
        public static final /* enum */ WorkbasketQuerySortBy ORG_LEVEL_4;
        private final BiConsumer<WorkbasketQuery, BaseQuery.SortDirection> consumer;
        private static final /* synthetic */ WorkbasketQuerySortBy[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        static {
            WorkbasketQuerySortBy.ajc$preClinit();
            NAME = new WorkbasketQuerySortBy(WorkbasketQuery::orderByName);
            KEY = new WorkbasketQuerySortBy(WorkbasketQuery::orderByKey);
            OWNER = new WorkbasketQuerySortBy(WorkbasketQuery::orderByOwner);
            TYPE = new WorkbasketQuerySortBy(WorkbasketQuery::orderByType);
            DESCRIPTION = new WorkbasketQuerySortBy(WorkbasketQuery::orderByDescription);
            CUSTOM_1 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_1, sort);
            });
            CUSTOM_2 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_2, sort);
            });
            CUSTOM_3 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_3, sort);
            });
            CUSTOM_4 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_4, sort);
            });
            CUSTOM_5 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_5, sort);
            });
            CUSTOM_6 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_6, sort);
            });
            CUSTOM_7 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_7, sort);
            });
            CUSTOM_8 = new WorkbasketQuerySortBy((query, sort) -> {
                WorkbasketQuery workbasketQuery = query.orderByCustomAttribute(WorkbasketCustomField.CUSTOM_8, sort);
            });
            DOMAIN = new WorkbasketQuerySortBy(WorkbasketQuery::orderByDomain);
            ORG_LEVEL_1 = new WorkbasketQuerySortBy(WorkbasketQuery::orderByOrgLevel1);
            ORG_LEVEL_2 = new WorkbasketQuerySortBy(WorkbasketQuery::orderByOrgLevel2);
            ORG_LEVEL_3 = new WorkbasketQuerySortBy(WorkbasketQuery::orderByOrgLevel3);
            ORG_LEVEL_4 = new WorkbasketQuerySortBy(WorkbasketQuery::orderByOrgLevel4);
            ENUM$VALUES = new WorkbasketQuerySortBy[]{NAME, KEY, OWNER, TYPE, DESCRIPTION, CUSTOM_1, CUSTOM_2, CUSTOM_3, CUSTOM_4, CUSTOM_5, CUSTOM_6, CUSTOM_7, CUSTOM_8, DOMAIN, ORG_LEVEL_1, ORG_LEVEL_2, ORG_LEVEL_3, ORG_LEVEL_4};
        }

        private WorkbasketQuerySortBy(BiConsumer<WorkbasketQuery, BaseQuery.SortDirection> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void applySortByForQuery(WorkbasketQuery query, BaseQuery.SortDirection sortDirection) {
            WorkbasketQuery workbasketQuery = query;
            BaseQuery.SortDirection sortDirection2 = sortDirection;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)workbasketQuery, (Object)sortDirection2);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            this.consumer.accept(query, sortDirection);
            Object var6_6 = null;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
        }

        public static WorkbasketQuerySortBy[] values() {
            WorkbasketQuerySortBy[] workbasketQuerySortByArray;
            WorkbasketQuerySortBy[] workbasketQuerySortByArray2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            WorkbasketQuerySortBy[] workbasketQuerySortByArray3 = ENUM$VALUES;
            int n = workbasketQuerySortByArray3.length;
            WorkbasketQuerySortBy[] workbasketQuerySortByArray4 = new WorkbasketQuerySortBy[n];
            System.arraycopy(ENUM$VALUES, 0, workbasketQuerySortByArray4, 0, n);
            WorkbasketQuerySortBy[] workbasketQuerySortByArray5 = workbasketQuerySortByArray2 = (workbasketQuerySortByArray = workbasketQuerySortByArray4);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketQuerySortByArray2);
            return workbasketQuerySortByArray;
        }

        public static WorkbasketQuerySortBy valueOf(String arg0) {
            WorkbasketQuerySortBy workbasketQuerySortBy;
            WorkbasketQuerySortBy workbasketQuerySortBy2;
            String string = arg0;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            WorkbasketQuerySortBy workbasketQuerySortBy3 = workbasketQuerySortBy2 = (workbasketQuerySortBy = Enum.valueOf(WorkbasketQuerySortBy.class, arg0));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketQuerySortBy2);
            return workbasketQuerySortBy;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("WorkbasketController.java", WorkbasketQuerySortBy.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "applySortByForQuery", "pro.taskana.workbasket.rest.WorkbasketController$WorkbasketQuerySortBy", "pro.taskana.workbasket.api.WorkbasketQuery:pro.taskana.common.api.BaseQuery$SortDirection", "query:sortDirection", "", "void"), 743);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "pro.taskana.workbasket.rest.WorkbasketController$WorkbasketQuerySortBy", "", "", "", "[Lpro.taskana.workbasket.rest.WorkbasketController$WorkbasketQuerySortBy;"), 1);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "pro.taskana.workbasket.rest.WorkbasketController$WorkbasketQuerySortBy", "java.lang.String", "arg0", "", "pro.taskana.workbasket.rest.WorkbasketController$WorkbasketQuerySortBy"), 1);
        }
    }

    public static class WorkbasketQuerySortParameter
    extends QuerySortParameter<WorkbasketQuery, WorkbasketQuerySortBy> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        @ConstructorProperties(value={"sort-by", "order"})
        public WorkbasketQuerySortParameter(List<WorkbasketQuerySortBy> sortBy, List<BaseQuery.SortDirection> order) throws InvalidArgumentException {
            super(sortBy, order);
        }

        @Override
        public List<WorkbasketQuerySortBy> getSortBy() {
            List<WorkbasketQuerySortBy> list;
            List<WorkbasketQuerySortBy> list2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            List<WorkbasketQuerySortBy> list3 = list2 = (list = super.getSortBy());
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
            return list;
        }

        static {
            WorkbasketQuerySortParameter.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("WorkbasketController.java", WorkbasketQuerySortParameter.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSortBy", "pro.taskana.workbasket.rest.WorkbasketController$WorkbasketQuerySortParameter", "", "", "", "java.util.List"), 762);
        }
    }
}

