/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.workbasket.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.rest.QueryParameter;
import pro.taskana.workbasket.api.WorkbasketPermission;
import pro.taskana.workbasket.api.WorkbasketQuery;
import pro.taskana.workbasket.api.WorkbasketType;

public class WorkbasketQueryFilterParameter
implements QueryParameter<WorkbasketQuery, Void> {
    @Schema(name="name", description="Filter by the name of the Workbasket. This is an exact match.")
    @JsonProperty(value="name")
    private final String[] name;
    @Schema(name="name-like", description="Filter by the name of the Workbasket. This results in a substring search. (% is appended to beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="name-like")
    private final String[] nameLike;
    @Schema(name="key", description="Filter by the key of the Workbasket. This is an exact match.")
    @JsonProperty(value="key")
    private final String[] key;
    @Schema(name="key-like", description="Filter by the key of the Workbasket. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="key-like")
    private final String[] keyLike;
    @Schema(name="owner", description="Filter by the owner of the Workbasket. This is an exact match.")
    @JsonProperty(value="owner")
    private final String[] owner;
    @Schema(name="owner-like", description="Filter by the owner of the Workbasket. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="owner-like")
    private final String[] ownerLike;
    @Schema(name="description-like", description="Filter by the description of the Workbasket. This results in a substring search.. (% is appended to the beginning and end of the requested value). Further SQL \"LIKE\" wildcard characters will be resolved correctly.")
    @JsonProperty(value="description-like")
    private final String[] descriptionLike;
    @Schema(name="domain", description="Filter by the domain of the Workbasket. This is an exact match.")
    @JsonProperty(value="domain")
    private final String[] domain;
    @Schema(name="type", description="Filter by the type of the Workbasket. This is an exact match.")
    @JsonProperty(value="type")
    private final WorkbasketType[] type;
    @Schema(name="required-permission", description="Filter by the required permission for the Workbasket.")
    @JsonProperty(value="required-permission")
    private final WorkbasketPermission[] requiredPermissions;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    public String[] getName() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.name);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getNameLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.nameLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getKey() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.key);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getKeyLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.keyLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getOwner() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.owner);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getOwnerLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.ownerLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getDescriptionLike() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.descriptionLike);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public String[] getDomain() {
        String[] stringArray;
        String[] stringArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String[] stringArray3 = stringArray2 = (stringArray = this.domain);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringArray2);
        return stringArray;
    }

    public WorkbasketType[] getType() {
        WorkbasketType[] workbasketTypeArray;
        WorkbasketType[] workbasketTypeArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketType[] workbasketTypeArray3 = workbasketTypeArray2 = (workbasketTypeArray = this.type);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketTypeArray2);
        return workbasketTypeArray;
    }

    public WorkbasketPermission[] getRequiredPermissions() {
        WorkbasketPermission[] workbasketPermissionArray;
        WorkbasketPermission[] workbasketPermissionArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketPermission[] workbasketPermissionArray3 = workbasketPermissionArray2 = (workbasketPermissionArray = this.requiredPermissions);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)workbasketPermissionArray2);
        return workbasketPermissionArray;
    }

    @ConstructorProperties(value={"name", "name-like", "key", "key-like", "owner", "owner-like", "description-like", "domain", "type", "required-permission"})
    public WorkbasketQueryFilterParameter(String[] name, String[] nameLike, String[] key, String[] keyLike, String[] owner, String[] ownerLike, String[] descriptionLike, String[] domain, WorkbasketType[] type, WorkbasketPermission[] requiredPermissions) {
        this.name = name;
        this.nameLike = nameLike;
        this.key = key;
        this.keyLike = keyLike;
        this.owner = owner;
        this.ownerLike = ownerLike;
        this.descriptionLike = descriptionLike;
        this.domain = domain;
        this.type = type;
        this.requiredPermissions = requiredPermissions;
    }

    @Override
    public Void apply(WorkbasketQuery query) {
        Void void_;
        WorkbasketQuery workbasketQuery = query;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)workbasketQuery);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Optional.ofNullable(this.name).ifPresent(stringArray -> {
            WorkbasketQuery workbasketQuery2 = query.nameIn(stringArray);
        });
        Optional.ofNullable(this.nameLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            WorkbasketQuery workbasketQuery2 = query.nameLike(stringArray);
        });
        Optional.ofNullable(this.key).ifPresent(stringArray -> {
            WorkbasketQuery workbasketQuery2 = query.keyIn(stringArray);
        });
        Optional.ofNullable(this.keyLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            WorkbasketQuery workbasketQuery2 = query.keyLike(stringArray);
        });
        Optional.ofNullable(this.owner).ifPresent(stringArray -> {
            WorkbasketQuery workbasketQuery2 = query.ownerIn(stringArray);
        });
        Optional.ofNullable(this.ownerLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            WorkbasketQuery workbasketQuery2 = query.ownerLike(stringArray);
        });
        Optional.ofNullable(this.descriptionLike).map(this::wrapElementsInLikeStatement).ifPresent(stringArray -> {
            WorkbasketQuery workbasketQuery2 = query.descriptionLike(stringArray);
        });
        Optional.ofNullable(this.domain).ifPresent(stringArray -> {
            WorkbasketQuery workbasketQuery2 = query.domainIn(stringArray);
        });
        Optional.ofNullable(this.type).ifPresent(workbasketTypeArray -> {
            WorkbasketQuery workbasketQuery2 = query.typeIn(workbasketTypeArray);
        });
        Optional.ofNullable(this.requiredPermissions).ifPresent(workbasketPermissionArray -> {
            WorkbasketQuery workbasketQuery2 = query.callerHasPermissions(workbasketPermissionArray);
        });
        Void void_2 = null;
        Void void_3 = void_ = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, void_);
        return void_2;
    }

    static {
        WorkbasketQueryFilterParameter.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkbasketQueryFilterParameter.java", WorkbasketQueryFilterParameter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getName", "pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 86);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNameLike", "pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 90);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "apply", "pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter", "pro.taskana.workbasket.api.WorkbasketQuery", "query", "", "java.lang.Void"), 163);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getKey", "pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 94);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getKeyLike", "pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 98);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOwner", "pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 102);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOwnerLike", "pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 106);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDescriptionLike", "pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 110);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomain", "pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter", "", "", "", "[Ljava.lang.String;"), 114);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter", "", "", "", "[Lpro.taskana.workbasket.api.WorkbasketType;"), 118);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRequiredPermissions", "pro.taskana.workbasket.rest.WorkbasketQueryFilterParameter", "", "", "", "[Lpro.taskana.workbasket.api.WorkbasketPermission;"), 122);
    }
}

