/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.routing.dmn.service;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.camunda.bpm.dmn.xlsx.AdvancedSpreadsheetAdapter;
import org.camunda.bpm.dmn.xlsx.XlsxConverter;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetAdapter;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.OutputEntry;
import org.camunda.bpm.model.dmn.instance.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import pro.taskana.common.api.KeyDomain;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.routing.dmn.service.util.InputEntriesSanitizer;
import pro.taskana.routing.dmn.spi.internal.DmnValidatorManager;
import pro.taskana.workbasket.api.WorkbasketService;

@Service
public class DmnConverterService {
    private static final Logger LOGGER;
    private final TaskanaEngine taskanaEngine;
    @Value(value="${taskana.routing.dmn.upload.path}")
    private String dmnUploadPath;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        DmnConverterService.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(DmnConverterService.class);
    }

    @Autowired
    public DmnConverterService(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = taskanaEngine;
        DmnValidatorManager.getInstance(taskanaEngine);
    }

    public String getDmnUploadPath() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.dmnUploadPath);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public void setDmnUploadPath(String dmnUploadPath) {
        String string = dmnUploadPath;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.dmnUploadPath = dmnUploadPath;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    /*
     * Unable to fully structure code
     */
    public DmnModelInstance convertExcelToDmn(MultipartFile excelRoutingFile) throws IOException, NotAuthorizedException {
        var9_2 = excelRoutingFile;
        var8_3 = Factory.makeJP((JoinPoint.StaticPart)DmnConverterService.ajc$tjp_2, (Object)this, (Object)this, (Object)var9_2);
        LoggingAspect.aspectOf().beforeMethodExecuted(var8_3);
        this.taskanaEngine.checkRoleMembership(new TaskanaRole[]{TaskanaRole.ADMIN, TaskanaRole.BUSINESS_ADMIN});
        var2_4 = null;
        var3_6 = null;
        inputStream = new BufferedInputStream(excelRoutingFile.getInputStream());
        try {
            converter = new XlsxConverter();
            converter.setIoDetectionStrategy((SpreadsheetAdapter)new AdvancedSpreadsheetAdapter());
            dmnModelInstance = converter.convert((InputStream)inputStream);
            this.validateOutputs(dmnModelInstance);
            InputEntriesSanitizer.sanitizeRegexInsideInputEntries(dmnModelInstance);
            if (DmnValidatorManager.isDmnUploadProviderEnabled()) {
                DmnValidatorManager.getInstance(this.taskanaEngine).validate(dmnModelInstance);
            }
            if (DmnConverterService.LOGGER.isDebugEnabled()) {
                DmnConverterService.LOGGER.debug(String.format("Persisting generated DMN table to %s", new Object[]{this.dmnUploadPath}));
            }
            uploadDestinationFile = new File(this.dmnUploadPath);
            Dmn.writeModelToFile((File)uploadDestinationFile, (DmnModelInstance)dmnModelInstance);
            v0 = dmnModelInstance;
            ** if (inputStream == null) goto lbl-1000
        }
        catch (Throwable var2_5) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                throw var2_5;
            }
            catch (Throwable var3_7) {
                if (var2_4 == null) {
                    var2_4 = var3_7;
                } else if (var2_4 != var3_7) {
                    var2_4.addSuppressed(var3_7);
                }
                throw var2_4;
            }
        }
lbl-1000:
        // 1 sources

        {
            inputStream.close();
        }
lbl-1000:
        // 2 sources

        {
        }
        var10_12 = v0;
        v1 = var11_13 = v0;
        LoggingAspect.aspectOf().afterMethodExecuted(var8_3, (Object)var11_13);
        return var10_12;
    }

    private Set<KeyDomain> getOutputKeyDomains(DmnModelInstance dmnModel) {
        HashSet<KeyDomain> hashSet;
        HashSet<KeyDomain> hashSet2;
        DmnModelInstance dmnModelInstance = dmnModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)dmnModelInstance);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HashSet<KeyDomain> outputKeyDomains = new HashSet<KeyDomain>();
        for (Rule rule : dmnModel.getModelElementsByType(Rule.class)) {
            ArrayList outputEntries = new ArrayList(rule.getOutputEntries());
            String workbasketKey = ((OutputEntry)outputEntries.get(0)).getTextContent().replaceAll("(^\")|(\"$)", "");
            String domain = ((OutputEntry)outputEntries.get(1)).getTextContent().replaceAll("(^\")|(\"$)", "");
            outputKeyDomains.add(new KeyDomain(workbasketKey, domain));
        }
        HashSet<KeyDomain> hashSet3 = hashSet2 = (hashSet = outputKeyDomains);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, hashSet2);
        return hashSet;
    }

    private void validateOutputs(DmnModelInstance dmnModel) {
        DmnModelInstance dmnModelInstance = dmnModel;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)dmnModelInstance);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Set<KeyDomain> outputKeyDomains = this.getOutputKeyDomains(dmnModel);
        Set<KeyDomain> existingKeyDomains = this.getExistingKeyDomains();
        outputKeyDomains.removeAll(existingKeyDomains);
        if (!outputKeyDomains.isEmpty()) {
            throw new SystemException(String.format("Unknown workbasket Key/Domain pairs defined in DMN Table: %s", outputKeyDomains));
        }
        Object var6_6 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var6_6);
    }

    private Set<KeyDomain> getExistingKeyDomains() {
        Set set;
        Set set2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        WorkbasketService workbasketService = this.taskanaEngine.getWorkbasketService();
        Set set3 = set2 = (set = (Set)this.taskanaEngine.runAsAdmin(() -> workbasketService.createWorkbasketQuery().list().stream().map(workbasketSummary -> new KeyDomain(workbasketSummary.getKey(), workbasketSummary.getDomain())).collect(Collectors.toSet())));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)set2);
        return set;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DmnConverterService.java", DmnConverterService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDmnUploadPath", "pro.taskana.routing.dmn.service.DmnConverterService", "", "", "", "java.lang.String"), 51);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDmnUploadPath", "pro.taskana.routing.dmn.service.DmnConverterService", "java.lang.String", "dmnUploadPath", "", "void"), 55);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "convertExcelToDmn", "pro.taskana.routing.dmn.service.DmnConverterService", "org.springframework.web.multipart.MultipartFile", "excelRoutingFile", "java.io.IOException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.camunda.bpm.model.dmn.DmnModelInstance"), 59);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getOutputKeyDomains", "pro.taskana.routing.dmn.service.DmnConverterService", "org.camunda.bpm.model.dmn.DmnModelInstance", "dmnModel", "", "java.util.Set"), 89);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "validateOutputs", "pro.taskana.routing.dmn.service.DmnConverterService", "org.camunda.bpm.model.dmn.DmnModelInstance", "dmnModel", "", "void"), 102);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getExistingKeyDomains", "pro.taskana.routing.dmn.service.DmnConverterService", "", "", "", "java.util.Set"), 114);
    }
}

