/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.routing.dmn.service;

import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.camunda.bpm.dmn.xlsx.CellContentHandler;
import org.camunda.bpm.dmn.xlsx.DmnConversionContext;
import org.camunda.bpm.dmn.xlsx.DmnValueNumberConverter;
import org.camunda.bpm.dmn.xlsx.DmnValueRangeConverter;
import org.camunda.bpm.dmn.xlsx.DmnValueStringConverter;
import org.camunda.bpm.dmn.xlsx.FeelSimpleUnaryTestConverter;
import org.camunda.bpm.dmn.xlsx.InputOutputColumns;
import org.camunda.bpm.dmn.xlsx.XlsxWorksheetContext;
import org.camunda.bpm.dmn.xlsx.api.Spreadsheet;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetAdapter;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetCell;
import org.camunda.bpm.dmn.xlsx.api.SpreadsheetRow;
import org.camunda.bpm.dmn.xlsx.elements.HeaderValuesContainer;
import org.camunda.bpm.dmn.xlsx.elements.IndexedDmnColumns;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.HitPolicy;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.DecisionTable;
import org.camunda.bpm.model.dmn.instance.Definitions;
import org.camunda.bpm.model.dmn.instance.Description;
import org.camunda.bpm.model.dmn.instance.DmnElement;
import org.camunda.bpm.model.dmn.instance.Input;
import org.camunda.bpm.model.dmn.instance.InputEntry;
import org.camunda.bpm.model.dmn.instance.InputExpression;
import org.camunda.bpm.model.dmn.instance.NamedElement;
import org.camunda.bpm.model.dmn.instance.Output;
import org.camunda.bpm.model.dmn.instance.OutputEntry;
import org.camunda.bpm.model.dmn.instance.Rule;
import org.camunda.bpm.model.dmn.instance.Text;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import pro.taskana.common.internal.logging.LoggingAspect;

public class XlsxWorksheetConverter {
    protected XlsxWorksheetContext worksheetContext;
    protected DmnConversionContext dmnConversionContext;
    protected SpreadsheetAdapter spreadsheetAdapter;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    static {
        XlsxWorksheetConverter.ajc$preClinit();
        CellContentHandler.DEFAULT_HANDLERS.add(new DmnValueRangeConverter());
        CellContentHandler.DEFAULT_HANDLERS.add(new FeelSimpleUnaryTestConverter());
        CellContentHandler.DEFAULT_HANDLERS.add(new DmnValueStringConverter());
        CellContentHandler.DEFAULT_HANDLERS.add(new DmnValueNumberConverter());
    }

    public XlsxWorksheetConverter(XlsxWorksheetContext worksheetContext, SpreadsheetAdapter spreadsheetAdapter) {
        this.worksheetContext = worksheetContext;
        this.dmnConversionContext = new DmnConversionContext(worksheetContext, spreadsheetAdapter.getCellContentHandlers((Spreadsheet)worksheetContext));
        this.spreadsheetAdapter = spreadsheetAdapter;
    }

    public DmnModelInstance convert(StringBuilder serializedRules) {
        DmnModelInstance dmnModelInstance;
        DmnModelInstance dmnModelInstance2;
        StringBuilder stringBuilder = serializedRules;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)stringBuilder);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DmnModelInstance dmnModel = this.initializeEmptyDmnModel();
        Decision decision = this.generateElement(dmnModel, Decision.class, this.worksheetContext.getName());
        decision.setName(this.spreadsheetAdapter.determineDecisionName((Spreadsheet)this.worksheetContext));
        dmnModel.getDefinitions().addChildElement((ModelElementInstance)decision);
        DecisionTable decisionTable = this.generateElement(dmnModel, DecisionTable.class, "decisionTable");
        decision.addChildElement((ModelElementInstance)decisionTable);
        this.setHitPolicy(decisionTable);
        this.convertInputsOutputs(dmnModel, decisionTable);
        this.convertRules(dmnModel, decisionTable, this.spreadsheetAdapter.determineRuleRows((Spreadsheet)this.worksheetContext), serializedRules);
        DmnModelInstance dmnModelInstance3 = dmnModelInstance2 = (dmnModelInstance = dmnModel);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dmnModelInstance2);
        return dmnModelInstance;
    }

    protected void setHitPolicy(DecisionTable decisionTable) {
        DecisionTable decisionTable2 = decisionTable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)decisionTable2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        HitPolicy hitPolicy = this.spreadsheetAdapter.determineHitPolicy((Spreadsheet)this.worksheetContext);
        if (hitPolicy != null) {
            decisionTable.setHitPolicy(hitPolicy);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    protected void convertInputsOutputs(DmnModelInstance dmnModel, DecisionTable decisionTable) {
        DmnModelInstance dmnModelInstance = dmnModel;
        DecisionTable decisionTable2 = decisionTable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)dmnModelInstance, (Object)decisionTable2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        InputOutputColumns inputOutputColumns = this.spreadsheetAdapter.determineInputOutputs((Spreadsheet)this.worksheetContext);
        for (HeaderValuesContainer hvc : inputOutputColumns.getInputHeaders()) {
            Input input = this.generateElement(dmnModel, Input.class, hvc.getId());
            decisionTable.addChildElement((ModelElementInstance)input);
            InputExpression inputExpression = this.generateElement(dmnModel, InputExpression.class);
            Text text = this.generateText(dmnModel, hvc.getText());
            inputExpression.setText(text);
            input.setInputExpression(inputExpression);
            if (hvc.getLabel() != null) {
                input.setLabel(hvc.getLabel());
            }
            if (hvc.getTypeRef() != null) {
                inputExpression.setTypeRef(hvc.getTypeRef());
            }
            if (hvc.getExpressionLanguage() != null) {
                inputExpression.setExpressionLanguage(hvc.getExpressionLanguage());
            }
            this.dmnConversionContext.getIndexedDmnColumns().addInput(hvc.getColumn(), input);
        }
        for (HeaderValuesContainer hvc : inputOutputColumns.getOutputHeaders()) {
            Output output = this.generateElement(dmnModel, Output.class, hvc.getId());
            decisionTable.addChildElement((ModelElementInstance)output);
            output.setName(hvc.getText());
            if (hvc.getLabel() != null) {
                output.setLabel(hvc.getLabel());
            }
            if (hvc.getTypeRef() != null) {
                output.setTypeRef(hvc.getTypeRef());
            }
            this.dmnConversionContext.getIndexedDmnColumns().addOutput(hvc.getColumn(), output);
        }
        Object var12_12 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var12_12);
    }

    protected void convertRules(DmnModelInstance dmnModel, DecisionTable decisionTable, List<SpreadsheetRow> rulesRows, StringBuilder serializedRules) {
        DmnModelInstance dmnModelInstance = dmnModel;
        DecisionTable decisionTable2 = decisionTable;
        List<SpreadsheetRow> list = rulesRows;
        StringBuilder stringBuilder = serializedRules;
        Object[] objectArray = new Object[]{dmnModelInstance, decisionTable2, list, stringBuilder};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        for (SpreadsheetRow rule : rulesRows) {
            this.convertRule(dmnModel, decisionTable, rule, serializedRules);
        }
        Object var13_13 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var13_13);
    }

    protected void convertRule(DmnModelInstance dmnModel, DecisionTable decisionTable, SpreadsheetRow ruleRow, StringBuilder serializedRules) {
        Text text;
        String textValue;
        String coordinate;
        SpreadsheetCell cell;
        String xlsxColumn;
        DmnModelInstance dmnModelInstance = dmnModel;
        DecisionTable decisionTable2 = decisionTable;
        SpreadsheetRow spreadsheetRow = ruleRow;
        StringBuilder stringBuilder = serializedRules;
        Object[] objectArray = new Object[]{dmnModelInstance, decisionTable2, spreadsheetRow, stringBuilder};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Rule rule = this.generateElement(dmnModel, Rule.class, "excelRow" + ruleRow.getRaw().getR());
        IndexedDmnColumns dmnColumns = this.dmnConversionContext.getIndexedDmnColumns();
        for (Input input : dmnColumns.getOrderedInputs()) {
            xlsxColumn = dmnColumns.getSpreadsheetColumn(input);
            cell = ruleRow.getCell(xlsxColumn);
            coordinate = String.valueOf(xlsxColumn) + ruleRow.getRaw().getR();
            InputEntry inputEntry = this.generateElement(dmnModel, InputEntry.class, coordinate);
            textValue = cell != null ? this.dmnConversionContext.resolveCellValue(cell) : this.getDefaultCellContent();
            text = this.generateText(dmnModel, textValue);
            inputEntry.setText(text);
            rule.addChildElement((ModelElementInstance)inputEntry);
        }
        for (Output output : dmnColumns.getOrderedOutputs()) {
            xlsxColumn = dmnColumns.getSpreadsheetColumn(output);
            cell = ruleRow.getCell(xlsxColumn);
            coordinate = String.valueOf(xlsxColumn) + ruleRow.getRaw().getR();
            OutputEntry outputEntry = this.generateElement(dmnModel, OutputEntry.class, coordinate);
            textValue = cell != null ? this.dmnConversionContext.resolveCellValue(cell) : this.getDefaultCellContent();
            text = this.generateText(dmnModel, textValue);
            outputEntry.setText(text);
            rule.addChildElement((ModelElementInstance)outputEntry);
        }
        SpreadsheetCell annotationCell = (SpreadsheetCell)ruleRow.getCells().get(ruleRow.getCells().size() - 1);
        Description description = this.generateDescription(dmnModel, this.worksheetContext.resolveCellContent(annotationCell));
        rule.setDescription(description);
        this.serializeRuleToStringBuilder(rule, ruleRow, description, serializedRules);
        Object var21_21 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var21_21);
    }

    protected void serializeRuleToStringBuilder(Rule rule, SpreadsheetRow ruleRow, Description description, StringBuilder serializedRules) {
        Rule rule2 = rule;
        SpreadsheetRow spreadsheetRow = ruleRow;
        Description description2 = description;
        StringBuilder stringBuilder = serializedRules;
        Object[] objectArray = new Object[]{rule2, spreadsheetRow, description2, stringBuilder};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        serializedRules.append("<rule id=\"excelRow").append(ruleRow.getRaw().getR()).append("\">\n<description>").append(description.getTextContent()).append("</description>\n");
        for (InputEntry inputEntry : rule.getInputEntries()) {
            serializedRules.append("<inputEntry id=\"").append(inputEntry.getId()).append("\">\n<text>").append(inputEntry.getText().getTextContent()).append("</text>\n</inputEntry>\n");
        }
        for (OutputEntry outputEntry : rule.getOutputEntries()) {
            serializedRules.append("<outputEntry id=\"").append(outputEntry.getId()).append("\">\n<text>").append(outputEntry.getText().getTextContent()).append("</text>\n</outputEntry>\n");
        }
        serializedRules.append("</rule>\n");
        Object var13_13 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var13_13);
    }

    protected String getDefaultCellContent() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string2 = "-";
        String string3 = string = "-";
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    protected DmnModelInstance initializeEmptyDmnModel() {
        DmnModelInstance dmnModelInstance;
        DmnModelInstance dmnModelInstance2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DmnModelInstance dmnModel = Dmn.createEmptyModel();
        Definitions definitions = this.generateNamedElement(dmnModel, Definitions.class, "definitions");
        definitions.setNamespace("http://camunda.org/schema/1.0/dmn");
        dmnModel.setDefinitions(definitions);
        DmnModelInstance dmnModelInstance3 = dmnModelInstance2 = (dmnModelInstance = dmnModel);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dmnModelInstance2);
        return dmnModelInstance;
    }

    public <E extends NamedElement> E generateNamedElement(DmnModelInstance modelInstance, Class<E> elementClass, String name) {
        NamedElement namedElement;
        NamedElement namedElement2;
        DmnModelInstance dmnModelInstance = modelInstance;
        Class<E> clazz = elementClass;
        String string = name;
        Object[] objectArray = new Object[]{dmnModelInstance, clazz, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        NamedElement element = (NamedElement)this.generateElement(modelInstance, elementClass, name);
        element.setName(name);
        NamedElement namedElement3 = namedElement2 = (namedElement = element);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)namedElement2);
        return (E)namedElement;
    }

    public <E extends DmnElement> E generateElement(DmnModelInstance modelInstance, Class<E> elementClass, String id) {
        DmnElement dmnElement;
        DmnElement dmnElement2;
        DmnModelInstance dmnModelInstance = modelInstance;
        Class<E> clazz = elementClass;
        String string = id;
        Object[] objectArray = new Object[]{dmnModelInstance, clazz, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DmnElement element = (DmnElement)modelInstance.newInstance(elementClass);
        element.setId(id);
        DmnElement dmnElement3 = dmnElement2 = (dmnElement = element);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dmnElement2);
        return (E)dmnElement;
    }

    public <E extends DmnElement> E generateElement(DmnModelInstance modelInstance, Class<E> elementClass) {
        E e;
        E e2;
        DmnModelInstance dmnModelInstance = modelInstance;
        Class<E> clazz = elementClass;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)dmnModelInstance, clazz);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String generatedId = String.valueOf(elementClass.getSimpleName()) + (int)(2.147483647E9 * Math.random());
        E e3 = e2 = (e = this.generateElement(modelInstance, elementClass, generatedId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, e2);
        return e;
    }

    protected Text generateText(DmnModelInstance dmnModel, String content) {
        Text text;
        Text text2;
        DmnModelInstance dmnModelInstance = dmnModel;
        String string = content;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)dmnModelInstance, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Text text3 = (Text)dmnModel.newInstance(Text.class);
        text3.setTextContent(content);
        Text text4 = text2 = (text = text3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)text2);
        return text;
    }

    protected Description generateDescription(DmnModelInstance dmnModel, String content) {
        Description description;
        Description description2;
        DmnModelInstance dmnModelInstance = dmnModel;
        String string = content;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)dmnModelInstance, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Description description3 = (Description)dmnModel.newInstance(Description.class);
        description3.setTextContent(content);
        Description description4 = description2 = (description = description3);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)description2);
        return description;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("XlsxWorksheetConverter.java", XlsxWorksheetConverter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "convert", "pro.taskana.routing.dmn.service.XlsxWorksheetConverter", "java.lang.StringBuilder", "serializedRules", "", "org.camunda.bpm.model.dmn.DmnModelInstance"), 78);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "setHitPolicy", "pro.taskana.routing.dmn.service.XlsxWorksheetConverter", "org.camunda.bpm.model.dmn.instance.DecisionTable", "decisionTable", "", "void"), 100);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateElement", "pro.taskana.routing.dmn.service.XlsxWorksheetConverter", "org.camunda.bpm.model.dmn.DmnModelInstance:java.lang.Class", "modelInstance:elementClass", "", "org.camunda.bpm.model.dmn.instance.DmnElement"), 265);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "generateText", "pro.taskana.routing.dmn.service.XlsxWorksheetConverter", "org.camunda.bpm.model.dmn.DmnModelInstance:java.lang.String", "dmnModel:content", "", "org.camunda.bpm.model.dmn.instance.Text"), 272);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "generateDescription", "pro.taskana.routing.dmn.service.XlsxWorksheetConverter", "org.camunda.bpm.model.dmn.DmnModelInstance:java.lang.String", "dmnModel:content", "", "org.camunda.bpm.model.dmn.instance.Description"), 278);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "convertInputsOutputs", "pro.taskana.routing.dmn.service.XlsxWorksheetConverter", "org.camunda.bpm.model.dmn.DmnModelInstance:org.camunda.bpm.model.dmn.instance.DecisionTable", "dmnModel:decisionTable", "", "void"), 107);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "convertRules", "pro.taskana.routing.dmn.service.XlsxWorksheetConverter", "org.camunda.bpm.model.dmn.DmnModelInstance:org.camunda.bpm.model.dmn.instance.DecisionTable:java.util.List:java.lang.StringBuilder", "dmnModel:decisionTable:rulesRows:serializedRules", "", "void"), 157);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "convertRule", "pro.taskana.routing.dmn.service.XlsxWorksheetConverter", "org.camunda.bpm.model.dmn.DmnModelInstance:org.camunda.bpm.model.dmn.instance.DecisionTable:org.camunda.bpm.dmn.xlsx.api.SpreadsheetRow:java.lang.StringBuilder", "dmnModel:decisionTable:ruleRow:serializedRules", "", "void"), 167);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "serializeRuleToStringBuilder", "pro.taskana.routing.dmn.service.XlsxWorksheetConverter", "org.camunda.bpm.model.dmn.instance.Rule:org.camunda.bpm.dmn.xlsx.api.SpreadsheetRow:org.camunda.bpm.model.dmn.instance.Description:java.lang.StringBuilder", "rule:ruleRow:description:serializedRules", "", "void"), 211);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getDefaultCellContent", "pro.taskana.routing.dmn.service.XlsxWorksheetConverter", "", "", "", "java.lang.String"), 238);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "initializeEmptyDmnModel", "pro.taskana.routing.dmn.service.XlsxWorksheetConverter", "", "", "", "org.camunda.bpm.model.dmn.DmnModelInstance"), 242);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateNamedElement", "pro.taskana.routing.dmn.service.XlsxWorksheetConverter", "org.camunda.bpm.model.dmn.DmnModelInstance:java.lang.Class:java.lang.String", "modelInstance:elementClass:name", "", "org.camunda.bpm.model.dmn.instance.NamedElement"), 251);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateElement", "pro.taskana.routing.dmn.service.XlsxWorksheetConverter", "org.camunda.bpm.model.dmn.DmnModelInstance:java.lang.Class:java.lang.String", "modelInstance:elementClass:id", "", "org.camunda.bpm.model.dmn.instance.DmnElement"), 258);
    }
}

