/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.routing.dmn.spi.internal;

import java.util.Objects;
import java.util.ServiceLoader;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.routing.dmn.spi.api.DmnValidator;

public class DmnValidatorManager {
    private static final Logger LOGGER;
    private static DmnValidatorManager singleton;
    private final ServiceLoader<DmnValidator> serviceLoader = ServiceLoader.load(DmnValidator.class);
    private boolean enabled = false;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        DmnValidatorManager.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(DmnValidatorManager.class);
    }

    private DmnValidatorManager(TaskanaEngine taskanaEngine) {
        for (DmnValidator dmnValidator : this.serviceLoader) {
            dmnValidator.initialize(taskanaEngine);
            LOGGER.info("Registered DmnValidator: {}", (Object)dmnValidator.getClass().getName());
            this.enabled = true;
        }
        if (!this.enabled) {
            LOGGER.info("No DmnValidator found. Running without DmnValidator.");
        }
    }

    public static synchronized DmnValidatorManager getInstance(TaskanaEngine taskanaEngine) {
        DmnValidatorManager dmnValidatorManager;
        DmnValidatorManager dmnValidatorManager2;
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (singleton == null) {
            singleton = new DmnValidatorManager(taskanaEngine);
        }
        DmnValidatorManager dmnValidatorManager3 = dmnValidatorManager2 = (dmnValidatorManager = singleton);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dmnValidatorManager2);
        return dmnValidatorManager;
    }

    public static boolean isDmnUploadProviderEnabled() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = Objects.nonNull(singleton) && DmnValidatorManager.singleton.enabled ? (bl = true) : (bl = false);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public void validate(DmnModelInstance dmnModelInstanceToValidate) {
        DmnModelInstance dmnModelInstance = dmnModelInstanceToValidate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)dmnModelInstance);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending DmnModelInstance to DmnValidators: {}", (Object)dmnModelInstanceToValidate);
        }
        this.serviceLoader.forEach(dmnValidator -> {
            try {
                dmnValidator.validate(dmnModelInstanceToValidate);
            }
            catch (Exception e) {
                throw new SystemException("Caught exception while validating dmnModelInstance", (Throwable)e);
            }
        });
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DmnValidatorManager.java", DmnValidatorManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("29", "getInstance", "pro.taskana.routing.dmn.spi.internal.DmnValidatorManager", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "pro.taskana.routing.dmn.spi.internal.DmnValidatorManager"), 32);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isDmnUploadProviderEnabled", "pro.taskana.routing.dmn.spi.internal.DmnValidatorManager", "", "", "", "boolean"), 39);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "validate", "pro.taskana.routing.dmn.spi.internal.DmnValidatorManager", "org.camunda.bpm.model.dmn.DmnModelInstance", "dmnModelInstanceToValidate", "", "void"), 43);
    }
}

