/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.routing.dmn.rest;

import java.io.IOException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.Rule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.routing.dmn.rest.RoutingUploadResultRepresentationModel;
import pro.taskana.routing.dmn.service.DmnConverterService;

@RestController
public class DmnUploadController {
    private final DmnConverterService dmnConverterService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Autowired
    public DmnUploadController(DmnConverterService dmnConverterService) {
        this.dmnConverterService = dmnConverterService;
    }

    @PutMapping(value={"/api/v1/routing-rules/default"})
    public ResponseEntity<RoutingUploadResultRepresentationModel> convertAndUpload(@RequestParam(value="excelRoutingFile") MultipartFile excelRoutingFile) throws IOException, NotAuthorizedException {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        MultipartFile multipartFile = excelRoutingFile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)multipartFile);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DmnModelInstance dmnModelInstance = this.dmnConverterService.convertExcelToDmn(excelRoutingFile);
        int importedRows = dmnModelInstance.getModelElementsByType(Rule.class).size();
        RoutingUploadResultRepresentationModel model = new RoutingUploadResultRepresentationModel();
        model.setAmountOfImportedRows(importedRows);
        model.setResult("Successfully imported " + importedRows + " routing rules from the provided excel sheet");
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)((Object)model)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    @GetMapping(path={"/api/v1/routing-rules/routing-rest-enabled"})
    public ResponseEntity<Boolean> getIsRoutingRestEnabled() {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ResponseEntity responseEntity3 = responseEntity2 = (responseEntity = ResponseEntity.ok((Object)true));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)responseEntity2);
        return responseEntity;
    }

    static {
        DmnUploadController.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DmnUploadController.java", DmnUploadController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "convertAndUpload", "pro.taskana.routing.dmn.rest.DmnUploadController", "org.springframework.web.multipart.MultipartFile", "excelRoutingFile", "java.io.IOException:pro.taskana.common.api.exceptions.NotAuthorizedException", "org.springframework.http.ResponseEntity"), 37);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIsRoutingRestEnabled", "pro.taskana.routing.dmn.rest.DmnUploadController", "", "", "", "org.springframework.http.ResponseEntity"), 59);
    }
}

