/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.routing.dmn;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.dmn.engine.DmnEngine;
import org.camunda.bpm.dmn.engine.DmnEngineConfiguration;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.OutputEntry;
import org.camunda.bpm.model.dmn.instance.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.util.FileLoaderUtil;
import pro.taskana.common.internal.util.Pair;
import pro.taskana.spi.routing.api.TaskRoutingProvider;
import pro.taskana.task.api.models.Task;
import pro.taskana.workbasket.api.WorkbasketService;
import pro.taskana.workbasket.api.exceptions.WorkbasketNotFoundException;

public class DmnTaskRouter
implements TaskRoutingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmnTaskRouter.class);
    private static final String DMN_TABLE_PROPERTY = "taskana.routing.dmn";
    private static final String DECISION_ID = "workbasketRouting";
    private static final String DECISION_VARIABLE_MAP_NAME = "task";
    private static final String OUTPUT_WORKBASKET_KEY = "workbasketKey";
    private static final String OUTPUT_DOMAIN = "domain";
    private TaskanaEngine taskanaEngine;
    private DmnEngine dmnEngine;
    private DmnDecision decision;

    public void initialize(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = taskanaEngine;
        this.dmnEngine = DmnEngineConfiguration.createDefaultDmnEngineConfiguration().buildEngine();
        DmnModelInstance dmnModel = this.readModelFromDmnTable();
        this.decision = this.dmnEngine.parseDecision(DECISION_ID, dmnModel);
        this.validateOutputs(dmnModel);
    }

    public String determineWorkbasketId(Task task) {
        VariableMap variables = Variables.putValue((String)DECISION_VARIABLE_MAP_NAME, (Object)task);
        DmnDecisionTableResult result = this.dmnEngine.evaluateDecisionTable(this.decision, (Map)variables);
        if (result.getSingleResult() == null) {
            return null;
        }
        String workbasketKey = (String)result.getSingleResult().getEntry(OUTPUT_WORKBASKET_KEY);
        String domain = (String)result.getSingleResult().getEntry(OUTPUT_DOMAIN);
        try {
            return this.taskanaEngine.getWorkbasketService().getWorkbasket(workbasketKey, domain).getId();
        }
        catch (WorkbasketNotFoundException e) {
            throw new SystemException(String.format("Unknown workbasket defined in DMN Table. key: '%s', domain: '%s'", workbasketKey, domain));
        }
        catch (NotAuthorizedException e) {
            throw new SystemException(String.format("The current user is not authorized to create a task in the routed workbasket. key: '%s', domain: '%s'", workbasketKey, domain));
        }
    }

    protected Set<Pair<String, String>> getAllWorkbasketAndDomainOutputs(DmnModelInstance dmnModel) {
        HashSet<Pair<String, String>> allWorkbasketAndDomainOutputs = new HashSet<Pair<String, String>>();
        for (Rule rule : dmnModel.getModelElementsByType(Rule.class)) {
            ArrayList outputEntries = new ArrayList(rule.getOutputEntries());
            String workbasketKey = ((OutputEntry)outputEntries.get(0)).getTextContent();
            String domain = ((OutputEntry)outputEntries.get(1)).getTextContent();
            allWorkbasketAndDomainOutputs.add((Pair<String, String>)Pair.of((Object)workbasketKey, (Object)domain));
        }
        return allWorkbasketAndDomainOutputs;
    }

    protected DmnModelInstance readModelFromDmnTable() {
        DmnModelInstance dmnModelInstance;
        block8: {
            String pathToDmn = this.taskanaEngine.getConfiguration().readPropertiesFromFile().getProperty(DMN_TABLE_PROPERTY);
            InputStream stream = FileLoaderUtil.openFileFromClasspathOrSystem((String)pathToDmn, this.getClass());
            try {
                dmnModelInstance = Dmn.readModelFromStream((InputStream)stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("caught IOException when processing dmn file {}.", (Object)pathToDmn);
                    throw new SystemException("internal System error when processing dmn file " + pathToDmn, e.getCause());
                }
            }
            stream.close();
        }
        return dmnModelInstance;
    }

    private void validateOutputs(DmnModelInstance dmnModel) {
        Set<Pair<String, String>> allWorkbasketAndDomainOutputs = this.getAllWorkbasketAndDomainOutputs(dmnModel);
        this.validate(allWorkbasketAndDomainOutputs);
    }

    private void validate(Set<Pair<String, String>> allWorkbasketAndDomainOutputs) {
        WorkbasketService workbasketService = this.taskanaEngine.getWorkbasketService();
        for (Pair<String, String> pair : allWorkbasketAndDomainOutputs) {
            String workbasketKey = ((String)pair.getLeft()).replace("\"", "");
            String domain = ((String)pair.getRight()).replace("\"", "");
            this.taskanaEngine.runAsAdmin(() -> {
                try {
                    return workbasketService.getWorkbasket(workbasketKey, domain);
                }
                catch (Exception e) {
                    throw new SystemException(String.format("Unknown workbasket defined in DMN Table. key: '%s', domain: '%s'", workbasketKey, domain), (Throwable)e);
                }
            });
        }
    }
}

