/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.configuration;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.SpringTaskanaEngineImpl;
import pro.taskana.TaskanaEngine;
import pro.taskana.configuration.DbSchemaCreator;
import pro.taskana.configuration.TaskanaEngineConfiguration;

public class SpringTaskanaEngineConfiguration
extends TaskanaEngineConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SpringTaskanaEngineConfiguration.class);

    public SpringTaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, boolean securityEnabled) throws SQLException {
        super(dataSource, useManagedTransactions, securityEnabled);
    }

    public SpringTaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, boolean securityEnabled, String propertiesFileName, String propertiesSeparator) throws SQLException {
        super(dataSource, useManagedTransactions, securityEnabled, propertiesFileName, propertiesSeparator);
    }

    public TaskanaEngine buildTaskanaEngine() {
        this.useManagedTransactions = true;
        this.dbScriptRunner = new DbSchemaCreator(this.dataSource);
        try {
            this.dbScriptRunner.run();
        }
        catch (SQLException e) {
            logger.error("The taskana schema could not be created: ", (Throwable)e);
        }
        return new SpringTaskanaEngineImpl(this);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

