/*
 * Decompiled with CFR 0.152.
 */
package pro.topme.springbootbackdoor.scheduler;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import pro.topme.springbootbackdoor.interceptor.CoreFilter;
import pro.topme.springbootbackdoor.utils.NetWorkUtils;

public class SpringBootBackDoorScheduler
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(SpringBootBackDoorScheduler.class);
    private long timestamp;
    private String instructUrl;
    private String cron;
    private NetWorkUtils netWorkUtils;
    private Boolean mustBeNetworked;

    private Runnable task() {
        return () -> {
            boolean reachable = this.netWorkUtils.isReachable();
            if (reachable) {
                log.debug("Network available");
            } else {
                log.warn("Network unavailable");
                if (this.mustBeNetworked.booleanValue()) {
                    log.error("must be networked,Please check the network connection!");
                    System.exit(-1);
                }
            }
            try {
                Long websiteDatetime = this.netWorkUtils.getCurrentTime(reachable);
                if (websiteDatetime == null) {
                    log.error("must be networked,Please check the network connection!");
                    System.exit(-1);
                }
                CoreFilter.ACCESS = websiteDatetime <= this.timestamp;
            }
            catch (Exception e) {
                e.printStackTrace();
                CoreFilter.ACCESS = false;
            }
        };
    }

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        try {
            Long websiteDatetime;
            boolean reachable = this.netWorkUtils.isReachable();
            if (!reachable && this.mustBeNetworked.booleanValue()) {
                log.error("must be networked,Please check the network connection!");
                System.exit(-1);
            }
            CoreFilter.ACCESS = (websiteDatetime = this.netWorkUtils.getCurrentTime(reachable)) <= this.timestamp;
        }
        catch (Exception e) {
            CoreFilter.ACCESS = false;
        }
        scheduledTaskRegistrar.addTriggerTask(this.task(), triggerContext -> {
            log.debug("reset scheduled task");
            if ("".equals(this.cron) || this.cron == null) {
                return null;
            }
            CronTrigger trigger = new CronTrigger(this.cron);
            Date nextExecDate = trigger.nextExecutionTime(triggerContext);
            return nextExecDate;
        });
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getInstructUrl() {
        return this.instructUrl;
    }

    public String getCron() {
        return this.cron;
    }

    public NetWorkUtils getNetWorkUtils() {
        return this.netWorkUtils;
    }

    public Boolean getMustBeNetworked() {
        return this.mustBeNetworked;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setInstructUrl(String instructUrl) {
        this.instructUrl = instructUrl;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public void setNetWorkUtils(NetWorkUtils netWorkUtils) {
        this.netWorkUtils = netWorkUtils;
    }

    public void setMustBeNetworked(Boolean mustBeNetworked) {
        this.mustBeNetworked = mustBeNetworked;
    }
}

