/*
 * Decompiled with CFR 0.152.
 */
package pro.topme.springbootbackdoor.utils;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import pro.topme.springbootbackdoor.utils.BackDoorPropertiesFileUtils;

public class NetWorkUtils {
    private BackDoorPropertiesFileUtils backDoorPropertiesFileUtils;
    private String remoteAddress;
    private String timeAddress;

    public boolean isReachable() {
        boolean reachable = false;
        try {
            InetAddress address = InetAddress.getByName(this.remoteAddress);
            reachable = address.isReachable(5000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reachable;
    }

    public Long getWebsiteDatetime() {
        try {
            URL url = new URL(this.timeAddress);
            URLConnection uc = url.openConnection();
            uc.connect();
            return uc.getDate();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Long getCurrentTime(boolean reachable) throws Exception {
        if (reachable) {
            return this.getWebsiteDatetime();
        }
        long l = System.currentTimeMillis();
        Long time = this.backDoorPropertiesFileUtils.getTime();
        if (time > l) {
            throw new Exception("Local time read exception");
        }
        return l;
    }

    public Long getCurrentTime() throws Exception {
        return this.getCurrentTime(this.isReachable());
    }

    @ConstructorProperties(value={"backDoorPropertiesFileUtils", "remoteAddress", "timeAddress"})
    public NetWorkUtils(BackDoorPropertiesFileUtils backDoorPropertiesFileUtils, String remoteAddress, String timeAddress) {
        this.backDoorPropertiesFileUtils = backDoorPropertiesFileUtils;
        this.remoteAddress = remoteAddress;
        this.timeAddress = timeAddress;
    }
}

