package pro.vdshb.dbcleaner

import org.junit.jupiter.api.extension.BeforeEachCallback
import org.junit.jupiter.api.extension.ExtensionContext

class DbCleanerExtension : BeforeEachCallback {

    override fun beforeEach(context: ExtensionContext) {
        val testClassAnnotations = context.testClass.map { it.annotations }.orElse(emptyArray()).toList()
        val testMethodAnnotations = context.element.map { it.annotations }.orElse(emptyArray()).toList()

        val excludeTablesClassAnnotation = testClassAnnotations.firstOrNull { it is ExcludeTables } as ExcludeTables?
        val excludeTablesMethodAnnotation = testMethodAnnotations.firstOrNull { it is ExcludeTables } as ExcludeTables?

        val onlyTablesClassAnnotation = testClassAnnotations.firstOrNull { it is OnlyTables } as OnlyTables?
        val onlyTablesMethodAnnotation = testMethodAnnotations.firstOrNull { it is OnlyTables } as OnlyTables?

        val schemaClassAnnotation = testClassAnnotations.firstOrNull { it is Schema } as Schema?
        val schemaMethodAnnotation = testMethodAnnotations.firstOrNull { it is Schema } as Schema?


        val schema = findSchema(schemaMethodAnnotation, schemaClassAnnotation)
        val onlyTables = findOnlyTables(onlyTablesMethodAnnotation, onlyTablesClassAnnotation)
        val excludeTables = findExcludeTables(excludeTablesMethodAnnotation, excludeTablesClassAnnotation)
        PostgresqlDatabaseCleaner.cleanPostgresDb(
            schemaToClean = schema,
            onlyTables = onlyTables,
            excludeTables = excludeTables
        )
    }

    private fun findExcludeTables(excludeTablesMethodAnnotation: ExcludeTables?, excludeTablesClassAnnotation: ExcludeTables?): List<String> {
        return excludeTablesMethodAnnotation?.tables?.toList()
                ?: excludeTablesClassAnnotation?.tables?.toList()
                ?: emptyList()
    }

    private fun findOnlyTables(onlyTablesMethodAnnotation: OnlyTables?, onlyTablesClassAnnotation: OnlyTables?): List<String> {
        return onlyTablesMethodAnnotation?.tables?.toList()
                ?: onlyTablesClassAnnotation?.tables?.toList()
                ?: emptyList()
    }

    private fun findSchema(schemaMethodAnnotation: Schema?, schemaClassAnnotation: Schema?): String {
        //todo: implement logic
        return "public"
    }

}