package pro.vdshb.dbcleaner.postgresutil

import java.sql.Connection
import java.util.*
import kotlin.collections.ArrayList

fun findAllTables(schema: String, connection: Connection): List<String> {
    val preparedStatement = connection.prepareStatement("SELECT table_name FROM information_schema.tables WHERE table_schema = ?")
    preparedStatement.setString(1, schema)
    val resultSet = preparedStatement.executeQuery()
    val result = ArrayList<String>()
    while (resultSet.next()) {
        result.add(resultSet.getString(1))
    }
    return result
}

fun findAllTableConstraints(schema: String, tables: List<String>, connection: Connection): List<PostgresConstraint> {
    if (tables.isEmpty()) {
        return emptyList()
    }
    val tableNames = tables.joinToString(separator = ",", transform = { "'$it'" })
    val resultSet = connection.createStatement()
        .executeQuery("""SELECT con.oid, rel.relname, con.conname, con.condeferrable, con.condeferred
                                      FROM pg_catalog.pg_constraint con
                                           INNER JOIN pg_catalog.pg_class rel ON rel.oid = con.conrelid
                                           INNER JOIN pg_catalog.pg_namespace nsp ON nsp.oid = connamespace
                                      WHERE nsp.nspname = '$schema' AND
                                            rel.relname in ($tableNames)""")
    val result = LinkedList<PostgresConstraint>()
    while (resultSet.next()) {
        result.add(
            PostgresConstraint(
                oid = resultSet.getLong(1),
                relname = resultSet.getString(2),
                conname = resultSet.getString(3),
                condeferrable = resultSet.getBoolean(4),
                condeferred = resultSet.getBoolean(5)
            )
        )
    }
    return result
}

fun findAllConstraintTriggers(constraints: List<PostgresConstraint>, connection: Connection): List<PostgresTrigger> {
    if (constraints.isEmpty()) {
        return emptyList()
    }
    val constraintsOids = constraints
        .map { it.oid }
        .joinToString(separator = ",")
    val resultSet = connection.createStatement()
        .executeQuery("""SELECT oid, tgname, tgdeferrable, tginitdeferred
                                      FROM pg_catalog.pg_trigger WHERE tgconstraint  IN ($constraintsOids)""")
    val result = LinkedList<PostgresTrigger>()
    while (resultSet.next()) {
        result.add(
            PostgresTrigger(
                oid = resultSet.getLong(1),
                tgname = resultSet.getString(2),
                tgdeferrable = resultSet.getBoolean(3),
                tginitdeferred = resultSet.getBoolean(4)
            )
        )
    }
    return result
}