/*
 * Decompiled with CFR 0.152.
 */
package pro.vdshb.dbcleaner.postgresutil;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pro.vdshb.dbcleaner.postgresutil.PostgresConstraint;
import pro.vdshb.dbcleaner.postgresutil.PostgresTrigger;
import pro.vdshb.dbcleaner.postgresutil.PostgresUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a*\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"findAllConstraintTriggers", "", "Lpro/vdshb/dbcleaner/postgresutil/PostgresTrigger;", "constraints", "Lpro/vdshb/dbcleaner/postgresutil/PostgresConstraint;", "connection", "Ljava/sql/Connection;", "findAllTableConstraints", "schema", "", "tables", "findAllTables", "junit-db-cleaner-extension"})
public final class PostgresUtilKt {
    @NotNull
    public static final List<String> findAllTables(@NotNull String schema, @NotNull Connection connection) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT table_name FROM information_schema.tables WHERE table_schema = ?");
        preparedStatement.setString(1, schema);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<String> result = new ArrayList<String>();
        while (resultSet.next()) {
            result.add(resultSet.getString(1));
        }
        return result;
    }

    @NotNull
    public static final List<PostgresConstraint> findAllTableConstraints(@NotNull String schema, @NotNull List<String> tables, @NotNull Connection connection) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull(tables, (String)"tables");
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        if (tables.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        String tableNames2 = CollectionsKt.joinToString$default((Iterable)tables, (CharSequence)",", null, null, (int)0, null, (Function1)findAllTableConstraints.tableNames.1.INSTANCE, (int)30, null);
        ResultSet resultSet = connection.createStatement().executeQuery("SELECT con.oid, rel.relname, con.conname, con.condeferrable, con.condeferred\n                                      FROM pg_catalog.pg_constraint con\n                                           INNER JOIN pg_catalog.pg_class rel ON rel.oid = con.conrelid\n                                           INNER JOIN pg_catalog.pg_namespace nsp ON nsp.oid = connamespace\n                                      WHERE nsp.nspname = '" + schema + "' AND\n                                            rel.relname in (" + tableNames2 + ')');
        LinkedList<PostgresConstraint> result = new LinkedList<PostgresConstraint>();
        while (resultSet.next()) {
            long l = resultSet.getLong(1);
            String string = resultSet.getString(2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultSet.getString(2)");
            String string2 = resultSet.getString(3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resultSet.getString(3)");
            result.add(new PostgresConstraint(l, string, string2, resultSet.getBoolean(4), resultSet.getBoolean(5)));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PostgresTrigger> findAllConstraintTriggers(@NotNull List<PostgresConstraint> constraints, @NotNull Connection connection) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        if (constraints.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = constraints;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PostgresConstraint postgresConstraint = (PostgresConstraint)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = it.getOid();
            collection.add(l);
        }
        String constraintsOids = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        ResultSet resultSet = connection.createStatement().executeQuery("SELECT oid, tgname, tgdeferrable, tginitdeferred\n                                      FROM pg_catalog.pg_trigger WHERE tgconstraint  IN (" + constraintsOids + ')');
        LinkedList<PostgresTrigger> result = new LinkedList<PostgresTrigger>();
        while (resultSet.next()) {
            long l = resultSet.getLong(1);
            String string = resultSet.getString(2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultSet.getString(2)");
            result.add(new PostgresTrigger(l, string, resultSet.getBoolean(3), resultSet.getBoolean(4)));
        }
        return result;
    }
}

