/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor.repeat;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsPart;
import org.docx4j.wml.Body;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.Tc;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.wickedsource.docxstamper.DocxStamper;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.processor.BaseCommentProcessor;
import org.wickedsource.docxstamper.processor.repeat.IRepeatDocPartProcessor;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.CommentWrapper;

public class RepeatDocPartProcessor
extends BaseCommentProcessor
implements IRepeatDocPartProcessor {
    private final DocxStamperConfiguration config;
    private Map<CommentWrapper, List<Object>> subContexts = new HashMap<CommentWrapper, List<Object>>();
    private Map<CommentWrapper, List<Object>> repeatElementsMap = new HashMap<CommentWrapper, List<Object>>();
    private Map<CommentWrapper, WordprocessingMLPackage> subTemplates = new HashMap<CommentWrapper, WordprocessingMLPackage>();
    private Map<CommentWrapper, ContentAccessor> gcpMap = new HashMap<CommentWrapper, ContentAccessor>();
    private Map<CommentWrapper, Integer> insertIndex = new HashMap<CommentWrapper, Integer>();
    private final ObjectFactory objectFactory;

    public RepeatDocPartProcessor(DocxStamperConfiguration config) {
        this.config = config;
        this.objectFactory = Context.getWmlObjectFactory();
    }

    @Override
    public void repeatDocPart(List<Object> contexts) {
        ContentAccessor gcp;
        CommentWrapper currentCommentWrapper = this.getCurrentCommentWrapper();
        List<Object> repeatElements = RepeatDocPartProcessor.getRepeatElements(currentCommentWrapper, gcp = RepeatDocPartProcessor.findGreatestCommonParent(currentCommentWrapper.getCommentRangeEnd().getParent(), (ContentAccessor)currentCommentWrapper.getCommentRangeStart().getParent()));
        if (repeatElements.size() > 0) {
            try {
                this.subContexts.put(currentCommentWrapper, contexts);
                this.subTemplates.put(currentCommentWrapper, this.extractSubTemplate(currentCommentWrapper, repeatElements));
                this.gcpMap.put(currentCommentWrapper, gcp);
                this.insertIndex.put(currentCommentWrapper, gcp.getContent().indexOf(repeatElements.get(0)));
                this.repeatElementsMap.put(currentCommentWrapper, repeatElements);
            }
            catch (InvalidFormatException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private WordprocessingMLPackage copyTemplate(WordprocessingMLPackage doc) throws Docx4JException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        doc.save((OutputStream)baos);
        return WordprocessingMLPackage.load((InputStream)new ByteArrayInputStream(baos.toByteArray()));
    }

    @Override
    public void commitChanges(WordprocessingMLPackage document) {
        for (CommentWrapper commentWrapper : this.subContexts.keySet()) {
            List<Object> expressionContexts = this.subContexts.get(commentWrapper);
            ArrayList changes = new ArrayList();
            Integer index = this.insertIndex.get(commentWrapper);
            for (Object subContext : expressionContexts) {
                try {
                    WordprocessingMLPackage subTemplate = this.copyTemplate(this.subTemplates.get(commentWrapper));
                    DocxStamper<Object> stamper = new DocxStamper<Object>(this.config);
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    stamper.stamp(subTemplate, subContext, (OutputStream)output);
                    WordprocessingMLPackage subDocument = WordprocessingMLPackage.load((InputStream)new ByteArrayInputStream(output.toByteArray()));
                    changes.addAll(subDocument.getMainDocumentPart().getContent());
                }
                catch (Docx4JException e) {
                    throw new RuntimeException(e);
                }
            }
            if (changes.isEmpty()) continue;
            ContentAccessor gcp = this.gcpMap.get(commentWrapper);
            CommentUtil.deleteComment(commentWrapper);
            gcp.getContent().removeAll((Collection)this.repeatElementsMap.get(commentWrapper));
            gcp.getContent().addAll(index, changes);
        }
    }

    @Override
    public void reset() {
        this.subContexts = new HashMap<CommentWrapper, List<Object>>();
        this.subTemplates = new HashMap<CommentWrapper, WordprocessingMLPackage>();
        this.insertIndex = new HashMap<CommentWrapper, Integer>();
        this.gcpMap = new HashMap<CommentWrapper, ContentAccessor>();
        this.repeatElementsMap = new HashMap<CommentWrapper, List<Object>>();
    }

    private WordprocessingMLPackage extractSubTemplate(CommentWrapper commentWrapper, List<Object> repeatElements) throws InvalidFormatException {
        CommentUtil.deleteComment(commentWrapper);
        WordprocessingMLPackage document = WordprocessingMLPackage.createPackage();
        CommentsPart commentsPart = new CommentsPart();
        document.getMainDocumentPart().addTargetPart((Part)commentsPart);
        document.getMainDocumentPart().getContent().addAll(repeatElements);
        Comments comments = this.objectFactory.createComments();
        commentWrapper.getChildren().forEach(comment -> comments.getComment().add(comment.getComment()));
        commentsPart.setContents((Object)comments);
        return document;
    }

    private static List<Object> getRepeatElements(CommentWrapper commentWrapper, ContentAccessor greatestCommonParent) {
        ArrayList<Object> repeatElements = new ArrayList<Object>();
        boolean startFound = false;
        for (Object element : greatestCommonParent.getContent()) {
            if (!startFound && RepeatDocPartProcessor.depthElementSearch(commentWrapper.getCommentRangeStart(), element)) {
                startFound = true;
            }
            if (!startFound) continue;
            if (RepeatDocPartProcessor.depthElementSearch(commentWrapper.getCommentRangeEnd(), element)) break;
            repeatElements.add(element);
        }
        return repeatElements;
    }

    private static ContentAccessor findGreatestCommonParent(Object targetSearch, ContentAccessor searchFrom) {
        if (RepeatDocPartProcessor.depthElementSearch(targetSearch, searchFrom)) {
            return RepeatDocPartProcessor.findInsertableParent(searchFrom);
        }
        return RepeatDocPartProcessor.findGreatestCommonParent(targetSearch, (ContentAccessor)((Child)searchFrom).getParent());
    }

    private static ContentAccessor findInsertableParent(ContentAccessor searchFrom) {
        if (!(searchFrom instanceof Tc) && !(searchFrom instanceof Body)) {
            return RepeatDocPartProcessor.findInsertableParent((ContentAccessor)((Child)searchFrom).getParent());
        }
        return searchFrom;
    }

    private static boolean depthElementSearch(Object searchTarget, Object content) {
        if (searchTarget.equals(content = XmlUtils.unwrap((Object)content))) {
            return true;
        }
        if (content instanceof ContentAccessor) {
            for (Object object : ((ContentAccessor)content).getContent()) {
                Object unwrappedObject = XmlUtils.unwrap(object);
                if (!searchTarget.equals(unwrappedObject) && !RepeatDocPartProcessor.depthElementSearch(searchTarget, unwrappedObject)) continue;
                return true;
            }
        }
        return false;
    }
}

