/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor.repeat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.Tr;
import org.wickedsource.docxstamper.api.coordinates.ParagraphCoordinates;
import org.wickedsource.docxstamper.api.coordinates.TableRowCoordinates;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.el.ExpressionResolver;
import org.wickedsource.docxstamper.processor.BaseCommentProcessor;
import org.wickedsource.docxstamper.processor.CommentProcessingException;
import org.wickedsource.docxstamper.processor.repeat.IRepeatProcessor;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.walk.BaseDocumentWalker;

public class RepeatProcessor
extends BaseCommentProcessor
implements IRepeatProcessor {
    private Map<TableRowCoordinates, List<Object>> tableRowsToRepeat = new HashMap<TableRowCoordinates, List<Object>>();
    private PlaceholderReplacer<Object> placeholderReplacer;

    public RepeatProcessor(TypeResolverRegistry typeResolverRegistry, ExpressionResolver expressionResolver) {
        this.placeholderReplacer = new PlaceholderReplacer(typeResolverRegistry);
        this.placeholderReplacer.setExpressionResolver(expressionResolver);
    }

    @Override
    public void commitChanges(WordprocessingMLPackage document) {
        this.repeatRows(document);
    }

    @Override
    public void reset() {
        this.tableRowsToRepeat = new HashMap<TableRowCoordinates, List<Object>>();
    }

    private void repeatRows(final WordprocessingMLPackage document) {
        for (TableRowCoordinates rCoords : this.tableRowsToRepeat.keySet()) {
            List<Object> expressionContexts = this.tableRowsToRepeat.get(rCoords);
            int index = rCoords.getIndex();
            for (final Object expressionContext : expressionContexts) {
                Tr rowClone = (Tr)XmlUtils.deepCopy((Object)rCoords.getRow());
                BaseDocumentWalker walker = new BaseDocumentWalker((ContentAccessor)rowClone){

                    @Override
                    protected void onParagraph(P paragraph) {
                        RepeatProcessor.this.placeholderReplacer.resolveExpressionsForParagraph(paragraph, expressionContext, document);
                    }
                };
                walker.walk();
                rCoords.getParentTableCoordinates().getTable().getContent().add(++index, rowClone);
            }
            rCoords.getParentTableCoordinates().getTable().getContent().remove(rCoords.getRow());
        }
    }

    @Override
    public void repeatTableRow(List<Object> objects) {
        ParagraphCoordinates pCoords = this.getCurrentParagraphCoordinates();
        if (pCoords.getParentTableCellCoordinates() == null || pCoords.getParentTableCellCoordinates().getParentTableRowCoordinates() == null) {
            throw new CommentProcessingException("Paragraph is not within a table!", pCoords);
        }
        this.tableRowsToRepeat.put(this.getCurrentParagraphCoordinates().getParentTableCellCoordinates().getParentTableRowCoordinates(), objects);
        CommentUtil.deleteComment(this.getCurrentCommentWrapper());
    }
}

