/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.CTMarkup;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelParseException;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.api.UnresolvedExpressionException;
import org.wickedsource.docxstamper.api.commentprocessor.ICommentProcessor;
import org.wickedsource.docxstamper.api.coordinates.ParagraphCoordinates;
import org.wickedsource.docxstamper.api.coordinates.RunCoordinates;
import org.wickedsource.docxstamper.el.ExpressionResolver;
import org.wickedsource.docxstamper.el.ExpressionUtil;
import org.wickedsource.docxstamper.proxy.ProxyBuilder;
import org.wickedsource.docxstamper.proxy.ProxyException;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.CommentWrapper;
import org.wickedsource.docxstamper.util.ParagraphWrapper;
import org.wickedsource.docxstamper.util.walk.BaseCoordinatesWalker;

public class CommentProcessorRegistry {
    private Logger logger = LoggerFactory.getLogger(CommentProcessorRegistry.class);
    private Map<ICommentProcessor, Class<?>> commentProcessorInterfaces = new HashMap();
    private List<ICommentProcessor> commentProcessors = new ArrayList<ICommentProcessor>();
    private ExpressionResolver expressionResolver = new ExpressionResolver();
    private ExpressionUtil expressionUtil = new ExpressionUtil();
    private PlaceholderReplacer placeholderReplacer;
    private boolean failOnInvalidExpression = true;

    public CommentProcessorRegistry(PlaceholderReplacer placeholderReplacer) {
        this.placeholderReplacer = placeholderReplacer;
    }

    public void setExpressionResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
    }

    public void registerCommentProcessor(Class<?> interfaceClass, ICommentProcessor commentProcessor) {
        this.commentProcessorInterfaces.put(commentProcessor, interfaceClass);
        this.commentProcessors.add(commentProcessor);
    }

    public <T> void runProcessors(final WordprocessingMLPackage document, final ProxyBuilder<T> proxyBuilder) {
        final Map<BigInteger, CommentWrapper> comments = CommentUtil.getComments(document);
        final ArrayList proceedComments = new ArrayList();
        BaseCoordinatesWalker walker = new BaseCoordinatesWalker(document){

            @Override
            protected void onParagraph(ParagraphCoordinates paragraphCoordinates) {
                CommentProcessorRegistry.this.runProcessorsOnParagraphComment(document, comments, proxyBuilder, paragraphCoordinates).ifPresent(proceedComments::add);
                CommentProcessorRegistry.this.runProcessorsOnInlineContent(proxyBuilder, paragraphCoordinates);
            }

            @Override
            protected void onRun(RunCoordinates runCoordinates, ParagraphCoordinates paragraphCoordinates) {
                CommentProcessorRegistry.this.runProcessorsOnRunComment(document, comments, proxyBuilder, paragraphCoordinates, runCoordinates).ifPresent(proceedComments::add);
            }
        };
        walker.walk();
        for (ICommentProcessor processor : this.commentProcessors) {
            processor.commitChanges(document);
        }
        for (CommentWrapper commentWrapper : proceedComments) {
            CommentUtil.deleteComment(commentWrapper);
        }
    }

    private <T> void runProcessorsOnInlineContent(ProxyBuilder<T> proxyBuilder, ParagraphCoordinates paragraphCoordinates) {
        ParagraphWrapper paragraph = new ParagraphWrapper(paragraphCoordinates.getParagraph());
        List<String> processorExpressions = this.expressionUtil.findProcessorExpressions(paragraph.getText());
        for (String processorExpression : processorExpressions) {
            String strippedExpression = this.expressionUtil.stripExpression(processorExpression);
            for (ICommentProcessor processor : this.commentProcessors) {
                Class<?> commentProcessorInterface = this.commentProcessorInterfaces.get(processor);
                proxyBuilder.withInterface(commentProcessorInterface, processor);
                processor.setCurrentParagraphCoordinates(paragraphCoordinates);
            }
            try {
                T contextRootProxy = proxyBuilder.build();
                this.expressionResolver.resolveExpression(strippedExpression, contextRootProxy);
                this.placeholderReplacer.replace(paragraph, processorExpression, null);
                this.logger.debug(String.format("Processor expression '%s' has been successfully processed by a comment processor.", processorExpression));
            }
            catch (SpelEvaluationException | SpelParseException e) {
                if (this.failOnInvalidExpression) {
                    throw new UnresolvedExpressionException(strippedExpression, e);
                }
                this.logger.warn(String.format("Skipping processor expression '%s' because it can not be resolved by any comment processor. Reason: %s. Set log level to TRACE to view Stacktrace.", processorExpression, e.getMessage()));
                this.logger.trace("Reason for skipping processor expression: ", e);
            }
            catch (ProxyException e) {
                throw new DocxStamperException("Could not create a proxy around context root object", e);
            }
        }
    }

    private <T> Optional<CommentWrapper> runProcessorsOnParagraphComment(WordprocessingMLPackage document, Map<BigInteger, CommentWrapper> comments, ProxyBuilder<T> proxyBuilder, ParagraphCoordinates paragraphCoordinates) {
        Comments.Comment comment = CommentUtil.getCommentFor((ContentAccessor)paragraphCoordinates.getParagraph(), document);
        return this.runCommentProcessors(document, comments, proxyBuilder, comment, paragraphCoordinates, null);
    }

    private <T> Optional<CommentWrapper> runProcessorsOnRunComment(WordprocessingMLPackage document, Map<BigInteger, CommentWrapper> comments, ProxyBuilder<T> proxyBuilder, ParagraphCoordinates paragraphCoordinates, RunCoordinates runCoordinates) {
        Comments.Comment comment = CommentUtil.getCommentAround(runCoordinates.getRun(), document);
        return this.runCommentProcessors(document, comments, proxyBuilder, comment, paragraphCoordinates, runCoordinates);
    }

    private <T> Optional<CommentWrapper> runCommentProcessors(WordprocessingMLPackage document, Map<BigInteger, CommentWrapper> comments, ProxyBuilder<T> proxyBuilder, Comments.Comment comment, ParagraphCoordinates paragraphCoordinates, RunCoordinates runCoordinates) {
        CommentWrapper commentWrapper = Optional.ofNullable(comment).map(CTMarkup::getId).map(comments::get).orElse(null);
        if (Objects.isNull(comment) || Objects.isNull(commentWrapper)) {
            return Optional.empty();
        }
        String commentString = CommentUtil.getCommentString(comment);
        for (ICommentProcessor processor : this.commentProcessors) {
            Class<?> commentProcessorInterface = this.commentProcessorInterfaces.get(processor);
            proxyBuilder.withInterface(commentProcessorInterface, processor);
            processor.setCurrentParagraphCoordinates(paragraphCoordinates);
            processor.setCurrentRunCoordinates(runCoordinates);
            processor.setCurrentCommentWrapper(commentWrapper);
        }
        try {
            T contextRootProxy = proxyBuilder.build();
            this.expressionResolver.resolveExpression(commentString, contextRootProxy);
            comments.remove(comment.getId());
            this.logger.debug(String.format("Comment '%s' has been successfully processed by a comment processor.", commentString));
            return Optional.of(commentWrapper);
        }
        catch (SpelEvaluationException | SpelParseException e) {
            if (this.failOnInvalidExpression) {
                throw new UnresolvedExpressionException(commentString, e);
            }
            this.logger.warn(String.format("Skipping comment expression '%s' because it can not be resolved by any comment processor. Reason: %s. Set log level to TRACE to view Stacktrace.", commentString, e.getMessage()));
            this.logger.trace("Reason for skipping comment: ", e);
        }
        catch (ProxyException e) {
            throw new DocxStamperException("Could not create a proxy around context root object", e);
        }
        return Optional.empty();
    }

    public boolean isFailOnInvalidExpression() {
        return this.failOnInvalidExpression;
    }

    public void setFailOnInvalidExpression(boolean failOnInvalidExpression) {
        this.failOnInvalidExpression = failOnInvalidExpression;
    }

    public void reset() {
        for (ICommentProcessor processor : this.commentProcessors) {
            processor.reset();
        }
    }
}

