/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsPart;
import org.docx4j.wml.CommentRangeEnd;
import org.docx4j.wml.CommentRangeStart;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.util.CommentWrapper;
import org.wickedsource.docxstamper.util.ParagraphWrapper;
import org.wickedsource.docxstamper.util.walk.BaseDocumentWalker;

public class CommentUtil {
    private static Logger logger = LoggerFactory.getLogger(CommentUtil.class);

    private CommentUtil() {
    }

    public static Comments.Comment getCommentAround(R run, WordprocessingMLPackage document) {
        try {
            if (run instanceof Child) {
                R child = run;
                ContentAccessor parent = (ContentAccessor)child.getParent();
                if (parent == null) {
                    return null;
                }
                CommentRangeStart possibleComment = null;
                boolean foundChild = false;
                for (Object contentElement : parent.getContent()) {
                    if (XmlUtils.unwrap(contentElement) instanceof CommentRangeStart) {
                        possibleComment = (CommentRangeStart)contentElement;
                        continue;
                    }
                    if (possibleComment != null && child.equals(contentElement)) {
                        foundChild = true;
                        continue;
                    }
                    if (possibleComment != null && foundChild && XmlUtils.unwrap(contentElement) instanceof CommentRangeEnd) {
                        try {
                            BigInteger id = possibleComment.getId();
                            CommentsPart commentsPart = (CommentsPart)document.getParts().get(new PartName("/word/comments.xml"));
                            Comments comments = (Comments)commentsPart.getContents();
                            for (Comments.Comment comment : comments.getComment()) {
                                if (!comment.getId().equals(id)) continue;
                                return comment;
                            }
                            continue;
                        }
                        catch (InvalidFormatException e) {
                            logger.warn(String.format("Error while searching comment. Skipping run %s.", run), (Throwable)e);
                            continue;
                        }
                    }
                    possibleComment = null;
                    foundChild = false;
                }
            }
            return null;
        }
        catch (Docx4JException e) {
            throw new DocxStamperException("error accessing the comments of the document!", e);
        }
    }

    public static Comments.Comment getCommentFor(ContentAccessor object, WordprocessingMLPackage document) {
        try {
            for (Object contentObject : object.getContent()) {
                if (!(contentObject instanceof CommentRangeStart)) continue;
                try {
                    BigInteger id = ((CommentRangeStart)contentObject).getId();
                    CommentsPart commentsPart = (CommentsPart)document.getParts().get(new PartName("/word/comments.xml"));
                    Comments comments = (Comments)commentsPart.getContents();
                    for (Comments.Comment comment : comments.getComment()) {
                        if (!comment.getId().equals(id)) continue;
                        return comment;
                    }
                }
                catch (InvalidFormatException e) {
                    logger.warn(String.format("Error while searching comment. Skipping object %s.", object), (Throwable)e);
                }
            }
            return null;
        }
        catch (Docx4JException e) {
            throw new DocxStamperException("error accessing the comments of the document!", e);
        }
    }

    public static String getCommentStringFor(ContentAccessor object, WordprocessingMLPackage document) throws Docx4JException {
        Comments.Comment comment = CommentUtil.getCommentFor(object, document);
        return CommentUtil.getCommentString(comment);
    }

    public static String getCommentString(Comments.Comment comment) {
        StringBuilder builder = new StringBuilder();
        for (Object commentChildObject : comment.getContent()) {
            if (!(commentChildObject instanceof P)) continue;
            builder.append(new ParagraphWrapper((P)commentChildObject).getText());
        }
        return builder.toString();
    }

    public static void deleteComment(CommentWrapper comment) {
        if (comment.getCommentRangeEnd() != null) {
            ContentAccessor commentRangeEndParent = (ContentAccessor)comment.getCommentRangeEnd().getParent();
            commentRangeEndParent.getContent().remove(comment.getCommentRangeEnd());
            CommentUtil.deleteCommentReference(commentRangeEndParent, comment.getCommentRangeEnd().getId());
        }
        if (comment.getCommentRangeStart() != null) {
            ContentAccessor commentRangeStartParent = (ContentAccessor)comment.getCommentRangeStart().getParent();
            commentRangeStartParent.getContent().remove(comment.getCommentRangeStart());
            CommentUtil.deleteCommentReference(commentRangeStartParent, comment.getCommentRangeStart().getId());
        }
    }

    private static boolean deleteCommentReference(ContentAccessor parent, BigInteger commentId) {
        for (int i = 0; i < parent.getContent().size(); ++i) {
            Object contentObject = XmlUtils.unwrap(parent.getContent().get(i));
            if (contentObject instanceof ContentAccessor && CommentUtil.deleteCommentReference((ContentAccessor)contentObject, commentId)) {
                return true;
            }
            if (!(contentObject instanceof R)) continue;
            for (Object runContentObject : ((R)contentObject).getContent()) {
                BigInteger foundCommentId;
                Object unwrapped = XmlUtils.unwrap(runContentObject);
                if (!(unwrapped instanceof R.CommentReference) || !(foundCommentId = ((R.CommentReference)unwrapped).getId()).equals(commentId)) continue;
                parent.getContent().remove(i);
                return true;
            }
        }
        return false;
    }

    public static Map<BigInteger, CommentWrapper> getComments(WordprocessingMLPackage document) {
        HashMap<BigInteger, CommentWrapper> rootComments = new HashMap<BigInteger, CommentWrapper>();
        HashMap<BigInteger, CommentWrapper> allComments = new HashMap<BigInteger, CommentWrapper>();
        CommentUtil.collectCommentRanges(rootComments, allComments, document);
        CommentUtil.collectComments(rootComments, allComments, document);
        return rootComments;
    }

    private static void collectCommentRanges(final Map<BigInteger, CommentWrapper> rootComments, final Map<BigInteger, CommentWrapper> allComments, WordprocessingMLPackage document) {
        final Stack stack = new Stack();
        BaseDocumentWalker documentWalker = new BaseDocumentWalker((ContentAccessor)document.getMainDocumentPart()){

            @Override
            protected void onCommentRangeStart(CommentRangeStart commentRangeStart) {
                CommentWrapper commentWrapper = (CommentWrapper)allComments.get(commentRangeStart.getId());
                if (commentWrapper == null) {
                    commentWrapper = new CommentWrapper();
                    allComments.put(commentRangeStart.getId(), commentWrapper);
                    if (stack.isEmpty()) {
                        rootComments.put(commentRangeStart.getId(), commentWrapper);
                    } else {
                        ((CommentWrapper)stack.peek()).getChildren().add(commentWrapper);
                    }
                }
                commentWrapper.setCommentRangeStart(commentRangeStart);
                stack.push(commentWrapper);
            }

            @Override
            protected void onCommentRangeEnd(CommentRangeEnd commentRangeEnd) {
                CommentWrapper commentWrapper = (CommentWrapper)allComments.get(commentRangeEnd.getId());
                if (commentWrapper == null) {
                    throw new RuntimeException("UNEXPECTED !");
                }
                commentWrapper.setCommentRangeEnd(commentRangeEnd);
                if (!stack.isEmpty()) {
                    if (((CommentWrapper)stack.peek()).equals(commentWrapper)) {
                        stack.pop();
                    } else {
                        throw new RuntimeException("UNEXPECTED 2 !");
                    }
                }
            }
        };
        documentWalker.walk();
    }

    private static void collectComments(Map<BigInteger, CommentWrapper> rootComments, Map<BigInteger, CommentWrapper> allComments, WordprocessingMLPackage document) {
        try {
            CommentsPart commentsPart = (CommentsPart)document.getParts().get(new PartName("/word/comments.xml"));
            if (commentsPart != null) {
                for (Comments.Comment comment : ((Comments)commentsPart.getContents()).getComment()) {
                    CommentWrapper commentWrapper = allComments.get(comment.getId());
                    if (commentWrapper == null) continue;
                    commentWrapper.setComment(comment);
                }
            }
        }
        catch (Docx4JException e) {
            throw new IllegalStateException(e);
        }
    }
}

