/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.api.typeresolver.ITypeResolver;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.el.ExpressionResolver;
import org.wickedsource.docxstamper.processor.CommentProcessorRegistry;
import org.wickedsource.docxstamper.processor.displayif.DisplayIfProcessor;
import org.wickedsource.docxstamper.processor.displayif.IDisplayIfProcessor;
import org.wickedsource.docxstamper.processor.repeat.IParagraphRepeatProcessor;
import org.wickedsource.docxstamper.processor.repeat.IRepeatDocPartProcessor;
import org.wickedsource.docxstamper.processor.repeat.IRepeatProcessor;
import org.wickedsource.docxstamper.processor.repeat.ParagraphRepeatProcessor;
import org.wickedsource.docxstamper.processor.repeat.RepeatDocPartProcessor;
import org.wickedsource.docxstamper.processor.repeat.RepeatProcessor;
import org.wickedsource.docxstamper.processor.replaceExpression.IReplaceWithProcessor;
import org.wickedsource.docxstamper.processor.replaceExpression.ReplaceWithProcessor;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.replace.typeresolver.DateResolver;
import org.wickedsource.docxstamper.replace.typeresolver.FallbackResolver;
import org.wickedsource.docxstamper.replace.typeresolver.image.Image;
import org.wickedsource.docxstamper.replace.typeresolver.image.ImageResolver;

public class DocxStamper<T> {
    private PlaceholderReplacer placeholderReplacer;
    private CommentProcessorRegistry commentProcessorRegistry;
    private TypeResolverRegistry typeResolverRegistry;
    private DocxStamperConfiguration config = new DocxStamperConfiguration();

    public DocxStamper() {
        this.initFields();
    }

    public DocxStamper(DocxStamperConfiguration config) {
        this.config = config;
        this.initFields();
    }

    private void initFields() {
        this.typeResolverRegistry = new TypeResolverRegistry(new FallbackResolver());
        this.typeResolverRegistry.registerTypeResolver(Image.class, new ImageResolver());
        this.typeResolverRegistry.registerTypeResolver(Date.class, new DateResolver("dd.MM.yyyy"));
        for (Map.Entry<Class<?>, ITypeResolver> entry : this.config.getTypeResolvers().entrySet()) {
            this.typeResolverRegistry.registerTypeResolver(entry.getKey(), entry.getValue());
        }
        ExpressionResolver expressionResolver = new ExpressionResolver(this.config);
        this.placeholderReplacer = new PlaceholderReplacer(this.typeResolverRegistry, this.config);
        this.config.getCommentProcessors().put(IRepeatProcessor.class, new RepeatProcessor(this.typeResolverRegistry, this.config));
        this.config.getCommentProcessors().put(IParagraphRepeatProcessor.class, new ParagraphRepeatProcessor(this.typeResolverRegistry, this.config));
        this.config.getCommentProcessors().put(IRepeatDocPartProcessor.class, new RepeatDocPartProcessor(this.config));
        this.config.getCommentProcessors().put(IDisplayIfProcessor.class, new DisplayIfProcessor());
        this.config.getCommentProcessors().put(IReplaceWithProcessor.class, new ReplaceWithProcessor(this.config));
        this.commentProcessorRegistry = new CommentProcessorRegistry(this.placeholderReplacer, this.config);
        this.commentProcessorRegistry.setExpressionResolver(expressionResolver);
    }

    public void stamp(InputStream template, T contextRoot, OutputStream out) throws DocxStamperException {
        try {
            WordprocessingMLPackage document = WordprocessingMLPackage.load((InputStream)template);
            this.stamp(document, contextRoot, out);
        }
        catch (DocxStamperException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocxStamperException(e);
        }
    }

    public void stamp(WordprocessingMLPackage document, T contextRoot, OutputStream out) throws DocxStamperException {
        try {
            this.processComments(document, contextRoot);
            this.replaceExpressions(document, contextRoot);
            document.save(out);
            this.commentProcessorRegistry.reset();
        }
        catch (DocxStamperException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocxStamperException(e);
        }
    }

    private void replaceExpressions(WordprocessingMLPackage document, T contextObject) {
        this.placeholderReplacer.resolveExpressions(document, contextObject);
    }

    private void processComments(WordprocessingMLPackage document, T contextObject) {
        this.commentProcessorRegistry.runProcessors(document, contextObject);
    }
}

