/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.CTMarkup;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelParseException;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.api.UnresolvedExpressionException;
import org.wickedsource.docxstamper.api.commentprocessor.ICommentProcessor;
import org.wickedsource.docxstamper.api.coordinates.ParagraphCoordinates;
import org.wickedsource.docxstamper.api.coordinates.RunCoordinates;
import org.wickedsource.docxstamper.el.ExpressionResolver;
import org.wickedsource.docxstamper.el.ExpressionUtil;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.CommentWrapper;
import org.wickedsource.docxstamper.util.ParagraphWrapper;
import org.wickedsource.docxstamper.util.walk.BaseCoordinatesWalker;

public class CommentProcessorRegistry {
    private final Logger logger = LoggerFactory.getLogger(CommentProcessorRegistry.class);
    private final DocxStamperConfiguration configuration;
    private ExpressionResolver expressionResolver;
    private final ExpressionUtil expressionUtil = new ExpressionUtil();
    private final PlaceholderReplacer placeholderReplacer;

    public CommentProcessorRegistry(PlaceholderReplacer placeholderReplacer, DocxStamperConfiguration configuration) {
        this.placeholderReplacer = placeholderReplacer;
        this.configuration = configuration;
        this.expressionResolver = new ExpressionResolver(configuration);
    }

    public void setExpressionResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
    }

    public <T> void runProcessors(final WordprocessingMLPackage document, final T expressionContext) {
        final Map<BigInteger, CommentWrapper> comments = CommentUtil.getComments(document);
        final ArrayList proceedComments = new ArrayList();
        BaseCoordinatesWalker walker = new BaseCoordinatesWalker(document){

            @Override
            protected void onParagraph(ParagraphCoordinates paragraphCoordinates) {
                CommentProcessorRegistry.this.runProcessorsOnParagraphComment(document, comments, expressionContext, paragraphCoordinates).ifPresent(proceedComments::add);
                CommentProcessorRegistry.this.runProcessorsOnInlineContent(expressionContext, paragraphCoordinates);
            }

            @Override
            protected void onRun(RunCoordinates runCoordinates, ParagraphCoordinates paragraphCoordinates) {
                CommentProcessorRegistry.this.runProcessorsOnRunComment(document, comments, expressionContext, paragraphCoordinates, runCoordinates).ifPresent(proceedComments::add);
            }
        };
        walker.walk();
        for (Object processor : this.configuration.getCommentProcessors().values()) {
            ((ICommentProcessor)processor).commitChanges(document);
        }
        for (CommentWrapper commentWrapper : proceedComments) {
            CommentUtil.deleteComment(commentWrapper);
        }
    }

    private <T> void runProcessorsOnInlineContent(T expressionContext, ParagraphCoordinates paragraphCoordinates) {
        ParagraphWrapper paragraph = new ParagraphWrapper(paragraphCoordinates.getParagraph());
        List<String> processorExpressions = this.expressionUtil.findProcessorExpressions(paragraph.getText());
        for (String processorExpression : processorExpressions) {
            String strippedExpression = this.expressionUtil.stripExpression(processorExpression);
            for (Object processor : this.configuration.getCommentProcessors().values()) {
                ((ICommentProcessor)processor).setCurrentParagraphCoordinates(paragraphCoordinates);
            }
            try {
                this.expressionResolver.resolveExpression(strippedExpression, expressionContext);
                this.placeholderReplacer.replace(paragraph, processorExpression, null);
                this.logger.debug(String.format("Processor expression '%s' has been successfully processed by a comment processor.", processorExpression));
            }
            catch (SpelEvaluationException | SpelParseException e) {
                if (this.configuration.isFailOnUnresolvedExpression()) {
                    throw new UnresolvedExpressionException(strippedExpression, e);
                }
                this.logger.warn(String.format("Skipping processor expression '%s' because it can not be resolved by any comment processor. Reason: %s. Set log level to TRACE to view Stacktrace.", processorExpression, e.getMessage()));
                this.logger.trace("Reason for skipping processor expression: ", e);
            }
        }
    }

    private <T> Optional<CommentWrapper> runProcessorsOnParagraphComment(WordprocessingMLPackage document, Map<BigInteger, CommentWrapper> comments, T expressionContext, ParagraphCoordinates paragraphCoordinates) {
        Comments.Comment comment = CommentUtil.getCommentFor((ContentAccessor)paragraphCoordinates.getParagraph(), document);
        return this.runCommentProcessors(comments, expressionContext, comment, paragraphCoordinates, null);
    }

    private <T> Optional<CommentWrapper> runProcessorsOnRunComment(WordprocessingMLPackage document, Map<BigInteger, CommentWrapper> comments, T expressionContext, ParagraphCoordinates paragraphCoordinates, RunCoordinates runCoordinates) {
        Comments.Comment comment = CommentUtil.getCommentAround(runCoordinates.getRun(), document);
        return this.runCommentProcessors(comments, expressionContext, comment, paragraphCoordinates, runCoordinates);
    }

    private <T> Optional<CommentWrapper> runCommentProcessors(Map<BigInteger, CommentWrapper> comments, T expressionContext, Comments.Comment comment, ParagraphCoordinates paragraphCoordinates, RunCoordinates runCoordinates) {
        CommentWrapper commentWrapper = Optional.ofNullable(comment).map(CTMarkup::getId).map(comments::get).orElse(null);
        if (Objects.isNull(comment) || Objects.isNull(commentWrapper)) {
            return Optional.empty();
        }
        String commentString = CommentUtil.getCommentString(comment);
        for (Object processor : this.configuration.getCommentProcessors().values()) {
            ((ICommentProcessor)processor).setCurrentParagraphCoordinates(paragraphCoordinates);
            ((ICommentProcessor)processor).setCurrentRunCoordinates(runCoordinates);
            ((ICommentProcessor)processor).setCurrentCommentWrapper(commentWrapper);
        }
        try {
            this.expressionResolver.resolveExpression(commentString, expressionContext);
            comments.remove(comment.getId());
            this.logger.debug(String.format("Comment '%s' has been successfully processed by a comment processor.", commentString));
            return Optional.of(commentWrapper);
        }
        catch (SpelEvaluationException | SpelParseException e) {
            if (this.configuration.isFailOnUnresolvedExpression()) {
                throw new UnresolvedExpressionException(commentString, e);
            }
            this.logger.warn(String.format("Skipping comment expression '%s' because it can not be resolved by any comment processor. Reason: %s. Set log level to TRACE to view Stacktrace.", commentString, e.getMessage()));
            this.logger.trace("Reason for skipping comment: ", e);
            return Optional.empty();
        }
    }

    public void reset() {
        for (Object processor : this.configuration.getCommentProcessors().values()) {
            ((ICommentProcessor)processor).reset();
        }
    }
}

