/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor.displayif;

import java.util.ArrayList;
import java.util.List;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.wickedsource.docxstamper.api.coordinates.ParagraphCoordinates;
import org.wickedsource.docxstamper.api.coordinates.TableCoordinates;
import org.wickedsource.docxstamper.api.coordinates.TableRowCoordinates;
import org.wickedsource.docxstamper.processor.BaseCommentProcessor;
import org.wickedsource.docxstamper.processor.CommentProcessingException;
import org.wickedsource.docxstamper.processor.displayif.IDisplayIfProcessor;
import org.wickedsource.docxstamper.util.ObjectDeleter;

public class DisplayIfProcessor
extends BaseCommentProcessor
implements IDisplayIfProcessor {
    private List<ParagraphCoordinates> paragraphsToBeRemoved = new ArrayList<ParagraphCoordinates>();
    private List<TableCoordinates> tablesToBeRemoved = new ArrayList<TableCoordinates>();
    private List<TableRowCoordinates> tableRowsToBeRemoved = new ArrayList<TableRowCoordinates>();

    @Override
    public void commitChanges(WordprocessingMLPackage document) {
        ObjectDeleter deleter = new ObjectDeleter(document);
        this.removeParagraphs(deleter);
        this.removeTables(deleter);
        this.removeTableRows(deleter);
    }

    @Override
    public void reset() {
        this.paragraphsToBeRemoved = new ArrayList<ParagraphCoordinates>();
        this.tablesToBeRemoved = new ArrayList<TableCoordinates>();
        this.tableRowsToBeRemoved = new ArrayList<TableRowCoordinates>();
    }

    private void removeParagraphs(ObjectDeleter deleter) {
        for (ParagraphCoordinates pCoords : this.paragraphsToBeRemoved) {
            deleter.deleteParagraph(pCoords);
        }
    }

    private void removeTables(ObjectDeleter deleter) {
        for (TableCoordinates tCoords : this.tablesToBeRemoved) {
            deleter.deleteTable(tCoords);
        }
    }

    private void removeTableRows(ObjectDeleter deleter) {
        for (TableRowCoordinates rCoords : this.tableRowsToBeRemoved) {
            deleter.deleteTableRow(rCoords);
        }
    }

    @Override
    public void displayParagraphIf(Boolean condition) {
        if (!condition.booleanValue()) {
            ParagraphCoordinates coords = this.getCurrentParagraphCoordinates();
            this.paragraphsToBeRemoved.add(coords);
        }
    }

    @Override
    public void displayParagraphIfPresent(Object condition) {
        this.displayParagraphIf(condition != null);
    }

    @Override
    public void displayTableIf(Boolean condition) {
        if (!condition.booleanValue()) {
            ParagraphCoordinates pCoords = this.getCurrentParagraphCoordinates();
            if (pCoords.getParentTableCellCoordinates() == null || pCoords.getParentTableCellCoordinates().getParentTableRowCoordinates() == null || pCoords.getParentTableCellCoordinates().getParentTableRowCoordinates().getParentTableCoordinates() == null) {
                throw new CommentProcessingException("Paragraph is not within a table!", pCoords);
            }
            this.tablesToBeRemoved.add(pCoords.getParentTableCellCoordinates().getParentTableRowCoordinates().getParentTableCoordinates());
        }
    }

    @Override
    public void displayTableRowIf(Boolean condition) {
        if (!condition.booleanValue()) {
            ParagraphCoordinates pCoords = this.getCurrentParagraphCoordinates();
            if (pCoords.getParentTableCellCoordinates() == null || pCoords.getParentTableCellCoordinates().getParentTableRowCoordinates() == null) {
                throw new CommentProcessingException("Paragraph is not within a table!", pCoords);
            }
            this.tableRowsToBeRemoved.add(pCoords.getParentTableCellCoordinates().getParentTableRowCoordinates());
        }
    }
}

