/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor.repeat;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.CommentRangeEnd;
import org.docx4j.wml.CommentRangeStart;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.api.coordinates.ParagraphCoordinates;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.processor.BaseCommentProcessor;
import org.wickedsource.docxstamper.processor.repeat.IParagraphRepeatProcessor;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.ParagraphUtil;

public class ParagraphRepeatProcessor
extends BaseCommentProcessor
implements IParagraphRepeatProcessor {
    private Map<ParagraphCoordinates, ParagraphsToRepeat> pToRepeat = new HashMap<ParagraphCoordinates, ParagraphsToRepeat>();
    private final PlaceholderReplacer placeholderReplacer;
    private final DocxStamperConfiguration config;

    public ParagraphRepeatProcessor(TypeResolverRegistry typeResolverRegistry, DocxStamperConfiguration config) {
        this.placeholderReplacer = new PlaceholderReplacer(typeResolverRegistry, config);
        this.config = config;
    }

    @Override
    public void repeatParagraph(List<Object> objects) {
        ParagraphCoordinates paragraphCoordinates = this.getCurrentParagraphCoordinates();
        P paragraph = paragraphCoordinates.getParagraph();
        List<P> paragraphs = ParagraphRepeatProcessor.getParagraphsInsideComment(paragraph);
        ParagraphsToRepeat toRepeat = new ParagraphsToRepeat();
        toRepeat.data = objects;
        toRepeat.paragraphs = paragraphs;
        this.pToRepeat.put(paragraphCoordinates, toRepeat);
        CommentUtil.deleteComment(this.getCurrentCommentWrapper());
    }

    @Override
    public void commitChanges(WordprocessingMLPackage document) {
        for (ParagraphCoordinates rCoords : this.pToRepeat.keySet()) {
            Object parent;
            ParagraphsToRepeat paragraphsToRepeat = this.pToRepeat.get(rCoords);
            List<Object> expressionContexts = paragraphsToRepeat.data;
            ArrayList<P> paragraphsToAdd = new ArrayList<P>();
            if (expressionContexts != null) {
                for (Object expressionContext : expressionContexts) {
                    for (P paragraphToClone : paragraphsToRepeat.paragraphs) {
                        P pClone = (P)XmlUtils.deepCopy((Object)paragraphToClone);
                        this.placeholderReplacer.resolveExpressionsForParagraph(pClone, expressionContext, document);
                        paragraphsToAdd.add(pClone);
                    }
                }
            } else if (this.config.isReplaceNullValues() && this.config.getNullValuesDefault() != null) {
                paragraphsToAdd.add(ParagraphUtil.create(this.config.getNullValuesDefault()));
            }
            if (!((parent = rCoords.getParagraph().getParent()) instanceof ContentAccessor)) continue;
            ContentAccessor contentAccessor = (ContentAccessor)parent;
            int index = contentAccessor.getContent().indexOf(rCoords.getParagraph());
            if (index >= 0) {
                contentAccessor.getContent().addAll(index, paragraphsToAdd);
            }
            contentAccessor.getContent().removeAll(paragraphsToRepeat.paragraphs);
        }
    }

    @Override
    public void reset() {
        this.pToRepeat = new HashMap<ParagraphCoordinates, ParagraphsToRepeat>();
    }

    public static List<P> getParagraphsInsideComment(P paragraph) {
        Object parent;
        BigInteger commentId = null;
        boolean foundEnd = false;
        ArrayList<P> paragraphs = new ArrayList<P>();
        paragraphs.add(paragraph);
        for (Object object : paragraph.getContent()) {
            if (object instanceof CommentRangeStart) {
                commentId = ((CommentRangeStart)object).getId();
            }
            if (!(object instanceof CommentRangeEnd) || commentId == null || !commentId.equals(((CommentRangeEnd)object).getId())) continue;
            foundEnd = true;
        }
        if (!foundEnd && commentId != null && (parent = paragraph.getParent()) instanceof ContentAccessor) {
            ContentAccessor contentAccessor = (ContentAccessor)parent;
            int index = contentAccessor.getContent().indexOf(paragraph);
            block1: for (int i = index + 1; i < contentAccessor.getContent().size() && !foundEnd; ++i) {
                Object next = contentAccessor.getContent().get(i);
                if (next instanceof CommentRangeEnd && ((CommentRangeEnd)next).getId().equals(commentId)) {
                    foundEnd = true;
                    continue;
                }
                if (next instanceof P) {
                    paragraphs.add((P)next);
                }
                if (!(next instanceof ContentAccessor)) continue;
                ContentAccessor childContent = (ContentAccessor)next;
                for (Object child : childContent.getContent()) {
                    if (!(child instanceof CommentRangeEnd) || !((CommentRangeEnd)child).getId().equals(commentId)) continue;
                    foundEnd = true;
                    continue block1;
                }
            }
        }
        return paragraphs;
    }

    private static class ParagraphsToRepeat {
        List<Object> data;
        List<P> paragraphs;

        private ParagraphsToRepeat() {
        }
    }
}

