/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.R;
import org.wickedsource.docxstamper.replace.typeresolver.image.ImageResolver;

public class DocumentUtil {
    public static List<Object> prepareDocumentForInsert(WordprocessingMLPackage sourceDocument, WordprocessingMLPackage destDocument) throws Exception {
        return DocumentUtil.walkObjects((ContentAccessor)sourceDocument.getMainDocumentPart(), sourceDocument, destDocument);
    }

    private static List<Object> walkObjects(ContentAccessor sourceContainer, WordprocessingMLPackage sourceDocument, WordprocessingMLPackage destDocument) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : sourceContainer.getContent()) {
            if (obj instanceof R && DocumentUtil.isImageRun((R)obj)) {
                byte[] imageData = DocumentUtil.getRunDrawingData((R)obj, sourceDocument);
                result.add(ImageResolver.createRunWithImage(destDocument, imageData, null, null, null));
                continue;
            }
            if (obj instanceof ContentAccessor) {
                List<Object> importedChildren = DocumentUtil.walkObjects((ContentAccessor)obj, sourceDocument, destDocument);
                ((ContentAccessor)obj).getContent().clear();
                ((ContentAccessor)obj).getContent().addAll(importedChildren);
                result.add(obj);
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    private static byte[] getRunDrawingData(R run, WordprocessingMLPackage document) throws Docx4JException, IOException {
        for (Object runElement : run.getContent()) {
            if (!(runElement instanceof JAXBElement) || !(((JAXBElement)runElement).getValue() instanceof Drawing)) continue;
            Drawing drawing = (Drawing)((JAXBElement)runElement).getValue();
            byte[] imageData = DocumentUtil.getImageData(document, drawing);
            return imageData;
        }
        throw new RuntimeException("Run drawing not found !");
    }

    private static byte[] getImageData(WordprocessingMLPackage document, Drawing drawing) throws IOException, Docx4JException {
        String imageRelId = DocumentUtil.getImageRelationshipId(drawing);
        Part imageRelPart = document.getMainDocumentPart().getRelationshipsPart().getPart(imageRelId);
        String imageRelPartName = imageRelPart.getPartName().getName().substring(1);
        byte[] imageData = DocumentUtil.streamToByteArray(document.getSourcePartStore().getPartSize(imageRelPartName), document.getSourcePartStore().loadPart(imageRelPartName));
        return imageData;
    }

    private static boolean isImageRun(R run) {
        for (Object runElement : run.getContent()) {
            if (!(runElement instanceof JAXBElement) || !(((JAXBElement)runElement).getValue() instanceof Drawing)) continue;
            return true;
        }
        return false;
    }

    private static String getImageRelationshipId(Drawing drawing) {
        Graphic graphic = DocumentUtil.getInlineGraphic(drawing);
        return graphic.getGraphicData().getPic().getBlipFill().getBlip().getEmbed();
    }

    private static Graphic getInlineGraphic(Drawing drawing) {
        if (drawing.getAnchorOrInline().isEmpty()) {
            throw new RuntimeException("Anchor or Inline is empty !");
        }
        Object anchorOrInline = drawing.getAnchorOrInline().get(0);
        if (anchorOrInline instanceof Inline) {
            Inline inline = (Inline)anchorOrInline;
            return inline.getGraphic();
        }
        throw new RuntimeException("Don't know how to process anchor !");
    }

    private static byte[] streamToByteArray(long size, InputStream is) throws IOException {
        int numRead;
        if (size > Integer.MAX_VALUE) {
            throw new RuntimeException("Image size exceeds maximum allowed (2GB)");
        }
        int intSize = (int)size;
        byte[] data = new byte[intSize];
        int offset = 0;
        while ((numRead = is.read(data, offset, intSize - offset)) > 0) {
            offset += numRead;
        }
        is.close();
        return data;
    }
}

