/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util.walk;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.wickedsource.docxstamper.api.coordinates.ParagraphCoordinates;
import org.wickedsource.docxstamper.api.coordinates.RunCoordinates;
import org.wickedsource.docxstamper.api.coordinates.TableCellCoordinates;
import org.wickedsource.docxstamper.api.coordinates.TableCoordinates;
import org.wickedsource.docxstamper.api.coordinates.TableRowCoordinates;
import org.wickedsource.docxstamper.util.ParagraphUtil;

public abstract class CoordinatesWalker {
    private WordprocessingMLPackage document;

    public CoordinatesWalker(WordprocessingMLPackage document) {
        this.document = document;
    }

    public void walk() {
        RelationshipsPart relationshipsPart = this.document.getMainDocumentPart().getRelationshipsPart();
        List<Relationship> headerRelationships = this.getRelationshipsOfType(this.document, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/header");
        for (Relationship header : headerRelationships) {
            HeaderPart headerPart = (HeaderPart)relationshipsPart.getPart(header.getId());
            this.walkContent(headerPart.getContent());
        }
        this.walkContent(this.document.getMainDocumentPart().getContent());
        this.walkContent(ParagraphUtil.getAllTextBoxes(this.document));
        List<Relationship> footerRelationships = this.getRelationshipsOfType(this.document, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer");
        for (Relationship footer : footerRelationships) {
            FooterPart footerPart = (FooterPart)relationshipsPart.getPart(footer.getId());
            this.walkContent(footerPart.getContent());
        }
    }

    private List<Relationship> getRelationshipsOfType(WordprocessingMLPackage document, String type) {
        List allRelationhips = document.getMainDocumentPart().getRelationshipsPart().getRelationships().getRelationship();
        ArrayList<Relationship> headerRelationships = new ArrayList<Relationship>();
        for (Relationship r : allRelationhips) {
            if (!r.getType().equals(type)) continue;
            headerRelationships.add(r);
        }
        return headerRelationships;
    }

    private void walkContent(List<Object> contentElements) {
        for (int i = 0; i < contentElements.size(); ++i) {
            Object contentElement = contentElements.get(i);
            Object unwrappedObject = XmlUtils.unwrap((Object)contentElement);
            if (unwrappedObject instanceof P) {
                P p = (P)unwrappedObject;
                ParagraphCoordinates coordinates = new ParagraphCoordinates(p, i);
                this.walkParagraph(coordinates);
                continue;
            }
            if (!(unwrappedObject instanceof Tbl)) continue;
            Tbl table = (Tbl)unwrappedObject;
            TableCoordinates tableCoordinates = new TableCoordinates(table, i);
            this.walkTable(tableCoordinates);
        }
    }

    private void walkParagraph(ParagraphCoordinates paragraphCoordinates) {
        int rowIndex = 0;
        for (Object contentElement : paragraphCoordinates.getParagraph().getContent()) {
            if (!(XmlUtils.unwrap(contentElement) instanceof R)) continue;
            R run = (R)contentElement;
            RunCoordinates runCoordinates = new RunCoordinates(run, rowIndex);
            this.onRun(runCoordinates, paragraphCoordinates);
        }
        this.onParagraph(paragraphCoordinates);
    }

    private void walkTable(TableCoordinates tableCoordinates) {
        this.onTable(tableCoordinates);
        int rowIndex = 0;
        for (Object contentElement : tableCoordinates.getTable().getContent()) {
            if (XmlUtils.unwrap(contentElement) instanceof Tr) {
                Tr row = (Tr)contentElement;
                TableRowCoordinates rowCoordinates = new TableRowCoordinates(row, rowIndex, tableCoordinates);
                this.walkTableRow(rowCoordinates);
            }
            ++rowIndex;
        }
    }

    private void walkTableRow(TableRowCoordinates rowCoordinates) {
        this.onTableRow(rowCoordinates);
        int cellIndex = 0;
        for (Object rowContentElement : rowCoordinates.getRow().getContent()) {
            if (XmlUtils.unwrap(rowContentElement) instanceof Tc) {
                Tc cell = rowContentElement instanceof Tc ? (Tc)rowContentElement : (Tc)((JAXBElement)rowContentElement).getValue();
                TableCellCoordinates cellCoordinates = new TableCellCoordinates(cell, cellIndex, rowCoordinates);
                this.walkTableCell(cellCoordinates);
            }
            ++cellIndex;
        }
    }

    private void walkTableCell(TableCellCoordinates cellCoordinates) {
        this.onTableCell(cellCoordinates);
        int elementIndex = 0;
        for (Object cellContentElement : cellCoordinates.getCell().getContent()) {
            if (XmlUtils.unwrap(cellContentElement) instanceof P) {
                P p = (P)cellContentElement;
                ParagraphCoordinates paragraphCoordinates = new ParagraphCoordinates(p, elementIndex, cellCoordinates);
                this.onParagraph(paragraphCoordinates);
            } else if (XmlUtils.unwrap(cellContentElement) instanceof Tbl) {
                Tbl nestedTable = (Tbl)((JAXBElement)cellContentElement).getValue();
                TableCoordinates innerTableCoordinates = new TableCoordinates(nestedTable, elementIndex, cellCoordinates);
                this.walkTable(innerTableCoordinates);
            }
            ++elementIndex;
        }
    }

    protected abstract void onParagraph(ParagraphCoordinates var1);

    protected abstract void onRun(RunCoordinates var1, ParagraphCoordinates var2);

    protected abstract void onTable(TableCoordinates var1);

    protected abstract void onTableCell(TableCellCoordinates var1);

    protected abstract void onTableRow(TableRowCoordinates var1);
}

