/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.processor.displayif;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.P;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.wickedsource.docxstamper.processor.BaseCommentProcessor;
import org.wickedsource.docxstamper.processor.CommentProcessingException;
import org.wickedsource.docxstamper.processor.displayif.IDisplayIfProcessor;
import org.wickedsource.docxstamper.util.ObjectDeleter;

public class DisplayIfProcessor
extends BaseCommentProcessor
implements IDisplayIfProcessor {
    private List<P> paragraphsToBeRemoved = new ArrayList<P>();
    private List<Tbl> tablesToBeRemoved = new ArrayList<Tbl>();
    private List<Tr> tableRowsToBeRemoved = new ArrayList<Tr>();
    private List<Objects> objectsToBeRemoved = new ArrayList<Objects>();

    @Override
    public void commitChanges(WordprocessingMLPackage document) {
        ObjectDeleter deleter = new ObjectDeleter();
        this.removeParagraphs(deleter);
        this.removeTables(deleter);
        this.removeTableRows(deleter);
        this.removeObjects(deleter);
    }

    @Override
    public void reset() {
        this.paragraphsToBeRemoved = new ArrayList<P>();
        this.tablesToBeRemoved = new ArrayList<Tbl>();
        this.tableRowsToBeRemoved = new ArrayList<Tr>();
        this.objectsToBeRemoved = new ArrayList<Objects>();
    }

    private void removeParagraphs(ObjectDeleter deleter) {
        for (P paragraph : this.paragraphsToBeRemoved) {
            deleter.deleteParagraph(paragraph);
        }
    }

    private void removeObjects(ObjectDeleter deleter) {
        for (Objects object : this.objectsToBeRemoved) {
            deleter.deleteObject(object);
        }
    }

    private void removeTables(ObjectDeleter deleter) {
        for (Tbl table : this.tablesToBeRemoved) {
            deleter.deleteTable(table);
        }
    }

    private void removeTableRows(ObjectDeleter deleter) {
        for (Tr tableRow : this.tableRowsToBeRemoved) {
            deleter.deleteTableRow(tableRow);
        }
    }

    @Override
    public void displayParagraphIf(Boolean condition) {
        if (!condition.booleanValue()) {
            P paragraph = this.getParagraph();
            this.paragraphsToBeRemoved.add(paragraph);
        }
    }

    @Override
    public void displayParagraphIfPresent(Object condition) {
        this.displayParagraphIf(condition != null);
    }

    @Override
    public void displayTableIf(Boolean condition) {
        if (!condition.booleanValue()) {
            P paragraph = this.getParagraph();
            if (paragraph.getParent() instanceof Tc && ((Tc)paragraph.getParent()).getParent() instanceof Tr && ((Tr)((Tc)paragraph.getParent()).getParent()).getParent() instanceof Tbl) {
                this.tablesToBeRemoved.add((Tbl)((Tr)((Tc)paragraph.getParent()).getParent()).getParent());
            } else {
                throw new CommentProcessingException("Paragraph is not within a table!", paragraph);
            }
        }
    }

    @Override
    public void displayTableRowIf(Boolean condition) {
        if (!condition.booleanValue()) {
            P paragraph = this.getParagraph();
            if (paragraph.getParent() instanceof Tc && ((Tc)paragraph.getParent()).getParent() instanceof Tr) {
                this.tableRowsToBeRemoved.add((Tr)((Tc)paragraph.getParent()).getParent());
            } else {
                throw new CommentProcessingException("Paragraph is not within a table!", paragraph);
            }
        }
    }
}

