/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.replace.typeresolver.image;

import java.util.Random;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.R;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.api.typeresolver.ITypeResolver;
import org.wickedsource.docxstamper.replace.typeresolver.image.Image;

public class ImageResolver
implements ITypeResolver {
    private static final Random random = new Random();

    public R resolve(WordprocessingMLPackage document, Object image) {
        try {
            Image img = (Image)image;
            return ImageResolver.createRunWithImage(document, img.getImageBytes(), img.getFilename(), img.getAltText(), img.getMaxWidth());
        }
        catch (Exception e) {
            throw new DocxStamperException("Error while adding image to document!", e);
        }
    }

    public static R createRunWithImage(WordprocessingMLPackage wordMLPackage, byte[] bytes, String filenameHint, String altText, Integer maxWidth) throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)wordMLPackage, (byte[])bytes);
        int id1 = random.nextInt(100000);
        int id2 = random.nextInt(100000);
        if (filenameHint == null) {
            filenameHint = "dummyFileName";
        }
        if (altText == null) {
            altText = "dummyAltText";
        }
        Inline inline = maxWidth == null ? imagePart.createImageInline(filenameHint, altText, (long)id1, id2, false) : imagePart.createImageInline(filenameHint, altText, (long)id1, id2, false, maxWidth.intValue());
        ObjectFactory factory = new ObjectFactory();
        R run = factory.createR();
        Drawing drawing = factory.createDrawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return run;
    }
}

