/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.docx4j.finders.ClassFinder;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.R;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.replace.typeresolver.image.ImageResolver;
import org.wickedsource.docxstamper.util.DocxImageExtractor;

public class DocumentUtil {
    private DocumentUtil() {
        throw new DocxStamperException("Utility clases shouldn't be instantiated");
    }

    public static List<Object> prepareDocumentForInsert(WordprocessingMLPackage sourceDocument, WordprocessingMLPackage destDocument) throws Exception {
        return DocumentUtil.walkObjects((ContentAccessor)sourceDocument.getMainDocumentPart(), sourceDocument, destDocument);
    }

    private static List<Object> walkObjects(ContentAccessor sourceContainer, WordprocessingMLPackage sourceDocument, WordprocessingMLPackage destDocument) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : sourceContainer.getContent()) {
            if (obj instanceof R && DocumentUtil.isImageRun((R)obj)) {
                DocxImageExtractor docxImageExtractor = new DocxImageExtractor(sourceDocument);
                byte[] imageData = docxImageExtractor.getRunDrawingData((R)obj);
                String filename = docxImageExtractor.getRunDrawingFilename((R)obj);
                String alt = docxImageExtractor.getRunDrawingAltText((R)obj);
                Integer maxWidth = docxImageExtractor.getRunDrawingMaxWidth((R)obj);
                result.add(ImageResolver.createRunWithImage(destDocument, imageData, filename, alt, maxWidth));
                continue;
            }
            if (obj instanceof ContentAccessor) {
                List<Object> importedChildren = DocumentUtil.walkObjects((ContentAccessor)obj, sourceDocument, destDocument);
                ((ContentAccessor)obj).getContent().clear();
                ((ContentAccessor)obj).getContent().addAll(importedChildren);
                result.add(obj);
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    private static boolean isImageRun(R run) {
        return run.getContent().stream().filter(runElement -> runElement instanceof JAXBElement).map(JAXBElement.class::cast).map(JAXBElement::getValue).anyMatch(runValue -> runValue instanceof Drawing);
    }

    public static <T> List<T> extractElements(Object object, Class<T> elementClass) {
        if (object instanceof WordprocessingMLPackage) {
            WordprocessingMLPackage document = (WordprocessingMLPackage)object;
            return Stream.of(DocumentUtil.getElementStreamFrom(document, elementClass, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/header"), DocumentUtil.getElementStream(document.getMainDocumentPart(), elementClass), DocumentUtil.getElementStreamFrom(document, elementClass, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")).flatMap(Function.identity()).collect(Collectors.toList());
        }
        return DocumentUtil.getElementStream(object, elementClass).collect(Collectors.toList());
    }

    private static <T> Stream<T> getElementStreamFrom(WordprocessingMLPackage document, Class<T> clazz, String relationshipType) {
        RelationshipsPart relationshipsPart = document.getMainDocumentPart().getRelationshipsPart();
        return relationshipsPart.getRelationships().getRelationship().stream().filter(relationship -> relationship.getType().equals(relationshipType)).map(arg_0 -> ((RelationshipsPart)relationshipsPart).getPart(arg_0)).flatMap(relationshipPart -> DocumentUtil.getElementStream(relationshipPart, clazz));
    }

    private static <T> Stream<T> getElementStream(Object obj, Class<T> clazz) {
        ClassFinder finder = new ClassFinder(clazz);
        finder.walkJAXBElements(obj);
        return finder.results.stream().map(clazz::cast);
    }
}

