/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import jakarta.xml.bind.JAXBElement;
import java.util.ListIterator;
import org.docx4j.XmlUtils;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wickedsource.docxstamper.util.TableCellUtil;

public class ObjectDeleter {
    private final Logger logger = LoggerFactory.getLogger(ObjectDeleter.class);

    public void deleteObject(Object object) {
        if (object instanceof P) {
            this.deleteParagraph((P)object);
        } else {
            Object unwrappedObject = XmlUtils.unwrap((Object)object);
            if (unwrappedObject instanceof Tbl) {
                this.deleteTable((Tbl)unwrappedObject);
            }
        }
    }

    public void deleteParagraph(P paragraph) {
        if (paragraph.getParent() instanceof Tc) {
            Tc parentCell = (Tc)paragraph.getParent();
            this.deleteFromCell(parentCell, paragraph);
        } else {
            ((ContentAccessor)paragraph.getParent()).getContent().remove(paragraph);
        }
    }

    public void deleteTable(Tbl table) {
        if (table.getParent() instanceof Tc) {
            Tc parentCell = (Tc)table.getParent();
            this.deleteFromCell(parentCell, table);
        } else {
            ((ContentAccessor)table.getParent()).getContent().remove(table.getParent());
            ListIterator iterator = ((ContentAccessor)table.getParent()).getContent().listIterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof JAXBElement) || !((JAXBElement)next).getValue().equals(table)) continue;
                iterator.remove();
                break;
            }
        }
    }

    private void deleteFromCell(Tc cell, Tbl table) {
        cell.getContent().remove(table);
        if (!TableCellUtil.hasAtLeastOneParagraphOrTable(cell)) {
            TableCellUtil.addEmptyParagraph(cell);
        }
    }

    private void deleteFromCell(Tc cell, P paragraph) {
        cell.getContent().remove(paragraph);
        if (!TableCellUtil.hasAtLeastOneParagraphOrTable(cell)) {
            TableCellUtil.addEmptyParagraph(cell);
        }
    }

    public void deleteTableRow(Tr tableRow) {
        if (tableRow.getParent() instanceof Tbl) {
            Tbl table = (Tbl)tableRow.getParent();
            table.getContent().remove(tableRow);
        } else {
            this.logger.error("Table row is not contained within a table. Unable to remove");
        }
    }
}

