/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util.walk;

import java.util.ArrayList;
import java.util.List;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.wickedsource.docxstamper.util.DocumentUtil;

public abstract class CoordinatesWalker {
    private final WordprocessingMLPackage document;

    public CoordinatesWalker(WordprocessingMLPackage document) {
        this.document = document;
    }

    public void walk() {
        List<P> paragraphs = DocumentUtil.extractElements(this.document, P.class);
        for (P paragraph : paragraphs) {
            this.walkParagraph(paragraph);
        }
    }

    private void walkParagraph(P paragraph) {
        ArrayList content = new ArrayList(paragraph.getContent());
        for (Object contentElement : content) {
            if (!(XmlUtils.unwrap(contentElement) instanceof R)) continue;
            R run = (R)contentElement;
            this.onRun(run, paragraph);
        }
        this.onParagraph(paragraph);
    }

    protected abstract void onParagraph(P var1);

    protected abstract void onRun(R var1, P var2);
}

